//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hdinsightcontainers/armhdinsightcontainers"
	"net/http"
	"net/url"
	"regexp"
)

// AvailableClusterPoolVersionsServer is a fake server for instances of the armhdinsightcontainers.AvailableClusterPoolVersionsClient type.
type AvailableClusterPoolVersionsServer struct {
	// NewListByLocationPager is the fake for method AvailableClusterPoolVersionsClient.NewListByLocationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByLocationPager func(location string, options *armhdinsightcontainers.AvailableClusterPoolVersionsClientListByLocationOptions) (resp azfake.PagerResponder[armhdinsightcontainers.AvailableClusterPoolVersionsClientListByLocationResponse])
}

// NewAvailableClusterPoolVersionsServerTransport creates a new instance of AvailableClusterPoolVersionsServerTransport with the provided implementation.
// The returned AvailableClusterPoolVersionsServerTransport instance is connected to an instance of armhdinsightcontainers.AvailableClusterPoolVersionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAvailableClusterPoolVersionsServerTransport(srv *AvailableClusterPoolVersionsServer) *AvailableClusterPoolVersionsServerTransport {
	return &AvailableClusterPoolVersionsServerTransport{
		srv:                    srv,
		newListByLocationPager: newTracker[azfake.PagerResponder[armhdinsightcontainers.AvailableClusterPoolVersionsClientListByLocationResponse]](),
	}
}

// AvailableClusterPoolVersionsServerTransport connects instances of armhdinsightcontainers.AvailableClusterPoolVersionsClient to instances of AvailableClusterPoolVersionsServer.
// Don't use this type directly, use NewAvailableClusterPoolVersionsServerTransport instead.
type AvailableClusterPoolVersionsServerTransport struct {
	srv                    *AvailableClusterPoolVersionsServer
	newListByLocationPager *tracker[azfake.PagerResponder[armhdinsightcontainers.AvailableClusterPoolVersionsClientListByLocationResponse]]
}

// Do implements the policy.Transporter interface for AvailableClusterPoolVersionsServerTransport.
func (a *AvailableClusterPoolVersionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AvailableClusterPoolVersionsClient.NewListByLocationPager":
		resp, err = a.dispatchNewListByLocationPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AvailableClusterPoolVersionsServerTransport) dispatchNewListByLocationPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByLocationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByLocationPager not implemented")}
	}
	newListByLocationPager := a.newListByLocationPager.get(req)
	if newListByLocationPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/availableClusterPoolVersions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByLocationPager(locationParam, nil)
		newListByLocationPager = &resp
		a.newListByLocationPager.add(req, newListByLocationPager)
		server.PagerResponderInjectNextLinks(newListByLocationPager, req, func(page *armhdinsightcontainers.AvailableClusterPoolVersionsClientListByLocationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByLocationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByLocationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByLocationPager) {
		a.newListByLocationPager.remove(req)
	}
	return resp, nil
}
