//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybridcontainerservice/armhybridcontainerservice"
	"net/http"
	"net/url"
	"regexp"
)

// AgentPoolServer is a fake server for instances of the armhybridcontainerservice.AgentPoolClient type.
type AgentPoolServer struct {
	// BeginCreateOrUpdate is the fake for method AgentPoolClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, connectedClusterResourceURI string, agentPoolName string, agentPool armhybridcontainerservice.AgentPool, options *armhybridcontainerservice.AgentPoolClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armhybridcontainerservice.AgentPoolClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method AgentPoolClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, connectedClusterResourceURI string, agentPoolName string, options *armhybridcontainerservice.AgentPoolClientBeginDeleteOptions) (resp azfake.PollerResponder[armhybridcontainerservice.AgentPoolClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AgentPoolClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, connectedClusterResourceURI string, agentPoolName string, options *armhybridcontainerservice.AgentPoolClientGetOptions) (resp azfake.Responder[armhybridcontainerservice.AgentPoolClientGetResponse], errResp azfake.ErrorResponder)

	// ListByProvisionedCluster is the fake for method AgentPoolClient.ListByProvisionedCluster
	// HTTP status codes to indicate success: http.StatusOK
	ListByProvisionedCluster func(ctx context.Context, connectedClusterResourceURI string, options *armhybridcontainerservice.AgentPoolClientListByProvisionedClusterOptions) (resp azfake.Responder[armhybridcontainerservice.AgentPoolClientListByProvisionedClusterResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method AgentPoolClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, connectedClusterResourceURI string, agentPoolName string, agentPool armhybridcontainerservice.AgentPoolPatch, options *armhybridcontainerservice.AgentPoolClientBeginUpdateOptions) (resp azfake.PollerResponder[armhybridcontainerservice.AgentPoolClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewAgentPoolServerTransport creates a new instance of AgentPoolServerTransport with the provided implementation.
// The returned AgentPoolServerTransport instance is connected to an instance of armhybridcontainerservice.AgentPoolClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAgentPoolServerTransport(srv *AgentPoolServer) *AgentPoolServerTransport {
	return &AgentPoolServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armhybridcontainerservice.AgentPoolClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armhybridcontainerservice.AgentPoolClientDeleteResponse]](),
		beginUpdate:         newTracker[azfake.PollerResponder[armhybridcontainerservice.AgentPoolClientUpdateResponse]](),
	}
}

// AgentPoolServerTransport connects instances of armhybridcontainerservice.AgentPoolClient to instances of AgentPoolServer.
// Don't use this type directly, use NewAgentPoolServerTransport instead.
type AgentPoolServerTransport struct {
	srv                 *AgentPoolServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armhybridcontainerservice.AgentPoolClientCreateOrUpdateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armhybridcontainerservice.AgentPoolClientDeleteResponse]]
	beginUpdate         *tracker[azfake.PollerResponder[armhybridcontainerservice.AgentPoolClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for AgentPoolServerTransport.
func (a *AgentPoolServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AgentPoolClient.BeginCreateOrUpdate":
		resp, err = a.dispatchBeginCreateOrUpdate(req)
	case "AgentPoolClient.BeginDelete":
		resp, err = a.dispatchBeginDelete(req)
	case "AgentPoolClient.Get":
		resp, err = a.dispatchGet(req)
	case "AgentPoolClient.ListByProvisionedCluster":
		resp, err = a.dispatchListByProvisionedCluster(req)
	case "AgentPoolClient.BeginUpdate":
		resp, err = a.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AgentPoolServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := a.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/(?P<connectedClusterResourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridContainerService/provisionedClusterInstances/default/agentPools/(?P<agentPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhybridcontainerservice.AgentPool](req)
		if err != nil {
			return nil, err
		}
		connectedClusterResourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedClusterResourceUri")])
		if err != nil {
			return nil, err
		}
		agentPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("agentPoolName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreateOrUpdate(req.Context(), connectedClusterResourceURIParam, agentPoolNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		a.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		a.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		a.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (a *AgentPoolServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if a.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := a.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/(?P<connectedClusterResourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridContainerService/provisionedClusterInstances/default/agentPools/(?P<agentPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		connectedClusterResourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedClusterResourceUri")])
		if err != nil {
			return nil, err
		}
		agentPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("agentPoolName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginDelete(req.Context(), connectedClusterResourceURIParam, agentPoolNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		a.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		a.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		a.beginDelete.remove(req)
	}

	return resp, nil
}

func (a *AgentPoolServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<connectedClusterResourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridContainerService/provisionedClusterInstances/default/agentPools/(?P<agentPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	connectedClusterResourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedClusterResourceUri")])
	if err != nil {
		return nil, err
	}
	agentPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("agentPoolName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), connectedClusterResourceURIParam, agentPoolNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AgentPool, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AgentPoolServerTransport) dispatchListByProvisionedCluster(req *http.Request) (*http.Response, error) {
	if a.srv.ListByProvisionedCluster == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByProvisionedCluster not implemented")}
	}
	const regexStr = `/(?P<connectedClusterResourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridContainerService/provisionedClusterInstances/default/agentPools`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	connectedClusterResourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedClusterResourceUri")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.ListByProvisionedCluster(req.Context(), connectedClusterResourceURIParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AgentPoolListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AgentPoolServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := a.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/(?P<connectedClusterResourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridContainerService/provisionedClusterInstances/default/agentPools/(?P<agentPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhybridcontainerservice.AgentPoolPatch](req)
		if err != nil {
			return nil, err
		}
		connectedClusterResourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedClusterResourceUri")])
		if err != nil {
			return nil, err
		}
		agentPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("agentPoolName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginUpdate(req.Context(), connectedClusterResourceURIParam, agentPoolNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		a.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		a.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		a.beginUpdate.remove(req)
	}

	return resp, nil
}
