//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple8000series/armstorsimple8000series"
	"net/http"
	"net/url"
	"regexp"
)

// BackupsServer is a fake server for instances of the armstorsimple8000series.BackupsClient type.
type BackupsServer struct {
	// BeginClone is the fake for method BackupsClient.BeginClone
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginClone func(ctx context.Context, deviceName string, backupName string, backupElementName string, resourceGroupName string, managerName string, parameters armstorsimple8000series.CloneRequest, options *armstorsimple8000series.BackupsClientBeginCloneOptions) (resp azfake.PollerResponder[armstorsimple8000series.BackupsClientCloneResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method BackupsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, deviceName string, backupName string, resourceGroupName string, managerName string, options *armstorsimple8000series.BackupsClientBeginDeleteOptions) (resp azfake.PollerResponder[armstorsimple8000series.BackupsClientDeleteResponse], errResp azfake.ErrorResponder)

	// NewListByDevicePager is the fake for method BackupsClient.NewListByDevicePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDevicePager func(deviceName string, resourceGroupName string, managerName string, options *armstorsimple8000series.BackupsClientListByDeviceOptions) (resp azfake.PagerResponder[armstorsimple8000series.BackupsClientListByDeviceResponse])

	// BeginRestore is the fake for method BackupsClient.BeginRestore
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestore func(ctx context.Context, deviceName string, backupName string, resourceGroupName string, managerName string, options *armstorsimple8000series.BackupsClientBeginRestoreOptions) (resp azfake.PollerResponder[armstorsimple8000series.BackupsClientRestoreResponse], errResp azfake.ErrorResponder)
}

// NewBackupsServerTransport creates a new instance of BackupsServerTransport with the provided implementation.
// The returned BackupsServerTransport instance is connected to an instance of armstorsimple8000series.BackupsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBackupsServerTransport(srv *BackupsServer) *BackupsServerTransport {
	return &BackupsServerTransport{
		srv:                  srv,
		beginClone:           newTracker[azfake.PollerResponder[armstorsimple8000series.BackupsClientCloneResponse]](),
		beginDelete:          newTracker[azfake.PollerResponder[armstorsimple8000series.BackupsClientDeleteResponse]](),
		newListByDevicePager: newTracker[azfake.PagerResponder[armstorsimple8000series.BackupsClientListByDeviceResponse]](),
		beginRestore:         newTracker[azfake.PollerResponder[armstorsimple8000series.BackupsClientRestoreResponse]](),
	}
}

// BackupsServerTransport connects instances of armstorsimple8000series.BackupsClient to instances of BackupsServer.
// Don't use this type directly, use NewBackupsServerTransport instead.
type BackupsServerTransport struct {
	srv                  *BackupsServer
	beginClone           *tracker[azfake.PollerResponder[armstorsimple8000series.BackupsClientCloneResponse]]
	beginDelete          *tracker[azfake.PollerResponder[armstorsimple8000series.BackupsClientDeleteResponse]]
	newListByDevicePager *tracker[azfake.PagerResponder[armstorsimple8000series.BackupsClientListByDeviceResponse]]
	beginRestore         *tracker[azfake.PollerResponder[armstorsimple8000series.BackupsClientRestoreResponse]]
}

// Do implements the policy.Transporter interface for BackupsServerTransport.
func (b *BackupsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BackupsClient.BeginClone":
		resp, err = b.dispatchBeginClone(req)
	case "BackupsClient.BeginDelete":
		resp, err = b.dispatchBeginDelete(req)
	case "BackupsClient.NewListByDevicePager":
		resp, err = b.dispatchNewListByDevicePager(req)
	case "BackupsClient.BeginRestore":
		resp, err = b.dispatchBeginRestore(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BackupsServerTransport) dispatchBeginClone(req *http.Request) (*http.Response, error) {
	if b.srv.BeginClone == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginClone not implemented")}
	}
	beginClone := b.beginClone.get(req)
	if beginClone == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/elements/(?P<backupElementName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clone`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorsimple8000series.CloneRequest](req)
		if err != nil {
			return nil, err
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
		if err != nil {
			return nil, err
		}
		backupElementNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupElementName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginClone(req.Context(), deviceNameParam, backupNameParam, backupElementNameParam, resourceGroupNameParam, managerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginClone = &respr
		b.beginClone.add(req, beginClone)
	}

	resp, err := server.PollerResponderNext(beginClone, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginClone.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginClone) {
		b.beginClone.remove(req)
	}

	return resp, nil
}

func (b *BackupsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if b.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := b.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginDelete(req.Context(), deviceNameParam, backupNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		b.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		b.beginDelete.remove(req)
	}

	return resp, nil
}

func (b *BackupsServerTransport) dispatchNewListByDevicePager(req *http.Request) (*http.Response, error) {
	if b.srv.NewListByDevicePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDevicePager not implemented")}
	}
	newListByDevicePager := b.newListByDevicePager.get(req)
	if newListByDevicePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armstorsimple8000series.BackupsClientListByDeviceOptions
		if filterParam != nil {
			options = &armstorsimple8000series.BackupsClientListByDeviceOptions{
				Filter: filterParam,
			}
		}
		resp := b.srv.NewListByDevicePager(deviceNameParam, resourceGroupNameParam, managerNameParam, options)
		newListByDevicePager = &resp
		b.newListByDevicePager.add(req, newListByDevicePager)
		server.PagerResponderInjectNextLinks(newListByDevicePager, req, func(page *armstorsimple8000series.BackupsClientListByDeviceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDevicePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newListByDevicePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDevicePager) {
		b.newListByDevicePager.remove(req)
	}
	return resp, nil
}

func (b *BackupsServerTransport) dispatchBeginRestore(req *http.Request) (*http.Response, error) {
	if b.srv.BeginRestore == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestore not implemented")}
	}
	beginRestore := b.beginRestore.get(req)
	if beginRestore == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restore`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginRestore(req.Context(), deviceNameParam, backupNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestore = &respr
		b.beginRestore.add(req, beginRestore)
	}

	resp, err := server.PollerResponderNext(beginRestore, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginRestore.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestore) {
		b.beginRestore.remove(req)
	}

	return resp, nil
}
