<!--
Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
HYPRE Project Developers. See the top-level COPYRIGHT file for details.

SPDX-License-Identifier: (Apache-2.0 OR MIT)
-->

HYPRE Installation Information for Unix-based systems
=====================================================

The simplest way to build HYPRE is:

1. From within the `src` directory, type `configure` to configure the package
   for your system.

   While configure runs, it prints messages indicating which features it is
   checking for.  Two output files are created: config.status and config.log.
   The config.status file can be run to recreate the current configuration, and
   config.log is useful for debugging configure.  Upon successful completion,
   the file `config/Makefile.config` is created from its template
   `Makefile.config.in` and HYPRE is ready to be made.

2. Type `make install` to compile and install HYPRE.

3. You can remove the program binaries and object files from the source code by
   typing `make clean`.  To remove additional files created by configure, type
   `make distclean`.

Optional Features:

Configure has many options to allow the user to override and refine the defaults
of any system.  To display the available options, type `configure --help`.

The make step in building HYPRE is where the compiling, loading and creation of
libraries occurs.  Make has several options called targets, which can be listed
by running `make help`.

When building HYPRE without the install target, the libraries and include files
are copied into the directories, `src/hypre/lib` and `src/hypre/include`.

When building with the install target, the libraries and files are copied into
the directories specified by the configure option, --prefix=/usr/apps.  If none
were specified, the default directories are used, hypre/lib and hypre/include.


HYPRE Installation Information using CMake
==========================================

CMake is another way to build HYPRE that is particularly useful for building the
code on Windows machines.  CMake provides a uniform interface for setting
configuration options on different platforms.  It does not actually build the
code, but generates input for other "native" build systems such as Make (Unix
platforms) or Visual Studio (Windows).  Here are the basic steps:

1. First, ensure that CMake version 3.21.0 or later is installed on the system.

2. To build the library, run CMake on the top-level HYPRE source directory to
   generate files appropriate for the native build system.  To prevent writing
   over the Makefiles in HYPRE's configure/make system above, only out-of-source
   builds are currently allowed with CMake. The directory `build` is provided in
   the release for convenience, but alternative build directories may be created
   by the user:

   - Unix: From the `build` directory, type `cmake ../src`.

   - Windows: Set the source and build directories to `src` and `build`, then
     click on 'Configure' following by 'Generate'.

3. To complete the build of the library, compile with the native build system:

   - Unix: From the `build` directory, type `make install`.

   - Windows Visual Studio: Open the 'hypre' VS solution file generated by CMake
     and build the 'ALL_BUILD' target, then the 'INSTALL' target.

Optional Features:

Various configuration options can be set from within CMake.  Change these as
appropriate, then reconfigure/generate:

- Unix: From the `build` directory, type `ccmake ../src`, change options, then
  type `c` then `q`.

- Windows VS: Change options, then click on 'Configure' then 'Generate'.

Complete Build Instructions
===========================

For the latest, complete instructions (Autotools, CMake, GPU/Spack options, build
targets, etc.), please refer to the User Manual on Read the Docs:

- [Documentation home](https://hypre.readthedocs.io/en/latest)
- [General Information -- Building the library (Autotools and CMake)](https://hypre.readthedocs.io/en/latest/ch-misc.html#building-the-library)
- [Build System Options](https://hypre.readthedocs.io/en/latest/ch-misc.html#build-system-options)
- [GPU Build Options](https://hypre.readthedocs.io/en/latest/ch-misc.html#gpu-build-options)

ABI Compatibility Policy
========================

HYPRE versions follow the X.Y.Z scheme.

- Patch releases (Z) are intended to be ABI-compatible within the same major and minor version (X.Y).
- Major (X) and minor (Y) releases may introduce ABI changes and should not be assumed compatible.

Examples:
- Likely compatible: 2.22.0 ↔ 2.22.1 (same X.Y, patch-level updates).
- Not necessarily compatible:
  - 2.31.z ↔ 2.32.z (minor version differs)
  - 2.y.z  ↔ 3.y.z (major version differs)

Recommendations:
- If distributing binaries or building plugins, pin to an exact X.Y and allow any Z.
- When upgrading across X or Y, plan to rebuild and revalidate dependent binaries.
