/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/

#include "_hypre_struct_ls.h"
#include "_hypre_lobpcg_temp_multivector.h"

HYPRE_Int
HYPRE_StructSetupInterpreter( mv_InterfaceInterpreter *i )
{
   i->CreateVector          = hypre_StructKrylovCreateVector;
   i->DestroyVector         = hypre_StructKrylovDestroyVector;
   i->InnerProd             = hypre_StructKrylovInnerProd;
   i->CopyVector            = hypre_StructKrylovCopyVector;
   i->ClearVector           = hypre_StructKrylovClearVector;
   i->SetRandomValues       = hypre_StructKrylovSetRandomValues;
   i->ScaleVector           = hypre_StructKrylovScaleVector;
   i->Axpy                  = hypre_StructKrylovAxpy;

   i->CreateMultiVector     = mv_TempMultiVectorCreateFromSampleVector;
   i->CopyCreateMultiVector = mv_TempMultiVectorCreateCopy;
   i->DestroyMultiVector    = mv_TempMultiVectorDestroy;

   i->Width                 = mv_TempMultiVectorWidth;
   i->Height                = mv_TempMultiVectorHeight;
   i->SetMask               = mv_TempMultiVectorSetMask;
   i->CopyMultiVector       = mv_TempMultiVectorCopy;
   i->ClearMultiVector      = mv_TempMultiVectorClear;
   i->SetRandomVectors      = mv_TempMultiVectorSetRandom;
   i->MultiInnerProd        = mv_TempMultiVectorByMultiVector;
   i->MultiInnerProdDiag    = mv_TempMultiVectorByMultiVectorDiag;
   i->MultiVecMat           = mv_TempMultiVectorByMatrix;
   i->MultiVecMatDiag       = mv_TempMultiVectorByDiagonal;
   i->MultiAxpy             = mv_TempMultiVectorAxpy;
   i->MultiXapy             = mv_TempMultiVectorXapy;
   i->Eval                  = mv_TempMultiVectorEval;

   return hypre_error_flag;
}

HYPRE_Int
HYPRE_StructSetupMatvec(HYPRE_MatvecFunctions * mv)
{
   mv->MatvecCreate       = hypre_StructKrylovMatvecCreate;
   mv->Matvec             = hypre_StructKrylovMatvec;
   mv->MatvecDestroy      = hypre_StructKrylovMatvecDestroy;

   mv->MatMultiVecCreate  = NULL;
   mv->MatMultiVec        = NULL;
   mv->MatMultiVecDestroy = NULL;

   return hypre_error_flag;
}
