/* Generated by wayland-scanner 1.23.0 */

#ifndef VIRTUAL_KEYBOARD_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define VIRTUAL_KEYBOARD_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_virtual_keyboard_unstable_v1 The virtual_keyboard_unstable_v1 protocol
 * @section page_ifaces_virtual_keyboard_unstable_v1 Interfaces
 * - @subpage page_iface_zwp_virtual_keyboard_v1 - virtual keyboard
 * - @subpage page_iface_zwp_virtual_keyboard_manager_v1 - virtual keyboard manager
 * @section page_copyright_virtual_keyboard_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2008-2011  Kristian Høgsberg
 * Copyright © 2010-2013  Intel Corporation
 * Copyright © 2012-2013  Collabora, Ltd.
 * Copyright © 2018       Purism SPC
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_seat;
struct zwp_virtual_keyboard_manager_v1;
struct zwp_virtual_keyboard_v1;

#ifndef ZWP_VIRTUAL_KEYBOARD_V1_INTERFACE
#define ZWP_VIRTUAL_KEYBOARD_V1_INTERFACE
/**
 * @page page_iface_zwp_virtual_keyboard_v1 zwp_virtual_keyboard_v1
 * @section page_iface_zwp_virtual_keyboard_v1_desc Description
 *
 * The virtual keyboard provides an application with requests which emulate
 * the behaviour of a physical keyboard.
 *
 * This interface can be used by clients on its own to provide raw input
 * events, or it can accompany the input method protocol.
 * @section page_iface_zwp_virtual_keyboard_v1_api API
 * See @ref iface_zwp_virtual_keyboard_v1.
 */
/**
 * @defgroup iface_zwp_virtual_keyboard_v1 The zwp_virtual_keyboard_v1 interface
 *
 * The virtual keyboard provides an application with requests which emulate
 * the behaviour of a physical keyboard.
 *
 * This interface can be used by clients on its own to provide raw input
 * events, or it can accompany the input method protocol.
 */
extern const struct wl_interface zwp_virtual_keyboard_v1_interface;
#endif
#ifndef ZWP_VIRTUAL_KEYBOARD_MANAGER_V1_INTERFACE
#define ZWP_VIRTUAL_KEYBOARD_MANAGER_V1_INTERFACE
/**
 * @page page_iface_zwp_virtual_keyboard_manager_v1 zwp_virtual_keyboard_manager_v1
 * @section page_iface_zwp_virtual_keyboard_manager_v1_desc Description
 *
 * A virtual keyboard manager allows an application to provide keyboard
 * input events as if they came from a physical keyboard.
 * @section page_iface_zwp_virtual_keyboard_manager_v1_api API
 * See @ref iface_zwp_virtual_keyboard_manager_v1.
 */
/**
 * @defgroup iface_zwp_virtual_keyboard_manager_v1 The zwp_virtual_keyboard_manager_v1 interface
 *
 * A virtual keyboard manager allows an application to provide keyboard
 * input events as if they came from a physical keyboard.
 */
extern const struct wl_interface zwp_virtual_keyboard_manager_v1_interface;
#endif

#ifndef ZWP_VIRTUAL_KEYBOARD_V1_ERROR_ENUM
#define ZWP_VIRTUAL_KEYBOARD_V1_ERROR_ENUM
enum zwp_virtual_keyboard_v1_error {
	/**
	 * No keymap was set
	 */
	ZWP_VIRTUAL_KEYBOARD_V1_ERROR_NO_KEYMAP = 0,
};
#endif /* ZWP_VIRTUAL_KEYBOARD_V1_ERROR_ENUM */

#define ZWP_VIRTUAL_KEYBOARD_V1_KEYMAP 0
#define ZWP_VIRTUAL_KEYBOARD_V1_KEY 1
#define ZWP_VIRTUAL_KEYBOARD_V1_MODIFIERS 2
#define ZWP_VIRTUAL_KEYBOARD_V1_DESTROY 3


/**
 * @ingroup iface_zwp_virtual_keyboard_v1
 */
#define ZWP_VIRTUAL_KEYBOARD_V1_KEYMAP_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_virtual_keyboard_v1
 */
#define ZWP_VIRTUAL_KEYBOARD_V1_KEY_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_virtual_keyboard_v1
 */
#define ZWP_VIRTUAL_KEYBOARD_V1_MODIFIERS_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_virtual_keyboard_v1
 */
#define ZWP_VIRTUAL_KEYBOARD_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwp_virtual_keyboard_v1 */
static inline void
zwp_virtual_keyboard_v1_set_user_data(struct zwp_virtual_keyboard_v1 *zwp_virtual_keyboard_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_virtual_keyboard_v1, user_data);
}

/** @ingroup iface_zwp_virtual_keyboard_v1 */
static inline void *
zwp_virtual_keyboard_v1_get_user_data(struct zwp_virtual_keyboard_v1 *zwp_virtual_keyboard_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_virtual_keyboard_v1);
}

static inline uint32_t
zwp_virtual_keyboard_v1_get_version(struct zwp_virtual_keyboard_v1 *zwp_virtual_keyboard_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_virtual_keyboard_v1);
}

/**
 * @ingroup iface_zwp_virtual_keyboard_v1
 *
 * Provide a file descriptor to the compositor which can be
 * memory-mapped to provide a keyboard mapping description.
 *
 * Format carries a value from the keymap_format enumeration.
 */
static inline void
zwp_virtual_keyboard_v1_keymap(struct zwp_virtual_keyboard_v1 *zwp_virtual_keyboard_v1, uint32_t format, int32_t fd, uint32_t size)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_virtual_keyboard_v1,
			 ZWP_VIRTUAL_KEYBOARD_V1_KEYMAP, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_virtual_keyboard_v1), 0, format, fd, size);
}

/**
 * @ingroup iface_zwp_virtual_keyboard_v1
 *
 * A key was pressed or released.
 * The time argument is a timestamp with millisecond granularity, with an
 * undefined base. All requests regarding a single object must share the
 * same clock.
 *
 * Keymap must be set before issuing this request.
 *
 * State carries a value from the key_state enumeration.
 */
static inline void
zwp_virtual_keyboard_v1_key(struct zwp_virtual_keyboard_v1 *zwp_virtual_keyboard_v1, uint32_t time, uint32_t key, uint32_t state)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_virtual_keyboard_v1,
			 ZWP_VIRTUAL_KEYBOARD_V1_KEY, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_virtual_keyboard_v1), 0, time, key, state);
}

/**
 * @ingroup iface_zwp_virtual_keyboard_v1
 *
 * Notifies the compositor that the modifier and/or group state has
 * changed, and it should update state.
 *
 * The client should use wl_keyboard.modifiers event to synchronize its
 * internal state with seat state.
 *
 * Keymap must be set before issuing this request.
 */
static inline void
zwp_virtual_keyboard_v1_modifiers(struct zwp_virtual_keyboard_v1 *zwp_virtual_keyboard_v1, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_virtual_keyboard_v1,
			 ZWP_VIRTUAL_KEYBOARD_V1_MODIFIERS, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_virtual_keyboard_v1), 0, mods_depressed, mods_latched, mods_locked, group);
}

/**
 * @ingroup iface_zwp_virtual_keyboard_v1
 */
static inline void
zwp_virtual_keyboard_v1_destroy(struct zwp_virtual_keyboard_v1 *zwp_virtual_keyboard_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_virtual_keyboard_v1,
			 ZWP_VIRTUAL_KEYBOARD_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_virtual_keyboard_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef ZWP_VIRTUAL_KEYBOARD_MANAGER_V1_ERROR_ENUM
#define ZWP_VIRTUAL_KEYBOARD_MANAGER_V1_ERROR_ENUM
enum zwp_virtual_keyboard_manager_v1_error {
	/**
	 * client not authorized to use the interface
	 */
	ZWP_VIRTUAL_KEYBOARD_MANAGER_V1_ERROR_UNAUTHORIZED = 0,
};
#endif /* ZWP_VIRTUAL_KEYBOARD_MANAGER_V1_ERROR_ENUM */

#define ZWP_VIRTUAL_KEYBOARD_MANAGER_V1_CREATE_VIRTUAL_KEYBOARD 0


/**
 * @ingroup iface_zwp_virtual_keyboard_manager_v1
 */
#define ZWP_VIRTUAL_KEYBOARD_MANAGER_V1_CREATE_VIRTUAL_KEYBOARD_SINCE_VERSION 1

/** @ingroup iface_zwp_virtual_keyboard_manager_v1 */
static inline void
zwp_virtual_keyboard_manager_v1_set_user_data(struct zwp_virtual_keyboard_manager_v1 *zwp_virtual_keyboard_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_virtual_keyboard_manager_v1, user_data);
}

/** @ingroup iface_zwp_virtual_keyboard_manager_v1 */
static inline void *
zwp_virtual_keyboard_manager_v1_get_user_data(struct zwp_virtual_keyboard_manager_v1 *zwp_virtual_keyboard_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_virtual_keyboard_manager_v1);
}

static inline uint32_t
zwp_virtual_keyboard_manager_v1_get_version(struct zwp_virtual_keyboard_manager_v1 *zwp_virtual_keyboard_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_virtual_keyboard_manager_v1);
}

/** @ingroup iface_zwp_virtual_keyboard_manager_v1 */
static inline void
zwp_virtual_keyboard_manager_v1_destroy(struct zwp_virtual_keyboard_manager_v1 *zwp_virtual_keyboard_manager_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zwp_virtual_keyboard_manager_v1);
}

/**
 * @ingroup iface_zwp_virtual_keyboard_manager_v1
 *
 * Creates a new virtual keyboard associated to a seat.
 *
 * If the compositor enables a keyboard to perform arbitrary actions, it
 * should present an error when an untrusted client requests a new
 * keyboard.
 */
static inline struct zwp_virtual_keyboard_v1 *
zwp_virtual_keyboard_manager_v1_create_virtual_keyboard(struct zwp_virtual_keyboard_manager_v1 *zwp_virtual_keyboard_manager_v1, struct wl_seat *seat)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zwp_virtual_keyboard_manager_v1,
			 ZWP_VIRTUAL_KEYBOARD_MANAGER_V1_CREATE_VIRTUAL_KEYBOARD, &zwp_virtual_keyboard_v1_interface, wl_proxy_get_version((struct wl_proxy *) zwp_virtual_keyboard_manager_v1), 0, seat, NULL);

	return (struct zwp_virtual_keyboard_v1 *) id;
}

#ifdef  __cplusplus
}
#endif

#endif
