%feature("docstring") OT::LogNormal
R"RAW(Lognormal distribution.

If :math:`X` follows a LogNormal distribution parametered by :math:`(\mu_\ell, \sigma_\ell)`, then
:math:`\log X` follows a normal distribution whose mean is :math:`\mu_\ell` and whose variance is
:math:`\sigma_\ell^2`.

Its probability density function is defined as:

.. math::

    f_X(x) = \frac{1}{\sqrt{2\pi}\sigma_\ell (x - \gamma)}
             \exp\left(- \frac{1}{2}
                       \left(\frac{\log(x - \gamma) - \mu_\ell}
                                  {\sigma_\ell}\right)^2\right),
             \quad x \in [\gamma; +\infty[

with :math:`\gamma, \mu_\ell \in \Rset` and :math:`\sigma_\ell > 0`.

Its first moments are:

.. math::
    :nowrap:

    \begin{eqnarray*}
        \Expect{X} & = & \exp\left(\mu_\ell + \sigma_\ell^2 / 2\right) + \gamma \\
        \Var{X} & = & \exp\left(2 \mu_\ell + \sigma_\ell^2\right)
                      \left(\exp(\sigma_\ell^2) - 1\right)
    \end{eqnarray*}

Parameters
----------
muLog : float
    Location parameter :math:`\mu_\ell`, the expectation of the logarithm of the log-normal random variable.

    Default value is 0.0.
sigmaLog : float, :math:`\sigma_\ell > 0`
    Scale parameter :math:`\sigma_\ell`, the standard deviation of the logarithm of the log-normal random variable.

    Default value is 1.0.
gamma : float, optional
    Location parameter :math:`\gamma < \mu`.

    Default value is 0.0.

Notes
-----
It is possible to create a LogNormal distribution from the alternative parametrizations :math:`(\mu, \sigma, \gamma)`: see  :class:`~openturns.LogNormalMuSigma` or :math:`(\mu, \sigma / \mu, \gamma)`: see  :class:`~openturns.LogNormalMuSigmaOverMu`. In that case, all the results are presented in that new parametrization.

In order to use the alternative parametrization only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(\mu_\ell, \sigma_\ell, \gamma)`.

Examples
--------
Create a distribution from its native parameters :math:`(\mu_\ell, \sigma_\ell, \gamma)`:

>>> import openturns as ot
>>> myDist = ot.LogNormal(1.0, 1.0, 0.0)

Create a it from the alternative parametrization :math:`(\mu, \sigma, \gamma)`:

>>> myDist2 = ot.LogNormal()
>>> myDist2.setParameter(ot.LogNormalMuSigma()([4.5, 5.8, 0.0]))

Create a it from the alternative parametrization :math:`(\mu, \sigma/\mu, \gamma)`:

>>> myDist3 = ot.LogNormal()
>>> myDist3.setParameter(ot.LogNormalMuSigmaOverMu()([4.5, 1.3, 0.0]))

Create it from :math:`(\mu, \sigma, \gamma)` and keep that parametrization for the remaining study: 

>>> myParam = ot.LogNormalMuSigma(4.5, 5.8, 0.0)
>>> myDist4 = ot.ParametrizedDistribution(myParam)

Create it from :math:`(\mu, \sigma/\mu, \gamma)` and keep that parametrization for the remaining study: 

>>> myParam = ot.LogNormalMuSigmaOverMu(4.5, 1.3, 0.0)
>>> myDist5 = ot.ParametrizedDistribution(myParam)

Draw a sample:

>>> sample = myDist.getSample(5)
)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::LogNormal::getGamma
R"RAW(Accessor to the distribution's location parameter :math:`\gamma`.

Returns
-------
gamma : float
    Location parameter :math:`\gamma`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::LogNormal::getMu
"Accessor to the distribution's mean.

Returns
-------
mu : float
    Mean."

// ---------------------------------------------------------------------

%feature("docstring") OT::LogNormal::getMuLog
R"RAW(Accessor to the distribution's location parameter :math:`\mu_\ell`.

Returns
-------
mu_log : float
    Location parameter :math:`\mu_\ell`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::LogNormal::getSigma
"Accessor to the distribution's standard deviation.

Returns
-------
sigma : float
    Standard deviation."

// ---------------------------------------------------------------------

%feature("docstring") OT::LogNormal::getSigmaLog
R"RAW(Accessor to the distribution's scale parameter :math:`\sigma_\ell`.

Returns
-------
sigma_log : float
    Scale parameter :math:`\sigma_\ell`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::LogNormal::getSigmaOverMu
R"RAW(Accessor to the distribution's coefficient of variation (if defined).

Returns
-------
cov : float
    Coefficient of variation :math:`\sigma/\mu, \mu \neq 0`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::LogNormal::setGamma
R"RAW(Accessor to the distribution's location parameter :math:`\gamma`.

Parameters
----------
gamma : float, :math:`\gamma < \mu`
    Location parameter :math:`\gamma`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::LogNormal::setMuLog
R"RAW(Accessor to the distribution's location parameter :math:`\mu_\ell`.

Parameters
----------
mu_log : float, :math:`\mu_\ell \in \Rset`
    Location parameter :math:`\mu_\ell`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::LogNormal::setSigmaLog
R"RAW(Accessor to the distribution's scale parameter :math:`\sigma_\ell`.

Parameters
----------
sigma_log : float, :math:`\sigma_\ell > 0`
    Scale parameter :math:`\sigma_\ell`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::LogNormal::setMuSigma
R"RAW(Accessor to the distribution's mean and standard deviation.

Parameters
----------
mu : float, :math:`\mu > \gamma`
    Mean.
sigma : float, :math:`\sigma > 0`
    Standard deviation.)RAW"
