/* AVB support */
/* SPDX-FileCopyrightText: Copyright © 2025 Kebag-Logic */
/* SPDX-FileCopyrightText: Copyright © 2025 Alexandre Malki <alexandre.malki@kebag-logic.com> */
/* SPDX-FileCopyrightText: Copyright © 2025 Simon Gapp <simon.gapp@kebag-logic.com> */
/* SPDX-License-Identifier: MIT */

#ifndef __AECP_AEM_CONTROLS_H__
#define __AECP_AEM_CONTROLS_H__

// TODO, When all the AVB needs to be supported then addition needs to be don here
/* IEEE 1722.1-2021, Table 7-121 - Value Types*/
#define AECP_AEM_CTRL_LINEAR_INT8             0x0000
#define AECP_AEM_CTRL_LINEAR_UINT8            0x0001
#define AECP_AEM_CTRL_LINEAR_INT16            0x0002
#define AECP_AEM_CTRL_LINEAR_UINT16           0x0003
#define AECP_AEM_CTRL_LINEAR_INT32            0x0004
#define AECP_AEM_CTRL_LINEAR_UINT32           0x0005
#define AECP_AEM_CTRL_LINEAR_INT64            0x0006
#define AECP_AEM_CTRL_LINEAR_UINT64           0x0007
#define AECP_AEM_CTRL_LINEAR_FLOAT            0x0008
#define AECP_AEM_CTRL_LINEAR_DOUBLE           0x0009

#define AECP_AEM_CTRL_SELECTOR_INT8           0x000a
#define AECP_AEM_CTRL_SELECTOR_UINT8          0x000b
#define AECP_AEM_CTRL_SELECTOR_INT16          0x000c
#define AECP_AEM_CTRL_SELECTOR_UINT16         0x000d
#define AECP_AEM_CTRL_SELECTOR_INT32          0x000e
#define AECP_AEM_CTRL_SELECTOR_UINT32         0x000f
#define AECP_AEM_CTRL_SELECTOR_INT64          0x0010
#define AECP_AEM_CTRL_SELECTOR_UINT64         0x0011
#define AECP_AEM_CTRL_SELECTOR_FLOAT          0x0012
#define AECP_AEM_CTRL_SELECTOR_DOUBLE         0x0013
#define AECP_AEM_CTRL_SELECTOR_STRING         0x0014

#define AEPC_AEM_CTRL_ARRAY_INT8              0x0015
#define AEPC_AEM_CTRL_ARRAY_UINT8             0x0016
#define AEPC_AEM_CTRL_ARRAY_INT16             0x0017
#define AEPC_AEM_CTRL_ARRAY_UINT16            0x0018
#define AEPC_AEM_CTRL_ARRAY_INT32             0x0019
#define AEPC_AEM_CTRL_ARRAY_UINT32            0x001a
#define AEPC_AEM_CTRL_ARRAY_INT64             0x001b
#define AEPC_AEM_CTRL_ARRAY_UINT64            0x001c
#define AEPC_AEM_CTRL_ARRAY_FLOAT             0x001d
#define AEPC_AEM_CTRL_ARRAY_DOUBLE            0x001e

#define AECP_AEM_CTRL_UTF8                    0x001f
#define AECP_AEM_CTRL_BODE_PLOT               0x0020
#define AECP_AEM_CTRL_SMPTE_TIME              0x0021
#define AECP_AEM_CTRL_SAMPLE_RATE             0x0022
#define AECP_AEM_CTRL_GPTP_TIME               0x0023

#define AECP_AEM_CTRL_CTRL_VENDOR          0x3ffe

/* Definition of the UNIT codes */
/* IEEE 1722.1-2021, Table 7-75 - Codes for Unitless quantities*/
#define AECP_AEM_CTRL_UNIT_CODE_UNITLESS      (0)
#define AECP_AEM_CTRL_UNIT_CODE_COUNT         (1)
#define AECP_AEM_CTRL_UNIT_CODE_PERCENT       (2)
#define AECP_AEM_CTRL_UNIT_CODE_FSTOP         (3)



#define AECP_AEM_CTRL_FORMAT_VENDOR           (0)
#define AECP_AEM_CTRL_FORMAT_AVDECC           (1)

/* IEEE 1722.1-2021, Sec. 7.3.5 Control Types */
#define AEM_CTRL_TYPE_ENABLE                            0x90E0F00000000000ULL
#define AEM_CTRL_TYPE_IDENTIFY                          0x90E0F00000000001ULL
#define AEM_CTRL_TYPE_MUTE                              0x90E0F00000000002ULL
#define AEM_CTRL_TYPE_INVERT                            0x90E0F00000000003ULL
#define AEM_CTRL_TYPE_GAIN                              0x90E0F00000000004ULL
#define AEM_CTRL_TYPE_ATTENUATE                         0x90E0F00000000005ULL
#define AEM_CTRL_TYPE_DELAY                             0x90E0F00000000006ULL
#define AEM_CTRL_TYPE_SRC_MODE                          0x90E0F00000000007ULL
#define AEM_CTRL_TYPE_SNAPSHOT                          0x90E0F00000000008ULL
#define AEM_CTRL_TYPE_POW_LINE_FREQ                     0x90E0F00000000009ULL
#define AEM_CTRL_TYPE_POWER_STATUS                      0x90E0F0000000000AULL
#define AEM_CTRL_TYPE_FAN_STATUS                        0x90E0F0000000000BULL
#define AEM_CTRL_TYPE_TEMPERATURE                       0x90E0F0000000000CULL
#define AEM_CTRL_TYPE_ALTITUDE                          0x90E0F0000000000DULL
#define AEM_CTRL_TYPE_ABSOLUTE_HUMIDITY                 0x90E0F0000000000EULL
#define AEM_CTRL_TYPE_RELATIVE_HUMIDITY                 0x90E0F0000000000FULL
#define AEM_CTRL_TYPE_ORIENTATION                       0x90E0F00000000010ULL
#define AEM_CTRL_TYPE_VELOCITY                          0x90E0F00000000011ULL
#define AEM_CTRL_TYPE_ACCELERATION                      0x90E0F00000000012ULL
#define AEM_CTRL_TYPE_FILTER_RESPONSE                   0x90E0F00000000013ULL
#define AEM_CTRL_TYPE_BAROMETRIC_PRESSURE               0x90E0F00000000014ULL
#define AEM_CTRL_TYPE_MANUFACTURER_URL                  0x90E0F00000000015ULL
#define AEM_CTRL_TYPE_ENTITY_URL                        0x90E0F00000000016ULL
#define AEM_CTRL_TYPE_CONFIGURATION_URL                 0x90E0F00000000017ULL
#define AEM_CTRL_TYPE_GENERIC_URL                       0x90E0F00000000018ULL
#define AEM_CTRL_TYPE_FAULT                             0x90E0F00000000019ULL
#define AEM_CTRL_TYPE_CONTROLLER_TARGET_ENTITY          0x90E0F0000000001AULL
#define AEM_CTRL_TYPE_CONTROLLER_TARGET_OBJECT          0x90E0F0000000001BULL
#define AEM_CTRL_TYPE_LATENCY_COMPENSATION              0x90E0F0000000001CULL

#define AEM_CTRL_TYPE_PANPOT                            0x90E0F00000010000ULL
#define AEM_CTRL_TYPE_PHANTOM                           0x90E0F00000010001ULL
#define AEM_CTRL_TYPE_AUDIO_SCALE                       0x90E0F00000010002ULL
#define AEM_CTRL_TYPE_AUDIO_METERS                      0x90E0F00000010003ULL
#define AEM_CTRL_TYPE_AUDIO_SPECTRUM                    0x90E0F00000010004ULL

#define AEM_CTRL_TYPE_SCANNING_MODE                     0x90E0F00000020000ULL
#define AEM_CTRL_TYPE_AUTO_EXP_MODE                     0x90E0F00000020001ULL
#define AEM_CTRL_TYPE_AUTO_EXP_PRIO                     0x90E0F00000020002ULL
#define AEM_CTRL_TYPE_EXP_TIME                          0x90E0F00000020003ULL
#define AEM_CTRL_TYPE_FOCUS                             0x90E0F00000020004ULL
#define AEM_CTRL_TYPE_FOCUS_AUTO                        0x90E0F00000020005ULL
#define AEM_CTRL_TYPE_IRIS                              0x90E0F00000020006ULL
#define AEM_CTRL_TYPE_ZOOM                              0x90E0F00000020007ULL
#define AEM_CTRL_TYPE_PRIVACY                           0x90E0F00000020008ULL
#define AEM_CTRL_TYPE_BACKLIGHT                         0x90E0F00000020009ULL
#define AEM_CTRL_TYPE_BRIGHTNESS                        0x90E0F0000002000AULL
#define AEM_CTRL_TYPE_CONTRAST                          0x90E0F0000002000BULL
#define AEM_CTRL_TYPE_HUE                               0x90E0F0000002000CULL
#define AEM_CTRL_TYPE_SATURATION                        0x90E0F0000002000DULL
#define AEM_CTRL_TYPE_SHARPNESS                         0x90E0F0000002000EULL
#define AEM_CTRL_TYPE_GAMMA                             0x90E0F0000002000FULL
#define AEM_CTRL_TYPE_WHITE_BAL_TEMP                    0x90E0F00000020010ULL
#define AEM_CTRL_TYPE_WHITE_BAL_TEMP_AUTO               0x90E0F00000020011ULL
#define AEM_CTRL_TYPE_WHITE_BAL_COMP                    0x90E0F00000020012ULL
#define AEM_CTRL_TYPE_WHITE_BAL_COMP_AUTO               0x90E0F00000020013ULL
#define AEM_CTRL_TYPE_DIGITAL_ZOOM                      0x90E0F00000020014ULL

#define AEM_CTRL_TYPE_MEDIA_PLAYLIST                    0x90E0F00000030000ULL
#define AEM_CTRL_TYPE_MEDIA_PLAYLIST_NAME               0x90E0F00000030001ULL
#define AEM_CTRL_TYPE_MEDIA_DISK                        0x90E0F00000030002ULL
#define AEM_CTRL_TYPE_MEIDA_DISK_NAME                   0x90E0F00000030003ULL
#define AEM_CTRL_TYPE_TRACK                             0x90E0F00000030004ULL
#define AEM_CTRL_TYPE_TRACK_NAME                        0x90E0F00000030005ULL
#define AEM_CTRL_TYPE_SPEED                             0x90E0F00000030006ULL
#define AEM_CTRL_TYPE_MEDIA_SAMPLE_POSITION             0x90E0F00000030007ULL
#define AEM_CTRL_TYPE_MEDIA_PLAYBACK_TRANSPORT          0x90E0F00000030008ULL
#define AEM_CTRL_TYPE_MEDIA_RECORD_TRANSPORT            0x90E0F00000030009ULL

#define AEM_CTRL_TYPE_FREQUENCY                         0x90E0F00000040000ULL
#define AEM_CTRL_TYPE_MODULATION                        0x90E0F00000040001ULL
#define AEM_CTRL_TYPE_POLARIZATION                      0x90E0F00000040002ULL

#define AEM_CTRL_TYPE_BAUD_RATE                         0x90E0F00000050000ULL
#define AEM_CTRL_TYPE_BIT_WIDTH                         0x90E0F00000050001ULL
#define AEM_CTRL_TYPE_PARITY                            0x90E0F00000050002ULL
#define AEM_CTRL_TYPE_STOP_BITS                         0x90E0F00000050003ULL

#define AEM_CTRL_TYPE_INTERFACE_OPERATIONAL             0x90E0F00000060000ULL
#define AEM_CTRL_TYPE_INTERFACE_MEDIA_OPTIONS           0x90E0F00000060001ULL
#define AEM_CTRL_TYPE_INTERFACE_MEDIA_STATUS            0x90E0F00000060002ULL
#define AEM_CTRL_TYPE_INTERFACE_NETWORK_NAME            0x90E0F00000060003ULL
#define AEM_CTRL_TYPE_FQTSS_DELTA_BANDWIDTH             0x90E0F00000060004ULL
#define AEM_CTRL_TYPE_FQTSS_ADMIN_IDLE_SLOPE            0x90E0F00000060005ULL
#define AEM_CTRL_TYPE_FQTSS_OPER_IDLE_SLOPE             0x90E0F00000060006ULL
#define AEM_CTRL_TYPE_FQTSS_PORT_TRANSMIT_RATE          0x90E0F00000060007ULL
#define AEM_CTRL_TYPE_FQTSS_CLASS_MEASUREMENT_INTERVAL  0x90E0F00000060008ULL
#define AEM_CTRL_TYPE_FQTSS_LOCK_CLASS_BANDWIDTH        0x90E0F00000060009ULL

/* Identify
* IEEE 1722.1, Sec. 7.3.5.2 - Identify Control (IDENTIFY)
* Milan v1.2, Sec. 5.4.5.4 - Identification notification
*/
#define AECP_AEM_CTRL_IDENTIFY_UNIT_MULTIPLY  0
#define AECP_AEM_CTRL_IDENTIFY_UNIT_CODE      AECP_AEM_CTRL_UNIT_CODE_UNITLESS
#define AECP_AEM_CTRL_IDENTIFY_STEP           (255)
#define AECP_AEM_CTRL_IDENTIFY_MINIMUM        (0)
#define AECP_AEM_CTRL_IDENTIFY_MAXIMUM        (255)


#define BASE_CTRL_TYPE_MAC            { 0x90, 0xe0, 0xf0, 0x01, 0x00, 0x00 };
// 1722.1-2021, Annex B Table B.1
#define BASE_CTRL_IDENTIFY_MAC        { 0x90, 0xe0, 0xf0, 0x00, 0x00, 0x01 };

#endif //__AECP_AEM_CONTROLS_H__
