# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.computebulkactions import ComputeBulkActionsMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-computebulkactions
# USAGE
    python bulk_actions_virtual_machines_execute_create_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ComputeBulkActionsMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.bulk_actions.virtual_machines_execute_create(
        location="eastus2euap",
        request_body={
            "correlationid": "7efcfae3-f50d-4323-9aba-1093a33368f8",
            "executionParameters": {"retryPolicy": {"retryCount": 5, "retryWindowInMinutes": 45}},
            "resourceConfigParameters": {
                "baseProfile": {
                    "computeApiVersion": "2023-09-01",
                    "properties": {
                        "hardwareProfile": {"vmSize": "Standard_D2ads_v5"},
                        "networkProfile": {
                            "networkApiVersion": "2022-07-01",
                            "networkInterfaceConfigurations": [
                                {
                                    "name": "vmTest",
                                    "properties": {
                                        "enableIPForwarding": True,
                                        "ipConfigurations": [
                                            {
                                                "name": "vmTest",
                                                "properties": {
                                                    "applicationGatewayBackendAddressPools": [],
                                                    "loadBalancerBackendAddressPools": [],
                                                    "primary": True,
                                                    "subnet": {
                                                        "id": "/subscriptions/264f0c8a-4d5f-496c-80df-b438624ce55f/resourceGroups/yourresourcegroup/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default"
                                                    },
                                                },
                                            }
                                        ],
                                        "primary": True,
                                    },
                                }
                            ],
                        },
                        "storageProfile": {
                            "diskControllerType": "SCSI",
                            "imageReference": {
                                "offer": "WindowsServer",
                                "publisher": "MicrosoftWindowsServer",
                                "sku": "2022-datacenter-azure-edition",
                                "version": "latest",
                            },
                            "osDisk": {
                                "caching": "ReadWrite",
                                "createOption": "FromImage",
                                "deleteOption": "Detach",
                                "diskSizeGB": 127,
                                "managedDisk": {"storageAccountType": "Standard_LRS"},
                                "osType": "Windows",
                            },
                        },
                        "vmExtensions": [
                            {
                                "location": "eastus2euap",
                                "name": "Microsoft.Azure.Geneva.GenevaMonitoring",
                                "properties": {
                                    "autoUpgradeMinorVersion": True,
                                    "enableAutomaticUpgrade": True,
                                    "publisher": "Microsoft.Azure.Geneva",
                                    "suppressFailures": True,
                                    "type": "GenevaMonitoring",
                                    "typeHandlerVersion": "2.0",
                                },
                            }
                        ],
                    },
                    "resourcegroupName": "yourresourcegroup",
                },
                "resourceCount": 1,
                "resourceOverrides": [
                    {
                        "location": "eastus2euap",
                        "name": "testvmtestTwo",
                        "properties": {
                            "hardwareProfile": {"vmSize": "Standard_D2ads_v5"},
                            "osProfile": {
                                "adminPassword": "YourStr0ngP@ssword123!",
                                "adminUsername": "testUserName",
                                "computerName": "testtestTwo",
                                "windowsConfiguration": {
                                    "enableAutomaticUpdates": True,
                                    "patchSettings": {
                                        "assessmentMode": "ImageDefault",
                                        "patchMode": "AutomaticByPlatform",
                                    },
                                    "provisionVmAgent": True,
                                },
                            },
                        },
                    }
                ],
            },
        },
    )
    print(response)


# x-ms-original-file: 2026-02-01-preview/BulkActions_VirtualMachinesExecuteCreate_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
