# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AutoScaleProperties(_Model):
    """The auto scale settings on Elastic San Appliance.

    :ivar scale_up_properties: Scale up settings on Elastic San Appliance.
    :vartype scale_up_properties: ~azure.mgmt.elasticsan.models.ScaleUpProperties
    """

    scale_up_properties: Optional["_models.ScaleUpProperties"] = rest_field(
        name="scaleUpProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Scale up settings on Elastic San Appliance."""

    @overload
    def __init__(
        self,
        *,
        scale_up_properties: Optional["_models.ScaleUpProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskSnapshotList(_Model):
    """object to hold array of Disk Snapshot ARM IDs.

    :ivar disk_snapshot_ids: array of DiskSnapshot ARM IDs. Required.
    :vartype disk_snapshot_ids: list[str]
    """

    disk_snapshot_ids: list[str] = rest_field(
        name="diskSnapshotIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """array of DiskSnapshot ARM IDs. Required."""

    @overload
    def __init__(
        self,
        *,
        disk_snapshot_ids: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ElasticSan(TrackedResource):
    """Response for ElasticSan request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of ElasticSan. Required.
    :vartype properties: ~azure.mgmt.elasticsan.models.ElasticSanProperties
    """

    properties: "_models.ElasticSanProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Properties of ElasticSan. Required."""

    __flattened_items = [
        "sku",
        "availability_zones",
        "provisioning_state",
        "base_size_ti_b",
        "extended_capacity_size_ti_b",
        "total_volume_size_gi_b",
        "volume_group_count",
        "total_iops",
        "total_m_bps",
        "total_size_ti_b",
        "private_endpoint_connections",
        "public_network_access",
        "auto_scale_properties",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: "_models.ElasticSanProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ElasticSanProperties(_Model):
    """Elastic San response properties.

    :ivar sku: resource sku. Required.
    :vartype sku: ~azure.mgmt.elasticsan.models.Sku
    :ivar availability_zones: Logical zone for Elastic San resource; example: ["1"].
    :vartype availability_zones: list[str]
    :ivar provisioning_state: State of the operation on the resource. Known values are: "Invalid",
     "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", "Deleting", "Deleted",
     and "Restoring".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    :ivar base_size_ti_b: Base size of the Elastic San appliance in TiB. Required.
    :vartype base_size_ti_b: int
    :ivar extended_capacity_size_ti_b: Extended size of the Elastic San appliance in TiB. Required.
    :vartype extended_capacity_size_ti_b: int
    :ivar total_volume_size_gi_b: Total size of the provisioned Volumes in GiB.
    :vartype total_volume_size_gi_b: int
    :ivar volume_group_count: Total number of volume groups in this Elastic San appliance.
    :vartype volume_group_count: int
    :ivar total_iops: Total Provisioned IOPS of the Elastic San appliance.
    :vartype total_iops: int
    :ivar total_m_bps: Total Provisioned MBps Elastic San appliance.
    :vartype total_m_bps: int
    :ivar total_size_ti_b: Total size of the Elastic San appliance in TB.
    :vartype total_size_ti_b: int
    :ivar private_endpoint_connections: The list of Private Endpoint Connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.elasticsan.models.PrivateEndpointConnection]
    :ivar public_network_access: Allow or disallow public network access to ElasticSan. Value is
     optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are: "Enabled" and
     "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.elasticsan.models.PublicNetworkAccess
    :ivar auto_scale_properties: Auto Scale Properties for Elastic San Appliance.
    :vartype auto_scale_properties: ~azure.mgmt.elasticsan.models.AutoScaleProperties
    """

    sku: "_models.Sku" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """resource sku. Required."""
    availability_zones: Optional[list[str]] = rest_field(
        name="availabilityZones", visibility=["read", "create", "update", "delete", "query"]
    )
    """Logical zone for Elastic San resource; example: [\"1\"]."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStates"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """State of the operation on the resource. Known values are: \"Invalid\", \"Succeeded\",
     \"Failed\", \"Canceled\", \"Pending\", \"Creating\", \"Updating\", \"Deleting\", \"Deleted\",
     and \"Restoring\"."""
    base_size_ti_b: int = rest_field(name="baseSizeTiB", visibility=["read", "create"])
    """Base size of the Elastic San appliance in TiB. Required."""
    extended_capacity_size_ti_b: int = rest_field(name="extendedCapacitySizeTiB", visibility=["read", "create"])
    """Extended size of the Elastic San appliance in TiB. Required."""
    total_volume_size_gi_b: Optional[int] = rest_field(name="totalVolumeSizeGiB", visibility=["read"])
    """Total size of the provisioned Volumes in GiB."""
    volume_group_count: Optional[int] = rest_field(name="volumeGroupCount", visibility=["read"])
    """Total number of volume groups in this Elastic San appliance."""
    total_iops: Optional[int] = rest_field(name="totalIops", visibility=["read"])
    """Total Provisioned IOPS of the Elastic San appliance."""
    total_m_bps: Optional[int] = rest_field(name="totalMBps", visibility=["read"])
    """Total Provisioned MBps Elastic San appliance."""
    total_size_ti_b: Optional[int] = rest_field(name="totalSizeTiB", visibility=["read"])
    """Total size of the Elastic San appliance in TB."""
    private_endpoint_connections: Optional[list["_models.PrivateEndpointConnection"]] = rest_field(
        name="privateEndpointConnections", visibility=["read"]
    )
    """The list of Private Endpoint Connections."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allow or disallow public network access to ElasticSan. Value is optional but if passed in, must
     be 'Enabled' or 'Disabled'. Known values are: \"Enabled\" and \"Disabled\"."""
    auto_scale_properties: Optional["_models.AutoScaleProperties"] = rest_field(
        name="autoScaleProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Auto Scale Properties for Elastic San Appliance."""

    @overload
    def __init__(
        self,
        *,
        sku: "_models.Sku",
        base_size_ti_b: int,
        extended_capacity_size_ti_b: int,
        availability_zones: Optional[list[str]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        auto_scale_properties: Optional["_models.AutoScaleProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ElasticSanUpdate(_Model):
    """Response for ElasticSan update request.

    :ivar properties: Properties of ElasticSan.
    :vartype properties: ~azure.mgmt.elasticsan.models.ElasticSanUpdateProperties
    :ivar tags: Update tags.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.ElasticSanUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of ElasticSan."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Update tags."""

    __flattened_items = [
        "base_size_ti_b",
        "extended_capacity_size_ti_b",
        "public_network_access",
        "auto_scale_properties",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ElasticSanUpdateProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ElasticSanUpdateProperties(_Model):
    """Elastic San update properties.

    :ivar base_size_ti_b: Base size of the Elastic San appliance in TiB.
    :vartype base_size_ti_b: int
    :ivar extended_capacity_size_ti_b: Extended size of the Elastic San appliance in TiB.
    :vartype extended_capacity_size_ti_b: int
    :ivar public_network_access: Allow or disallow public network access to ElasticSan Account.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.elasticsan.models.PublicNetworkAccess
    :ivar auto_scale_properties: Auto Scale Properties for Elastic San Appliance.
    :vartype auto_scale_properties: ~azure.mgmt.elasticsan.models.AutoScaleProperties
    """

    base_size_ti_b: Optional[int] = rest_field(name="baseSizeTiB", visibility=["update"])
    """Base size of the Elastic San appliance in TiB."""
    extended_capacity_size_ti_b: Optional[int] = rest_field(name="extendedCapacitySizeTiB", visibility=["update"])
    """Extended size of the Elastic San appliance in TiB."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allow or disallow public network access to ElasticSan Account. Value is optional but if passed
     in, must be 'Enabled' or 'Disabled'. Known values are: \"Enabled\" and \"Disabled\"."""
    auto_scale_properties: Optional["_models.AutoScaleProperties"] = rest_field(
        name="autoScaleProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Auto Scale Properties for Elastic San Appliance."""

    @overload
    def __init__(
        self,
        *,
        base_size_ti_b: Optional[int] = None,
        extended_capacity_size_ti_b: Optional[int] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        auto_scale_properties: Optional["_models.AutoScaleProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EncryptionIdentity(_Model):
    """Encryption identity for the volume group.

    :ivar encryption_user_assigned_identity: Resource identifier of the UserAssigned identity to be
     associated with server-side encryption on the volume group.
    :vartype encryption_user_assigned_identity: str
    """

    encryption_user_assigned_identity: Optional[str] = rest_field(
        name="userAssignedIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource identifier of the UserAssigned identity to be associated with server-side encryption
     on the volume group."""

    @overload
    def __init__(
        self,
        *,
        encryption_user_assigned_identity: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EncryptionProperties(_Model):
    """The encryption settings on the volume group.

    :ivar key_vault_properties: Properties provided by key vault.
    :vartype key_vault_properties: ~azure.mgmt.elasticsan.models.KeyVaultProperties
    :ivar encryption_identity: The identity to be used with service-side encryption at rest.
    :vartype encryption_identity: ~azure.mgmt.elasticsan.models.EncryptionIdentity
    """

    key_vault_properties: Optional["_models.KeyVaultProperties"] = rest_field(
        name="keyVaultProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties provided by key vault."""
    encryption_identity: Optional["_models.EncryptionIdentity"] = rest_field(
        name="identity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity to be used with service-side encryption at rest."""

    @overload
    def __init__(
        self,
        *,
        key_vault_properties: Optional["_models.KeyVaultProperties"] = None,
        encryption_identity: Optional["_models.EncryptionIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.elasticsan.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.elasticsan.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.elasticsan.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Identity(_Model):
    """Identity for the resource.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Required. Known values are: "None", "SystemAssigned", and
     "UserAssigned".
    :vartype type: str or ~azure.mgmt.elasticsan.models.IdentityType
    :ivar user_assigned_identities: Gets or sets a list of key value pairs that describe the set of
     User Assigned identities that will be used with this volume group. The key is the ARM resource
     identifier of the identity.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.elasticsan.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of resource identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of resource."""
    type: Union[str, "_models.IdentityType"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The identity type. Required. Known values are: \"None\", \"SystemAssigned\", and
     \"UserAssigned\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a list of key value pairs that describe the set of User Assigned identities that
     will be used with this volume group. The key is the ARM resource identifier of the identity."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.IdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IscsiTargetInfo(_Model):
    """Iscsi target information.

    :ivar target_iqn: iSCSI Target IQN (iSCSI Qualified Name); example:
     "iqn.2005-03.org.iscsi:server".
    :vartype target_iqn: str
    :ivar target_portal_hostname: iSCSI Target Portal Host Name.
    :vartype target_portal_hostname: str
    :ivar target_portal_port: iSCSI Target Portal Port.
    :vartype target_portal_port: int
    :ivar provisioning_state: State of the operation on the resource. Known values are: "Invalid",
     "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", "Deleting", "Deleted",
     and "Restoring".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    :ivar status: Operational status of the iSCSI Target. Known values are: "Invalid", "Unknown",
     "Healthy", "Unhealthy", "Updating", "Running", "Stopped", and "Stopped (deallocated)".
    :vartype status: str or ~azure.mgmt.elasticsan.models.OperationalStatus
    """

    target_iqn: Optional[str] = rest_field(name="targetIqn", visibility=["read"])
    """iSCSI Target IQN (iSCSI Qualified Name); example: \"iqn.2005-03.org.iscsi:server\"."""
    target_portal_hostname: Optional[str] = rest_field(name="targetPortalHostname", visibility=["read"])
    """iSCSI Target Portal Host Name."""
    target_portal_port: Optional[int] = rest_field(name="targetPortalPort", visibility=["read"])
    """iSCSI Target Portal Port."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStates"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """State of the operation on the resource. Known values are: \"Invalid\", \"Succeeded\",
     \"Failed\", \"Canceled\", \"Pending\", \"Creating\", \"Updating\", \"Deleting\", \"Deleted\",
     and \"Restoring\"."""
    status: Optional[Union[str, "_models.OperationalStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Operational status of the iSCSI Target. Known values are: \"Invalid\", \"Unknown\",
     \"Healthy\", \"Unhealthy\", \"Updating\", \"Running\", \"Stopped\", and \"Stopped
     (deallocated)\"."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.OperationalStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyVaultProperties(_Model):
    """Properties of key vault.

    :ivar key_name: The name of KeyVault key.
    :vartype key_name: str
    :ivar key_version: The version of KeyVault key.
    :vartype key_version: str
    :ivar key_vault_uri: The Uri of KeyVault.
    :vartype key_vault_uri: str
    :ivar current_versioned_key_identifier: The object identifier of the current versioned Key
     Vault Key in use.
    :vartype current_versioned_key_identifier: str
    :ivar last_key_rotation_timestamp: Timestamp of last rotation of the Key Vault Key.
    :vartype last_key_rotation_timestamp: ~datetime.datetime
    :ivar current_versioned_key_expiration_timestamp: This is a read only property that represents
     the expiration time of the current version of the customer managed key used for encryption.
    :vartype current_versioned_key_expiration_timestamp: ~datetime.datetime
    """

    key_name: Optional[str] = rest_field(name="keyName", visibility=["read", "create", "update", "delete", "query"])
    """The name of KeyVault key."""
    key_version: Optional[str] = rest_field(
        name="keyVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of KeyVault key."""
    key_vault_uri: Optional[str] = rest_field(
        name="keyVaultUri", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Uri of KeyVault."""
    current_versioned_key_identifier: Optional[str] = rest_field(
        name="currentVersionedKeyIdentifier", visibility=["read"]
    )
    """The object identifier of the current versioned Key Vault Key in use."""
    last_key_rotation_timestamp: Optional[datetime.datetime] = rest_field(
        name="lastKeyRotationTimestamp", visibility=["read"], format="rfc3339"
    )
    """Timestamp of last rotation of the Key Vault Key."""
    current_versioned_key_expiration_timestamp: Optional[datetime.datetime] = rest_field(
        name="currentVersionedKeyExpirationTimestamp", visibility=["read"], format="rfc3339"
    )
    """This is a read only property that represents the expiration time of the current version of the
     customer managed key used for encryption."""

    @overload
    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
        key_vault_uri: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedByInfo(_Model):
    """Parent resource information.

    :ivar resource_id: Resource ID of the resource managing the volume, this is a restricted field
     and can only be set for internal use.
    :vartype resource_id: str
    """

    resource_id: Optional[str] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource ID of the resource managing the volume, this is a restricted field and can only be set
     for internal use."""

    @overload
    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkRuleSet(_Model):
    """A set of rules governing the network accessibility.

    :ivar virtual_network_rules: The list of virtual network rules.
    :vartype virtual_network_rules: list[~azure.mgmt.elasticsan.models.VirtualNetworkRule]
    """

    virtual_network_rules: Optional[list["_models.VirtualNetworkRule"]] = rest_field(
        name="virtualNetworkRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of virtual network rules."""

    @overload
    def __init__(
        self,
        *,
        virtual_network_rules: Optional[list["_models.VirtualNetworkRule"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.elasticsan.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.elasticsan.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.elasticsan.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class PreValidationResponse(_Model):
    """response object for pre validation api.

    :ivar validation_status: a status value indicating success or failure of validation.
    :vartype validation_status: str
    """

    validation_status: Optional[str] = rest_field(
        name="validationStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """a status value indicating success or failure of validation."""

    @overload
    def __init__(
        self,
        *,
        validation_status: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpoint(_Model):
    """Response for PrivateEndpoint.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The ARM identifier for Private Endpoint."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    """


class PrivateEndpointConnection(ProxyResource):
    """Response for PrivateEndpoint Connection object.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar properties: Private Endpoint Connection Properties. Required.
    :vartype properties: ~azure.mgmt.elasticsan.models.PrivateEndpointConnectionProperties
    """

    properties: "_models.PrivateEndpointConnectionProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Private Endpoint Connection Properties. Required."""

    __flattened_items = ["provisioning_state", "private_endpoint", "private_link_service_connection_state", "group_ids"]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.PrivateEndpointConnectionProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateEndpointConnectionProperties(_Model):
    """Response for PrivateEndpoint connection properties.

    :ivar provisioning_state: Provisioning State of Private Endpoint connection resource. Known
     values are: "Invalid", "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating",
     "Deleting", "Deleted", and "Restoring".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    :ivar private_endpoint: Private Endpoint resource.
    :vartype private_endpoint: ~azure.mgmt.elasticsan.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Private Link Service Connection State. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.elasticsan.models.PrivateLinkServiceConnectionState
    :ivar group_ids: List of resources private endpoint is mapped.
    :vartype group_ids: list[str]
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningStates"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State of Private Endpoint connection resource. Known values are: \"Invalid\",
     \"Succeeded\", \"Failed\", \"Canceled\", \"Pending\", \"Creating\", \"Updating\", \"Deleting\",
     \"Deleted\", and \"Restoring\"."""
    private_endpoint: Optional["_models.PrivateEndpoint"] = rest_field(
        name="privateEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """Private Endpoint resource."""
    private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState" = rest_field(
        name="privateLinkServiceConnectionState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Private Link Service Connection State. Required."""
    group_ids: Optional[list[str]] = rest_field(
        name="groupIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of resources private endpoint is mapped."""

    @overload
    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        group_ids: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkResource(Resource):
    """A private link resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.elasticsan.models.PrivateLinkResourceProperties
    """

    properties: Optional["_models.PrivateLinkResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource properties."""

    __flattened_items = ["group_id", "required_members", "required_zone_names"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateLinkResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateLinkResourceListResult(_Model):
    """A list of private link resources.

    :ivar value: Array of private link resources. Required.
    :vartype value: list[~azure.mgmt.elasticsan.models.PrivateLinkResource]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    value: list["_models.PrivateLinkResource"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Array of private link resources. Required."""
    next_link: Optional[str] = rest_field(name="nextLink", visibility=["read"])
    """URI to fetch the next section of the paginated response."""

    @overload
    def __init__(
        self,
        *,
        value: list["_models.PrivateLinkResource"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkResourceProperties(_Model):
    """Properties of a private link resource.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    group_id: Optional[str] = rest_field(name="groupId", visibility=["read"])
    """The private link resource group id."""
    required_members: Optional[list[str]] = rest_field(name="requiredMembers", visibility=["read"])
    """The private link resource required member names."""
    required_zone_names: Optional[list[str]] = rest_field(
        name="requiredZoneNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The private link resource Private link DNS zone name."""

    @overload
    def __init__(
        self,
        *,
        required_zone_names: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkServiceConnectionState(_Model):
    """Response for Private Link Service Connection state.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", "Failed", and "Rejected".
    :vartype status: str or ~azure.mgmt.elasticsan.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the connection has been Approved/Rejected/Removed by the owner of the
     service. Known values are: \"Pending\", \"Approved\", \"Failed\", and \"Rejected\"."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The reason for approval/rejection of the connection."""
    actions_required: Optional[str] = rest_field(
        name="actionsRequired", visibility=["read", "create", "update", "delete", "query"]
    )
    """A message indicating if changes on the service provider require any updates on the consumer."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScaleUpProperties(_Model):
    """Scale up properties on Elastic San Appliance.

    :ivar unused_size_ti_b: Unused size on Elastic San appliance in TiB.
    :vartype unused_size_ti_b: int
    :ivar increase_capacity_unit_by_ti_b: Unit to increase Capacity Unit on Elastic San appliance
     in TiB.
    :vartype increase_capacity_unit_by_ti_b: int
    :ivar capacity_unit_scale_up_limit_ti_b: Maximum scale up size on Elastic San appliance in TiB.
    :vartype capacity_unit_scale_up_limit_ti_b: int
    :ivar auto_scale_policy_enforcement: Enable or Disable scale up setting on Elastic San
     Appliance. Known values are: "None", "Enabled", and "Disabled".
    :vartype auto_scale_policy_enforcement: str or
     ~azure.mgmt.elasticsan.models.AutoScalePolicyEnforcement
    """

    unused_size_ti_b: Optional[int] = rest_field(
        name="unusedSizeTiB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Unused size on Elastic San appliance in TiB."""
    increase_capacity_unit_by_ti_b: Optional[int] = rest_field(
        name="increaseCapacityUnitByTiB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Unit to increase Capacity Unit on Elastic San appliance in TiB."""
    capacity_unit_scale_up_limit_ti_b: Optional[int] = rest_field(
        name="capacityUnitScaleUpLimitTiB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum scale up size on Elastic San appliance in TiB."""
    auto_scale_policy_enforcement: Optional[Union[str, "_models.AutoScalePolicyEnforcement"]] = rest_field(
        name="autoScalePolicyEnforcement", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enable or Disable scale up setting on Elastic San Appliance. Known values are: \"None\",
     \"Enabled\", and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        unused_size_ti_b: Optional[int] = None,
        increase_capacity_unit_by_ti_b: Optional[int] = None,
        capacity_unit_scale_up_limit_ti_b: Optional[int] = None,
        auto_scale_policy_enforcement: Optional[Union[str, "_models.AutoScalePolicyEnforcement"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Sku(_Model):
    """The SKU name. Required for account creation; optional for update.

    :ivar name: The sku name. Required. Known values are: "Premium_LRS" and "Premium_ZRS".
    :vartype name: str or ~azure.mgmt.elasticsan.models.SkuName
    :ivar tier: The sku tier. "Premium"
    :vartype tier: str or ~azure.mgmt.elasticsan.models.SkuTier
    """

    name: Union[str, "_models.SkuName"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sku name. Required. Known values are: \"Premium_LRS\" and \"Premium_ZRS\"."""
    tier: Optional[Union[str, "_models.SkuTier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The sku tier. \"Premium\""""

    @overload
    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SKUCapability(_Model):
    """The capability information in the specified SKU.

    :ivar name: The name of capability.
    :vartype name: str
    :ivar value: A string value to indicate states of given capability.
    :vartype value: str
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of capability."""
    value: Optional[str] = rest_field(visibility=["read"])
    """A string value to indicate states of given capability."""


class SkuInformation(_Model):
    """ElasticSAN SKU and its properties.

    :ivar name: Sku Name. Required. Known values are: "Premium_LRS" and "Premium_ZRS".
    :vartype name: str or ~azure.mgmt.elasticsan.models.SkuName
    :ivar tier: Sku Tier. "Premium"
    :vartype tier: str or ~azure.mgmt.elasticsan.models.SkuTier
    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    :ivar locations: The set of locations that the SKU is available. This will be supported and
     registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
    :vartype locations: list[str]
    :ivar location_info: Availability of the SKU for the location/zone.
    :vartype location_info: list[~azure.mgmt.elasticsan.models.SkuLocationInfo]
    :ivar capabilities: The capability information in the specified SKU.
    :vartype capabilities: list[~azure.mgmt.elasticsan.models.SKUCapability]
    """

    name: Union[str, "_models.SkuName"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sku Name. Required. Known values are: \"Premium_LRS\" and \"Premium_ZRS\"."""
    tier: Optional[Union[str, "_models.SkuTier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Sku Tier. \"Premium\""""
    resource_type: Optional[str] = rest_field(name="resourceType", visibility=["read"])
    """The type of the resource."""
    locations: Optional[list[str]] = rest_field(visibility=["read"])
    """The set of locations that the SKU is available. This will be supported and registered Azure Geo
     Regions (e.g. West US, East US, Southeast Asia, etc.)."""
    location_info: Optional[list["_models.SkuLocationInfo"]] = rest_field(name="locationInfo", visibility=["read"])
    """Availability of the SKU for the location/zone."""
    capabilities: Optional[list["_models.SKUCapability"]] = rest_field(visibility=["read"])
    """The capability information in the specified SKU."""

    @overload
    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SkuLocationInfo(_Model):
    """The location info.

    :ivar location: The location.
    :vartype location: str
    :ivar zones: The zones.
    :vartype zones: list[str]
    """

    location: Optional[str] = rest_field(visibility=["read"])
    """The location."""
    zones: Optional[list[str]] = rest_field(visibility=["read"])
    """The zones."""


class Snapshot(ProxyResource):
    """Response for Volume Snapshot request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar properties: Properties of Volume Snapshot. Required.
    :vartype properties: ~azure.mgmt.elasticsan.models.SnapshotProperties
    """

    properties: "_models.SnapshotProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Properties of Volume Snapshot. Required."""

    __flattened_items = ["creation_data", "provisioning_state", "source_volume_size_gi_b", "volume_name"]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.SnapshotProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class SnapshotCreationData(_Model):
    """Data used when creating a volume snapshot.

    :ivar source_id: Fully qualified resource ID of the volume. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}".
     Required.
    :vartype source_id: str
    """

    source_id: str = rest_field(name="sourceId", visibility=["read", "create", "update", "delete", "query"])
    """Fully qualified resource ID of the volume. E.g.
     \"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}\".
     Required."""

    @overload
    def __init__(
        self,
        *,
        source_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SnapshotProperties(_Model):
    """Properties for Snapshot.

    :ivar creation_data: Data used when creating a volume snapshot. Required.
    :vartype creation_data: ~azure.mgmt.elasticsan.models.SnapshotCreationData
    :ivar provisioning_state: State of the operation on the resource. Known values are: "Invalid",
     "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", "Deleting", "Deleted",
     and "Restoring".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    :ivar source_volume_size_gi_b: Size of Source Volume.
    :vartype source_volume_size_gi_b: int
    :ivar volume_name: Source Volume Name of a snapshot.
    :vartype volume_name: str
    """

    creation_data: "_models.SnapshotCreationData" = rest_field(
        name="creationData", visibility=["read", "create", "update", "delete", "query"]
    )
    """Data used when creating a volume snapshot. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStates"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """State of the operation on the resource. Known values are: \"Invalid\", \"Succeeded\",
     \"Failed\", \"Canceled\", \"Pending\", \"Creating\", \"Updating\", \"Deleting\", \"Deleted\",
     and \"Restoring\"."""
    source_volume_size_gi_b: Optional[int] = rest_field(name="sourceVolumeSizeGiB", visibility=["read"])
    """Size of Source Volume."""
    volume_name: Optional[str] = rest_field(name="volumeName", visibility=["read"])
    """Source Volume Name of a snapshot."""

    @overload
    def __init__(
        self,
        *,
        creation_data: "_models.SnapshotCreationData",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceCreationData(_Model):
    """Data source used when creating the volume.

    :ivar create_source: This enumerates the possible sources of a volume creation. Known values
     are: "None", "VolumeSnapshot", "DiskSnapshot", "Disk", and "DiskRestorePoint".
    :vartype create_source: str or ~azure.mgmt.elasticsan.models.VolumeCreateOption
    :ivar source_id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype source_id: str
    """

    create_source: Optional[Union[str, "_models.VolumeCreateOption"]] = rest_field(
        name="createSource", visibility=["read", "create", "update", "delete", "query"]
    )
    """This enumerates the possible sources of a volume creation. Known values are: \"None\",
     \"VolumeSnapshot\", \"DiskSnapshot\", \"Disk\", and \"DiskRestorePoint\"."""
    source_id: Optional[str] = rest_field(name="sourceId", visibility=["read", "create", "update", "delete", "query"])
    """Fully qualified resource ID for the resource. E.g.
     \"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}\"."""

    @overload
    def __init__(
        self,
        *,
        create_source: Optional[Union[str, "_models.VolumeCreateOption"]] = None,
        source_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.elasticsan.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.elasticsan.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """UserAssignedIdentity for the resource.

    :ivar principal_id: The principal ID of the identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the identity."""


class VirtualNetworkRule(_Model):
    """Virtual Network rule.

    :ivar virtual_network_resource_id: Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     Required.
    :vartype virtual_network_resource_id: str
    :ivar action: The action of virtual network rule. "Allow"
    :vartype action: str or ~azure.mgmt.elasticsan.models.Action
    """

    virtual_network_resource_id: str = rest_field(name="id", visibility=["read", "create", "update", "delete", "query"])
    """Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     Required."""
    action: Optional[Union[str, "_models.Action"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The action of virtual network rule. \"Allow\""""

    @overload
    def __init__(
        self,
        *,
        virtual_network_resource_id: str,
        action: Optional[Union[str, "_models.Action"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Volume(ProxyResource):
    """Response for Volume request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar properties: Properties of Volume. Required.
    :vartype properties: ~azure.mgmt.elasticsan.models.VolumeProperties
    """

    properties: "_models.VolumeProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Properties of Volume. Required."""

    __flattened_items = [
        "volume_id",
        "creation_data",
        "size_gi_b",
        "storage_target",
        "managed_by",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.VolumeProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VolumeGroup(ProxyResource):
    """Response for Volume Group request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.elasticsan.models.Identity
    :ivar properties: Properties of VolumeGroup.
    :vartype properties: ~azure.mgmt.elasticsan.models.VolumeGroupProperties
    """

    identity: Optional["_models.Identity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The identity of the resource."""
    properties: Optional["_models.VolumeGroupProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of VolumeGroup."""

    __flattened_items = [
        "provisioning_state",
        "protocol_type",
        "encryption",
        "encryption_properties",
        "network_acls",
        "private_endpoint_connections",
        "enforce_data_integrity_check_for_iscsi",
    ]

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_models.Identity"] = None,
        properties: Optional["_models.VolumeGroupProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VolumeGroupProperties(_Model):
    """VolumeGroup response properties.

    :ivar provisioning_state: State of the operation on the resource. Known values are: "Invalid",
     "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", "Deleting", "Deleted",
     and "Restoring".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    :ivar protocol_type: Type of storage target. Known values are: "Iscsi" and "None".
    :vartype protocol_type: str or ~azure.mgmt.elasticsan.models.StorageTargetType
    :ivar encryption: Type of encryption. Known values are: "EncryptionAtRestWithPlatformKey" and
     "EncryptionAtRestWithCustomerManagedKey".
    :vartype encryption: str or ~azure.mgmt.elasticsan.models.EncryptionType
    :ivar encryption_properties: Encryption Properties describing Key Vault and Identity
     information.
    :vartype encryption_properties: ~azure.mgmt.elasticsan.models.EncryptionProperties
    :ivar network_acls: A collection of rules governing the accessibility from specific network
     locations.
    :vartype network_acls: ~azure.mgmt.elasticsan.models.NetworkRuleSet
    :ivar private_endpoint_connections: The list of Private Endpoint Connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.elasticsan.models.PrivateEndpointConnection]
    :ivar enforce_data_integrity_check_for_iscsi: A boolean indicating whether or not Data
     Integrity Check is enabled.
    :vartype enforce_data_integrity_check_for_iscsi: bool
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningStates"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """State of the operation on the resource. Known values are: \"Invalid\", \"Succeeded\",
     \"Failed\", \"Canceled\", \"Pending\", \"Creating\", \"Updating\", \"Deleting\", \"Deleted\",
     and \"Restoring\"."""
    protocol_type: Optional[Union[str, "_models.StorageTargetType"]] = rest_field(
        name="protocolType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of storage target. Known values are: \"Iscsi\" and \"None\"."""
    encryption: Optional[Union[str, "_models.EncryptionType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of encryption. Known values are: \"EncryptionAtRestWithPlatformKey\" and
     \"EncryptionAtRestWithCustomerManagedKey\"."""
    encryption_properties: Optional["_models.EncryptionProperties"] = rest_field(
        name="encryptionProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Encryption Properties describing Key Vault and Identity information."""
    network_acls: Optional["_models.NetworkRuleSet"] = rest_field(name="networkAcls", visibility=["read", "create"])
    """A collection of rules governing the accessibility from specific network locations."""
    private_endpoint_connections: Optional[list["_models.PrivateEndpointConnection"]] = rest_field(
        name="privateEndpointConnections", visibility=["read"]
    )
    """The list of Private Endpoint Connections."""
    enforce_data_integrity_check_for_iscsi: Optional[bool] = rest_field(
        name="enforceDataIntegrityCheckForIscsi", visibility=["read", "create", "update", "delete", "query"]
    )
    """A boolean indicating whether or not Data Integrity Check is enabled."""

    @overload
    def __init__(
        self,
        *,
        protocol_type: Optional[Union[str, "_models.StorageTargetType"]] = None,
        encryption: Optional[Union[str, "_models.EncryptionType"]] = None,
        encryption_properties: Optional["_models.EncryptionProperties"] = None,
        network_acls: Optional["_models.NetworkRuleSet"] = None,
        enforce_data_integrity_check_for_iscsi: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeGroupUpdate(_Model):
    """Volume Group request.

    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.elasticsan.models.Identity
    :ivar properties: Properties of VolumeGroup.
    :vartype properties: ~azure.mgmt.elasticsan.models.VolumeGroupUpdateProperties
    """

    identity: Optional["_models.Identity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The identity of the resource."""
    properties: Optional["_models.VolumeGroupUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of VolumeGroup."""

    __flattened_items = [
        "protocol_type",
        "encryption",
        "encryption_properties",
        "network_acls",
        "enforce_data_integrity_check_for_iscsi",
    ]

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_models.Identity"] = None,
        properties: Optional["_models.VolumeGroupUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VolumeGroupUpdateProperties(_Model):
    """VolumeGroup response properties.

    :ivar protocol_type: Type of storage target. Known values are: "Iscsi" and "None".
    :vartype protocol_type: str or ~azure.mgmt.elasticsan.models.StorageTargetType
    :ivar encryption: Type of encryption. Known values are: "EncryptionAtRestWithPlatformKey" and
     "EncryptionAtRestWithCustomerManagedKey".
    :vartype encryption: str or ~azure.mgmt.elasticsan.models.EncryptionType
    :ivar encryption_properties: Encryption Properties describing Key Vault and Identity
     information.
    :vartype encryption_properties: ~azure.mgmt.elasticsan.models.EncryptionProperties
    :ivar network_acls: A collection of rules governing the accessibility from specific network
     locations.
    :vartype network_acls: ~azure.mgmt.elasticsan.models.NetworkRuleSet
    :ivar enforce_data_integrity_check_for_iscsi: A boolean indicating whether or not Data
     Integrity Check is enabled.
    :vartype enforce_data_integrity_check_for_iscsi: bool
    """

    protocol_type: Optional[Union[str, "_models.StorageTargetType"]] = rest_field(
        name="protocolType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of storage target. Known values are: \"Iscsi\" and \"None\"."""
    encryption: Optional[Union[str, "_models.EncryptionType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of encryption. Known values are: \"EncryptionAtRestWithPlatformKey\" and
     \"EncryptionAtRestWithCustomerManagedKey\"."""
    encryption_properties: Optional["_models.EncryptionProperties"] = rest_field(
        name="encryptionProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Encryption Properties describing Key Vault and Identity information."""
    network_acls: Optional["_models.NetworkRuleSet"] = rest_field(name="networkAcls", visibility=["update"])
    """A collection of rules governing the accessibility from specific network locations."""
    enforce_data_integrity_check_for_iscsi: Optional[bool] = rest_field(
        name="enforceDataIntegrityCheckForIscsi", visibility=["read", "create", "update", "delete", "query"]
    )
    """A boolean indicating whether or not Data Integrity Check is enabled."""

    @overload
    def __init__(
        self,
        *,
        protocol_type: Optional[Union[str, "_models.StorageTargetType"]] = None,
        encryption: Optional[Union[str, "_models.EncryptionType"]] = None,
        encryption_properties: Optional["_models.EncryptionProperties"] = None,
        network_acls: Optional["_models.NetworkRuleSet"] = None,
        enforce_data_integrity_check_for_iscsi: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeNameList(_Model):
    """object to hold array of volume names.

    :ivar volume_names: array of volume names. Required.
    :vartype volume_names: list[str]
    """

    volume_names: list[str] = rest_field(name="volumeNames", visibility=["read", "create", "update", "delete", "query"])
    """array of volume names. Required."""

    @overload
    def __init__(
        self,
        *,
        volume_names: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeProperties(_Model):
    """Volume response properties.

    :ivar volume_id: Unique Id of the volume in GUID format.
    :vartype volume_id: str
    :ivar creation_data: State of the operation on the resource.
    :vartype creation_data: ~azure.mgmt.elasticsan.models.SourceCreationData
    :ivar size_gi_b: Volume size. Required.
    :vartype size_gi_b: int
    :ivar storage_target: Storage target information.
    :vartype storage_target: ~azure.mgmt.elasticsan.models.IscsiTargetInfo
    :ivar managed_by: Parent resource information.
    :vartype managed_by: ~azure.mgmt.elasticsan.models.ManagedByInfo
    :ivar provisioning_state: State of the operation on the resource. Known values are: "Invalid",
     "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", "Deleting", "Deleted",
     and "Restoring".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    """

    volume_id: Optional[str] = rest_field(name="volumeId", visibility=["read"])
    """Unique Id of the volume in GUID format."""
    creation_data: Optional["_models.SourceCreationData"] = rest_field(
        name="creationData", visibility=["read", "create", "update", "delete", "query"]
    )
    """State of the operation on the resource."""
    size_gi_b: int = rest_field(name="sizeGiB", visibility=["read", "create", "update", "delete", "query"])
    """Volume size. Required."""
    storage_target: Optional["_models.IscsiTargetInfo"] = rest_field(name="storageTarget", visibility=["read"])
    """Storage target information."""
    managed_by: Optional["_models.ManagedByInfo"] = rest_field(
        name="managedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parent resource information."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStates"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """State of the operation on the resource. Known values are: \"Invalid\", \"Succeeded\",
     \"Failed\", \"Canceled\", \"Pending\", \"Creating\", \"Updating\", \"Deleting\", \"Deleted\",
     and \"Restoring\"."""

    @overload
    def __init__(
        self,
        *,
        size_gi_b: int,
        creation_data: Optional["_models.SourceCreationData"] = None,
        managed_by: Optional["_models.ManagedByInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeUpdate(_Model):
    """Response for Volume request.

    :ivar properties: Properties of Volume.
    :vartype properties: ~azure.mgmt.elasticsan.models.VolumeUpdateProperties
    """

    properties: Optional["_models.VolumeUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of Volume."""

    __flattened_items = ["size_gi_b", "managed_by"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.VolumeUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VolumeUpdateProperties(_Model):
    """Volume response properties.

    :ivar size_gi_b: Volume size.
    :vartype size_gi_b: int
    :ivar managed_by: Parent resource information.
    :vartype managed_by: ~azure.mgmt.elasticsan.models.ManagedByInfo
    """

    size_gi_b: Optional[int] = rest_field(name="sizeGiB", visibility=["read", "create", "update", "delete", "query"])
    """Volume size."""
    managed_by: Optional["_models.ManagedByInfo"] = rest_field(
        name="managedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parent resource information."""

    @overload
    def __init__(
        self,
        *,
        size_gi_b: Optional[int] = None,
        managed_by: Optional["_models.ManagedByInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
