# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.resource.privatelinks import ResourcePrivateLinkClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-resource-privatelinks
# USAGE
    python list_resource_group_resource_management_private_link.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ResourcePrivateLinkClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-0000-0000-0000-000000000000",
    )

    response = client.resource_management_private_link.list_by_resource_group(
        resource_group_name="my-resource-group",
    )
    print(response)


# x-ms-original-file: specification/resources/resource-manager/Microsoft.Authorization/privatelinks/stable/2020-05-01/examples/ListResourceGroupResourceManagementPrivateLink.json
if __name__ == "__main__":
    main()
