// re2rust $INPUT -o $OUTPUT --header lexer/state.rs

mod lexer;
use lexer::state::State; // the module is generated by re2c

/*!header:re2c:on*/
pub struct State<'a> {
    pub yyinput: &'a [u8],
    pub yycursor: usize,
    /*!stags:re2c format = "pub @@: usize,"; */
}
/*!header:re2c:off*/

fn lex(yyrecord: &mut State) -> usize {
    assert_eq!(yyrecord.yyinput.last(), Some(&0)); // expect null-terminated input

    let t: usize;
    /*!re2c
        re2c:header = "lexer/state.rs";
        re2c:yyfill:enable = 0;
        re2c:api = record;
        re2c:YYCTYPE = "u8";
        re2c:tags = 1;

        [a]* @t [b]* { return t; }
    */
}

fn main() {
    let mut st = State {
        yyinput: b"ab\0",
        yycursor: 0,
        /*!stags:re2c format = "@@: 0,"; */
    };
    assert_eq!(lex(&mut st), 1);
}
