/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.epubcheck.core;

import com.adobe.epubcheck.bitmap.BitmapChecker;
import com.adobe.epubcheck.css.CSSChecker;
import com.adobe.epubcheck.dict.SearchKeyMapChecker;
import com.adobe.epubcheck.dtbook.DTBookChecker;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.PublicationResourceChecker;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.ops.OPSChecker;
import com.adobe.epubcheck.overlay.OverlayChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import org.w3c.epubcheck.constants.MIMEType;
import org.w3c.epubcheck.core.Checker;

public final class CheckerFactory {
    public static Checker newChecker(ValidationContext context) {
        switch (MIMEType.get(context.mimeType)) {
            case CSS: {
                return new CSSChecker(context);
            }
            case DTBOOK: {
                return new DTBookChecker(context);
            }
            case EPUB: {
                break;
            }
            case HTML: {
                if (context.version != EPUBVersion.VERSION_2) break;
                return new OPSChecker(context);
            }
            case IMAGE_GIF: 
            case IMAGE_JPEG: 
            case IMAGE_PNG: {
                return new BitmapChecker(context);
            }
            case OEBPS: {
                if (context.version != EPUBVersion.VERSION_2) break;
                return new OPSChecker(context);
            }
            case PACKAGE_DOC: {
                return context.version == EPUBVersion.VERSION_2 ? new OPFChecker(context) : new OPFChecker30(context);
            }
            case SEARCH_KEY_MAP: {
                if (context.version != EPUBVersion.VERSION_3) break;
                return new SearchKeyMapChecker(context);
            }
            case SVG: {
                return new OPSChecker(context);
            }
            case SMIL: {
                if (context.version != EPUBVersion.VERSION_3) break;
                return new OverlayChecker(context);
            }
            case XHTML: {
                return new OPSChecker(context);
            }
        }
        return new PublicationResourceChecker(context);
    }

    public static final class CheckerTypes
    extends Enum<CheckerTypes> {
        private static final /* synthetic */ CheckerTypes[] $VALUES;

        public static CheckerTypes[] values() {
            return (CheckerTypes[])$VALUES.clone();
        }

        public static CheckerTypes valueOf(String name) {
            return Enum.valueOf(CheckerTypes.class, name);
        }

        private static /* synthetic */ CheckerTypes[] $values() {
            return new CheckerTypes[0];
        }

        static {
            $VALUES = CheckerTypes.$values();
        }
    }
}

