/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.debugger;

public class SuspendInfo {
    private boolean terminated;
    private boolean newRound;
    private final InfoSetter updater = new InfoSetter();

    public long getThreadID() {
        return this.updater.thread;
    }

    public long getClassID() {
        return this.updater.clazz;
    }

    public long getMethodID() {
        return this.updater.method;
    }

    public long getOffset() {
        return this.updater.offset;
    }

    InfoSetter update() {
        this.updater.changed = false;
        this.updater.nextRound(this.newRound);
        this.newRound = false;
        return this.updater;
    }

    void nextRound() {
        this.newRound = true;
    }

    boolean isAnythingChanged() {
        return this.updater.changed;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    void setTerminated() {
        this.terminated = true;
    }

    static class InfoSetter {
        private long thread;
        private long clazz;
        private long method;
        private long offset;
        private boolean changed;

        InfoSetter() {
        }

        void nextRound(boolean newRound) {
            if (!this.changed) {
                this.changed = newRound;
            }
        }

        InfoSetter updateThread(long thread) {
            if (!this.changed) {
                this.changed = this.thread != thread;
            }
            this.thread = thread;
            return this;
        }

        InfoSetter updateClass(long clazz) {
            if (!this.changed) {
                this.changed = this.clazz != clazz;
            }
            this.clazz = clazz;
            return this;
        }

        InfoSetter updateMethod(long method) {
            if (!this.changed) {
                this.changed = this.method != method;
            }
            this.method = method;
            return this;
        }

        InfoSetter updateOffset(long offset) {
            if (!this.changed) {
                this.changed = this.offset != offset;
            }
            this.offset = offset;
            return this;
        }
    }
}

