/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaNode;
import jadx.api.JavaVariable;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.utils.UiUtils;
import javax.swing.Icon;

public class JVariable
extends JNode {
    private static final long serialVersionUID = -3002100457834453783L;
    private final JMethod jMth;
    private final JavaVariable var;

    public JVariable(JMethod jMth, JavaVariable var) {
        this.jMth = jMth;
        this.var = var;
    }

    public JavaVariable getJavaVarNode() {
        return this.var;
    }

    @Override
    public JavaNode getJavaNode() {
        return this.var;
    }

    @Override
    public JClass getRootClass() {
        return this.jMth.getRootClass();
    }

    @Override
    public JClass getJParent() {
        return this.jMth.getJParent();
    }

    @Override
    public int getPos() {
        return this.var.getDefPos();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String makeString() {
        return this.var.getName();
    }

    @Override
    public String makeLongString() {
        return this.var.getFullName();
    }

    @Override
    public String makeLongStringHtml() {
        return UiUtils.typeFormatHtml(this.var.getName(), this.var.getType());
    }

    @Override
    public boolean disableHtml() {
        return false;
    }

    @Override
    public String getTooltip() {
        String name = this.var.getName() + " (r" + this.var.getReg() + "v" + this.var.getSsa() + ")";
        String fullType = UiUtils.escapeHtml(this.var.getType().toString());
        return UiUtils.wrapHtml(fullType + ' ' + UiUtils.escapeHtml(name));
    }

    @Override
    public boolean canRename() {
        return this.var.getName() != null;
    }
}

