/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.StyleRule;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class StyleSheet
implements Cloneable,
Serializable {
    private transient ResourceManager resourceManager;
    private transient Map roNamespaces;
    private boolean readOnly;
    private ResourceKey source;
    private ArrayList rules;
    private ArrayList styleSheets;
    private HashMap namespaces;
    private StyleKeyRegistry styleKeyRegistry = StyleKeyRegistry.getRegistry();

    public StyleSheet() {
        this.rules = new ArrayList();
        this.styleSheets = new ArrayList();
        this.namespaces = new HashMap();
    }

    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    protected synchronized void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public ResourceKey getSource() {
        return this.source;
    }

    public synchronized void setSource(ResourceKey resourceKey) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        this.source = resourceKey;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager();
            this.resourceManager.registerDefaults();
        }
        return this.resourceManager;
    }

    public synchronized void addRule(StyleRule styleRule) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        this.rules.add(styleRule);
    }

    public synchronized void insertRule(int n, StyleRule styleRule) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        this.rules.add(n, styleRule);
    }

    public synchronized void deleteRule(int n) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        this.rules.remove(n);
    }

    public synchronized int getRuleCount() {
        return this.rules.size();
    }

    public synchronized StyleRule getRule(int n) {
        return (StyleRule)this.rules.get(n);
    }

    public synchronized void addStyleSheet(StyleSheet styleSheet) {
        this.styleSheets.add(styleSheet);
    }

    public synchronized int getStyleSheetCount() {
        return this.styleSheets.size();
    }

    public synchronized StyleSheet getStyleSheet(int n) {
        return (StyleSheet)this.styleSheets.get(n);
    }

    public synchronized void removeStyleSheet(StyleSheet styleSheet) {
        this.styleSheets.remove(styleSheet);
    }

    public synchronized void addNamespace(String string, String string2) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.namespaces.put(string, string2);
        this.roNamespaces = null;
    }

    public synchronized String getNamespaceURI(String string) {
        return (String)this.namespaces.get(string);
    }

    public synchronized String[] getNamespacePrefixes() {
        return this.namespaces.keySet().toArray(new String[this.namespaces.size()]);
    }

    public synchronized Map getNamespaces() {
        if (this.roNamespaces == null) {
            this.roNamespaces = Collections.unmodifiableMap(this.namespaces);
        }
        return this.roNamespaces;
    }

    public Object clone() throws CloneNotSupportedException {
        StyleSheet styleSheet = (StyleSheet)super.clone();
        return styleSheet;
    }

    public StyleKeyRegistry getStyleKeyRegistry() {
        return this.styleKeyRegistry;
    }
}

