/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader;

import org.pentaho.reporting.libraries.resourceloader.DependencyCollector;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class CompoundResource
implements Resource {
    private static final long serialVersionUID = -5828242419391352185L;
    private ResourceKey source;
    private DependencyCollector dependencies;
    private Object product;
    private Class targetType;

    public CompoundResource(ResourceKey source, DependencyCollector dependencies, Object product, Class targetType) {
        if (source == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (dependencies == null) {
            throw new NullPointerException("Dependecies must be given.");
        }
        if (targetType == null) {
            throw new NullPointerException("TargetType must not be null");
        }
        if (product == null) {
            throw new NullPointerException("Product must not be null");
        }
        this.targetType = targetType;
        this.source = source;
        try {
            this.dependencies = (DependencyCollector)dependencies.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone not supported? This should not happen.");
        }
        this.product = product;
    }

    @Override
    public Object getResource() throws ResourceException {
        return this.product;
    }

    @Override
    public long getVersion(ResourceKey key) {
        return this.dependencies.getVersion(key);
    }

    @Override
    public ResourceKey[] getDependencies() {
        return this.dependencies.getDependencies();
    }

    @Override
    public ResourceKey getSource() {
        return this.source;
    }

    @Override
    public Class getTargetType() {
        return this.targetType;
    }

    @Override
    public boolean isTemporaryResult() {
        return false;
    }
}

