/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.Duration;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.asta.AstaDataType;
import net.sf.mpxj.asta.MapRow;
import net.sf.mpxj.common.NumberHelper;

final class SqliteResultSetRow
extends MapRow {
    public SqliteResultSetRow(ResultSet resultSet, Map<String, Integer> map) throws SQLException {
        super(new HashMap<String, Object>());
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String string = entry.getKey().toUpperCase();
            int n = entry.getValue();
            Object object = switch (n) {
                case -7, 16 -> resultSet.getBoolean(string);
                case -1, 1, 12, 2005 -> resultSet.getString(string);
                case 91 -> {
                    Object var8_8 = resultSet.getString(string);
                    if (var8_8 == null || ((String)var8_8).isEmpty()) {
                        yield null;
                    }
                    yield resultSet.getDate(string);
                }
                case 93 -> {
                    Object var8_8 = resultSet.getTimestamp(string);
                    if (var8_8 != null) {
                        yield new Date(((Timestamp)var8_8).getTime());
                    }
                    yield null;
                }
                case 2, 6, 8 -> NumberHelper.getDouble(resultSet.getDouble(string));
                case 4, 5 -> resultSet.getInt(string);
                case -5 -> resultSet.getLong(string);
                case -4, -3 -> resultSet.getBytes(string);
                case 1111 -> resultSet.getObject(string);
                default -> throw new IllegalArgumentException("Unsupported SQL type: " + n + " for column " + string);
            };
            if (resultSet.wasNull()) {
                object = null;
            }
            this.m_map.put(string, object);
        }
    }

    @Override
    public Duration getDuration(String string) {
        Number number;
        String string2 = this.getString(string);
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Unexpected duration value");
        }
        String[] stringArray = string2.split(",");
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("Unexpected duration value: " + string2);
        }
        String string3 = AstaDataType.parseString(stringArray[2]);
        try {
            number = AstaDataType.parseDouble(string3);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Unexpected duration value", parseException);
        }
        return Duration.getInstance(NumberHelper.getDouble(number), TimeUnit.HOURS);
    }
}

