/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContext;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.architect.swingui.dbtree.DBTreeModel;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.RecentMenu;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.SPSwingWorker;
import ca.sqlpower.swingui.SwingWorkerRegistry;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitorInputStream;
import org.apache.log4j.Logger;

public class OpenProjectAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(OpenProjectAction.class);
    private static FileLoader fileLoader = new FileLoader(){

        @Override
        public void open(ArchitectSwingSession newSession, File f, ArchitectSwingSession openingSession, boolean separateThread) {
            try {
                LoadFileWorker worker = new LoadFileWorker(f, newSession, openingSession);
                if (separateThread) {
                    new Thread((Runnable)((Object)worker)).start();
                } else {
                    worker.run();
                }
            }
            catch (Exception e1) {
                ASUtils.showExceptionDialogNoReport(Messages.getString("OpenProjectAction.errorLoadingFile"), e1);
            }
        }

        @Override
        public void open(ArchitectSwingSession newSession, InputStream in, ArchitectSwingSession openingSession, boolean separateThread) {
            try {
                LoadFileWorker worker = new LoadFileWorker(in, newSession, openingSession);
                if (separateThread) {
                    new Thread((Runnable)((Object)worker)).start();
                } else {
                    worker.run();
                }
            }
            catch (Exception e1) {
                ASUtils.showExceptionDialogNoReport(Messages.getString("OpenProjectAction.errorLoadingFile"), e1);
            }
        }
    };

    public static void setFileLoader(FileLoader loader) {
        fileLoader = loader;
    }

    public static FileLoader getFileLoader() {
        return fileLoader;
    }

    public OpenProjectAction(ArchitectFrame frame) {
        super(frame, Messages.getString("OpenProjectAction.name"), Messages.getString("OpenProjectAction.description"), "folder");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        File f;
        if (e.getActionCommand() == null || !e.getActionCommand().startsWith("file:")) {
            JFileChooser chooser = new JFileChooser(this.getSession().getRecentMenu().getMostRecentFile());
            chooser.addChoosableFileFilter(SPSUtils.ARCHITECT_FILE_FILTER);
            int returnVal = chooser.showOpenDialog(this.frame);
            if (returnVal != 0) return;
            f = chooser.getSelectedFile();
        } else {
            f = new File(e.getActionCommand().substring("file:".length()));
        }
        try {
            fileLoader.open(this.getSession().getContext().createSession(), f, this.getSession(), true);
            return;
        }
        catch (SQLObjectException ex) {
            SPSUtils.showExceptionDialogNoReport((Component)this.getSession().getArchitectFrame(), (String)Messages.getString("OpenProjectAction.failedToOpenProjectFile"), (Throwable)ex);
        }
    }

    public static class LoadFileWorker
    extends SPSwingWorker {
        private final ArchitectSwingSessionContext context;
        private final InputStream in;
        private final File file;
        private final RecentMenu recent;
        private final ArchitectSwingSession openingSession;
        private ArchitectSwingSession session;

        public LoadFileWorker(File file, ArchitectSwingSession newSession, ArchitectSwingSession openingSession) throws SQLObjectException, FileNotFoundException {
            super((SwingWorkerRegistry)newSession);
            this.context = newSession.getContext();
            this.file = file;
            this.recent = newSession.getRecentMenu();
            this.openingSession = openingSession;
            this.session = newSession;
            this.in = new BufferedInputStream(new ProgressMonitorInputStream(openingSession.getArchitectFrame(), Messages.getString("OpenProjectAction.reading") + file.getName(), new FileInputStream(file)));
        }

        public LoadFileWorker(InputStream in, ArchitectSwingSession newSession, ArchitectSwingSession openingSession) {
            super((SwingWorkerRegistry)newSession);
            this.context = newSession.getContext();
            this.file = null;
            this.recent = newSession.getRecentMenu();
            this.openingSession = openingSession;
            this.session = newSession;
            this.in = in;
        }

        public void doStuff() throws Exception {
            this.session.getProjectLoader().load(this.in, this.session.getDataSources(), this.openingSession);
            this.session.getProjectLoader().setFile(this.file);
        }

        public void cleanup() throws SQLObjectException {
            if (this.getDoStuffException() != null) {
                Throwable cause = this.getDoStuffException().getCause();
                if (!(this.getDoStuffException() instanceof InterruptedIOException || cause instanceof InterruptedIOException && cause.getMessage().equals("progress"))) {
                    ASUtils.showExceptionDialogNoReport(Messages.getString("OpenProjectAction.cannotOpenProjectFile") + this.file.getAbsolutePath(), this.getDoStuffException());
                    logger.error((Object)"Got exception while opening a project", this.getDoStuffException());
                }
                this.session.removeSwingWorker(this);
                if (this.session.getContext().getSessions().size() > 1) {
                    this.session.getProjectLoader().setModified(false);
                    this.session.close();
                }
            } else {
                if (this.file != null) {
                    this.recent.putRecentFileName(this.file.getAbsolutePath());
                }
                if (this.openingSession != null) {
                    this.openingSession.getArchitectFrame().addSession(this.session);
                    this.openingSession.getArchitectFrame().setCurrentSession(this.session);
                }
                ((DBTreeModel)this.session.getDBTree().getModel()).refreshTreeStructure();
            }
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException ie) {
                logger.error((Object)"got exception while closing project file", (Throwable)ie);
            }
        }
    }

    public static interface FileLoader {
        public void open(ArchitectSwingSession var1, File var2, ArchitectSwingSession var3, boolean var4);

        public void open(ArchitectSwingSession var1, InputStream var2, ArchitectSwingSession var3, boolean var4);
    }
}

