/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSecondaryViewConfigurationFrameStateMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFrameState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int PREDICTEDDISPLAYTIME;
    public static final int PREDICTEDDISPLAYPERIOD;
    public static final int SHOULDRENDER;

    public XrFrameState(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrFrameState.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFrameState.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrFrameState.nnext(this.address());
    }

    @NativeType(value="XrTime")
    public long predictedDisplayTime() {
        return XrFrameState.npredictedDisplayTime(this.address());
    }

    @NativeType(value="XrDuration")
    public long predictedDisplayPeriod() {
        return XrFrameState.npredictedDisplayPeriod(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean shouldRender() {
        return XrFrameState.nshouldRender(this.address()) != 0;
    }

    public XrFrameState type(@NativeType(value="XrStructureType") int value) {
        XrFrameState.ntype(this.address(), value);
        return this;
    }

    public XrFrameState type$Default() {
        return this.type(44);
    }

    public XrFrameState next(@NativeType(value="void *") long value) {
        XrFrameState.nnext(this.address(), value);
        return this;
    }

    public XrFrameState next(XrSecondaryViewConfigurationFrameStateMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrFrameState predictedDisplayTime(@NativeType(value="XrTime") long value) {
        XrFrameState.npredictedDisplayTime(this.address(), value);
        return this;
    }

    public XrFrameState predictedDisplayPeriod(@NativeType(value="XrDuration") long value) {
        XrFrameState.npredictedDisplayPeriod(this.address(), value);
        return this;
    }

    public XrFrameState shouldRender(@NativeType(value="XrBool32") boolean value) {
        XrFrameState.nshouldRender(this.address(), value ? 1 : 0);
        return this;
    }

    public XrFrameState set(int type, long next, long predictedDisplayTime, long predictedDisplayPeriod, boolean shouldRender) {
        this.type(type);
        this.next(next);
        this.predictedDisplayTime(predictedDisplayTime);
        this.predictedDisplayPeriod(predictedDisplayPeriod);
        this.shouldRender(shouldRender);
        return this;
    }

    public XrFrameState set(XrFrameState src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrFrameState malloc() {
        return (XrFrameState)XrFrameState.wrap(XrFrameState.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrFrameState calloc() {
        return (XrFrameState)XrFrameState.wrap(XrFrameState.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrFrameState create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrFrameState)XrFrameState.wrap(XrFrameState.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrFrameState create(long address) {
        return (XrFrameState)XrFrameState.wrap(XrFrameState.class, (long)address);
    }

    @Nullable
    public static XrFrameState createSafe(long address) {
        return address == 0L ? null : (XrFrameState)XrFrameState.wrap(XrFrameState.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrFrameState.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrFrameState.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrFrameState.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFrameState.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrFrameState.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrFrameState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrFrameState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrFrameState malloc(MemoryStack stack) {
        return (XrFrameState)XrFrameState.wrap(XrFrameState.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrFrameState calloc(MemoryStack stack) {
        return (XrFrameState)XrFrameState.wrap(XrFrameState.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrFrameState.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrFrameState.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long npredictedDisplayTime(long struct) {
        return UNSAFE.getLong(null, struct + (long)PREDICTEDDISPLAYTIME);
    }

    public static long npredictedDisplayPeriod(long struct) {
        return UNSAFE.getLong(null, struct + (long)PREDICTEDDISPLAYPERIOD);
    }

    public static int nshouldRender(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHOULDRENDER);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void npredictedDisplayTime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)PREDICTEDDISPLAYTIME, value);
    }

    public static void npredictedDisplayPeriod(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)PREDICTEDDISPLAYPERIOD, value);
    }

    public static void nshouldRender(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHOULDRENDER, value);
    }

    static {
        Struct.Layout layout = XrFrameState.__struct((Struct.Member[])new Struct.Member[]{XrFrameState.__member((int)4), XrFrameState.__member((int)POINTER_SIZE), XrFrameState.__member((int)8), XrFrameState.__member((int)8), XrFrameState.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        PREDICTEDDISPLAYTIME = layout.offsetof(2);
        PREDICTEDDISPLAYPERIOD = layout.offsetof(3);
        SHOULDRENDER = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrFrameState, Buffer>
    implements NativeResource {
        private static final XrFrameState ELEMENT_FACTORY = XrFrameState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrFrameState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFrameState.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrFrameState.nnext(this.address());
        }

        @NativeType(value="XrTime")
        public long predictedDisplayTime() {
            return XrFrameState.npredictedDisplayTime(this.address());
        }

        @NativeType(value="XrDuration")
        public long predictedDisplayPeriod() {
            return XrFrameState.npredictedDisplayPeriod(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean shouldRender() {
            return XrFrameState.nshouldRender(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFrameState.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(44);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrFrameState.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrSecondaryViewConfigurationFrameStateMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer predictedDisplayTime(@NativeType(value="XrTime") long value) {
            XrFrameState.npredictedDisplayTime(this.address(), value);
            return this;
        }

        public Buffer predictedDisplayPeriod(@NativeType(value="XrDuration") long value) {
            XrFrameState.npredictedDisplayPeriod(this.address(), value);
            return this;
        }

        public Buffer shouldRender(@NativeType(value="XrBool32") boolean value) {
            XrFrameState.nshouldRender(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

