/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import nu.validator.checker.Checker;
import nu.validator.checker.LocatorImpl;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class UsemapChecker
extends Checker {
    private final Map<String, Locator> usemapLocationsByName = new LinkedHashMap<String, Locator>();
    private final Set<String> mapNames = new HashSet<String>();
    private Locator locator = null;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("http://www.w3.org/1999/xhtml" == uri) {
            int hashIndex;
            String usemap;
            if ("map" == localName) {
                String name = atts.getValue("", "name");
                if (name != null && !"".equals(name)) {
                    this.mapNames.add(name);
                }
            } else if (("img" == localName || "object" == localName) && (usemap = atts.getValue("", "usemap")) != null && (hashIndex = usemap.indexOf(35)) > -1 && hashIndex < usemap.length() - 1) {
                String ref = usemap.substring(hashIndex + 1);
                this.usemapLocationsByName.put(ref, new LocatorImpl(this.locator));
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        for (Map.Entry<String, Locator> entry : this.usemapLocationsByName.entrySet()) {
            if (this.mapNames.contains(entry.getKey())) continue;
            this.err("The hash-name reference in attribute \u201cusemap\u201d referred to \u201c" + entry.getKey() + "\u201d, but there is no \u201cmap\u201d element with a \u201cname\u201d attribute with that value.", entry.getValue());
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.usemapLocationsByName.clear();
        this.mapNames.clear();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void reset() {
        this.usemapLocationsByName.clear();
        this.mapNames.clear();
    }
}

