/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias.cli;

import io.mola.galimatias.ErrorHandler;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import io.mola.galimatias.URLParsingSettings;
import io.mola.galimatias.canonicalize.RFC2396Canonicalizer;
import io.mola.galimatias.canonicalize.RFC3986Canonicalizer;

public class CLI {
    private static ErrorHandler errorHandler = new PrintErrorHandler();

    private static void printError(GalimatiasParseException error) {
        System.out.println("\t\tError: " + error.getMessage());
        if (error.getPosition() != -1) {
            System.out.println("\t\tPosition: " + error.getPosition());
        }
    }

    private static void printResult(URL url) {
        System.out.println("\tResult:");
        System.out.println("\t\tURL: " + url.toString());
        System.out.println("\t\tURL type: " + (url.isHierarchical() ? "hierarchical" : "opaque"));
        System.out.println("\t\tScheme: " + url.scheme());
        if (url.schemeData() != null) {
            System.out.println("\t\tScheme data: " + url.schemeData());
        }
        if (url.username() != null) {
            System.out.println("\t\tUsername: " + url.username());
        }
        if (url.password() != null) {
            System.out.println("\t\tPassword: " + url.password());
        }
        if (url.host() != null) {
            System.out.println("\t\tHost: " + String.valueOf(url.host()));
        }
        if (url.port() != -1) {
            System.out.println("\t\tPort: " + url.port());
        }
        if (url.path() != null) {
            System.out.println("\t\tPath: " + url.path());
        }
        if (url.query() != null) {
            System.out.println("\t\tQuery: " + url.query());
        }
        if (url.fragment() != null) {
            System.out.println("\t\tFragment: " + url.fragment());
        }
    }

    public static void main(String[] args) {
        String input;
        URL base;
        String rfc2396UrlSerialized;
        String rfc3986UrlSerialized;
        String whatwgUrlSerialized;
        URL url;
        URLParsingSettings settings;
        block22: {
            settings = URLParsingSettings.create().withErrorHandler(errorHandler);
            url = null;
            whatwgUrlSerialized = "";
            rfc3986UrlSerialized = "";
            rfc2396UrlSerialized = "";
            base = null;
            input = "";
            if (args.length < 1) {
                System.err.println("Need a URL as input");
                System.exit(1);
            } else if (args.length == 1) {
                input = args[0];
            } else if (args.length == 2) {
                block21: {
                    try {
                        base = URL.parse(args[0]);
                    }
                    catch (GalimatiasParseException ex) {
                        if ($assertionsDisabled) break block21;
                        throw new AssertionError();
                    }
                }
                input = args[1];
            } else {
                System.err.println("Too many args");
                System.exit(1);
            }
            if (base == null) {
                try {
                    base = URL.parse("http://example.org/foo/bar");
                }
                catch (GalimatiasParseException ex) {
                    if ($assertionsDisabled) break block22;
                    throw new AssertionError();
                }
            }
        }
        System.out.println("Base: " + base.toString());
        System.out.println("Analyzing URL: " + input);
        try {
            System.out.println("Parsing...");
            url = URL.parse(settings, base, input);
            whatwgUrlSerialized = url.toString();
            CLI.printResult(url);
        }
        catch (GalimatiasParseException ex) {
            System.out.println("Parsing with WHATWG rules resulted in fatal error");
            CLI.printError(ex);
            return;
        }
        try {
            System.out.println("Canonicalizing with RFC 3986 rules...");
            rfc3986UrlSerialized = new RFC3986Canonicalizer().canonicalize(url).toString();
            if (whatwgUrlSerialized.equals(rfc3986UrlSerialized)) {
                System.out.println("\tResult identical to WHATWG rules");
            } else {
                CLI.printResult(url);
            }
        }
        catch (GalimatiasParseException ex) {
            System.out.println("Canonicalizing with RFC 3986 rules resulted in fatal error");
            CLI.printError(ex);
        }
        try {
            System.out.println("Canonicalizing with RFC 2396 rules...");
            rfc2396UrlSerialized = new RFC2396Canonicalizer().canonicalize(url).toString();
            if (rfc3986UrlSerialized.equals(rfc2396UrlSerialized)) {
                System.out.println("\tResult identical to RFC 3986 rules");
            } else {
                CLI.printResult(url);
            }
        }
        catch (GalimatiasParseException ex) {
            System.out.println("Canonicalizing with RFC 2396 rules resulted in fatal error");
            CLI.printError(ex);
        }
    }

    private static class PrintErrorHandler
    implements ErrorHandler {
        private PrintErrorHandler() {
        }

        @Override
        public void error(GalimatiasParseException error) throws GalimatiasParseException {
            System.out.println("\tRecoverable error found;");
            System.out.println("\t\tError: " + error.getMessage());
            if (error.getPosition() != -1) {
                System.out.println("\t\tPosition: " + error.getPosition());
            }
        }

        @Override
        public void fatalError(GalimatiasParseException error) {
        }
    }
}

