// Ripped from https://github.com/Ch0pin/medusa/ and modified to fit Androguard packets

colorLog('[+] LOADING HELPER/ANTIDEBUG/ENVIRONMENT.JS',{c: Color.Red});

var a_activity = Java.use('android.app.Activity');

a_activity.isTaskRoot.implementation=function(){
    agSysPacket({information: "overwriting isTaskRoot"}).send();
    return true;
}

var hook = Java.use('android.provider.Settings$Secure');

var overloadCount1 = hook['getInt'].overloads.length;

for (var i = 0; i < overloadCount1; i++) {
    hook['getInt'].overloads[i].implementation = function() {
        var retval = this['getInt'].apply(this, arguments);
        var param = arguments[1];
        if(param === "development_settings_enabled" || param == "adb_enabled") {
            agSysPacket({information: "AntiDebug technique detected", param: param}).send();
            return 0;
        }
        
        return retval;
    }
}

const STRINGS_TO_REPLACE = "frida";

const replaceLine = (text) => {
    if (text.indexOf("ro.build.tags=test-keys") > -1) {
        agSysPacket({information: "replaceLine bypass", match: "Bypass build.prop file read", text: text}).send();
        return text.replace("ro.build.tags=test-keys", "ro.build.tags=release-keys");
    }

    text.trim().toLowerCase().replace(STRINGS_TO_REPLACE, (match) => {
        agSysPacket({information: "replaceLine bypass", match: match, text: text}).send();
        return text.replaceAll(match, getRandomNumberString(5, 20));
    });
    
    return text;
}

var RootProperties = {
    "ro.build.selinux": "0",
    "ro.debuggable": "0",
    "service.adb.root": "0",
    "ro.secure": "1"
};

var RootPropertiesKeys = [];

for (var k in RootProperties) RootPropertiesKeys.push(k);

var String = Java.use('java.lang.String');

var SystemProperties = Java.use('android.os.SystemProperties');

var BufferedReader = Java.use('java.io.BufferedReader');

var StringBuffer = Java.use('java.lang.StringBuffer');

var loaded_classes = Java.enumerateLoadedClassesSync();

console.log("Loaded " + loaded_classes.length + " classes!");

var useKeyInfo = false;

var KeyInfo = null;

if (loaded_classes.indexOf('android.security.keystore.KeyInfo') != -1) {
    try {
        useKeyInfo = true;
        var KeyInfo = Java.use('android.security.keystore.KeyInfo');
    } catch (err) {
        console.log("KeyInfo Hook failed: " + err);
    }
} else {
    console.log("KeyInfo hook not loaded");
}


if (useKeyInfo) {
    KeyInfo.isInsideSecureHardware.implementation = function() {
        agSysPacket({information: "bypass", details: "isInsideSecureHardware"}).send();
        return true;
    }
}

String.contains.implementation = function(name) {
    if (name == "test-keys") {
        agSysPacket({information: "bypass", details: "Bypass test-keys check"}).send();
        return false;
    }
    return this.contains.call(this, name);
};

var get = SystemProperties.get.overload('java.lang.String');

get.implementation = function(name) {
    if (RootPropertiesKeys.indexOf(name) != -1) {
        agSysPacket({information: "bypass", name: name}).send();
        return RootProperties[name];
    }
    return this.get.call(this, name);
};

BufferedReader.readLine.overloads[0].implementation = function() {
    var text = this.readLine.call(this);
    if (text !== null) {
        text = replaceLine(text);
    }
    return text;
};

BufferedReader.readLine.overloads[1].implementation = function(boolean_) {
    var text = this.readLine(boolean_);
    if (text !== null) {
        text = replaceLine(text);
    } 
    return text;
};

/*
Interceptor.attach(Module.findExportByName(null, '__system_property_get'), {
	onEnter: function (args) {
		this._name = args[0].readCString();
		this._value = args[1];

        colorLog("__system_property_get " + this._name, {c: Color.Red});
	},
	onLeave: function (retval) {
		console.log(JSON.stringify({
			result_length: retval,
			name: this._name,
			val: this._value.readCString()
		}));
	}
});
*/