% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R, R/convenience.R
\name{ReadNanostring}
\alias{ReadNanostring}
\alias{LoadNanostring}
\title{Read and Load Nanostring SMI data}
\usage{
ReadNanostring(
  data.dir,
  mtx.file = NULL,
  metadata.file = NULL,
  molecules.file = NULL,
  segmentations.file = NULL,
  type = "centroids",
  mol.type = "pixels",
  metadata = NULL,
  mols.filter = NA_character_,
  genes.filter = NA_character_,
  fov.filter = NULL,
  subset.counts.matrix = NULL,
  cell.mols.only = TRUE
)

LoadNanostring(data.dir, fov, assay = "Nanostring")
}
\arguments{
\item{data.dir}{Path to folder containing Nanostring SMI outputs}

\item{mtx.file}{Path to Nanostring cell x gene matrix CSV}

\item{metadata.file}{Contains metadata including cell center, area,
and stain intensities}

\item{molecules.file}{Path to molecules file}

\item{segmentations.file}{Path to segmentations CSV}

\item{type}{Type of cell spatial coordinate matrices to read; choose one
or more of:
\itemize{
 \item \dQuote{centroids}: cell centroids in pixel coordinate space
 \item \dQuote{segmentations}: cell segmentations in pixel coordinate space
}}

\item{mol.type}{Type of molecule spatial coordinate matrices to read;
choose one or more of:
\itemize{
 \item \dQuote{pixels}: molecule coordinates in pixel space
}}

\item{metadata}{Type of available metadata to read;
choose zero or more of:
\itemize{
 \item \dQuote{Area}: number of pixels in cell segmentation
 \item \dQuote{fov}: cell's fov
 \item \dQuote{Mean.MembraneStain}: mean membrane stain intensity
 \item \dQuote{Mean.DAPI}: mean DAPI stain intensity
 \item \dQuote{Mean.G}: mean green channel stain intensity
 \item \dQuote{Mean.Y}: mean yellow channel stain intensity
 \item \dQuote{Mean.R}: mean red channel stain intensity
 \item \dQuote{Max.MembraneStain}: max membrane stain intensity
 \item \dQuote{Max.DAPI}: max DAPI stain intensity
 \item \dQuote{Max.G}: max green channel stain intensity
 \item \dQuote{Max.Y}: max yellow stain intensity
 \item \dQuote{Max.R}: max red stain intensity
}}

\item{mols.filter}{Filter molecules that match provided string}

\item{genes.filter}{Filter genes from cell x gene matrix that match
provided string}

\item{fov.filter}{Only load in select FOVs. Nanostring SMI data contains
30 total FOVs.}

\item{subset.counts.matrix}{If the counts matrix should be built from
molecule coordinates for a specific segmentation; One of:
\itemize{
 \item \dQuote{Nuclear}: nuclear segmentations
 \item \dQuote{Cytoplasm}: cell cytoplasm segmentations
 \item \dQuote{Membrane}: cell membrane segmentations
}}

\item{cell.mols.only}{If TRUE, only load molecules within a cell}

\item{fov}{Name to store FOV as}

\item{assay}{Name to store expression matrix as}
}
\value{
\code{ReadNanostring}: A list with some combination of the
following values:
\itemize{
 \item \dQuote{\code{matrix}}: a
 \link[Matrix:dgCMatrix-class]{sparse matrix} with expression data; cells
  are columns and features are rows
 \item \dQuote{\code{centroids}}: a data frame with cell centroid
  coordinates in three columns: \dQuote{x}, \dQuote{y}, and \dQuote{cell}
 \item \dQuote{\code{pixels}}: a data frame with molecule pixel coordinates
  in three columns: \dQuote{x}, \dQuote{y}, and \dQuote{gene}
}

\code{LoadNanostring}: A \code{\link[SeuratObject]{Seurat}} object
}
\description{
Read and Load Nanostring SMI data
}
\note{
This function requires the
\href{https://cran.r-project.org/package=data.table}{\pkg{data.table}} package
to be installed
}
\section{Progress Updates with \pkg{progressr}}{

This function uses
\href{https://cran.r-project.org/package=progressr}{\pkg{progressr}} to
render status updates and progress bars. To enable progress updates, wrap
the function call in \code{\link[progressr]{with_progress}} or run
\code{\link[progressr:handlers]{handlers(global = TRUE)}} before running
this function. For more details about \pkg{progressr}, please read
\href{https://progressr.futureverse.org/articles/progressr-01-intro.html}{\code{vignette("progressr-intro")}}
}

\section{Parallelization with \pkg{future}}{

This function uses
\href{https://cran.r-project.org/package=future}{\pkg{future}} to enable
parallelization. Parallelization strategies can be set using
\code{\link[future]{plan}}. Common plans include \dQuote{\code{sequential}}
for non-parallelized processing or \dQuote{\code{multisession}} for parallel
evaluation using multiple \R sessions; for other plans, see the
\dQuote{Implemented evaluation strategies} section of
\code{\link[future:plan]{?future::plan}}. For a more thorough introduction
to \pkg{future}, see
\href{https://future.futureverse.org/articles/future-1-overview.html}{\code{vignette("future-1-overview")}}
}

\concept{future}
\concept{preprocessing}
