#!/usr/bin/env tclsh8.6
#
# joiner.tcl: join a channel by select and click in a text widget
#
# To install in the default directory:
#
#	# make install
#
# To install on a different prefix (i.e. your homedir)
#
#	$PREFIX=${HOME} make install
#
# The extension works by joining a channel the user clicked on with
# the mouse button 2, after having selected it.
#

source $::env(IRCTK_TCL_SDK)

set name "Joiner"
set version 1.0.0

proc joiner {msg} {
	#
	# Check if the string correspond to an IRC public
	# channel. If so, send the join.
	#
	if {![regexp {^[&#!+]} [dict get $msg data]]} {return}

	::irctk::ircsend [dict get $msg network] [dict get $msg channel] \
	    JOIN [dict get $msg data]
}

::irctk::init $name $version {}

::irctk::filter plumb joiner

::irctk::loop
