/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem.nativeimage;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.logging.Log;
import java.util.Arrays;
import java.util.List;

public final class ReflectiveClassBuildItem
extends MultiBuildItem {
    private final List<String> className;
    private final boolean methods;
    private final boolean queryMethods;
    private final boolean fields;
    private final boolean classes;
    private final boolean constructors;
    private final boolean queryConstructors;
    private final boolean weak;
    private final boolean serialization;
    private final boolean unsafeAllocated;
    private final String reason;

    public static Builder builder(Class<?> ... classes) {
        String[] classNames = (String[])Arrays.stream(classes).map(aClass -> {
            if (aClass == null) {
                throw new NullPointerException();
            }
            return aClass.getName();
        }).toArray(String[]::new);
        return new Builder().className(classNames);
    }

    public static Builder builder(String ... classNames) {
        return new Builder().className(classNames);
    }

    private ReflectiveClassBuildItem(boolean constructors, boolean queryConstructors, boolean methods, boolean queryMethods, boolean fields, boolean getClasses, boolean weak, boolean serialization, boolean unsafeAllocated, String reason, Class<?> ... classes) {
        this(constructors, queryConstructors, methods, queryMethods, fields, getClasses, weak, serialization, unsafeAllocated, reason, (String[])Arrays.stream(classes).map(Class::getName).toArray(String[]::new));
    }

    @Deprecated(since="3.0", forRemoval=true)
    public ReflectiveClassBuildItem(boolean methods, boolean fields, Class<?> ... classes) {
        this(true, methods, fields, classes);
    }

    @Deprecated(since="3.0", forRemoval=true)
    public ReflectiveClassBuildItem(boolean constructors, boolean methods, boolean fields, Class<?> ... classes) {
        this(constructors, false, methods, false, fields, false, false, false, false, null, classes);
    }

    @Deprecated(since="3.0", forRemoval=true)
    public ReflectiveClassBuildItem(boolean methods, boolean fields, String ... classNames) {
        this(true, methods, fields, classNames);
    }

    @Deprecated(since="3.0", forRemoval=true)
    public ReflectiveClassBuildItem(boolean constructors, boolean methods, boolean fields, String ... classNames) {
        this(constructors, false, methods, false, fields, false, false, false, classNames);
    }

    @Deprecated(since="3.0", forRemoval=true)
    public ReflectiveClassBuildItem(boolean constructors, boolean methods, boolean fields, boolean serialization, String ... classNames) {
        this(constructors, false, methods, false, fields, false, serialization, false, classNames);
    }

    public static ReflectiveClassBuildItem weakClass(String ... classNames) {
        return ReflectiveClassBuildItem.builder(classNames).constructors().methods().fields().weak().build();
    }

    public static ReflectiveClassBuildItem weakClass(boolean constructors, boolean methods, boolean fields, String ... classNames) {
        return ReflectiveClassBuildItem.builder(classNames).constructors(constructors).methods(methods).fields(fields).weak().build();
    }

    public static ReflectiveClassBuildItem serializationClass(String ... classNames) {
        return ReflectiveClassBuildItem.builder(classNames).serialization().build();
    }

    @Deprecated(since="3.14", forRemoval=true)
    ReflectiveClassBuildItem(boolean constructors, boolean queryConstructors, boolean methods, boolean queryMethods, boolean fields, boolean weak, boolean serialization, boolean unsafeAllocated, String ... className) {
        this(constructors, queryConstructors, methods, queryMethods, fields, false, weak, serialization, unsafeAllocated, null, className);
    }

    ReflectiveClassBuildItem(boolean constructors, boolean queryConstructors, boolean methods, boolean queryMethods, boolean fields, boolean classes, boolean weak, boolean serialization, boolean unsafeAllocated, String reason, String ... className) {
        for (String i : className) {
            if (i != null) continue;
            throw new NullPointerException();
        }
        this.className = Arrays.asList(className);
        this.methods = methods;
        if (methods && queryMethods) {
            Log.warnf((String)"Both methods and queryMethods are set to true for classes: %s. queryMethods is redundant and will be ignored", (Object)String.join((CharSequence)", ", className));
            this.queryMethods = false;
        } else {
            this.queryMethods = queryMethods;
        }
        this.fields = fields;
        this.classes = classes;
        this.constructors = constructors;
        if (constructors && queryConstructors) {
            Log.warnf((String)"Both constructors and queryConstructors are set to true for classes: %s. queryConstructors is redundant and will be ignored", (Object)String.join((CharSequence)", ", className));
            this.queryConstructors = false;
        } else {
            this.queryConstructors = queryConstructors;
        }
        this.weak = weak;
        this.serialization = serialization;
        this.unsafeAllocated = unsafeAllocated;
        this.reason = reason;
    }

    public List<String> getClassNames() {
        return this.className;
    }

    public boolean isMethods() {
        return this.methods;
    }

    public boolean isQueryMethods() {
        return this.queryMethods;
    }

    public boolean isFields() {
        return this.fields;
    }

    public boolean isClasses() {
        return this.classes;
    }

    public boolean isConstructors() {
        return this.constructors;
    }

    public boolean isQueryConstructors() {
        return this.queryConstructors;
    }

    @Deprecated
    public boolean areFinalFieldsWritable() {
        return false;
    }

    public boolean isWeak() {
        return this.weak;
    }

    public boolean isSerialization() {
        return this.serialization;
    }

    public boolean isUnsafeAllocated() {
        return this.unsafeAllocated;
    }

    public String getReason() {
        return this.reason;
    }

    public static class Builder {
        private String[] className;
        private boolean constructors = true;
        private boolean queryConstructors;
        private boolean methods;
        private boolean queryMethods;
        private boolean fields;
        private boolean classes;
        private boolean weak;
        private boolean serialization;
        private boolean unsafeAllocated;
        private String reason;

        private Builder() {
        }

        public Builder className(String[] className) {
            this.className = className;
            return this;
        }

        public Builder constructors(boolean constructors) {
            this.constructors = constructors;
            return this;
        }

        public Builder constructors() {
            return this.constructors(true);
        }

        public Builder queryConstructors(boolean queryConstructors) {
            this.queryConstructors = queryConstructors;
            return this;
        }

        public Builder queryConstructors() {
            return this.queryConstructors(true);
        }

        public Builder methods(boolean methods) {
            this.methods = methods;
            return this;
        }

        public Builder methods() {
            return this.methods(true);
        }

        public Builder queryMethods(boolean queryMethods) {
            this.queryMethods = queryMethods;
            return this;
        }

        public Builder queryMethods() {
            return this.queryMethods(true);
        }

        public Builder fields(boolean fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields() {
            return this.fields(true);
        }

        public Builder classes(boolean classes) {
            this.classes = classes;
            return this;
        }

        public Builder classes() {
            return this.classes(true);
        }

        @Deprecated(forRemoval=true)
        public Builder finalFieldsWritable(boolean finalFieldsWritable) {
            return this;
        }

        public Builder weak(boolean weak) {
            this.weak = weak;
            return this;
        }

        public Builder weak() {
            return this.weak(true);
        }

        public Builder serialization(boolean serialization) {
            this.serialization = serialization;
            return this;
        }

        public Builder serialization() {
            return this.serialization(true);
        }

        public Builder unsafeAllocated(boolean unsafeAllocated) {
            this.unsafeAllocated = unsafeAllocated;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder unsafeAllocated() {
            return this.unsafeAllocated(true);
        }

        public ReflectiveClassBuildItem build() {
            return new ReflectiveClassBuildItem(this.constructors, this.queryConstructors, this.methods, this.queryMethods, this.fields, this.classes, this.weak, this.serialization, this.unsafeAllocated, this.reason, this.className);
        }
    }
}

