/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.HardcodedLDAPGroupStorageMapper;

public class HardcodedLDAPGroupStorageMapperFactory
extends AbstractLDAPStorageMapperFactory {
    public static final String PROVIDER_ID = "hardcoded-ldap-group-mapper";
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    @Override
    public String getHelpText() {
        return "When user is imported from LDAP, he will be automatically added into this configured group.";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        String groupName = (String)config.getConfig().getFirst((Object)"group");
        if (groupName == null) {
            throw new ComponentValidationException("Group can't be null", new Object[0]);
        }
        GroupModel group = KeycloakModelUtils.findGroupByPath((KeycloakSession)session, (RealmModel)realm, (String)groupName);
        if (group == null) {
            throw new ComponentValidationException("There is no group corresponding to configured value", new Object[0]);
        }
    }

    @Override
    protected AbstractLDAPStorageMapper createMapper(ComponentModel mapperModel, LDAPStorageProvider federationProvider) {
        return new HardcodedLDAPGroupStorageMapper(mapperModel, federationProvider);
    }

    static {
        ProviderConfigProperty groupAttr = HardcodedLDAPGroupStorageMapperFactory.createConfigProperty("group", "Group", "Group to add the user in. Fill the full path of the group including path. For example '/root-group/child-group'", "String", null, true);
        configProperties.add(groupAttr);
    }
}

