/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.descriptor.java.JavaType;

public interface SqmPath<T>
extends SqmExpression<T>,
SemanticPathPart,
JpaPath<T> {
    @Override
    public NavigablePath getNavigablePath();

    public SqmPathSource<?> getReferencedPathSource();

    public String getExplicitAlias();

    public void setExplicitAlias(String var1);

    default public String resolveAlias() {
        String explicitAlias = this.getExplicitAlias();
        if (explicitAlias != null) {
            return explicitAlias;
        }
        String generatedAlias = "alias_" + System.identityHashCode(this);
        this.setExplicitAlias(generatedAlias);
        return generatedAlias;
    }

    @Override
    public SqmPath<?> getLhs();

    public List<SqmPath<?>> getReusablePaths();

    public void visitReusablePaths(Consumer<SqmPath<?>> var1);

    public void registerReusablePath(SqmPath<?> var1);

    public SqmPath<?> getReusablePath(String var1);

    @Override
    public SqmPathSource<T> getNodeType();

    @Override
    default public void applyInferableType(@Nullable SqmExpressible<?> type) {
    }

    @Override
    default public JavaType<T> getJavaTypeDescriptor() {
        return this.getNodeType().getExpressibleJavaType();
    }

    @Override
    public <S extends T> SqmPath<S> treatAs(Class<S> var1);

    @Override
    public <S extends T> SqmPath<S> treatAs(EntityDomainType<S> var1);

    default public SqmRoot<?> findRoot() {
        JpaPath lhs = this.getLhs();
        if (lhs != null) {
            return lhs.findRoot();
        }
        throw new ParsingException("Could not find root");
    }

    @Override
    public SqmPath<?> resolvePathPart(String var1, boolean var2, SqmCreationState var3);

    @Override
    default public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        throw new SemanticException("Index operator applied to non-plural path '" + this.getNavigablePath() + "'");
    }

    public SqmPathSource<?> getResolvedModel();

    @Override
    public <Y> SqmPath<Y> get(SingularAttribute<? super T, Y> var1);

    @Override
    public <E, C extends Collection<E>> SqmExpression<C> get(PluralAttribute<T, C, E> var1);

    @Override
    public <K, V, M extends Map<K, V>> SqmExpression<M> get(MapAttribute<T, K, V> var1);

    @Override
    public SqmExpression<Class<? extends T>> type();

    @Override
    public <Y> SqmPath<Y> get(String var1);

    @Override
    public SqmPath<T> copy(SqmCopyContext var1);
}

