/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.authentication.CredentialAction;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.authenticators.util.AcrStore;
import org.keycloak.authentication.requiredactions.util.CredentialDeleteHelper;
import org.keycloak.credential.CredentialModel;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.utils.StringUtil;

public class DeleteCredentialAction
implements RequiredActionProvider,
RequiredActionFactory,
CredentialAction {
    public static final String PROVIDER_ID = "delete_credential";

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public String getCredentialType(KeycloakSession session, AuthenticationSessionModel authenticationSession) {
        String credentialId = authenticationSession.getClientNote("kc_action_parameter");
        if (credentialId == null) {
            return null;
        }
        UserModel user = authenticationSession.getAuthenticatedUser();
        if (user == null) {
            return null;
        }
        CredentialModel credential = user.credentialManager().getStoredCredentialById(credentialId);
        if (credential == null) {
            if (credentialId.endsWith("-id")) {
                return credentialId.substring(0, credentialId.length() - 3);
            }
            return null;
        }
        return credential.getType();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void requiredActionChallenge(RequiredActionContext context) {
        String credentialLabel;
        String credentialId = context.getAuthenticationSession().getClientNote("kc_action_parameter");
        UserModel user = context.getUser();
        if (credentialId == null) {
            context.getEvent().error("missing_credential_id");
            context.ignore();
            return;
        }
        CredentialModel credential = user.credentialManager().getStoredCredentialById(credentialId);
        if (credential == null) {
            if (!credentialId.endsWith("-id")) {
                context.getEvent().detail("credential_id", credentialId).error("credential_not_found");
                context.ignore();
                return;
            }
            credentialLabel = credentialId.substring(0, credentialId.length() - 3);
        } else {
            credentialLabel = StringUtil.isNotBlank((String)credential.getUserLabel()) ? credential.getUserLabel() : credential.getType();
        }
        Response challenge = context.form().setAttribute("credentialLabel", (Object)credentialLabel).createForm("delete-credential.ftl");
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent();
        event.event(EventType.REMOVE_CREDENTIAL);
        EventBuilder deprecatedEvent = null;
        String credentialId = context.getAuthenticationSession().getClientNote("kc_action_parameter");
        CredentialModel credential = context.getUser().credentialManager().getStoredCredentialById(credentialId);
        if (credential != null) {
            event.detail("credential_type", credential.getType()).detail("credential_id", credential.getId()).detail("credential_user_label", credential.getUserLabel());
            if ("otp".equals(credential.getType())) {
                deprecatedEvent = event.clone().event(EventType.REMOVE_TOTP);
            }
        }
        try {
            CredentialDeleteHelper.removeCredential(context.getSession(), context.getUser(), credentialId, () -> this.getCurrentLoa(context.getSession(), context.getAuthenticationSession()));
            context.success();
            if (deprecatedEvent != null) {
                deprecatedEvent.success();
            }
        }
        catch (WebApplicationException wae) {
            Response response = ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setAuthenticationSession(context.getAuthenticationSession()).setUser(context.getUser()).setError(wae.getMessage(), new Object[0]).createErrorPage(Response.Status.BAD_REQUEST);
            event.detail("reason", wae.getMessage()).error("delete_credential_failed");
            if (deprecatedEvent != null) {
                deprecatedEvent.detail("reason", wae.getMessage()).error("delete_credential_failed");
            }
            context.challenge(response);
        }
    }

    private int getCurrentLoa(KeycloakSession session, AuthenticationSessionModel authSession) {
        return new AcrStore(session, authSession).getLevelOfAuthenticationFromCurrentAuthentication();
    }

    public String getDisplayText() {
        return "Delete Credential";
    }

    public void close() {
    }
}

