/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.HeaderPortlet;
import javax.portlet.HeaderRequest;
import javax.portlet.HeaderResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.ProcessAction;
import javax.portlet.ProcessEvent;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.WindowState;
import javax.xml.namespace.QName;

public abstract class GenericPortlet
implements Portlet,
PortletConfig,
EventPortlet,
ResourceServingPortlet,
HeaderPortlet {
    public static final String AUTOMATIC_RESOURCE_DISPATCH = "javax.portlet.automaticResourceDispatching";
    private transient PortletConfig config;
    private transient Map<String, Method> processActionHandlingMethodsMap = new HashMap<String, Method>();
    private transient Map<String, Method> processEventHandlingMethodsMap = new HashMap<String, Method>();
    private transient Map<String, Method> renderModeHandlingMethodsMap = new HashMap<String, Method>();

    @Override
    public void init(PortletConfig config) throws PortletException {
        this.config = config;
        this.cacheAnnotatedMethods();
        this.init();
    }

    public void init() throws PortletException {
    }

    @Override
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String action = request.getParameter("javax.portlet.action");
        try {
            Method actionMethod = this.processActionHandlingMethodsMap.get(action);
            if (actionMethod != null) {
                actionMethod.invoke((Object)this, request, response);
                return;
            }
        }
        catch (Exception e) {
            Throwable th;
            if (e instanceof InvocationTargetException && (th = e.getCause()) != null) {
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof PortletException) {
                    throw (PortletException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
            }
            throw new PortletException(e);
        }
        throw new PortletException("processAction method not implemented");
    }

    @Override
    public void renderHeaders(HeaderRequest request, HeaderResponse response) throws PortletException, IOException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Object renderPartAttrValue = request.getAttribute("javax.portlet.render_part");
        if (renderPartAttrValue != null) {
            if (renderPartAttrValue.equals("RENDER_HEADERS")) {
                this.doHeaders(request, response);
                Collection<PortletMode> nextModes = this.getNextPossiblePortletModes(request);
                if (nextModes != null) {
                    response.setNextPossiblePortletModes(nextModes);
                }
                response.setTitle(this.getTitle(request));
                return;
            } else {
                if (!renderPartAttrValue.equals("RENDER_MARKUP")) throw new PortletException("Unknown value of the 'javax.portlet.render_part' request attribute");
                this.doDispatch(request, response);
            }
            return;
        } else {
            this.doHeaders(request, response);
            Collection<PortletMode> nextModes = this.getNextPossiblePortletModes(request);
            if (nextModes != null) {
                response.setNextPossiblePortletModes(nextModes);
            }
            response.setTitle(this.getTitle(request));
            this.doDispatch(request, response);
        }
    }

    protected String getTitle(RenderRequest request) {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getResourceBundle(request.getLocale()).getString("javax.portlet.title");
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        WindowState state = request.getWindowState();
        if (!state.equals(WindowState.MINIMIZED)) {
            PortletMode mode = request.getPortletMode();
            try {
                Method renderMethod = this.renderModeHandlingMethodsMap.get(mode.toString());
                if (renderMethod != null) {
                    renderMethod.invoke((Object)this, request, response);
                    return;
                }
            }
            catch (Exception e) {
                Throwable th;
                if (e instanceof InvocationTargetException && (th = e.getCause()) != null) {
                    if (th instanceof IOException) {
                        throw (IOException)th;
                    }
                    if (th instanceof PortletException) {
                        throw (PortletException)th;
                    }
                    if (th instanceof RuntimeException) {
                        throw (RuntimeException)th;
                    }
                }
                throw new PortletException(e);
            }
            if (mode.equals(PortletMode.VIEW)) {
                this.doView(request, response);
            } else if (mode.equals(PortletMode.EDIT)) {
                this.doEdit(request, response);
            } else if (mode.equals(PortletMode.HELP)) {
                this.doHelp(request, response);
            } else {
                throw new PortletException("unknown portlet mode: " + mode);
            }
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doView method not implemented");
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doEdit method not implemented");
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doHelp method not implemented");
    }

    public PortletConfig getPortletConfig() {
        return this.config;
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getPortletName() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getPortletName();
    }

    @Override
    public PortletContext getPortletContext() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getPortletContext();
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getResourceBundle(locale);
    }

    @Override
    public String getInitParameter(String name) {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getInitParameter(name);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getInitParameterNames();
    }

    @Override
    public Enumeration<QName> getProcessingEventQNames() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getProcessingEventQNames();
    }

    @Override
    public Enumeration<QName> getPublishingEventQNames() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getPublishingEventQNames();
    }

    @Override
    public Enumeration<Locale> getSupportedLocales() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getSupportedLocales();
    }

    @Override
    public Map<String, String[]> getContainerRuntimeOptions() {
        return this.config.getContainerRuntimeOptions();
    }

    @Override
    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortletRequestDispatcher rd;
        String autofwd = this.getInitParameter(AUTOMATIC_RESOURCE_DISPATCH);
        if (autofwd != null && autofwd.equalsIgnoreCase("true") && request.getResourceID() != null && (rd = this.getPortletConfig().getPortletContext().getRequestDispatcher(request.getResourceID())) != null) {
            rd.forward(request, response);
        }
    }

    @Override
    public void processEvent(EventRequest request, EventResponse response) throws PortletException, IOException {
        String eventName = request.getEvent().getQName().toString();
        try {
            Method eventMethod = this.processEventHandlingMethodsMap.get(eventName);
            if (eventMethod != null) {
                eventMethod.invoke((Object)this, request, response);
                return;
            }
            int endPos = eventName.indexOf(125);
            int dotPos = eventName.lastIndexOf(46);
            while (dotPos > endPos) {
                String wildcardLookup = eventName.substring(0, dotPos + 1);
                eventMethod = this.processEventHandlingMethodsMap.get(wildcardLookup);
                if (eventMethod != null) {
                    eventMethod.invoke((Object)this, request, response);
                    return;
                }
                if (dotPos != 0) {
                    dotPos = eventName.lastIndexOf(46, dotPos - 1);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Throwable th;
            if (e instanceof InvocationTargetException && (th = e.getCause()) != null) {
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof PortletException) {
                    throw (PortletException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
            }
            throw new PortletException(e);
        }
        response.setRenderParameters(request);
    }

    protected void doHeaders(RenderRequest request, RenderResponse response) throws PortletException, IOException {
    }

    protected Collection<PortletMode> getNextPossiblePortletModes(RenderRequest request) {
        return null;
    }

    @Override
    public Enumeration<String> getPublicRenderParameterNames() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getPublicRenderParameterNames();
    }

    @Override
    public String getDefaultNamespace() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getDefaultNamespace();
    }

    @Override
    public Enumeration<PortletMode> getPortletModes(String mimeType) {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getPortletModes(mimeType);
    }

    @Override
    public Enumeration<WindowState> getWindowStates(String mimeType) {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getWindowStates(mimeType);
    }

    @Override
    public Map<String, QName> getPublicRenderParameterDefinitions() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getPublicRenderParameterDefinitions();
    }

    protected boolean dispatchAnnotatedActionMethod(String name, ActionRequest request, ActionResponse response) throws PortletException, IOException {
        boolean methodInvoked = false;
        try {
            Method actionMethod = this.processActionHandlingMethodsMap.get(name);
            if (actionMethod != null) {
                actionMethod.invoke((Object)this, request, response);
                methodInvoked = true;
            }
        }
        catch (Exception e) {
            Throwable th;
            if (e instanceof InvocationTargetException && (th = e.getCause()) != null) {
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof PortletException) {
                    throw (PortletException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
            }
            throw new PortletException(e);
        }
        return methodInvoked;
    }

    protected boolean dispatchAnnotatedEventMethod(String name, EventRequest request, EventResponse response) throws PortletException, IOException {
        boolean methodInvoked = false;
        String eventName = request.getEvent().getQName().toString();
        try {
            Method eventMethod = this.processEventHandlingMethodsMap.get(eventName);
            if (eventMethod != null) {
                eventMethod.invoke((Object)this, request, response);
                methodInvoked = true;
            }
        }
        catch (Exception e) {
            Throwable th;
            if (e instanceof InvocationTargetException && (th = e.getCause()) != null) {
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof PortletException) {
                    throw (PortletException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
            }
            throw new PortletException(e);
        }
        return methodInvoked;
    }

    protected boolean dispatchAnnotatedRenderMethod(String name, RenderRequest request, RenderResponse response) throws PortletException, IOException {
        boolean methodInvoked = false;
        try {
            Method renderMethod = this.renderModeHandlingMethodsMap.get(name);
            if (renderMethod != null) {
                renderMethod.invoke((Object)this, request, response);
                methodInvoked = true;
            }
        }
        catch (Exception e) {
            Throwable th;
            if (e instanceof InvocationTargetException && (th = e.getCause()) != null) {
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof PortletException) {
                    throw (PortletException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
            }
            throw new PortletException(e);
        }
        return methodInvoked;
    }

    private void cacheAnnotatedMethods() {
        for (Method method : this.getClass().getMethods()) {
            Annotation[] annotations = method.getAnnotations();
            if (annotations == null) continue;
            for (Annotation annotation : annotations) {
                String name;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (ProcessAction.class.equals(annotationType)) {
                    name = ((ProcessAction)annotation).name();
                    if (name == null || name.length() <= 0) continue;
                    this.addToMap(this.processActionHandlingMethodsMap, name, method);
                    continue;
                }
                if (ProcessEvent.class.equals(annotationType)) {
                    String qname = ((ProcessEvent)annotation).qname();
                    if (qname == null || qname.length() <= 0) {
                        if (this.config == null) {
                            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
                        }
                        String name2 = ((ProcessEvent)annotation).name();
                        if (name2 == null || name2.length() <= 0) continue;
                        qname = new QName(this.config.getDefaultNamespace(), name2).toString();
                        this.addToMap(this.processEventHandlingMethodsMap, qname, method);
                        continue;
                    }
                    this.addToMap(this.processEventHandlingMethodsMap, qname, method);
                    continue;
                }
                if (!RenderMode.class.equals(annotationType) || (name = ((RenderMode)annotation).name()) == null || name.length() <= 0) continue;
                this.addToMap(this.renderModeHandlingMethodsMap, name.toLowerCase(), method);
            }
        }
    }

    private void addToMap(Map<String, Method> map, String name, Method newMethod) {
        Method mapMethod = map.get(name);
        if (mapMethod != null && newMethod != null) {
            int classLevelNew;
            ArrayList classHierarchy = new ArrayList();
            for (Class<?> cls = this.getClass(); cls != null; cls = cls.getSuperclass()) {
                classHierarchy.add(cls);
            }
            int classLevelMap = classHierarchy.indexOf(mapMethod.getDeclaringClass());
            if (classLevelMap <= (classLevelNew = classHierarchy.indexOf(newMethod.getDeclaringClass()))) {
                return;
            }
        }
        map.put(name, newMethod);
    }
}

