/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.telemetry.impl.TelemetryService;

public abstract class StatsAffectingRetryingOperation<T>
extends RetryOnFailureOperation<T> {
    protected ClientStatistics clientStatistics;
    private long startTime;

    protected StatsAffectingRetryingOperation(short requestCode, short responseCode, Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, DataFormat dataFormat, ClientStatistics clientStatistics, TelemetryService telemetryService) {
        super(requestCode, responseCode, codec, channelFactory, cacheName, clientTopology, flags, cfg, dataFormat, telemetryService);
        this.clientStatistics = clientStatistics;
    }

    @Override
    protected void scheduleRead(Channel channel) {
        if (this.clientStatistics.isEnabled()) {
            this.startTime = this.clientStatistics.time();
        }
        super.scheduleRead(channel);
    }

    protected void statsDataRead(boolean success) {
        if (this.clientStatistics.isEnabled()) {
            this.clientStatistics.dataRead(success, this.startTime, 1);
        }
    }

    protected void statsDataRead(boolean success, int count) {
        if (this.clientStatistics.isEnabled() && count > 0) {
            this.clientStatistics.dataRead(success, this.startTime, count);
        }
    }

    protected void statsDataStore() {
        if (this.clientStatistics.isEnabled()) {
            this.clientStatistics.dataStore(this.startTime, 1);
        }
    }

    protected void statsDataStore(int count) {
        if (this.clientStatistics.isEnabled() && count > 0) {
            this.clientStatistics.dataStore(this.startTime, count);
        }
    }

    protected void statsDataRemove() {
        if (this.clientStatistics.isEnabled()) {
            this.clientStatistics.dataRemove(this.startTime, 1);
        }
    }
}

