/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrReferenceSpaceCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int REFERENCESPACETYPE;
    public static final int POSEINREFERENCESPACE;

    public XrReferenceSpaceCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrReferenceSpaceCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrReferenceSpaceCreateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrReferenceSpaceCreateInfo.nnext(this.address());
    }

    @NativeType(value="XrReferenceSpaceType")
    public int referenceSpaceType() {
        return XrReferenceSpaceCreateInfo.nreferenceSpaceType(this.address());
    }

    public XrPosef poseInReferenceSpace() {
        return XrReferenceSpaceCreateInfo.nposeInReferenceSpace(this.address());
    }

    public XrReferenceSpaceCreateInfo type(@NativeType(value="XrStructureType") int value) {
        XrReferenceSpaceCreateInfo.ntype(this.address(), value);
        return this;
    }

    public XrReferenceSpaceCreateInfo type$Default() {
        return this.type(37);
    }

    public XrReferenceSpaceCreateInfo next(@NativeType(value="void const *") long value) {
        XrReferenceSpaceCreateInfo.nnext(this.address(), value);
        return this;
    }

    public XrReferenceSpaceCreateInfo referenceSpaceType(@NativeType(value="XrReferenceSpaceType") int value) {
        XrReferenceSpaceCreateInfo.nreferenceSpaceType(this.address(), value);
        return this;
    }

    public XrReferenceSpaceCreateInfo poseInReferenceSpace(XrPosef value) {
        XrReferenceSpaceCreateInfo.nposeInReferenceSpace(this.address(), value);
        return this;
    }

    public XrReferenceSpaceCreateInfo poseInReferenceSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInReferenceSpace());
        return this;
    }

    public XrReferenceSpaceCreateInfo set(int type, long next, int referenceSpaceType, XrPosef poseInReferenceSpace) {
        this.type(type);
        this.next(next);
        this.referenceSpaceType(referenceSpaceType);
        this.poseInReferenceSpace(poseInReferenceSpace);
        return this;
    }

    public XrReferenceSpaceCreateInfo set(XrReferenceSpaceCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrReferenceSpaceCreateInfo malloc() {
        return (XrReferenceSpaceCreateInfo)XrReferenceSpaceCreateInfo.wrap(XrReferenceSpaceCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrReferenceSpaceCreateInfo calloc() {
        return (XrReferenceSpaceCreateInfo)XrReferenceSpaceCreateInfo.wrap(XrReferenceSpaceCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrReferenceSpaceCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrReferenceSpaceCreateInfo)XrReferenceSpaceCreateInfo.wrap(XrReferenceSpaceCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrReferenceSpaceCreateInfo create(long address) {
        return (XrReferenceSpaceCreateInfo)XrReferenceSpaceCreateInfo.wrap(XrReferenceSpaceCreateInfo.class, (long)address);
    }

    @Nullable
    public static XrReferenceSpaceCreateInfo createSafe(long address) {
        return address == 0L ? null : (XrReferenceSpaceCreateInfo)XrReferenceSpaceCreateInfo.wrap(XrReferenceSpaceCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrReferenceSpaceCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrReferenceSpaceCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrReferenceSpaceCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrReferenceSpaceCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrReferenceSpaceCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrReferenceSpaceCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrReferenceSpaceCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrReferenceSpaceCreateInfo malloc(MemoryStack stack) {
        return (XrReferenceSpaceCreateInfo)XrReferenceSpaceCreateInfo.wrap(XrReferenceSpaceCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrReferenceSpaceCreateInfo calloc(MemoryStack stack) {
        return (XrReferenceSpaceCreateInfo)XrReferenceSpaceCreateInfo.wrap(XrReferenceSpaceCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrReferenceSpaceCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrReferenceSpaceCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nreferenceSpaceType(long struct) {
        return UNSAFE.getInt(null, struct + (long)REFERENCESPACETYPE);
    }

    public static XrPosef nposeInReferenceSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINREFERENCESPACE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nreferenceSpaceType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REFERENCESPACETYPE, value);
    }

    public static void nposeInReferenceSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSEINREFERENCESPACE), (long)XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrReferenceSpaceCreateInfo.__struct((Struct.Member[])new Struct.Member[]{XrReferenceSpaceCreateInfo.__member((int)4), XrReferenceSpaceCreateInfo.__member((int)POINTER_SIZE), XrReferenceSpaceCreateInfo.__member((int)4), XrReferenceSpaceCreateInfo.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        REFERENCESPACETYPE = layout.offsetof(2);
        POSEINREFERENCESPACE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrReferenceSpaceCreateInfo, Buffer>
    implements NativeResource {
        private static final XrReferenceSpaceCreateInfo ELEMENT_FACTORY = XrReferenceSpaceCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrReferenceSpaceCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrReferenceSpaceCreateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrReferenceSpaceCreateInfo.nnext(this.address());
        }

        @NativeType(value="XrReferenceSpaceType")
        public int referenceSpaceType() {
            return XrReferenceSpaceCreateInfo.nreferenceSpaceType(this.address());
        }

        public XrPosef poseInReferenceSpace() {
            return XrReferenceSpaceCreateInfo.nposeInReferenceSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrReferenceSpaceCreateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(37);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrReferenceSpaceCreateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer referenceSpaceType(@NativeType(value="XrReferenceSpaceType") int value) {
            XrReferenceSpaceCreateInfo.nreferenceSpaceType(this.address(), value);
            return this;
        }

        public Buffer poseInReferenceSpace(XrPosef value) {
            XrReferenceSpaceCreateInfo.nposeInReferenceSpace(this.address(), value);
            return this;
        }

        public Buffer poseInReferenceSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInReferenceSpace());
            return this;
        }
    }
}

