/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.types;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.zone.ZoneRulesException;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.types.Command;
import org.openhab.core.types.PrimitiveType;
import org.openhab.core.types.State;

@NonNullByDefault
public class DateTimeType
implements PrimitiveType,
State,
Command,
Comparable<DateTimeType> {
    public static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String DATE_PATTERN_WITH_TZ = "yyyy-MM-dd'T'HH:mm:ssz";
    public static final String DATE_PATTERN_WITH_TZ_AND_MS = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String DATE_PATTERN_WITH_TZ_AND_MS_GENERAL = "yyyy-MM-dd'T'HH:mm:ss.SSSz";
    public static final String DATE_PATTERN_WITH_TZ_AND_MS_ISO = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    public static final String DATE_PATTERN_JSON_COMPAT = "MMM d, yyyy, h:mm:ss aaa";
    private static final String DATE_PARSE_PATTERN_WITHOUT_TZ = "yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]";
    private static final String DATE_PARSE_PATTERN_WITH_TZ = "yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]z";
    private static final String DATE_PARSE_PATTERN_WITH_TZ_RFC = "yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]Z";
    private static final String DATE_PARSE_PATTERN_WITH_TZ_ISO = "yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]X";
    private static final DateTimeFormatter PARSER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]");
    private static final DateTimeFormatter PARSER_TZ = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]z");
    private static final DateTimeFormatter PARSER_TZ_RFC = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]Z");
    private static final DateTimeFormatter PARSER_TZ_ISO = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]X");
    private static final Pattern DATE_PARSE_PATTERN_WITH_SPACE = Pattern.compile("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}.*");
    private static final String DATE_FORMAT_PATTERN_WITH_TZ_RFC = "yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS]]Z";
    private static final DateTimeFormatter FORMATTER_TZ_RFC = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm[:ss[.SSSSSSSSS]]Z");
    private Instant instant;

    public DateTimeType() {
        this(Instant.now());
    }

    public DateTimeType(Instant instant) {
        this.instant = instant;
    }

    public DateTimeType(ZonedDateTime zoned) {
        this.instant = zoned.toInstant();
    }

    public DateTimeType(String zonedValue) {
        block10: {
            try {
                try {
                    if (DATE_PARSE_PATTERN_WITH_SPACE.matcher(zonedValue).matches()) {
                        this.instant = this.parse(zonedValue.substring(0, 10) + "T" + zonedValue.substring(11));
                        break block10;
                    }
                    this.instant = this.parse(zonedValue);
                }
                catch (DateTimeParseException fullDtException) {
                    try {
                        this.instant = this.parse("1970-01-01T" + zonedValue);
                    }
                    catch (DateTimeParseException timeOnlyException) {
                        try {
                            long epoch = Double.valueOf(zonedValue).longValue();
                            int length = (int)(Math.log10(epoch >= 0L ? epoch : epoch * -1L) + 1.0);
                            this.instant = length < 12 ? Instant.ofEpochSecond(epoch) : Instant.ofEpochMilli(epoch);
                        }
                        catch (NumberFormatException notANumberException) {
                            if (zonedValue.length() == 10) {
                                this.instant = this.parse(zonedValue + "T00:00:00");
                                break block10;
                            }
                            this.instant = this.parse(zonedValue.substring(0, 10) + "T00:00:00" + zonedValue.substring(10));
                        }
                    }
                }
            }
            catch (DateTimeParseException invalidFormatException) {
                throw new IllegalArgumentException(zonedValue + " is not in a valid format.", invalidFormatException);
            }
        }
    }

    @Deprecated
    public ZonedDateTime getZonedDateTime() {
        return this.getZonedDateTime(ZoneId.systemDefault());
    }

    public ZonedDateTime getZonedDateTime(ZoneId zoneId) {
        return this.instant.atZone(zoneId);
    }

    public Instant getInstant() {
        return this.instant;
    }

    public static DateTimeType valueOf(String value) {
        return new DateTimeType(value);
    }

    @Override
    public String format(@Nullable String pattern) {
        return this.format(pattern, ZoneId.systemDefault());
    }

    public String format(@Nullable String pattern, ZoneId zoneId) {
        ZonedDateTime zonedDateTime = this.instant.atZone(zoneId);
        if (pattern == null) {
            return DateTimeFormatter.ofPattern(DATE_PATTERN).format(zonedDateTime);
        }
        return String.format(pattern, zonedDateTime);
    }

    public String format(Locale locale, String pattern) {
        return String.format(locale, pattern, this.getZonedDateTime());
    }

    @Deprecated
    public DateTimeType toLocaleZone() throws DateTimeException, ZoneRulesException {
        return new DateTimeType(this.instant);
    }

    @Deprecated
    public DateTimeType toZone(String zone) throws DateTimeException, ZoneRulesException {
        return new DateTimeType(this.instant);
    }

    @Deprecated
    public DateTimeType toZone(ZoneId zoneId) throws DateTimeException {
        return new DateTimeType(this.instant);
    }

    public String toString() {
        return this.toFullString();
    }

    @Override
    public String toFullString() {
        return this.toFullString(ZoneId.systemDefault());
    }

    public String toFullString(ZoneId zoneId) {
        String formatted = this.instant.atZone(zoneId).format(FORMATTER_TZ_RFC);
        if (formatted.contains(".")) {
            String sign = "";
            if (formatted.contains("+")) {
                sign = "+";
            } else if (formatted.contains("-")) {
                sign = "-";
            }
            if (!sign.isEmpty()) {
                return formatted.replace("000" + sign, sign).replace("000" + sign, sign);
            }
        }
        return formatted;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.instant.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTimeType other = (DateTimeType)obj;
        return this.instant.compareTo(other.instant) == 0;
    }

    @Override
    public int compareTo(DateTimeType o) {
        return this.instant.compareTo(o.getInstant());
    }

    private Instant parse(String value) throws DateTimeParseException {
        ZonedDateTime date;
        try {
            date = ZonedDateTime.parse(value, PARSER_TZ_RFC);
        }
        catch (DateTimeParseException tzMsRfcException) {
            try {
                date = ZonedDateTime.parse(value, PARSER_TZ_ISO);
            }
            catch (DateTimeParseException tzMsIsoException) {
                try {
                    date = ZonedDateTime.parse(value, PARSER_TZ);
                }
                catch (DateTimeParseException tzException) {
                    try {
                        date = ZonedDateTime.parse(value);
                    }
                    catch (DateTimeParseException e) {
                        LocalDateTime localDateTime = LocalDateTime.parse(value, PARSER);
                        date = ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
                    }
                }
            }
        }
        return date.toInstant();
    }
}

