/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

public class MultimapBasedScope
extends AbstractScope {
    private Multimap<QualifiedName, IEObjectDescription> elements;

    public static IScope createScope(IScope parent, Iterable<IEObjectDescription> descriptions, boolean ignoreCase) {
        LinkedHashMultimap map = null;
        for (IEObjectDescription description : descriptions) {
            if (map == null) {
                map = LinkedHashMultimap.create((int)5, (int)2);
            }
            if (ignoreCase) {
                map.put((Object)description.getName().toLowerCase(), (Object)description);
                continue;
            }
            map.put((Object)description.getName(), (Object)description);
        }
        if (map == null || map.isEmpty()) {
            return parent;
        }
        return new MultimapBasedScope(parent, (Multimap<QualifiedName, IEObjectDescription>)map, ignoreCase);
    }

    protected MultimapBasedScope(IScope parent, Multimap<QualifiedName, IEObjectDescription> elements, boolean ignoreCase) {
        super(parent, ignoreCase);
        this.elements = elements;
    }

    @Override
    protected Iterable<IEObjectDescription> getAllLocalElements() {
        return this.elements.values();
    }

    @Override
    protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        QualifiedName query = name;
        if (this.isIgnoreCase()) {
            query = name.toLowerCase();
        }
        if (this.elements.containsKey((Object)query)) {
            Collection result = this.elements.get((Object)query);
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean isShadowed(IEObjectDescription fromParent) {
        QualifiedName name = fromParent.getName();
        if (this.isIgnoreCase()) {
            name = name.toLowerCase();
        }
        boolean result = this.elements.containsKey((Object)name);
        return result;
    }
}

