/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.views.synchro;

import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScrollPaneSynchronizer {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected JScrollPane scrollPane1;
    protected JScrollPane scrollPane2;
    protected int orientation;
    protected ChangeListener listener = null;
    protected int defaultScrollBarPolicy1;
    protected int defaultScrollBarPolicy2;
    protected boolean bottomBarActivated = true;
    protected boolean bottomBarEnabled = false;

    public ScrollPaneSynchronizer(JScrollPane jScrollPane, JScrollPane jScrollPane2, int n) {
        this.scrollPane1 = jScrollPane;
        this.scrollPane2 = jScrollPane2;
        this.orientation = n;
    }

    public boolean isBottomBarActivated() {
        return this.bottomBarActivated;
    }

    public void setBottomBarActivated(boolean bl) {
        this.bottomBarActivated = bl;
    }

    public boolean isBottomBarEnabled() {
        return this.bottomBarEnabled;
    }

    public void setBottomBarEnabled(boolean bl) {
        this.bottomBarEnabled = bl;
    }

    public void activateSynchro() {
        if (this.listener == null) {
            if (this.orientation == 0) {
                this.defaultScrollBarPolicy1 = this.scrollPane1.getVerticalScrollBarPolicy();
                this.defaultScrollBarPolicy2 = this.scrollPane2.getVerticalScrollBarPolicy();
                this.scrollPane1.setHorizontalScrollBarPolicy(32);
                this.scrollPane2.setHorizontalScrollBarPolicy(32);
                this.scrollPane1.setVerticalScrollBarPolicy(21);
                this.scrollPane2.setVerticalScrollBarPolicy(22);
                this.scrollPane1.getViewport().addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        JViewport jViewport = ScrollPaneSynchronizer.this.scrollPane1.getViewport();
                        JViewport jViewport2 = ScrollPaneSynchronizer.this.scrollPane2.getViewport();
                        Point point = jViewport.getViewPosition();
                        Point point2 = jViewport2.getViewPosition();
                        point2.setLocation((int)point2.getX(), (int)point.getY());
                        jViewport2.setViewPosition(point2);
                        jViewport2.revalidate();
                    }
                });
                this.scrollPane2.getViewport().addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        JViewport jViewport = ScrollPaneSynchronizer.this.scrollPane1.getViewport();
                        JViewport jViewport2 = ScrollPaneSynchronizer.this.scrollPane2.getViewport();
                        Point point = jViewport.getViewPosition();
                        Point point2 = jViewport2.getViewPosition();
                        point.setLocation((int)point.getX(), (int)point2.getY());
                        jViewport.setViewPosition(point);
                        jViewport.revalidate();
                    }
                });
            } else if (this.orientation == 1) {
                this.defaultScrollBarPolicy1 = this.scrollPane1.getHorizontalScrollBarPolicy();
                this.defaultScrollBarPolicy2 = this.scrollPane2.getHorizontalScrollBarPolicy();
                this.scrollPane1.setHorizontalScrollBarPolicy(32);
                this.scrollPane2.setHorizontalScrollBarPolicy(this.bottomBarActivated ? 32 : 31);
                this.scrollPane2.getHorizontalScrollBar().setEnabled(this.bottomBarEnabled);
                this.listener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        JViewport jViewport = ScrollPaneSynchronizer.this.scrollPane1.getViewport();
                        JViewport jViewport2 = ScrollPaneSynchronizer.this.scrollPane2.getViewport();
                        Point point = jViewport.getViewPosition();
                        Point point2 = jViewport2.getViewPosition();
                        point2.setLocation((int)point.getX(), (int)point2.getY());
                        jViewport2.setViewPosition(point2);
                        Dimension dimension = jViewport.getViewSize();
                        Dimension dimension2 = jViewport2.getViewSize();
                        dimension2.setSize((int)dimension.getWidth(), (int)dimension2.getHeight());
                        jViewport2.setViewSize(dimension2);
                        ((JComponent)jViewport2.getView()).setPreferredSize(dimension2);
                        jViewport2.revalidate();
                    }
                };
                this.scrollPane1.getViewport().addChangeListener(this.listener);
            }
        }
    }

    public void deactivateSynchro() {
        if (this.listener != null) {
            this.scrollPane2.getViewport().removeChangeListener(this.listener);
            if (this.orientation == 0) {
                this.scrollPane1.setVerticalScrollBarPolicy(this.defaultScrollBarPolicy1);
                this.scrollPane2.setVerticalScrollBarPolicy(this.defaultScrollBarPolicy2);
            } else if (this.orientation == 1) {
                this.scrollPane1.setHorizontalScrollBarPolicy(this.defaultScrollBarPolicy1);
                this.scrollPane2.setHorizontalScrollBarPolicy(this.defaultScrollBarPolicy2);
                this.scrollPane2.getHorizontalScrollBar().setEnabled(true);
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public JScrollPane getScrollPane1() {
        return this.scrollPane1;
    }

    public void setScrollPane1(JScrollPane jScrollPane) {
        this.scrollPane1 = jScrollPane;
    }

    public JScrollPane getScrollPane2() {
        return this.scrollPane2;
    }

    public void setScrollPane2(JScrollPane jScrollPane) {
        this.scrollPane2 = jScrollPane;
    }
}

