/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.http;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import java.util.Objects;
import org.glassfish.jersey.http.VersionOptional;

public final class JerseyNewCookie
extends NewCookie
implements VersionOptional {
    private final Integer version;

    private JerseyNewCookie(Builder builder) {
        super((NewCookie.AbstractNewCookieBuilder)builder);
        this.version = builder.version;
    }

    @Override
    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != NewCookie.class && obj.getClass() != JerseyNewCookie.class) {
            return false;
        }
        NewCookie other = (NewCookie)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getValue(), other.getValue())) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (!Objects.equals(this.getPath(), other.getPath())) {
            return false;
        }
        if (!Objects.equals(this.getDomain(), other.getDomain())) {
            return false;
        }
        if (!Objects.equals(this.getComment(), other.getComment())) {
            return false;
        }
        if (this.getMaxAge() != other.getMaxAge()) {
            return false;
        }
        if (!Objects.equals(this.getExpiry(), other.getExpiry())) {
            return false;
        }
        if (this.isSecure() != other.isSecure()) {
            return false;
        }
        if (this.isHttpOnly() != other.isHttpOnly()) {
            return false;
        }
        return this.getSameSite() == other.getSameSite();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.version);
    }

    public static final class Builder
    extends NewCookie.AbstractNewCookieBuilder<Builder> {
        private Integer version;

        public Builder(String name) {
            super(name);
        }

        public Builder(Cookie cookie) {
            super(cookie);
            if (cookie instanceof VersionOptional) {
                this.version = ((VersionOptional)cookie).hasVersion() ? Integer.valueOf(cookie.getVersion()) : null;
            }
        }

        public Builder version(int version) {
            super.version(version);
            this.version = version;
            return this;
        }

        public Builder version(Integer version) {
            super.version(version == null ? 1 : version);
            this.version = version;
            return this;
        }

        public NewCookie build() {
            return new JerseyNewCookie(this);
        }
    }
}

