KDBindings
==========
Reactive programming & data binding in C++

From plain C++ you get:

 * Signals + Slots.
 * Properties templated on the contained type.
 * Property bindings allowing reactive code to be written without having to do all the low-level, error prone plumbing by hand.
 * Lazy evaluation of property bindings.
 * No more broken bindings.
 * Totally stand-alone "header-only" library. No heavy Qt dependency.
 * Can still be used with Qt if you so wish.

Using KDBindings
================
KDBindings requires a C++ compiler with C++17 support.

Find more information at:

 * [detailed browsable API reference](https://kdab.github.io/KDBindings/md__home_runner_work_KDBindings_KDBindings_docs_api_docs_getting_started_index.html)
 * [our assorted example programs](https://github.com/KDAB/KDBindings/blob/main/examples)

Compatibility with Qt
=====================
Because Qt defines `emit` as a keyword, Qt is by default incompatible with KDBindings, which uses `emit` as a function name.

This can only be fixed by defining `QT_NO_EMIT` or `QT_NO_KEYWORDS` and simply omitting `emit` in your Qt code.

To make this easy, KDBindings includes a CMake option: `KDBindings_QT_NO_EMIT`, which defines this for all dependents of KDBindings.

See also: [#79](https://github.com/KDAB/KDBindings/issues/79)

Contact
=======
* Visit us on GitHub: https://github.com/KDAB/KDBindings
* Email info@kdab.com for questions about copyright, licensing or commercial support.

Stay up-to-date with KDAB product announcements:

* [KDAB Newsletter](https://news.kdab.com)
* [KDAB Blogs](https://www.kdab.com/category/blogs)
* [KDAB on Twitter](https://twitter.com/KDABQt)

Licensing
=========
KDBindings is © Klarälvdalens Datakonsult AB and available under the terms of
the [MIT](https://github.com/KDAB/KDBindings/blob/main/LICENSES/MIT.txt) license.

Contact KDAB at <info@kdab.com> if you need different licensing options.

KDBindings includes these source files, also available under the terms of the MIT license:

* [doctest.h](https://github.com/onqtam/doctest) - the lightest feature-rich C++ single-header testing framework for unit tests and TDD (C) 2016-2021 Viktor Kirilov <vik.kirilov@gmail.com>
* [genindex_array.h](https://gist.github.com/jaburns/ca72487198832f6203e831133ffdfff4) (C) 2021 Jeremy Burns (adapted by KDAB for KDBindings)

Get Involved
============
Please submit your contributions or issue reports from our GitHub space at
https://github.com/KDAB/KDBindings

Contact info@kdab.com for more information.

About KDAB
==========
KDBindings is supported and maintained by Klarälvdalens Datakonsult AB (KDAB).

The KDAB Group is the global No.1 software consultancy for Qt, C++ and
OpenGL applications across desktop, embedded and mobile platforms.

The KDAB Group provides consulting and mentoring for developing Qt applications
from scratch and in porting from all popular and legacy frameworks to Qt.
We continue to help develop parts of Qt and are one of the major contributors
to the Qt Project. We can give advanced or standard trainings anywhere
around the globe on Qt as well as C++, OpenGL, 3D and more.

Please visit https://www.kdab.com to meet the people who write code like this.
