/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * any(bvec3(false, false, false)) => false
 * any(bvec3(false, false, true)) => true
 * any(bvec3(false, true, false)) => true
 * any(bvec3(false, true, true)) => true
 * any(bvec3(true, false, false)) => true
 * any(bvec3(true, false, true)) => true
 * any(bvec3(true, true, false)) => true
 * any(bvec3(true, true, true)) => true
 */
#version 120

void main()
{
  float[any(bvec3(false, false, false)) == false ? 1 : -1] array0;
  float[any(bvec3(false, false, true)) == true ? 1 : -1] array1;
  float[any(bvec3(false, true, false)) == true ? 1 : -1] array2;
  float[any(bvec3(false, true, true)) == true ? 1 : -1] array3;
  float[any(bvec3(true, false, false)) == true ? 1 : -1] array4;
  float[any(bvec3(true, false, true)) == true ? 1 : -1] array5;
  float[any(bvec3(true, true, false)) == true ? 1 : -1] array6;
  float[any(bvec3(true, true, true)) == true ? 1 : -1] array7;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
