/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.mapcss.CSSColors;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GenericParser;
import org.openstreetmap.josm.tools.Logging;

public final class Cascade {
    private final Map<String, Object> prop;
    private boolean defaultSelectedHandling = true;
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("#([0-9a-fA-F]{3}|[0-9a-fA-F]{6}|[0-9a-fA-F]{8})");
    private static final GenericParser<Object> GENERIC_PARSER = new GenericParser<Object>().registerParser(Float.TYPE, Cascade::toFloat).registerParser(Float.class, Cascade::toFloat).registerParser(Double.TYPE, Cascade::toDouble).registerParser(Double.class, Cascade::toDouble).registerParser(Boolean.TYPE, Cascade::toBool).registerParser(Boolean.class, Cascade::toBool).registerParser(float[].class, Cascade::toFloatArray).registerParser(Color.class, Cascade::toColor).registerParser(String.class, Cascade::toString);

    public Cascade() {
        this.prop = new HashMap<String, Object>();
    }

    public Cascade(Cascade other) {
        this.prop = new HashMap<String, Object>(other.prop);
    }

    public <T> T get(String key, T def, Class<T> klass) {
        return this.get(key, def, klass, false);
    }

    public <T> T get(String key, T def, Class<T> klass, boolean suppressWarnings) {
        if (def != null && !klass.isInstance(def)) {
            throw new IllegalArgumentException(String.valueOf(def) + " is not an instance of " + String.valueOf(klass));
        }
        Object o = this.prop.get(key);
        if (o == null) {
            return def;
        }
        T res = Cascade.convertTo(o, klass);
        if (res == null) {
            if (!suppressWarnings) {
                Logging.warn(String.format("Unable to convert property %s to type %s: found %s of type %s!", key, klass, o, o.getClass()));
            }
            return def;
        }
        return res;
    }

    public Object get(String key) {
        return this.prop.get(key);
    }

    public void put(String key, Object val) {
        this.prop.put(key, val);
    }

    public void putOrClear(String key, Object val) {
        if (val != null) {
            this.prop.put(key, val);
        } else {
            this.prop.remove(key);
        }
    }

    public void remove(String key) {
        this.prop.remove(key);
    }

    public static <T> T convertTo(Object o, Class<T> klass) {
        if (o == null) {
            return null;
        }
        if (klass.isInstance(o)) {
            return klass.cast(o);
        }
        return GENERIC_PARSER.supports(klass) ? (T)GENERIC_PARSER.parse(klass, o) : null;
    }

    private static String toString(Object o) {
        if (o instanceof Keyword) {
            return ((Keyword)o).val;
        }
        if (o instanceof Color) {
            return ColorHelper.color2html((Color)o);
        }
        return o.toString();
    }

    private static Float toFloat(Object o) {
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof String && !((String)o).isEmpty()) {
            try {
                return Float.valueOf((String)o);
            }
            catch (NumberFormatException e) {
                Logging.debug("''{0}'' cannot be converted to float", o);
            }
        }
        return null;
    }

    private static Double toDouble(Object o) {
        Float number = Cascade.toFloat(o);
        return number != null ? Double.valueOf(number.floatValue()) : null;
    }

    private static Boolean toBool(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        String s = null;
        if (o instanceof Keyword) {
            s = ((Keyword)o).val;
        } else if (o instanceof String) {
            s = (String)o;
        }
        if (s != null) {
            return !s.isEmpty() && !"false".equals(s) && !"no".equals(s) && !"0".equals(s) && !"0.0".equals(s);
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue() != 0.0f;
        }
        if (o instanceof List) {
            return !((List)o).isEmpty();
        }
        if (o instanceof float[]) {
            return ((float[])o).length != 0;
        }
        return null;
    }

    private static float[] toFloatArray(Object o) {
        if (o instanceof float[]) {
            return (float[])o;
        }
        if (o instanceof List) {
            List l = (List)o;
            float[] a = new float[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                Float f = Cascade.toFloat(l.get(i));
                if (f == null) {
                    return null;
                }
                a[i] = f.floatValue();
            }
            return a;
        }
        Float f = Cascade.toFloat(o);
        if (f != null) {
            return new float[]{f.floatValue()};
        }
        return null;
    }

    private static Color toColor(Object o) {
        if (o instanceof Color) {
            return (Color)o;
        }
        if (o instanceof Keyword) {
            return CSSColors.get(((Keyword)o).val);
        }
        if (o instanceof String) {
            Color c = CSSColors.get((String)o);
            if (c != null) {
                return c;
            }
            if (HEX_COLOR_PATTERN.matcher((String)o).matches()) {
                return ColorHelper.html2color((String)o);
            }
        }
        return null;
    }

    public String toString() {
        TreeSet<String> props = new TreeSet<String>();
        for (Map.Entry<String, Object> entry : this.prop.entrySet()) {
            StringBuilder sb = new StringBuilder(entry.getKey()).append(':');
            Object val = entry.getValue();
            if (val instanceof float[]) {
                sb.append(Arrays.toString((float[])val));
            } else if (val instanceof Color) {
                sb.append(ColorHelper.color2html((Color)val));
            } else if (val != null) {
                sb.append(val);
            }
            sb.append("; ");
            props.add(sb.toString());
        }
        return props.stream().collect(Collectors.joining("", "Cascade{ ", "}"));
    }

    public boolean containsKey(String key) {
        return this.prop.containsKey(key);
    }

    public boolean isDefaultSelectedHandling() {
        return this.defaultSelectedHandling;
    }

    public void setDefaultSelectedHandling(boolean defaultSelectedHandling) {
        this.defaultSelectedHandling = defaultSelectedHandling;
    }
}

