/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.pac.datetime;

import java.util.Calendar;

class TimeRange {
    private static final int UNDEFINED = -1;
    private final int hourMin;
    private final int hourMax;
    private final int minuteMin;
    private final int minuteMax;
    private final int secondMin;
    private final int secondMax;

    public TimeRange(int n, int n2, int n3, int n4, int n5, int n6) {
        this.hourMin = n;
        this.hourMax = n2 == -1 && n != -1 ? n : n2;
        this.minuteMin = n3;
        this.minuteMax = n4 == -1 && n3 != -1 ? n3 : n4;
        this.secondMin = n5;
        this.secondMax = n6 == -1 && n5 != -1 ? n5 : n6;
    }

    public boolean isInRange(Calendar calendar) {
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        if (this.hourDefined() && (this.hourMin <= this.hourMax ? n < this.hourMin || n > this.hourMax : n < this.hourMin && n > this.hourMax)) {
            return false;
        }
        if (this.minuteDefined()) {
            if (this.hourDefined()) {
                if (n == this.hourMin && n2 < this.minuteMin) {
                    return false;
                }
                if (n == this.hourMax && n2 > this.minuteMax) {
                    return false;
                }
            } else if (this.minuteMin <= this.minuteMax ? n2 < this.minuteMin || n2 > this.minuteMax : n2 < this.minuteMin && n2 > this.minuteMax) {
                return false;
            }
        }
        if (this.secondDefined()) {
            if (this.minuteDefined()) {
                if (this.hourDefined()) {
                    if (n == this.hourMin && n2 == this.minuteMin && n3 < this.secondMin) {
                        return false;
                    }
                    if (n == this.hourMax && n2 == this.minuteMax && n3 > this.secondMax) {
                        return false;
                    }
                } else {
                    if (n2 == this.minuteMin && n3 < this.secondMin) {
                        return false;
                    }
                    if (n2 == this.minuteMax && n3 > this.secondMax) {
                        return false;
                    }
                }
            } else if (this.secondMin <= this.secondMax ? n3 < this.secondMin || n3 > this.secondMax : n3 < this.secondMin && n3 > this.secondMax) {
                return false;
            }
        }
        return true;
    }

    private boolean hourDefined() {
        return this.hourMin != -1 || this.hourMax != -1;
    }

    private boolean minuteDefined() {
        return this.minuteMin != -1 || this.minuteMax != -1;
    }

    private boolean secondDefined() {
        return this.secondMin != -1 || this.secondMax != -1;
    }

    public static TimeRangeBuilder getBuilder() {
        return new TimeRangeBuilder();
    }

    public static class TimeRangeBuilder {
        private int hourMin = -1;
        private int hourMax = -1;
        private int minuteMin = -1;
        private int minuteMax = -1;
        private int secondMin = -1;
        private int secondMax = -1;

        private TimeRangeBuilder() {
        }

        public TimeRangeBuilder setHourMinMax(int n, int n2) {
            this.hourMin = n;
            this.hourMax = n2;
            return this;
        }

        public TimeRangeBuilder setMinuteMinMax(int n, int n2) {
            this.minuteMin = n;
            this.minuteMax = n2;
            return this;
        }

        public TimeRangeBuilder setSecondMinMax(int n, int n2) {
            this.secondMin = n;
            this.secondMax = n2;
            return this;
        }

        public TimeRange createTimeRange() {
            return new TimeRange(this.hourMin, this.hourMax, this.minuteMin, this.minuteMax, this.secondMin, this.secondMax);
        }
    }
}

