<?php
/**
 * BucketsService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * BucketsService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class BucketsService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation deleteBucketsID
     *
     * Delete a bucket
     *
     * @param  string $bucket_id Bucket ID. The ID of the bucket to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteBucketsID($bucket_id, $zap_trace_span = null)
    {
        $this->deleteBucketsIDWithHttpInfo($bucket_id, $zap_trace_span);
    }

    /**
     * Operation deleteBucketsIDWithHttpInfo
     *
     * Delete a bucket
     *
     * @param  string $bucket_id Bucket ID. The ID of the bucket to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBucketsIDWithHttpInfo($bucket_id, $zap_trace_span = null)
    {
        $request = $this->deleteBucketsIDRequest($bucket_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteBucketsID'
     *
     * @param  string $bucket_id Bucket ID. The ID of the bucket to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteBucketsIDRequest($bucket_id, $zap_trace_span = null)
    {
        // verify the required parameter 'bucket_id' is set
        if ($bucket_id === null || (is_array($bucket_id) && count($bucket_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket_id when calling deleteBucketsID'
            );
        }

        $resourcePath = '/api/v2/buckets/{bucketID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($bucket_id !== null) {
            $resourcePath = str_replace(
                '{' . 'bucketID' . '}',
                ObjectSerializer::toPathValue($bucket_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteBucketsIDLabelsID
     *
     * Delete a label from a bucket
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteBucketsIDLabelsID($bucket_id, $label_id, $zap_trace_span = null)
    {
        $this->deleteBucketsIDLabelsIDWithHttpInfo($bucket_id, $label_id, $zap_trace_span);
    }

    /**
     * Operation deleteBucketsIDLabelsIDWithHttpInfo
     *
     * Delete a label from a bucket
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBucketsIDLabelsIDWithHttpInfo($bucket_id, $label_id, $zap_trace_span = null)
    {
        $request = $this->deleteBucketsIDLabelsIDRequest($bucket_id, $label_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteBucketsIDLabelsID'
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteBucketsIDLabelsIDRequest($bucket_id, $label_id, $zap_trace_span = null)
    {
        // verify the required parameter 'bucket_id' is set
        if ($bucket_id === null || (is_array($bucket_id) && count($bucket_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket_id when calling deleteBucketsIDLabelsID'
            );
        }
        // verify the required parameter 'label_id' is set
        if ($label_id === null || (is_array($label_id) && count($label_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_id when calling deleteBucketsIDLabelsID'
            );
        }

        $resourcePath = '/api/v2/buckets/{bucketID}/labels/{labelID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($bucket_id !== null) {
            $resourcePath = str_replace(
                '{' . 'bucketID' . '}',
                ObjectSerializer::toPathValue($bucket_id),
                $resourcePath
            );
        }
        // path params
        if ($label_id !== null) {
            $resourcePath = str_replace(
                '{' . 'labelID' . '}',
                ObjectSerializer::toPathValue($label_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteBucketsIDMembersID
     *
     * Remove a member from a bucket
     *
     * @param  string $user_id The ID of the user to remove. (required)
     * @param  string $bucket_id The ID of the bucket to remove a user from. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteBucketsIDMembersID($user_id, $bucket_id, $zap_trace_span = null)
    {
        $this->deleteBucketsIDMembersIDWithHttpInfo($user_id, $bucket_id, $zap_trace_span);
    }

    /**
     * Operation deleteBucketsIDMembersIDWithHttpInfo
     *
     * Remove a member from a bucket
     *
     * @param  string $user_id The ID of the user to remove. (required)
     * @param  string $bucket_id The ID of the bucket to remove a user from. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBucketsIDMembersIDWithHttpInfo($user_id, $bucket_id, $zap_trace_span = null)
    {
        $request = $this->deleteBucketsIDMembersIDRequest($user_id, $bucket_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteBucketsIDMembersID'
     *
     * @param  string $user_id The ID of the user to remove. (required)
     * @param  string $bucket_id The ID of the bucket to remove a user from. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteBucketsIDMembersIDRequest($user_id, $bucket_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteBucketsIDMembersID'
            );
        }
        // verify the required parameter 'bucket_id' is set
        if ($bucket_id === null || (is_array($bucket_id) && count($bucket_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket_id when calling deleteBucketsIDMembersID'
            );
        }

        $resourcePath = '/api/v2/buckets/{bucketID}/members/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }
        // path params
        if ($bucket_id !== null) {
            $resourcePath = str_replace(
                '{' . 'bucketID' . '}',
                ObjectSerializer::toPathValue($bucket_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteBucketsIDOwnersID
     *
     * Remove an owner from a bucket
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $bucket_id The bucket ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteBucketsIDOwnersID($user_id, $bucket_id, $zap_trace_span = null)
    {
        $this->deleteBucketsIDOwnersIDWithHttpInfo($user_id, $bucket_id, $zap_trace_span);
    }

    /**
     * Operation deleteBucketsIDOwnersIDWithHttpInfo
     *
     * Remove an owner from a bucket
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $bucket_id The bucket ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBucketsIDOwnersIDWithHttpInfo($user_id, $bucket_id, $zap_trace_span = null)
    {
        $request = $this->deleteBucketsIDOwnersIDRequest($user_id, $bucket_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteBucketsIDOwnersID'
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $bucket_id The bucket ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteBucketsIDOwnersIDRequest($user_id, $bucket_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteBucketsIDOwnersID'
            );
        }
        // verify the required parameter 'bucket_id' is set
        if ($bucket_id === null || (is_array($bucket_id) && count($bucket_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket_id when calling deleteBucketsIDOwnersID'
            );
        }

        $resourcePath = '/api/v2/buckets/{bucketID}/owners/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }
        // path params
        if ($bucket_id !== null) {
            $resourcePath = str_replace(
                '{' . 'bucketID' . '}',
                ObjectSerializer::toPathValue($bucket_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getBuckets
     *
     * List buckets
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  string $after Resource ID to seek from. Results are not inclusive of this ID. Use &#x60;after&#x60; instead of &#x60;offset&#x60;. (optional)
     * @param  string $org Organization name. The name of the organization.  #### InfluxDB Cloud   - Doesn&#39;t use &#x60;org&#x60; or &#x60;orgID&#x60;.  - Creates a bucket in the organization associated with the authorization (API token).   #### InfluxDB OSS   - Accepts either &#x60;org&#x60; or &#x60;orgID&#x60;.  - InfluxDB creates the bucket within this organization. (optional)
     * @param  string $org_id Organization ID. The organization ID.  #### InfluxDB Cloud   - Doesn&#39;t use &#x60;org&#x60; or &#x60;orgID&#x60;.  - Creates a bucket in the organization associated with the authorization (API token).   #### InfluxDB OSS   - Accepts either &#x60;org&#x60; or &#x60;orgID&#x60;.  - InfluxDB creates the bucket within this organization. (optional)
     * @param  string $name Bucket name. Only returns buckets with this specific name. (optional)
     * @param  string $id Bucket ID. Only returns the bucket with this ID. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Buckets|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getBuckets($zap_trace_span = null, $offset = null, $limit = 20, $after = null, $org = null, $org_id = null, $name = null, $id = null)
    {
        list($response) = $this->getBucketsWithHttpInfo($zap_trace_span, $offset, $limit, $after, $org, $org_id, $name, $id);
        return $response;
    }

    /**
     * Operation getBucketsWithHttpInfo
     *
     * List buckets
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  string $after Resource ID to seek from. Results are not inclusive of this ID. Use &#x60;after&#x60; instead of &#x60;offset&#x60;. (optional)
     * @param  string $org Organization name. The name of the organization.  #### InfluxDB Cloud   - Doesn&#39;t use &#x60;org&#x60; or &#x60;orgID&#x60;.  - Creates a bucket in the organization associated with the authorization (API token).   #### InfluxDB OSS   - Accepts either &#x60;org&#x60; or &#x60;orgID&#x60;.  - InfluxDB creates the bucket within this organization. (optional)
     * @param  string $org_id Organization ID. The organization ID.  #### InfluxDB Cloud   - Doesn&#39;t use &#x60;org&#x60; or &#x60;orgID&#x60;.  - Creates a bucket in the organization associated with the authorization (API token).   #### InfluxDB OSS   - Accepts either &#x60;org&#x60; or &#x60;orgID&#x60;.  - InfluxDB creates the bucket within this organization. (optional)
     * @param  string $name Bucket name. Only returns buckets with this specific name. (optional)
     * @param  string $id Bucket ID. Only returns the bucket with this ID. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Buckets|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBucketsWithHttpInfo($zap_trace_span = null, $offset = null, $limit = 20, $after = null, $org = null, $org_id = null, $name = null, $id = null)
    {
        $request = $this->getBucketsRequest($zap_trace_span, $offset, $limit, $after, $org, $org_id, $name, $id);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Buckets';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getBuckets'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  string $after Resource ID to seek from. Results are not inclusive of this ID. Use &#x60;after&#x60; instead of &#x60;offset&#x60;. (optional)
     * @param  string $org Organization name. The name of the organization.  #### InfluxDB Cloud   - Doesn&#39;t use &#x60;org&#x60; or &#x60;orgID&#x60;.  - Creates a bucket in the organization associated with the authorization (API token).   #### InfluxDB OSS   - Accepts either &#x60;org&#x60; or &#x60;orgID&#x60;.  - InfluxDB creates the bucket within this organization. (optional)
     * @param  string $org_id Organization ID. The organization ID.  #### InfluxDB Cloud   - Doesn&#39;t use &#x60;org&#x60; or &#x60;orgID&#x60;.  - Creates a bucket in the organization associated with the authorization (API token).   #### InfluxDB OSS   - Accepts either &#x60;org&#x60; or &#x60;orgID&#x60;.  - InfluxDB creates the bucket within this organization. (optional)
     * @param  string $name Bucket name. Only returns buckets with this specific name. (optional)
     * @param  string $id Bucket ID. Only returns the bucket with this ID. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getBucketsRequest($zap_trace_span = null, $offset = null, $limit = 20, $after = null, $org = null, $org_id = null, $name = null, $id = null)
    {
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling BucketsService.getBuckets, must be bigger than or equal to 0.');
        }

        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling BucketsService.getBuckets, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling BucketsService.getBuckets, must be bigger than or equal to 1.');
        }


        $resourcePath = '/api/v2/buckets';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($after !== null) {
            $queryParams['after'] = ObjectSerializer::toQueryValue($after);
        }
        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = ObjectSerializer::toQueryValue($name);
        }
        // query params
        if ($id !== null) {
            $queryParams['id'] = ObjectSerializer::toQueryValue($id);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getBucketsID
     *
     * Retrieve a bucket
     *
     * @param  string $bucket_id The ID of the bucket to retrieve. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Bucket|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getBucketsID($bucket_id, $zap_trace_span = null)
    {
        list($response) = $this->getBucketsIDWithHttpInfo($bucket_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getBucketsIDWithHttpInfo
     *
     * Retrieve a bucket
     *
     * @param  string $bucket_id The ID of the bucket to retrieve. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Bucket|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBucketsIDWithHttpInfo($bucket_id, $zap_trace_span = null)
    {
        $request = $this->getBucketsIDRequest($bucket_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Bucket';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getBucketsID'
     *
     * @param  string $bucket_id The ID of the bucket to retrieve. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getBucketsIDRequest($bucket_id, $zap_trace_span = null)
    {
        // verify the required parameter 'bucket_id' is set
        if ($bucket_id === null || (is_array($bucket_id) && count($bucket_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket_id when calling getBucketsID'
            );
        }

        $resourcePath = '/api/v2/buckets/{bucketID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($bucket_id !== null) {
            $resourcePath = str_replace(
                '{' . 'bucketID' . '}',
                ObjectSerializer::toPathValue($bucket_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getBucketsIDLabels
     *
     * List all labels for a bucket
     *
     * @param  string $bucket_id The ID of the bucket to retrieve labels for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getBucketsIDLabels($bucket_id, $zap_trace_span = null)
    {
        list($response) = $this->getBucketsIDLabelsWithHttpInfo($bucket_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getBucketsIDLabelsWithHttpInfo
     *
     * List all labels for a bucket
     *
     * @param  string $bucket_id The ID of the bucket to retrieve labels for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBucketsIDLabelsWithHttpInfo($bucket_id, $zap_trace_span = null)
    {
        $request = $this->getBucketsIDLabelsRequest($bucket_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelsResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getBucketsIDLabels'
     *
     * @param  string $bucket_id The ID of the bucket to retrieve labels for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getBucketsIDLabelsRequest($bucket_id, $zap_trace_span = null)
    {
        // verify the required parameter 'bucket_id' is set
        if ($bucket_id === null || (is_array($bucket_id) && count($bucket_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket_id when calling getBucketsIDLabels'
            );
        }

        $resourcePath = '/api/v2/buckets/{bucketID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($bucket_id !== null) {
            $resourcePath = str_replace(
                '{' . 'bucketID' . '}',
                ObjectSerializer::toPathValue($bucket_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getBucketsIDMembers
     *
     * List all users with member privileges for a bucket
     *
     * @param  string $bucket_id The ID of the bucket to retrieve users for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceMembers|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getBucketsIDMembers($bucket_id, $zap_trace_span = null)
    {
        list($response) = $this->getBucketsIDMembersWithHttpInfo($bucket_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getBucketsIDMembersWithHttpInfo
     *
     * List all users with member privileges for a bucket
     *
     * @param  string $bucket_id The ID of the bucket to retrieve users for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceMembers|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBucketsIDMembersWithHttpInfo($bucket_id, $zap_trace_span = null)
    {
        $request = $this->getBucketsIDMembersRequest($bucket_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceMembers';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getBucketsIDMembers'
     *
     * @param  string $bucket_id The ID of the bucket to retrieve users for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getBucketsIDMembersRequest($bucket_id, $zap_trace_span = null)
    {
        // verify the required parameter 'bucket_id' is set
        if ($bucket_id === null || (is_array($bucket_id) && count($bucket_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket_id when calling getBucketsIDMembers'
            );
        }

        $resourcePath = '/api/v2/buckets/{bucketID}/members';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($bucket_id !== null) {
            $resourcePath = str_replace(
                '{' . 'bucketID' . '}',
                ObjectSerializer::toPathValue($bucket_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getBucketsIDOwners
     *
     * List all owners of a bucket
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceOwners|\InfluxDB2\Model\Error
     */
    public function getBucketsIDOwners($bucket_id, $zap_trace_span = null)
    {
        list($response) = $this->getBucketsIDOwnersWithHttpInfo($bucket_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getBucketsIDOwnersWithHttpInfo
     *
     * List all owners of a bucket
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceOwners|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBucketsIDOwnersWithHttpInfo($bucket_id, $zap_trace_span = null)
    {
        $request = $this->getBucketsIDOwnersRequest($bucket_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceOwners';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getBucketsIDOwners'
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getBucketsIDOwnersRequest($bucket_id, $zap_trace_span = null)
    {
        // verify the required parameter 'bucket_id' is set
        if ($bucket_id === null || (is_array($bucket_id) && count($bucket_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket_id when calling getBucketsIDOwners'
            );
        }

        $resourcePath = '/api/v2/buckets/{bucketID}/owners';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($bucket_id !== null) {
            $resourcePath = str_replace(
                '{' . 'bucketID' . '}',
                ObjectSerializer::toPathValue($bucket_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getSourcesIDBuckets
     *
     * Get buckets in a source
     *
     * @param  string $source_id The source ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org The name of the organization. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Buckets|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getSourcesIDBuckets($source_id, $zap_trace_span = null, $org = null)
    {
        list($response) = $this->getSourcesIDBucketsWithHttpInfo($source_id, $zap_trace_span, $org);
        return $response;
    }

    /**
     * Operation getSourcesIDBucketsWithHttpInfo
     *
     * Get buckets in a source
     *
     * @param  string $source_id The source ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org The name of the organization. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Buckets|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSourcesIDBucketsWithHttpInfo($source_id, $zap_trace_span = null, $org = null)
    {
        $request = $this->getSourcesIDBucketsRequest($source_id, $zap_trace_span, $org);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Buckets';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getSourcesIDBuckets'
     *
     * @param  string $source_id The source ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org The name of the organization. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getSourcesIDBucketsRequest($source_id, $zap_trace_span = null, $org = null)
    {
        // verify the required parameter 'source_id' is set
        if ($source_id === null || (is_array($source_id) && count($source_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $source_id when calling getSourcesIDBuckets'
            );
        }

        $resourcePath = '/api/v2/sources/{sourceID}/buckets';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($source_id !== null) {
            $resourcePath = str_replace(
                '{' . 'sourceID' . '}',
                ObjectSerializer::toPathValue($source_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchBucketsID
     *
     * Update a bucket
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  \InfluxDB2\Model\PatchBucketRequest $patch_bucket_request The bucket update to apply. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Bucket|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function patchBucketsID($bucket_id, $patch_bucket_request, $zap_trace_span = null)
    {
        list($response) = $this->patchBucketsIDWithHttpInfo($bucket_id, $patch_bucket_request, $zap_trace_span);
        return $response;
    }

    /**
     * Operation patchBucketsIDWithHttpInfo
     *
     * Update a bucket
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  \InfluxDB2\Model\PatchBucketRequest $patch_bucket_request The bucket update to apply. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Bucket|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchBucketsIDWithHttpInfo($bucket_id, $patch_bucket_request, $zap_trace_span = null)
    {
        $request = $this->patchBucketsIDRequest($bucket_id, $patch_bucket_request, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Bucket';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchBucketsID'
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  \InfluxDB2\Model\PatchBucketRequest $patch_bucket_request The bucket update to apply. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchBucketsIDRequest($bucket_id, $patch_bucket_request, $zap_trace_span = null)
    {
        // verify the required parameter 'bucket_id' is set
        if ($bucket_id === null || (is_array($bucket_id) && count($bucket_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket_id when calling patchBucketsID'
            );
        }
        // verify the required parameter 'patch_bucket_request' is set
        if ($patch_bucket_request === null || (is_array($patch_bucket_request) && count($patch_bucket_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $patch_bucket_request when calling patchBucketsID'
            );
        }

        $resourcePath = '/api/v2/buckets/{bucketID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($bucket_id !== null) {
            $resourcePath = str_replace(
                '{' . 'bucketID' . '}',
                ObjectSerializer::toPathValue($bucket_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($patch_bucket_request)) {
            $_tempBody = $patch_bucket_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postBuckets
     *
     * Create a bucket
     *
     * @param  \InfluxDB2\Model\PostBucketRequest $post_bucket_request Bucket to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Bucket|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function postBuckets($post_bucket_request, $zap_trace_span = null)
    {
        list($response) = $this->postBucketsWithHttpInfo($post_bucket_request, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postBucketsWithHttpInfo
     *
     * Create a bucket
     *
     * @param  \InfluxDB2\Model\PostBucketRequest $post_bucket_request Bucket to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Bucket|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postBucketsWithHttpInfo($post_bucket_request, $zap_trace_span = null)
    {
        $request = $this->postBucketsRequest($post_bucket_request, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Bucket';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postBuckets'
     *
     * @param  \InfluxDB2\Model\PostBucketRequest $post_bucket_request Bucket to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postBucketsRequest($post_bucket_request, $zap_trace_span = null)
    {
        // verify the required parameter 'post_bucket_request' is set
        if ($post_bucket_request === null || (is_array($post_bucket_request) && count($post_bucket_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $post_bucket_request when calling postBuckets'
            );
        }

        $resourcePath = '/api/v2/buckets';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;
        if (isset($post_bucket_request)) {
            $_tempBody = $post_bucket_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postBucketsIDLabels
     *
     * Add a label to a bucket
     *
     * @param  string $bucket_id Bucket ID. The ID of the bucket to label. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping An object that contains a _&#x60;labelID&#x60;_ to add to the bucket. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function postBucketsIDLabels($bucket_id, $label_mapping, $zap_trace_span = null)
    {
        list($response) = $this->postBucketsIDLabelsWithHttpInfo($bucket_id, $label_mapping, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postBucketsIDLabelsWithHttpInfo
     *
     * Add a label to a bucket
     *
     * @param  string $bucket_id Bucket ID. The ID of the bucket to label. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping An object that contains a _&#x60;labelID&#x60;_ to add to the bucket. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postBucketsIDLabelsWithHttpInfo($bucket_id, $label_mapping, $zap_trace_span = null)
    {
        $request = $this->postBucketsIDLabelsRequest($bucket_id, $label_mapping, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postBucketsIDLabels'
     *
     * @param  string $bucket_id Bucket ID. The ID of the bucket to label. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping An object that contains a _&#x60;labelID&#x60;_ to add to the bucket. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postBucketsIDLabelsRequest($bucket_id, $label_mapping, $zap_trace_span = null)
    {
        // verify the required parameter 'bucket_id' is set
        if ($bucket_id === null || (is_array($bucket_id) && count($bucket_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket_id when calling postBucketsIDLabels'
            );
        }
        // verify the required parameter 'label_mapping' is set
        if ($label_mapping === null || (is_array($label_mapping) && count($label_mapping) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_mapping when calling postBucketsIDLabels'
            );
        }

        $resourcePath = '/api/v2/buckets/{bucketID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($bucket_id !== null) {
            $resourcePath = str_replace(
                '{' . 'bucketID' . '}',
                ObjectSerializer::toPathValue($bucket_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($label_mapping)) {
            $_tempBody = $label_mapping;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postBucketsIDMembers
     *
     * Add a member to a bucket
     *
     * @param  string $bucket_id The ID of the bucket to retrieve users for. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body A user to add as a member to the bucket. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceMember|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function postBucketsIDMembers($bucket_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        list($response) = $this->postBucketsIDMembersWithHttpInfo($bucket_id, $add_resource_member_request_body, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postBucketsIDMembersWithHttpInfo
     *
     * Add a member to a bucket
     *
     * @param  string $bucket_id The ID of the bucket to retrieve users for. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body A user to add as a member to the bucket. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceMember|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postBucketsIDMembersWithHttpInfo($bucket_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        $request = $this->postBucketsIDMembersRequest($bucket_id, $add_resource_member_request_body, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceMember';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postBucketsIDMembers'
     *
     * @param  string $bucket_id The ID of the bucket to retrieve users for. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body A user to add as a member to the bucket. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postBucketsIDMembersRequest($bucket_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        // verify the required parameter 'bucket_id' is set
        if ($bucket_id === null || (is_array($bucket_id) && count($bucket_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket_id when calling postBucketsIDMembers'
            );
        }
        // verify the required parameter 'add_resource_member_request_body' is set
        if ($add_resource_member_request_body === null || (is_array($add_resource_member_request_body) && count($add_resource_member_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $add_resource_member_request_body when calling postBucketsIDMembers'
            );
        }

        $resourcePath = '/api/v2/buckets/{bucketID}/members';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($bucket_id !== null) {
            $resourcePath = str_replace(
                '{' . 'bucketID' . '}',
                ObjectSerializer::toPathValue($bucket_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($add_resource_member_request_body)) {
            $_tempBody = $add_resource_member_request_body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postBucketsIDOwners
     *
     * Add an owner to a bucket
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as owner (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceOwner|\InfluxDB2\Model\Error
     */
    public function postBucketsIDOwners($bucket_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        list($response) = $this->postBucketsIDOwnersWithHttpInfo($bucket_id, $add_resource_member_request_body, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postBucketsIDOwnersWithHttpInfo
     *
     * Add an owner to a bucket
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as owner (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceOwner|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postBucketsIDOwnersWithHttpInfo($bucket_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        $request = $this->postBucketsIDOwnersRequest($bucket_id, $add_resource_member_request_body, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceOwner';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postBucketsIDOwners'
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as owner (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postBucketsIDOwnersRequest($bucket_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        // verify the required parameter 'bucket_id' is set
        if ($bucket_id === null || (is_array($bucket_id) && count($bucket_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket_id when calling postBucketsIDOwners'
            );
        }
        // verify the required parameter 'add_resource_member_request_body' is set
        if ($add_resource_member_request_body === null || (is_array($add_resource_member_request_body) && count($add_resource_member_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $add_resource_member_request_body when calling postBucketsIDOwners'
            );
        }

        $resourcePath = '/api/v2/buckets/{bucketID}/owners';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($bucket_id !== null) {
            $resourcePath = str_replace(
                '{' . 'bucketID' . '}',
                ObjectSerializer::toPathValue($bucket_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($add_resource_member_request_body)) {
            $_tempBody = $add_resource_member_request_body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
