require 'shellwords'
require 'chake/config'
require 'chake/tmpdir'
require 'chake/config_manager/itamae_base'

module Chake
  class ConfigManager
    class Itamae < ItamaeBase
      def needs_upload?
        false
      end

      def self.accept?(node)
        node.data.key?('itamae')
      end

      private

      def run_itamae(preview, *recipes)
        cmd = ['itamae']
        case node.connection
        when Chake::Connection::Ssh
          cmd << 'ssh' << "--user=#{node.username}" << "--host=#{node.hostname}"
          if node.username == 'root'
            cmd << '--no-sudo'
          end
          cmd += ssh_config
        when Chake::Connection::Local
          if node.username == 'root'
            cmd.prepend 'sudo'
          end
          cmd << 'local'
        else
          raise NotImplementedError, "Connection type #{node.connection.class} not supported for itamee"
        end
        cmd << "--node-json=#{json_config}"
        if node.silent
          cmd << '--log-level=warn'
        end
        if preview
          cmd << '--dry-run'
        end
        cmd += recipes
        node.log("$ #{cmd.join(' ')}")
        io = IO.popen(cmd, 'r', err: %i[child out])
        node.connection.read_output(io)
      end

      def json_config
        File.join(Chake.tmpdir, "#{node.hostname}.json")
      end

      def ssh_config
        ssh_config = node.connection.send(:ssh_config_file) # FIXME
        File.exist?(ssh_config) ? ["--ssh-config=#{ssh_config}"] : []
      end
    end
  end
end
