/*****************************************************************
 * gavl - a general purpose audio/video processing library
 *
 * Copyright (c) 2001 - 2024 Members of the Gmerlin project
 * http://github.com/bplaum
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * *****************************************************************/


#include <inttypes.h>
#include "colorspace_tables.h"
const uint8_t gavl_yj_8_to_y_8[256] = 
{
  0x10, 0x11, 0x12, 0x13, 0x13, 0x14, 0x15, 0x16, 
  0x17, 0x18, 0x19, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 
  0x1e, 0x1f, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24, 
  0x25, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 
  0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x31, 
  0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x38, 
  0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3e, 0x3f, 
  0x40, 0x41, 0x42, 0x43, 0x44, 0x44, 0x45, 0x46, 
  0x47, 0x48, 0x49, 0x4a, 0x4a, 0x4b, 0x4c, 0x4d, 
  0x4e, 0x4f, 0x50, 0x50, 0x51, 0x52, 0x53, 0x54, 
  0x55, 0x56, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 
  0x5c, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x62, 
  0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x68, 
  0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6e, 0x6f, 
  0x70, 0x71, 0x72, 0x73, 0x74, 0x74, 0x75, 0x76, 
  0x77, 0x78, 0x79, 0x7a, 0x7a, 0x7b, 0x7c, 0x7d, 
  0x7e, 0x7f, 0x80, 0x81, 0x81, 0x82, 0x83, 0x84, 
  0x85, 0x86, 0x87, 0x87, 0x88, 0x89, 0x8a, 0x8b, 
  0x8c, 0x8d, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x92, 
  0x93, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 
  0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f, 0x9f, 
  0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa5, 0xa6, 
  0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xab, 0xac, 0xad, 
  0xae, 0xaf, 0xb0, 0xb1, 0xb1, 0xb2, 0xb3, 0xb4, 
  0xb5, 0xb6, 0xb7, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 
  0xbc, 0xbd, 0xbd, 0xbe, 0xbf, 0xc0, 0xc1, 0xc2, 
  0xc3, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 
  0xca, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 
  0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd6, 
  0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdc, 0xdd, 
  0xde, 0xdf, 0xe0, 0xe1, 0xe2, 0xe2, 0xe3, 0xe4, 
  0xe5, 0xe6, 0xe7, 0xe8, 0xe8, 0xe9, 0xea, 0xeb, 
};

const uint8_t gavl_uvj_8_to_uv_8[256] = 
{
  0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 
  0x17, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 
  0x1e, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24, 
  0x25, 0x26, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 
  0x2c, 0x2d, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 
  0x33, 0x34, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
  0x3a, 0x3b, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 
  0x41, 0x42, 0x43, 0x43, 0x44, 0x45, 0x46, 0x47, 
  0x48, 0x49, 0x4a, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 
  0x4f, 0x50, 0x51, 0x51, 0x52, 0x53, 0x54, 0x55, 
  0x56, 0x57, 0x58, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 
  0x5d, 0x5e, 0x5f, 0x5f, 0x60, 0x61, 0x62, 0x63, 
  0x64, 0x65, 0x66, 0x67, 0x67, 0x68, 0x69, 0x6a, 
  0x6b, 0x6c, 0x6d, 0x6e, 0x6e, 0x6f, 0x70, 0x71, 
  0x72, 0x73, 0x74, 0x75, 0x75, 0x76, 0x77, 0x78, 
  0x79, 0x7a, 0x7b, 0x7c, 0x7c, 0x7d, 0x7e, 0x7f, 
  0x80, 0x81, 0x82, 0x83, 0x84, 0x84, 0x85, 0x86, 
  0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8b, 0x8c, 0x8d, 
  0x8e, 0x8f, 0x90, 0x91, 0x92, 0x92, 0x93, 0x94, 
  0x95, 0x96, 0x97, 0x98, 0x99, 0x99, 0x9a, 0x9b, 
  0x9c, 0x9d, 0x9e, 0x9f, 0xa0, 0xa1, 0xa1, 0xa2, 
  0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa8, 0xa9, 
  0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xaf, 0xb0, 
  0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb6, 0xb7, 
  0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbd, 0xbe, 
  0xbf, 0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc5, 
  0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcc, 
  0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd3, 
  0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xda, 
  0xdb, 0xdc, 0xdd, 0xde, 0xdf, 0xe0, 0xe1, 0xe2, 
  0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 
  0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 
};

const uint16_t gavl_yj_8_to_y_16[256] = 
{
  0x1000, 0x10dc, 0x11b8, 0x1294, 0x136f, 0x144b, 0x1527, 0x1603, 
  0x16df, 0x17bb, 0x1897, 0x1972, 0x1a4e, 0x1b2a, 0x1c06, 0x1ce2, 
  0x1dbe, 0x1e9a, 0x1f75, 0x2051, 0x212d, 0x2209, 0x22e5, 0x23c1, 
  0x249d, 0x2578, 0x2654, 0x2730, 0x280c, 0x28e8, 0x29c4, 0x2aa0, 
  0x2b7b, 0x2c57, 0x2d33, 0x2e0f, 0x2eeb, 0x2fc7, 0x30a3, 0x317e, 
  0x325a, 0x3336, 0x3412, 0x34ee, 0x35ca, 0x36a6, 0x3782, 0x385d, 
  0x3939, 0x3a15, 0x3af1, 0x3bcd, 0x3ca9, 0x3d85, 0x3e60, 0x3f3c, 
  0x4018, 0x40f4, 0x41d0, 0x42ac, 0x4388, 0x4463, 0x453f, 0x461b, 
  0x46f7, 0x47d3, 0x48af, 0x498b, 0x4a66, 0x4b42, 0x4c1e, 0x4cfa, 
  0x4dd6, 0x4eb2, 0x4f8e, 0x5069, 0x5145, 0x5221, 0x52fd, 0x53d9, 
  0x54b5, 0x5591, 0x566c, 0x5748, 0x5824, 0x5900, 0x59dc, 0x5ab8, 
  0x5b94, 0x5c6f, 0x5d4b, 0x5e27, 0x5f03, 0x5fdf, 0x60bb, 0x6197, 
  0x6272, 0x634e, 0x642a, 0x6506, 0x65e2, 0x66be, 0x679a, 0x6875, 
  0x6951, 0x6a2d, 0x6b09, 0x6be5, 0x6cc1, 0x6d9d, 0x6e78, 0x6f54, 
  0x7030, 0x710c, 0x71e8, 0x72c4, 0x73a0, 0x747b, 0x7557, 0x7633, 
  0x770f, 0x77eb, 0x78c7, 0x79a3, 0x7a7e, 0x7b5a, 0x7c36, 0x7d12, 
  0x7dee, 0x7eca, 0x7fa6, 0x8082, 0x815d, 0x8239, 0x8315, 0x83f1, 
  0x84cd, 0x85a9, 0x8685, 0x8760, 0x883c, 0x8918, 0x89f4, 0x8ad0, 
  0x8bac, 0x8c88, 0x8d63, 0x8e3f, 0x8f1b, 0x8ff7, 0x90d3, 0x91af, 
  0x928b, 0x9366, 0x9442, 0x951e, 0x95fa, 0x96d6, 0x97b2, 0x988e, 
  0x9969, 0x9a45, 0x9b21, 0x9bfd, 0x9cd9, 0x9db5, 0x9e91, 0x9f6c, 
  0xa048, 0xa124, 0xa200, 0xa2dc, 0xa3b8, 0xa494, 0xa56f, 0xa64b, 
  0xa727, 0xa803, 0xa8df, 0xa9bb, 0xaa97, 0xab72, 0xac4e, 0xad2a, 
  0xae06, 0xaee2, 0xafbe, 0xb09a, 0xb175, 0xb251, 0xb32d, 0xb409, 
  0xb4e5, 0xb5c1, 0xb69d, 0xb778, 0xb854, 0xb930, 0xba0c, 0xbae8, 
  0xbbc4, 0xbca0, 0xbd7b, 0xbe57, 0xbf33, 0xc00f, 0xc0eb, 0xc1c7, 
  0xc2a3, 0xc37e, 0xc45a, 0xc536, 0xc612, 0xc6ee, 0xc7ca, 0xc8a6, 
  0xc982, 0xca5d, 0xcb39, 0xcc15, 0xccf1, 0xcdcd, 0xcea9, 0xcf85, 
  0xd060, 0xd13c, 0xd218, 0xd2f4, 0xd3d0, 0xd4ac, 0xd588, 0xd663, 
  0xd73f, 0xd81b, 0xd8f7, 0xd9d3, 0xdaaf, 0xdb8b, 0xdc66, 0xdd42, 
  0xde1e, 0xdefa, 0xdfd6, 0xe0b2, 0xe18e, 0xe269, 0xe345, 0xe421, 
  0xe4fd, 0xe5d9, 0xe6b5, 0xe791, 0xe86c, 0xe948, 0xea24, 0xeb00, 
};

const uint16_t gavl_uvj_8_to_uv_16[256] = 
{
  0x0f90, 0x1070, 0x1151, 0x1232, 0x1313, 0x13f4, 0x14d5, 0x15b6, 
  0x1697, 0x1777, 0x1858, 0x1939, 0x1a1a, 0x1afb, 0x1bdc, 0x1cbd, 
  0x1d9e, 0x1e7e, 0x1f5f, 0x2040, 0x2121, 0x2202, 0x22e3, 0x23c4, 
  0x24a5, 0x2586, 0x2666, 0x2747, 0x2828, 0x2909, 0x29ea, 0x2acb, 
  0x2bac, 0x2c8d, 0x2d6d, 0x2e4e, 0x2f2f, 0x3010, 0x30f1, 0x31d2, 
  0x32b3, 0x3394, 0x3474, 0x3555, 0x3636, 0x3717, 0x37f8, 0x38d9, 
  0x39ba, 0x3a9b, 0x3b7b, 0x3c5c, 0x3d3d, 0x3e1e, 0x3eff, 0x3fe0, 
  0x40c1, 0x41a2, 0x4283, 0x4363, 0x4444, 0x4525, 0x4606, 0x46e7, 
  0x47c8, 0x48a9, 0x498a, 0x4a6a, 0x4b4b, 0x4c2c, 0x4d0d, 0x4dee, 
  0x4ecf, 0x4fb0, 0x5091, 0x5171, 0x5252, 0x5333, 0x5414, 0x54f5, 
  0x55d6, 0x56b7, 0x5798, 0x5878, 0x5959, 0x5a3a, 0x5b1b, 0x5bfc, 
  0x5cdd, 0x5dbe, 0x5e9f, 0x5f7f, 0x6060, 0x6141, 0x6222, 0x6303, 
  0x63e4, 0x64c5, 0x65a6, 0x6687, 0x6767, 0x6848, 0x6929, 0x6a0a, 
  0x6aeb, 0x6bcc, 0x6cad, 0x6d8e, 0x6e6e, 0x6f4f, 0x7030, 0x7111, 
  0x71f2, 0x72d3, 0x73b4, 0x7495, 0x7575, 0x7656, 0x7737, 0x7818, 
  0x78f9, 0x79da, 0x7abb, 0x7b9c, 0x7c7c, 0x7d5d, 0x7e3e, 0x7f1f, 
  0x8000, 0x80e1, 0x81c2, 0x82a3, 0x8384, 0x8464, 0x8545, 0x8626, 
  0x8707, 0x87e8, 0x88c9, 0x89aa, 0x8a8b, 0x8b6b, 0x8c4c, 0x8d2d, 
  0x8e0e, 0x8eef, 0x8fd0, 0x90b1, 0x9192, 0x9272, 0x9353, 0x9434, 
  0x9515, 0x95f6, 0x96d7, 0x97b8, 0x9899, 0x9979, 0x9a5a, 0x9b3b, 
  0x9c1c, 0x9cfd, 0x9dde, 0x9ebf, 0x9fa0, 0xa081, 0xa161, 0xa242, 
  0xa323, 0xa404, 0xa4e5, 0xa5c6, 0xa6a7, 0xa788, 0xa868, 0xa949, 
  0xaa2a, 0xab0b, 0xabec, 0xaccd, 0xadae, 0xae8f, 0xaf6f, 0xb050, 
  0xb131, 0xb212, 0xb2f3, 0xb3d4, 0xb4b5, 0xb596, 0xb676, 0xb757, 
  0xb838, 0xb919, 0xb9fa, 0xbadb, 0xbbbc, 0xbc9d, 0xbd7d, 0xbe5e, 
  0xbf3f, 0xc020, 0xc101, 0xc1e2, 0xc2c3, 0xc3a4, 0xc485, 0xc565, 
  0xc646, 0xc727, 0xc808, 0xc8e9, 0xc9ca, 0xcaab, 0xcb8c, 0xcc6c, 
  0xcd4d, 0xce2e, 0xcf0f, 0xcff0, 0xd0d1, 0xd1b2, 0xd293, 0xd373, 
  0xd454, 0xd535, 0xd616, 0xd6f7, 0xd7d8, 0xd8b9, 0xd99a, 0xda7a, 
  0xdb5b, 0xdc3c, 0xdd1d, 0xddfe, 0xdedf, 0xdfc0, 0xe0a1, 0xe182, 
  0xe262, 0xe343, 0xe424, 0xe505, 0xe5e6, 0xe6c7, 0xe7a8, 0xe889, 
  0xe969, 0xea4a, 0xeb2b, 0xec0c, 0xeced, 0xedce, 0xeeaf, 0xef90, 
};

const uint8_t gavl_y_8_to_yj_8[256] = 
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x01, 0x02, 0x03, 0x05, 0x06, 0x07, 0x08, 
  0x09, 0x0a, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 
  0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x1a, 0x1b, 
  0x1c, 0x1d, 0x1e, 0x1f, 0x21, 0x22, 0x23, 0x24, 
  0x25, 0x26, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 
  0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x36, 0x37, 
  0x38, 0x39, 0x3a, 0x3b, 0x3d, 0x3e, 0x3f, 0x40, 
  0x41, 0x42, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 
  0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x52, 0x53, 
  0x54, 0x55, 0x56, 0x57, 0x58, 0x5a, 0x5b, 0x5c, 
  0x5d, 0x5e, 0x5f, 0x61, 0x62, 0x63, 0x64, 0x65, 
  0x66, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6f, 
  0x70, 0x71, 0x72, 0x73, 0x74, 0x76, 0x77, 0x78, 
  0x79, 0x7a, 0x7b, 0x7d, 0x7e, 0x7f, 0x80, 0x81, 
  0x82, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8b, 
  0x8c, 0x8d, 0x8e, 0x8f, 0x90, 0x92, 0x93, 0x94, 
  0x95, 0x96, 0x97, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 
  0x9e, 0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa7, 
  0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xaf, 0xb0, 
  0xb1, 0xb2, 0xb3, 0xb4, 0xb6, 0xb7, 0xb8, 0xb9, 
  0xba, 0xbb, 0xbd, 0xbe, 0xbf, 0xc0, 0xc1, 0xc2, 
  0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xcb, 0xcc, 
  0xcd, 0xce, 0xcf, 0xd0, 0xd2, 0xd3, 0xd4, 0xd5, 
  0xd6, 0xd7, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 
  0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe7, 0xe8, 
  0xe9, 0xea, 0xeb, 0xec, 0xee, 0xef, 0xf0, 0xf1, 
  0xf2, 0xf3, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 
  0xfc, 0xfd, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
};

const uint8_t gavl_uv_8_to_uvj_8[256] = 
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 
  0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x12, 
  0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x1a, 0x1b, 
  0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x22, 0x23, 0x24, 
  0x25, 0x26, 0x27, 0x28, 0x29, 0x2b, 0x2c, 0x2d, 
  0x2e, 0x2f, 0x30, 0x31, 0x33, 0x34, 0x35, 0x36, 
  0x37, 0x38, 0x39, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 
  0x40, 0x41, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 
  0x49, 0x4a, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 
  0x52, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 
  0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x62, 0x64, 
  0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6c, 0x6d, 
  0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x75, 0x76, 
  0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7d, 0x7e, 0x7f, 
  0x80, 0x81, 0x82, 0x83, 0x85, 0x86, 0x87, 0x88, 
  0x89, 0x8a, 0x8b, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 
  0x92, 0x93, 0x94, 0x96, 0x97, 0x98, 0x99, 0x9a, 
  0x9b, 0x9c, 0x9e, 0x9f, 0xa0, 0xa1, 0xa2, 0xa3, 
  0xa4, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 
  0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb6, 
  0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbf, 
  0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc7, 0xc8, 
  0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xcf, 0xd0, 0xd1, 
  0xd2, 0xd3, 0xd4, 0xd5, 0xd7, 0xd8, 0xd9, 0xda, 
  0xdb, 0xdc, 0xdd, 0xde, 0xe0, 0xe1, 0xe2, 0xe3, 
  0xe4, 0xe5, 0xe6, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 
  0xed, 0xee, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 
  0xf6, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
};

const uint16_t gavl_y_8_to_yj_16[256] = 
{
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x012b, 0x0256, 0x0382, 0x04ad, 0x05d8, 0x0703, 0x082f, 
  0x095a, 0x0a85, 0x0bb0, 0x0cdc, 0x0e07, 0x0f32, 0x105d, 0x1189, 
  0x12b4, 0x13df, 0x150a, 0x1636, 0x1761, 0x188c, 0x19b7, 0x1ae3, 
  0x1c0e, 0x1d39, 0x1e64, 0x1f90, 0x20bb, 0x21e6, 0x2311, 0x243d, 
  0x2568, 0x2693, 0x27be, 0x28ea, 0x2a15, 0x2b40, 0x2c6b, 0x2d97, 
  0x2ec2, 0x2fed, 0x3118, 0x3244, 0x336f, 0x349a, 0x35c5, 0x36f1, 
  0x381c, 0x3947, 0x3a72, 0x3b9e, 0x3cc9, 0x3df4, 0x3f1f, 0x404b, 
  0x4176, 0x42a1, 0x43cc, 0x44f8, 0x4623, 0x474e, 0x4879, 0x49a5, 
  0x4ad0, 0x4bfb, 0x4d26, 0x4e52, 0x4f7d, 0x50a8, 0x51d3, 0x52ff, 
  0x542a, 0x5555, 0x5680, 0x57ab, 0x58d7, 0x5a02, 0x5b2d, 0x5c58, 
  0x5d84, 0x5eaf, 0x5fda, 0x6105, 0x6231, 0x635c, 0x6487, 0x65b2, 
  0x66de, 0x6809, 0x6934, 0x6a5f, 0x6b8b, 0x6cb6, 0x6de1, 0x6f0c, 
  0x7038, 0x7163, 0x728e, 0x73b9, 0x74e5, 0x7610, 0x773b, 0x7866, 
  0x7992, 0x7abd, 0x7be8, 0x7d13, 0x7e3f, 0x7f6a, 0x8095, 0x81c0, 
  0x82ec, 0x8417, 0x8542, 0x866d, 0x8799, 0x88c4, 0x89ef, 0x8b1a, 
  0x8c46, 0x8d71, 0x8e9c, 0x8fc7, 0x90f3, 0x921e, 0x9349, 0x9474, 
  0x95a0, 0x96cb, 0x97f6, 0x9921, 0x9a4d, 0x9b78, 0x9ca3, 0x9dce, 
  0x9efa, 0xa025, 0xa150, 0xa27b, 0xa3a7, 0xa4d2, 0xa5fd, 0xa728, 
  0xa854, 0xa97f, 0xaaaa, 0xabd5, 0xad00, 0xae2c, 0xaf57, 0xb082, 
  0xb1ad, 0xb2d9, 0xb404, 0xb52f, 0xb65a, 0xb786, 0xb8b1, 0xb9dc, 
  0xbb07, 0xbc33, 0xbd5e, 0xbe89, 0xbfb4, 0xc0e0, 0xc20b, 0xc336, 
  0xc461, 0xc58d, 0xc6b8, 0xc7e3, 0xc90e, 0xca3a, 0xcb65, 0xcc90, 
  0xcdbb, 0xcee7, 0xd012, 0xd13d, 0xd268, 0xd394, 0xd4bf, 0xd5ea, 
  0xd715, 0xd841, 0xd96c, 0xda97, 0xdbc2, 0xdcee, 0xde19, 0xdf44, 
  0xe06f, 0xe19b, 0xe2c6, 0xe3f1, 0xe51c, 0xe648, 0xe773, 0xe89e, 
  0xe9c9, 0xeaf5, 0xec20, 0xed4b, 0xee76, 0xefa2, 0xf0cd, 0xf1f8, 
  0xf323, 0xf44f, 0xf57a, 0xf6a5, 0xf7d0, 0xf8fc, 0xfa27, 0xfb52, 
  0xfc7d, 0xfda9, 0xfed4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
};

const float gavl_y_8_to_y_float[256] = 
{
  0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 
  0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 
  0.0000000000, 0.0045662099, 0.0091324197, 0.0136986300, 0.0182648394, 0.0228310507, 0.0273972601, 0.0319634713, 
  0.0365296789, 0.0410958901, 0.0456621014, 0.0502283089, 0.0547945201, 0.0593607314, 0.0639269426, 0.0684931502, 
  0.0730593577, 0.0776255727, 0.0821917802, 0.0867579877, 0.0913242027, 0.0958904102, 0.1004566178, 0.1050228328, 
  0.1095890403, 0.1141552478, 0.1187214628, 0.1232876703, 0.1278538853, 0.1324200928, 0.1369863003, 0.1415525079, 
  0.1461187154, 0.1506849378, 0.1552511454, 0.1598173529, 0.1643835604, 0.1689497679, 0.1735159755, 0.1780821979, 
  0.1826484054, 0.1872146130, 0.1917808205, 0.1963470280, 0.2009132355, 0.2054794580, 0.2100456655, 0.2146118730, 
  0.2191780806, 0.2237442881, 0.2283104956, 0.2328767180, 0.2374429256, 0.2420091331, 0.2465753406, 0.2511415482, 
  0.2557077706, 0.2602739632, 0.2648401856, 0.2694063783, 0.2739726007, 0.2785388231, 0.2831050158, 0.2876712382, 
  0.2922374308, 0.2968036532, 0.3013698757, 0.3059360683, 0.3105022907, 0.3150684834, 0.3196347058, 0.3242008984, 
  0.3287671208, 0.3333333433, 0.3378995359, 0.3424657583, 0.3470319510, 0.3515981734, 0.3561643958, 0.3607305884, 
  0.3652968109, 0.3698630035, 0.3744292259, 0.3789954484, 0.3835616410, 0.3881278634, 0.3926940560, 0.3972602785, 
  0.4018264711, 0.4063926935, 0.4109589159, 0.4155251086, 0.4200913310, 0.4246575236, 0.4292237461, 0.4337899685, 
  0.4383561611, 0.4429223835, 0.4474885762, 0.4520547986, 0.4566209912, 0.4611872137, 0.4657534361, 0.4703196287, 
  0.4748858511, 0.4794520438, 0.4840182662, 0.4885844886, 0.4931506813, 0.4977169037, 0.5022830963, 0.5068492889, 
  0.5114155412, 0.5159817338, 0.5205479264, 0.5251141787, 0.5296803713, 0.5342465639, 0.5388127565, 0.5433790088, 
  0.5479452014, 0.5525113940, 0.5570776463, 0.5616438389, 0.5662100315, 0.5707762837, 0.5753424764, 0.5799086690, 
  0.5844748616, 0.5890411139, 0.5936073065, 0.5981734991, 0.6027397513, 0.6073059440, 0.6118721366, 0.6164383292, 
  0.6210045815, 0.6255707741, 0.6301369667, 0.6347032189, 0.6392694116, 0.6438356042, 0.6484017968, 0.6529680490, 
  0.6575342417, 0.6621004343, 0.6666666865, 0.6712328792, 0.6757990718, 0.6803653240, 0.6849315166, 0.6894977093, 
  0.6940639019, 0.6986301541, 0.7031963468, 0.7077625394, 0.7123287916, 0.7168949842, 0.7214611769, 0.7260273695, 
  0.7305936217, 0.7351598144, 0.7397260070, 0.7442922592, 0.7488584518, 0.7534246445, 0.7579908967, 0.7625570893, 
  0.7671232820, 0.7716894746, 0.7762557268, 0.7808219194, 0.7853881121, 0.7899543643, 0.7945205569, 0.7990867496, 
  0.8036529422, 0.8082191944, 0.8127853870, 0.8173515797, 0.8219178319, 0.8264840245, 0.8310502172, 0.8356164098, 
  0.8401826620, 0.8447488546, 0.8493150473, 0.8538812995, 0.8584474921, 0.8630136847, 0.8675799370, 0.8721461296, 
  0.8767123222, 0.8812785149, 0.8858447671, 0.8904109597, 0.8949771523, 0.8995434046, 0.9041095972, 0.9086757898, 
  0.9132419825, 0.9178082347, 0.9223744273, 0.9269406199, 0.9315068722, 0.9360730648, 0.9406392574, 0.9452054501, 
  0.9497717023, 0.9543378949, 0.9589040875, 0.9634703398, 0.9680365324, 0.9726027250, 0.9771689773, 0.9817351699, 
  0.9863013625, 0.9908675551, 0.9954338074, 1.0000000000, 1.0000000000, 1.0000000000, 1.0000000000, 1.0000000000, 
  1.0000000000, 1.0000000000, 1.0000000000, 1.0000000000, 1.0000000000, 1.0000000000, 1.0000000000, 1.0000000000, 
  1.0000000000, 1.0000000000, 1.0000000000, 1.0000000000, 1.0000000000, 1.0000000000, 1.0000000000, 1.0000000000, 
};

const float gavl_uv_8_to_uv_float[256] = 
{
  -0.5000000000, -0.5000000000, -0.5000000000, -0.5000000000, -0.5000000000, -0.5000000000, -0.5000000000, -0.5000000000, 
  -0.5000000000, -0.5000000000, -0.5000000000, -0.5000000000, -0.5000000000, -0.5000000000, -0.5000000000, -0.5000000000, 
  -0.5000000000, -0.4955357015, -0.4910714328, -0.4866071343, -0.4821428657, -0.4776785672, -0.4732142985, -0.4687500000, 
  -0.4642857015, -0.4598214328, -0.4553571343, -0.4508928657, -0.4464285672, -0.4419642985, -0.4375000000, -0.4330357015, 
  -0.4285714328, -0.4241071343, -0.4196428657, -0.4151785672, -0.4107142985, -0.4062500000, -0.4017857015, -0.3973214328, 
  -0.3928571343, -0.3883928657, -0.3839285672, -0.3794642985, -0.3750000000, -0.3705357015, -0.3660714328, -0.3616071343, 
  -0.3571428657, -0.3526785672, -0.3482142985, -0.3437500000, -0.3392857015, -0.3348214328, -0.3303571343, -0.3258928657, 
  -0.3214285672, -0.3169642985, -0.3125000000, -0.3080357015, -0.3035714328, -0.2991071343, -0.2946428657, -0.2901785672, 
  -0.2857142985, -0.2812500000, -0.2767857015, -0.2723214328, -0.2678571343, -0.2633928657, -0.2589285672, -0.2544642985, 
  -0.2500000000, -0.2455357164, -0.2410714328, -0.2366071492, -0.2321428508, -0.2276785672, -0.2232142836, -0.2187500000, 
  -0.2142857164, -0.2098214328, -0.2053571492, -0.2008928508, -0.1964285672, -0.1919642836, -0.1875000000, -0.1830357164, 
  -0.1785714328, -0.1741071492, -0.1696428508, -0.1651785672, -0.1607142836, -0.1562500000, -0.1517857164, -0.1473214328, 
  -0.1428571492, -0.1383928508, -0.1339285672, -0.1294642836, -0.1250000000, -0.1205357164, -0.1160714254, -0.1116071418, 
  -0.1071428582, -0.1026785746, -0.0982142836, -0.0937500000, -0.0892857164, -0.0848214254, -0.0803571418, -0.0758928582, 
  -0.0714285746, -0.0669642836, -0.0625000000, -0.0580357127, -0.0535714291, -0.0491071418, -0.0446428582, -0.0401785709, 
  -0.0357142873, -0.0312500000, -0.0267857146, -0.0223214291, -0.0178571437, -0.0133928573, -0.0089285718, -0.0044642859, 
  0.0000000000, 0.0044642859, 0.0089285718, 0.0133928573, 0.0178571437, 0.0223214291, 0.0267857146, 0.0312500000, 
  0.0357142873, 0.0401785709, 0.0446428582, 0.0491071418, 0.0535714291, 0.0580357127, 0.0625000000, 0.0669642836, 
  0.0714285746, 0.0758928582, 0.0803571418, 0.0848214254, 0.0892857164, 0.0937500000, 0.0982142836, 0.1026785746, 
  0.1071428582, 0.1116071418, 0.1160714254, 0.1205357164, 0.1250000000, 0.1294642836, 0.1339285672, 0.1383928508, 
  0.1428571492, 0.1473214328, 0.1517857164, 0.1562500000, 0.1607142836, 0.1651785672, 0.1696428508, 0.1741071492, 
  0.1785714328, 0.1830357164, 0.1875000000, 0.1919642836, 0.1964285672, 0.2008928508, 0.2053571492, 0.2098214328, 
  0.2142857164, 0.2187500000, 0.2232142836, 0.2276785672, 0.2321428508, 0.2366071492, 0.2410714328, 0.2455357164, 
  0.2500000000, 0.2544642985, 0.2589285672, 0.2633928657, 0.2678571343, 0.2723214328, 0.2767857015, 0.2812500000, 
  0.2857142985, 0.2901785672, 0.2946428657, 0.2991071343, 0.3035714328, 0.3080357015, 0.3125000000, 0.3169642985, 
  0.3214285672, 0.3258928657, 0.3303571343, 0.3348214328, 0.3392857015, 0.3437500000, 0.3482142985, 0.3526785672, 
  0.3571428657, 0.3616071343, 0.3660714328, 0.3705357015, 0.3750000000, 0.3794642985, 0.3839285672, 0.3883928657, 
  0.3928571343, 0.3973214328, 0.4017857015, 0.4062500000, 0.4107142985, 0.4151785672, 0.4196428657, 0.4241071343, 
  0.4285714328, 0.4330357015, 0.4375000000, 0.4419642985, 0.4464285672, 0.4508928657, 0.4553571343, 0.4598214328, 
  0.4642857015, 0.4687500000, 0.4732142985, 0.4776785672, 0.4821428657, 0.4866071343, 0.4910714328, 0.4955357015, 
  0.5000000000, 0.5000000000, 0.5000000000, 0.5000000000, 0.5000000000, 0.5000000000, 0.5000000000, 0.5000000000, 
  0.5000000000, 0.5000000000, 0.5000000000, 0.5000000000, 0.5000000000, 0.5000000000, 0.5000000000, 0.5000000000, 
};

const float gavl_yj_8_to_y_float[256] = 
{
  0.0000000000, 0.0039215689, 0.0078431377, 0.0117647061, 0.0156862754, 0.0196078438, 0.0235294122, 0.0274509806, 
  0.0313725509, 0.0352941193, 0.0392156877, 0.0431372561, 0.0470588244, 0.0509803928, 0.0549019612, 0.0588235296, 
  0.0627451017, 0.0666666701, 0.0705882385, 0.0745098069, 0.0784313753, 0.0823529437, 0.0862745121, 0.0901960805, 
  0.0941176489, 0.0980392173, 0.1019607857, 0.1058823541, 0.1098039225, 0.1137254909, 0.1176470593, 0.1215686277, 
  0.1254902035, 0.1294117719, 0.1333333403, 0.1372549087, 0.1411764771, 0.1450980455, 0.1490196139, 0.1529411823, 
  0.1568627506, 0.1607843190, 0.1647058874, 0.1686274558, 0.1725490242, 0.1764705926, 0.1803921610, 0.1843137294, 
  0.1882352978, 0.1921568662, 0.1960784346, 0.2000000030, 0.2039215714, 0.2078431398, 0.2117647082, 0.2156862766, 
  0.2196078449, 0.2235294133, 0.2274509817, 0.2313725501, 0.2352941185, 0.2392156869, 0.2431372553, 0.2470588237, 
  0.2509804070, 0.2549019754, 0.2588235438, 0.2627451122, 0.2666666806, 0.2705882490, 0.2745098174, 0.2784313858, 
  0.2823529541, 0.2862745225, 0.2901960909, 0.2941176593, 0.2980392277, 0.3019607961, 0.3058823645, 0.3098039329, 
  0.3137255013, 0.3176470697, 0.3215686381, 0.3254902065, 0.3294117749, 0.3333333433, 0.3372549117, 0.3411764801, 
  0.3450980484, 0.3490196168, 0.3529411852, 0.3568627536, 0.3607843220, 0.3647058904, 0.3686274588, 0.3725490272, 
  0.3764705956, 0.3803921640, 0.3843137324, 0.3882353008, 0.3921568692, 0.3960784376, 0.4000000060, 0.4039215744, 
  0.4078431427, 0.4117647111, 0.4156862795, 0.4196078479, 0.4235294163, 0.4274509847, 0.4313725531, 0.4352941215, 
  0.4392156899, 0.4431372583, 0.4470588267, 0.4509803951, 0.4549019635, 0.4588235319, 0.4627451003, 0.4666666687, 
  0.4705882370, 0.4745098054, 0.4784313738, 0.4823529422, 0.4862745106, 0.4901960790, 0.4941176474, 0.4980392158, 
  0.5019608140, 0.5058823824, 0.5098039508, 0.5137255192, 0.5176470876, 0.5215686560, 0.5254902244, 0.5294117928, 
  0.5333333611, 0.5372549295, 0.5411764979, 0.5450980663, 0.5490196347, 0.5529412031, 0.5568627715, 0.5607843399, 
  0.5647059083, 0.5686274767, 0.5725490451, 0.5764706135, 0.5803921819, 0.5843137503, 0.5882353187, 0.5921568871, 
  0.5960784554, 0.6000000238, 0.6039215922, 0.6078431606, 0.6117647290, 0.6156862974, 0.6196078658, 0.6235294342, 
  0.6274510026, 0.6313725710, 0.6352941394, 0.6392157078, 0.6431372762, 0.6470588446, 0.6509804130, 0.6549019814, 
  0.6588235497, 0.6627451181, 0.6666666865, 0.6705882549, 0.6745098233, 0.6784313917, 0.6823529601, 0.6862745285, 
  0.6901960969, 0.6941176653, 0.6980392337, 0.7019608021, 0.7058823705, 0.7098039389, 0.7137255073, 0.7176470757, 
  0.7215686440, 0.7254902124, 0.7294117808, 0.7333333492, 0.7372549176, 0.7411764860, 0.7450980544, 0.7490196228, 
  0.7529411912, 0.7568627596, 0.7607843280, 0.7647058964, 0.7686274648, 0.7725490332, 0.7764706016, 0.7803921700, 
  0.7843137383, 0.7882353067, 0.7921568751, 0.7960784435, 0.8000000119, 0.8039215803, 0.8078431487, 0.8117647171, 
  0.8156862855, 0.8196078539, 0.8235294223, 0.8274509907, 0.8313725591, 0.8352941275, 0.8392156959, 0.8431372643, 
  0.8470588326, 0.8509804010, 0.8549019694, 0.8588235378, 0.8627451062, 0.8666666746, 0.8705882430, 0.8745098114, 
  0.8784313798, 0.8823529482, 0.8862745166, 0.8901960850, 0.8941176534, 0.8980392218, 0.9019607902, 0.9058823586, 
  0.9098039269, 0.9137254953, 0.9176470637, 0.9215686321, 0.9254902005, 0.9294117689, 0.9333333373, 0.9372549057, 
  0.9411764741, 0.9450980425, 0.9490196109, 0.9529411793, 0.9568627477, 0.9607843161, 0.9647058845, 0.9686274529, 
  0.9725490212, 0.9764705896, 0.9803921580, 0.9843137264, 0.9882352948, 0.9921568632, 0.9960784316, 1.0000000000, 
};

const uint8_t gavl_rgb_5_to_8[32] = 
{
  0x00, 0x08, 0x10, 0x19, 0x21, 0x29, 0x31, 0x3a, 
  0x42, 0x4a, 0x52, 0x5a, 0x63, 0x6b, 0x73, 0x7b, 
  0x84, 0x8c, 0x94, 0x9c, 0xa5, 0xad, 0xb5, 0xbd, 
  0xc5, 0xce, 0xd6, 0xde, 0xe6, 0xef, 0xf7, 0xff, 
};

const uint8_t gavl_rgb_6_to_8[64] = 
{
  0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 
  0x20, 0x24, 0x28, 0x2d, 0x31, 0x35, 0x39, 0x3d, 
  0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59, 0x5d, 
  0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 
  0x82, 0x86, 0x8a, 0x8e, 0x92, 0x96, 0x9a, 0x9e, 
  0xa2, 0xa6, 0xaa, 0xae, 0xb2, 0xb6, 0xba, 0xbe, 
  0xc2, 0xc6, 0xca, 0xce, 0xd2, 0xd7, 0xdb, 0xdf, 
  0xe3, 0xe7, 0xeb, 0xef, 0xf3, 0xf7, 0xfb, 0xff, 
};

const uint16_t gavl_rgb_5_to_16[32] = 
{
  0x0000, 0x0842, 0x1084, 0x18c6, 0x2108, 0x294a, 0x318c, 0x39ce, 
  0x4210, 0x4a52, 0x5294, 0x5ad6, 0x6318, 0x6b5a, 0x739c, 0x7bde, 
  0x8421, 0x8c63, 0x94a5, 0x9ce7, 0xa529, 0xad6b, 0xb5ad, 0xbdef, 
  0xc631, 0xce73, 0xd6b5, 0xdef7, 0xe739, 0xef7b, 0xf7bd, 0xffff, 
};

const uint16_t gavl_rgb_6_to_16[64] = 
{
  0x0000, 0x0410, 0x0820, 0x0c31, 0x1041, 0x1451, 0x1861, 0x1c72, 
  0x2082, 0x2492, 0x28a2, 0x2cb3, 0x30c3, 0x34d3, 0x38e3, 0x3cf4, 
  0x4104, 0x4514, 0x4924, 0x4d35, 0x5145, 0x5555, 0x5965, 0x5d75, 
  0x6186, 0x6596, 0x69a6, 0x6db6, 0x71c7, 0x75d7, 0x79e7, 0x7df7, 
  0x8208, 0x8618, 0x8a28, 0x8e38, 0x9249, 0x9659, 0x9a69, 0x9e79, 
  0xa28a, 0xa69a, 0xaaaa, 0xaeba, 0xb2ca, 0xb6db, 0xbaeb, 0xbefb, 
  0xc30b, 0xc71c, 0xcb2c, 0xcf3c, 0xd34c, 0xd75d, 0xdb6d, 0xdf7d, 
  0xe38d, 0xe79e, 0xebae, 0xefbe, 0xf3ce, 0xf7df, 0xfbef, 0xffff, 
};

const float gavl_rgb_5_to_float[32] = 
{
  0.000000, 0.032258, 0.064516, 0.096774, 0.129032, 0.161290, 0.193548, 0.225806, 
  0.258065, 0.290323, 0.322581, 0.354839, 0.387097, 0.419355, 0.451613, 0.483871, 
  0.516129, 0.548387, 0.580645, 0.612903, 0.645161, 0.677419, 0.709677, 0.741935, 
  0.774194, 0.806452, 0.838710, 0.870968, 0.903226, 0.935484, 0.967742, 1.000000, 
};

const float gavl_rgb_6_to_float[64] = 
{
  0.000000, 0.015873, 0.031746, 0.047619, 0.063492, 0.079365, 0.095238, 0.111111, 
  0.126984, 0.142857, 0.158730, 0.174603, 0.190476, 0.206349, 0.222222, 0.238095, 
  0.253968, 0.269841, 0.285714, 0.301587, 0.317460, 0.333333, 0.349206, 0.365079, 
  0.380952, 0.396825, 0.412698, 0.428571, 0.444444, 0.460317, 0.476190, 0.492063, 
  0.507937, 0.523810, 0.539683, 0.555556, 0.571429, 0.587302, 0.603175, 0.619048, 
  0.634921, 0.650794, 0.666667, 0.682540, 0.698413, 0.714286, 0.730159, 0.746032, 
  0.761905, 0.777778, 0.793651, 0.809524, 0.825397, 0.841270, 0.857143, 0.873016, 
  0.888889, 0.904762, 0.920635, 0.936508, 0.952381, 0.968254, 0.984127, 1.000000, 
};

/* RGB -> YUV conversions */
const int gavl_r_to_y[256] = 
{
  1048576, 1065405, 1082234, 1099063, 1115891, 1132720, 1149549, 1166378, 
  1183207, 1200036, 1216865, 1233694, 1250522, 1267351, 1284180, 1301009, 
  1317838, 1334667, 1351496, 1368325, 1385153, 1401982, 1418811, 1435640, 
  1452469, 1469298, 1486127, 1502956, 1519784, 1536613, 1553442, 1570271, 
  1587100, 1603929, 1620758, 1637587, 1654415, 1671244, 1688073, 1704902, 
  1721731, 1738560, 1755389, 1772218, 1789046, 1805875, 1822704, 1839533, 
  1856362, 1873191, 1890020, 1906849, 1923677, 1940506, 1957335, 1974164, 
  1990993, 2007822, 2024651, 2041480, 2058308, 2075137, 2091966, 2108795, 
  2125624, 2142453, 2159282, 2176111, 2192939, 2209768, 2226597, 2243426, 
  2260255, 2277084, 2293913, 2310742, 2327570, 2344399, 2361228, 2378057, 
  2394886, 2411715, 2428544, 2445373, 2462201, 2479030, 2495859, 2512688, 
  2529517, 2546346, 2563175, 2580004, 2596832, 2613661, 2630490, 2647319, 
  2664148, 2680977, 2697806, 2714635, 2731463, 2748292, 2765121, 2781950, 
  2798779, 2815608, 2832437, 2849265, 2866094, 2882923, 2899752, 2916581, 
  2933410, 2950239, 2967068, 2983896, 3000725, 3017554, 3034383, 3051212, 
  3068041, 3084870, 3101699, 3118527, 3135356, 3152185, 3169014, 3185843, 
  3202672, 3219501, 3236330, 3253158, 3269987, 3286816, 3303645, 3320474, 
  3337303, 3354132, 3370961, 3387789, 3404618, 3421447, 3438276, 3455105, 
  3471934, 3488763, 3505592, 3522420, 3539249, 3556078, 3572907, 3589736, 
  3606565, 3623394, 3640223, 3657051, 3673880, 3690709, 3707538, 3724367, 
  3741196, 3758025, 3774854, 3791682, 3808511, 3825340, 3842169, 3858998, 
  3875827, 3892656, 3909485, 3926313, 3943142, 3959971, 3976800, 3993629, 
  4010458, 4027287, 4044116, 4060944, 4077773, 4094602, 4111431, 4128260, 
  4145089, 4161918, 4178747, 4195575, 4212404, 4229233, 4246062, 4262891, 
  4279720, 4296549, 4313378, 4330206, 4347035, 4363864, 4380693, 4397522, 
  4414351, 4431180, 4448009, 4464837, 4481666, 4498495, 4515324, 4532153, 
  4548982, 4565811, 4582639, 4599468, 4616297, 4633126, 4649955, 4666784, 
  4683613, 4700442, 4717270, 4734099, 4750928, 4767757, 4784586, 4801415, 
  4818244, 4835073, 4851901, 4868730, 4885559, 4902388, 4919217, 4936046, 
  4952875, 4969704, 4986532, 5003361, 5020190, 5037019, 5053848, 5070677, 
  5087506, 5104335, 5121163, 5137992, 5154821, 5171650, 5188479, 5205308, 
  5222137, 5238966, 5255794, 5272623, 5289452, 5306281, 5323110, 5339939, 
};

const int gavl_g_to_y[256] = 
{
  0, 33039, 66077, 99116, 132155, 165193, 198232, 231270, 
  264309, 297348, 330386, 363425, 396464, 429502, 462541, 495579, 
  528618, 561657, 594695, 627734, 660773, 693811, 726850, 759888, 
  792927, 825966, 859004, 892043, 925082, 958120, 991159, 1024197, 
  1057236, 1090275, 1123313, 1156352, 1189391, 1222429, 1255468, 1288506, 
  1321545, 1354584, 1387622, 1420661, 1453700, 1486738, 1519777, 1552815, 
  1585854, 1618893, 1651931, 1684970, 1718009, 1751047, 1784086, 1817124, 
  1850163, 1883202, 1916240, 1949279, 1982318, 2015356, 2048395, 2081433, 
  2114472, 2147511, 2180549, 2213588, 2246627, 2279665, 2312704, 2345742, 
  2378781, 2411820, 2444858, 2477897, 2510936, 2543974, 2577013, 2610051, 
  2643090, 2676129, 2709167, 2742206, 2775245, 2808283, 2841322, 2874360, 
  2907399, 2940438, 2973476, 3006515, 3039554, 3072592, 3105631, 3138669, 
  3171708, 3204747, 3237785, 3270824, 3303863, 3336901, 3369940, 3402978, 
  3436017, 3469056, 3502094, 3535133, 3568172, 3601210, 3634249, 3667287, 
  3700326, 3733365, 3766403, 3799442, 3832481, 3865519, 3898558, 3931596, 
  3964635, 3997674, 4030712, 4063751, 4096790, 4129828, 4162867, 4195905, 
  4228944, 4261983, 4295021, 4328060, 4361099, 4394137, 4427176, 4460214, 
  4493253, 4526292, 4559330, 4592369, 4625408, 4658446, 4691485, 4724523, 
  4757562, 4790601, 4823639, 4856678, 4889717, 4922755, 4955794, 4988832, 
  5021871, 5054910, 5087948, 5120987, 5154026, 5187064, 5220103, 5253141, 
  5286180, 5319219, 5352257, 5385296, 5418335, 5451373, 5484412, 5517450, 
  5550489, 5583528, 5616566, 5649605, 5682644, 5715682, 5748721, 5781759, 
  5814798, 5847837, 5880875, 5913914, 5946953, 5979991, 6013030, 6046068, 
  6079107, 6112146, 6145184, 6178223, 6211262, 6244300, 6277339, 6310377, 
  6343416, 6376455, 6409493, 6442532, 6475571, 6508609, 6541648, 6574686, 
  6607725, 6640764, 6673802, 6706841, 6739880, 6772918, 6805957, 6838995, 
  6872034, 6905073, 6938111, 6971150, 7004189, 7037227, 7070266, 7103304, 
  7136343, 7169382, 7202420, 7235459, 7268498, 7301536, 7334575, 7367613, 
  7400652, 7433691, 7466729, 7499768, 7532807, 7565845, 7598884, 7631922, 
  7664961, 7698000, 7731038, 7764077, 7797116, 7830154, 7863193, 7896231, 
  7929270, 7962309, 7995347, 8028386, 8061425, 8094463, 8127502, 8160540, 
  8193579, 8226618, 8259656, 8292695, 8325734, 8358772, 8391811, 8424849, 
};

const int gavl_b_to_y[256] = 
{
  0, 6416, 12833, 19249, 25665, 32082, 38498, 44915, 
  51331, 57747, 64164, 70580, 76996, 83413, 89829, 96245, 
  102662, 109078, 115494, 121911, 128327, 134744, 141160, 147576, 
  153993, 160409, 166825, 173242, 179658, 186074, 192491, 198907, 
  205324, 211740, 218156, 224573, 230989, 237405, 243822, 250238, 
  256654, 263071, 269487, 275903, 282320, 288736, 295153, 301569, 
  307985, 314402, 320818, 327234, 333651, 340067, 346483, 352900, 
  359316, 365733, 372149, 378565, 384982, 391398, 397814, 404231, 
  410647, 417063, 423480, 429896, 436312, 442729, 449145, 455562, 
  461978, 468394, 474811, 481227, 487643, 494060, 500476, 506892, 
  513309, 519725, 526142, 532558, 538974, 545391, 551807, 558223, 
  564640, 571056, 577472, 583889, 590305, 596721, 603138, 609554, 
  615971, 622387, 628803, 635220, 641636, 648052, 654469, 660885, 
  667301, 673718, 680134, 686551, 692967, 699383, 705800, 712216, 
  718632, 725049, 731465, 737881, 744298, 750714, 757130, 763547, 
  769963, 776380, 782796, 789212, 795629, 802045, 808461, 814878, 
  821294, 827710, 834127, 840543, 846960, 853376, 859792, 866209, 
  872625, 879041, 885458, 891874, 898290, 904707, 911123, 917539, 
  923956, 930372, 936789, 943205, 949621, 956038, 962454, 968870, 
  975287, 981703, 988119, 994536, 1000952, 1007369, 1013785, 1020201, 
  1026618, 1033034, 1039450, 1045867, 1052283, 1058699, 1065116, 1071532, 
  1077948, 1084365, 1090781, 1097198, 1103614, 1110030, 1116447, 1122863, 
  1129279, 1135696, 1142112, 1148528, 1154945, 1161361, 1167778, 1174194, 
  1180610, 1187027, 1193443, 1199859, 1206276, 1212692, 1219108, 1225525, 
  1231941, 1238357, 1244774, 1251190, 1257607, 1264023, 1270439, 1276856, 
  1283272, 1289688, 1296105, 1302521, 1308937, 1315354, 1321770, 1328187, 
  1334603, 1341019, 1347436, 1353852, 1360268, 1366685, 1373101, 1379517, 
  1385934, 1392350, 1398766, 1405183, 1411599, 1418016, 1424432, 1430848, 
  1437265, 1443681, 1450097, 1456514, 1462930, 1469346, 1475763, 1482179, 
  1488595, 1495012, 1501428, 1507845, 1514261, 1520677, 1527094, 1533510, 
  1539926, 1546343, 1552759, 1559175, 1565592, 1572008, 1578425, 1584841, 
  1591257, 1597674, 1604090, 1610506, 1616923, 1623339, 1629755, 1636172, 
};

const int gavl_r_to_u[256] = 
{
  0, -9713, -19427, -29142, -38856, -48570, -58284, -67998, 
  -77712, -87427, -97141, -106855, -116569, -126283, -135997, -145712, 
  -155426, -165140, -174854, -184568, -194282, -203997, -213711, -223425, 
  -233139, -242853, -252567, -262282, -271996, -281710, -291424, -301138, 
  -310853, -320567, -330281, -339995, -349709, -359423, -369138, -378852, 
  -388566, -398280, -407994, -417708, -427423, -437137, -446851, -456565, 
  -466279, -475993, -485708, -495422, -505136, -514850, -524564, -534278, 
  -543993, -553707, -563421, -573135, -582849, -592564, -602278, -611992, 
  -621706, -631420, -641134, -650849, -660563, -670277, -679991, -689705, 
  -699419, -709134, -718848, -728562, -738276, -747990, -757704, -767419, 
  -777133, -786847, -796561, -806275, -815989, -825704, -835418, -845132, 
  -854846, -864560, -874275, -883989, -893703, -903417, -913131, -922845, 
  -932560, -942274, -951988, -961702, -971416, -981130, -990845, -1000559, 
  -1010273, -1019987, -1029701, -1039415, -1049130, -1058844, -1068558, -1078272, 
  -1087986, -1097700, -1107415, -1117129, -1126843, -1136557, -1146271, -1155986, 
  -1165700, -1175414, -1185128, -1194842, -1204556, -1214271, -1223985, -1233699, 
  -1243413, -1253127, -1262841, -1272556, -1282270, -1291984, -1301698, -1311412, 
  -1321126, -1330841, -1340555, -1350269, -1359983, -1369697, -1379412, -1389126, 
  -1398840, -1408554, -1418268, -1427982, -1437697, -1447411, -1457125, -1466839, 
  -1476553, -1486267, -1495982, -1505696, -1515410, -1525124, -1534838, -1544552, 
  -1554267, -1563981, -1573695, -1583409, -1593123, -1602837, -1612552, -1622266, 
  -1631980, -1641694, -1651408, -1661123, -1670837, -1680551, -1690265, -1699979, 
  -1709693, -1719408, -1729122, -1738836, -1748550, -1758264, -1767978, -1777693, 
  -1787407, -1797121, -1806835, -1816549, -1826263, -1835978, -1845692, -1855406, 
  -1865120, -1874834, -1884548, -1894263, -1903977, -1913691, -1923405, -1933119, 
  -1942834, -1952548, -1962262, -1971976, -1981690, -1991404, -2001119, -2010833, 
  -2020547, -2030261, -2039975, -2049689, -2059404, -2069118, -2078832, -2088546, 
  -2098260, -2107974, -2117689, -2127403, -2137117, -2146831, -2156545, -2166259, 
  -2175974, -2185688, -2195402, -2205116, -2214830, -2224545, -2234259, -2243973, 
  -2253687, -2263401, -2273115, -2282830, -2292544, -2302258, -2311972, -2321686, 
  -2331400, -2341115, -2350829, -2360543, -2370257, -2379971, -2389685, -2399400, 
  -2409114, -2418828, -2428542, -2438256, -2447970, -2457685, -2467399, -2477113, 
};

const int gavl_g_to_u[256] = 
{
  0, -19069, -38140, -57210, -76280, -95350, -114421, -133491, 
  -152561, -171631, -190702, -209772, -228842, -247912, -266983, -286053, 
  -305123, -324194, -343264, -362334, -381404, -400475, -419545, -438615, 
  -457685, -476756, -495826, -514896, -533966, -553037, -572107, -591177, 
  -610248, -629318, -648388, -667458, -686529, -705599, -724669, -743739, 
  -762810, -781880, -800950, -820020, -839091, -858161, -877231, -896302, 
  -915372, -934442, -953512, -972583, -991653, -1010723, -1029793, -1048864, 
  -1067934, -1087004, -1106074, -1125145, -1144215, -1163285, -1182356, -1201426, 
  -1220496, -1239566, -1258637, -1277707, -1296777, -1315847, -1334918, -1353988, 
  -1373058, -1392128, -1411199, -1430269, -1449339, -1468410, -1487480, -1506550, 
  -1525620, -1544691, -1563761, -1582831, -1601901, -1620972, -1640042, -1659112, 
  -1678182, -1697253, -1716323, -1735393, -1754464, -1773534, -1792604, -1811674, 
  -1830745, -1849815, -1868885, -1887955, -1907026, -1926096, -1945166, -1964236, 
  -1983307, -2002377, -2021447, -2040518, -2059588, -2078658, -2097728, -2116799, 
  -2135869, -2154939, -2174009, -2193080, -2212150, -2231220, -2250290, -2269361, 
  -2288431, -2307501, -2326572, -2345642, -2364712, -2383782, -2402853, -2421923, 
  -2440993, -2460063, -2479134, -2498204, -2517274, -2536344, -2555415, -2574485, 
  -2593555, -2612626, -2631696, -2650766, -2669836, -2688907, -2707977, -2727047, 
  -2746117, -2765188, -2784258, -2803328, -2822398, -2841469, -2860539, -2879609, 
  -2898680, -2917750, -2936820, -2955890, -2974961, -2994031, -3013101, -3032171, 
  -3051242, -3070312, -3089382, -3108452, -3127523, -3146593, -3165663, -3184734, 
  -3203804, -3222874, -3241944, -3261015, -3280085, -3299155, -3318225, -3337296, 
  -3356366, -3375436, -3394506, -3413577, -3432647, -3451717, -3470788, -3489858, 
  -3508928, -3527998, -3547069, -3566139, -3585209, -3604279, -3623350, -3642420, 
  -3661490, -3680560, -3699631, -3718701, -3737771, -3756842, -3775912, -3794982, 
  -3814052, -3833123, -3852193, -3871263, -3890333, -3909404, -3928474, -3947544, 
  -3966614, -3985685, -4004755, -4023825, -4042896, -4061966, -4081036, -4100106, 
  -4119177, -4138247, -4157317, -4176387, -4195458, -4214528, -4233598, -4252668, 
  -4271739, -4290809, -4309879, -4328950, -4348020, -4367090, -4386160, -4405231, 
  -4424301, -4443371, -4462441, -4481512, -4500582, -4519652, -4538722, -4557793, 
  -4576863, -4595933, -4615004, -4634074, -4653144, -4672214, -4691285, -4710355, 
  -4729425, -4748495, -4767566, -4786636, -4805706, -4824776, -4843847, -4862917, 
};

const int gavl_b_to_u[256] = 
{
  8388608, 8417392, 8446177, 8474961, 8503746, 8532530, 8561315, 8590099, 
  8618884, 8647668, 8676452, 8705237, 8734021, 8762806, 8791590, 8820375, 
  8849159, 8877943, 8906728, 8935512, 8964297, 8993081, 9021866, 9050650, 
  9079435, 9108219, 9137003, 9165788, 9194572, 9223357, 9252141, 9280926, 
  9309710, 9338494, 9367279, 9396063, 9424848, 9453632, 9482417, 9511201, 
  9539986, 9568770, 9597554, 9626339, 9655123, 9683908, 9712692, 9741477, 
  9770261, 9799046, 9827830, 9856614, 9885399, 9914183, 9942968, 9971752, 
  10000537, 10029321, 10058105, 10086890, 10115674, 10144459, 10173243, 10202028, 
  10230812, 10259597, 10288381, 10317165, 10345950, 10374734, 10403519, 10432303, 
  10461088, 10489872, 10518657, 10547441, 10576225, 10605010, 10633794, 10662579, 
  10691363, 10720148, 10748932, 10777716, 10806501, 10835285, 10864070, 10892854, 
  10921639, 10950423, 10979208, 11007992, 11036776, 11065561, 11094345, 11123130, 
  11151914, 11180699, 11209483, 11238267, 11267052, 11295836, 11324621, 11353405, 
  11382190, 11410974, 11439759, 11468543, 11497327, 11526112, 11554896, 11583681, 
  11612465, 11641250, 11670034, 11698819, 11727603, 11756387, 11785172, 11813956, 
  11842741, 11871525, 11900310, 11929094, 11957878, 11986663, 12015447, 12044232, 
  12073016, 12101801, 12130585, 12159370, 12188154, 12216938, 12245723, 12274507, 
  12303292, 12332076, 12360861, 12389645, 12418429, 12447214, 12475998, 12504783, 
  12533567, 12562352, 12591136, 12619921, 12648705, 12677489, 12706274, 12735058, 
  12763843, 12792627, 12821412, 12850196, 12878981, 12907765, 12936549, 12965334, 
  12994118, 13022903, 13051687, 13080472, 13109256, 13138040, 13166825, 13195609, 
  13224394, 13253178, 13281963, 13310747, 13339532, 13368316, 13397100, 13425885, 
  13454669, 13483454, 13512238, 13541023, 13569807, 13598591, 13627376, 13656160, 
  13684945, 13713729, 13742514, 13771298, 13800083, 13828867, 13857651, 13886436, 
  13915220, 13944005, 13972789, 14001574, 14030358, 14059143, 14087927, 14116711, 
  14145496, 14174280, 14203065, 14231849, 14260634, 14289418, 14318202, 14346987, 
  14375771, 14404556, 14433340, 14462125, 14490909, 14519694, 14548478, 14577262, 
  14606047, 14634831, 14663616, 14692400, 14721185, 14749969, 14778754, 14807538, 
  14836322, 14865107, 14893891, 14922676, 14951460, 14980245, 15009029, 15037813, 
  15066598, 15095382, 15124167, 15152951, 15181736, 15210520, 15239305, 15268089, 
  15296873, 15325658, 15354442, 15383227, 15412011, 15440796, 15469580, 15498364, 
  15527149, 15555933, 15584718, 15613502, 15642287, 15671071, 15699856, 15728640, 
};

const int gavl_r_to_v[256] = 
{
  0, 28784, 57569, 86353, 115138, 143922, 172707, 201491, 
  230276, 259060, 287844, 316629, 345413, 374198, 402982, 431767, 
  460551, 489335, 518120, 546904, 575689, 604473, 633258, 662042, 
  690827, 719611, 748395, 777180, 805964, 834749, 863533, 892318, 
  921102, 949886, 978671, 1007455, 1036240, 1065024, 1093809, 1122593, 
  1151378, 1180162, 1208946, 1237731, 1266515, 1295300, 1324084, 1352869, 
  1381653, 1410438, 1439222, 1468006, 1496791, 1525575, 1554360, 1583144, 
  1611929, 1640713, 1669497, 1698282, 1727066, 1755851, 1784635, 1813420, 
  1842204, 1870989, 1899773, 1928557, 1957342, 1986126, 2014911, 2043695, 
  2072480, 2101264, 2130049, 2158833, 2187617, 2216402, 2245186, 2273971, 
  2302755, 2331540, 2360324, 2389108, 2417893, 2446677, 2475462, 2504246, 
  2533031, 2561815, 2590600, 2619384, 2648168, 2676953, 2705737, 2734522, 
  2763306, 2792091, 2820875, 2849659, 2878444, 2907228, 2936013, 2964797, 
  2993582, 3022366, 3051151, 3079935, 3108719, 3137504, 3166288, 3195073, 
  3223857, 3252642, 3281426, 3310211, 3338995, 3367779, 3396564, 3425348, 
  3454133, 3482917, 3511702, 3540486, 3569270, 3598055, 3626839, 3655624, 
  3684408, 3713193, 3741977, 3770762, 3799546, 3828330, 3857115, 3885899, 
  3914684, 3943468, 3972253, 4001037, 4029821, 4058606, 4087390, 4116175, 
  4144959, 4173744, 4202528, 4231313, 4260097, 4288881, 4317666, 4346450, 
  4375235, 4404019, 4432804, 4461588, 4490373, 4519157, 4547941, 4576726, 
  4605510, 4634295, 4663079, 4691864, 4720648, 4749432, 4778217, 4807001, 
  4835786, 4864570, 4893355, 4922139, 4950924, 4979708, 5008492, 5037277, 
  5066061, 5094846, 5123630, 5152415, 5181199, 5209983, 5238768, 5267552, 
  5296337, 5325121, 5353906, 5382690, 5411475, 5440259, 5469043, 5497828, 
  5526612, 5555397, 5584181, 5612966, 5641750, 5670535, 5699319, 5728103, 
  5756888, 5785672, 5814457, 5843241, 5872026, 5900810, 5929594, 5958379, 
  5987163, 6015948, 6044732, 6073517, 6102301, 6131086, 6159870, 6188654, 
  6217439, 6246223, 6275008, 6303792, 6332577, 6361361, 6390146, 6418930, 
  6447714, 6476499, 6505283, 6534068, 6562852, 6591637, 6620421, 6649205, 
  6677990, 6706774, 6735559, 6764343, 6793128, 6821912, 6850697, 6879481, 
  6908265, 6937050, 6965834, 6994619, 7023403, 7052188, 7080972, 7109756, 
  7138541, 7167325, 7196110, 7224894, 7253679, 7282463, 7311248, 7340032, 
};

const int gavl_g_to_v[256] = 
{
  0, -24103, -48206, -72310, -96413, -120517, -144620, -168724, 
  -192827, -216931, -241034, -265138, -289241, -313345, -337448, -361552, 
  -385655, -409759, -433862, -457966, -482069, -506173, -530276, -554380, 
  -578483, -602587, -626690, -650794, -674897, -699001, -723104, -747208, 
  -771311, -795415, -819518, -843622, -867725, -891829, -915933, -940036, 
  -964140, -988243, -1012347, -1036450, -1060554, -1084657, -1108761, -1132864, 
  -1156968, -1181071, -1205175, -1229278, -1253382, -1277485, -1301589, -1325692, 
  -1349796, -1373899, -1398003, -1422106, -1446210, -1470313, -1494417, -1518520, 
  -1542624, -1566727, -1590831, -1614934, -1639038, -1663141, -1687245, -1711348, 
  -1735452, -1759556, -1783659, -1807763, -1831866, -1855970, -1880073, -1904177, 
  -1928280, -1952384, -1976487, -2000591, -2024694, -2048798, -2072901, -2097005, 
  -2121108, -2145212, -2169315, -2193419, -2217522, -2241626, -2265729, -2289833, 
  -2313936, -2338040, -2362143, -2386247, -2410350, -2434454, -2458557, -2482661, 
  -2506764, -2530868, -2554971, -2579075, -2603178, -2627282, -2651386, -2675489, 
  -2699593, -2723696, -2747800, -2771903, -2796007, -2820110, -2844214, -2868317, 
  -2892421, -2916524, -2940628, -2964731, -2988835, -3012938, -3037042, -3061145, 
  -3085249, -3109352, -3133456, -3157559, -3181663, -3205766, -3229870, -3253973, 
  -3278077, -3302180, -3326284, -3350387, -3374491, -3398594, -3422698, -3446801, 
  -3470905, -3495008, -3519112, -3543216, -3567319, -3591423, -3615526, -3639630, 
  -3663733, -3687837, -3711940, -3736044, -3760147, -3784251, -3808354, -3832458, 
  -3856561, -3880665, -3904768, -3928872, -3952975, -3977079, -4001182, -4025286, 
  -4049389, -4073493, -4097596, -4121700, -4145803, -4169907, -4194010, -4218114, 
  -4242217, -4266321, -4290424, -4314528, -4338631, -4362735, -4386838, -4410942, 
  -4435046, -4459149, -4483253, -4507356, -4531460, -4555563, -4579667, -4603770, 
  -4627874, -4651977, -4676081, -4700184, -4724288, -4748391, -4772495, -4796598, 
  -4820702, -4844805, -4868909, -4893012, -4917116, -4941219, -4965323, -4989426, 
  -5013530, -5037633, -5061737, -5085840, -5109944, -5134047, -5158151, -5182254, 
  -5206358, -5230461, -5254565, -5278669, -5302772, -5326876, -5350979, -5375083, 
  -5399186, -5423290, -5447393, -5471497, -5495600, -5519704, -5543807, -5567911, 
  -5592014, -5616118, -5640221, -5664325, -5688428, -5712532, -5736635, -5760739, 
  -5784842, -5808946, -5833049, -5857153, -5881256, -5905360, -5929463, -5953567, 
  -5977670, -6001774, -6025877, -6049981, -6074084, -6098188, -6122291, -6146395, 
};

const int gavl_b_to_v[256] = 
{
  8388608, 8383927, 8379246, 8374565, 8369884, 8365203, 8360522, 8355842, 
  8351161, 8346480, 8341799, 8337118, 8332437, 8327756, 8323075, 8318394, 
  8313713, 8309032, 8304351, 8299670, 8294989, 8290309, 8285628, 8280947, 
  8276266, 8271585, 8266904, 8262223, 8257542, 8252861, 8248180, 8243499, 
  8238818, 8234137, 8229457, 8224776, 8220095, 8215414, 8210733, 8206052, 
  8201371, 8196690, 8192009, 8187328, 8182647, 8177966, 8173285, 8168605, 
  8163924, 8159243, 8154562, 8149881, 8145200, 8140519, 8135838, 8131157, 
  8126476, 8121795, 8117114, 8112433, 8107752, 8103072, 8098391, 8093710, 
  8089029, 8084348, 8079667, 8074986, 8070305, 8065624, 8060943, 8056262, 
  8051581, 8046900, 8042220, 8037539, 8032858, 8028177, 8023496, 8018815, 
  8014134, 8009453, 8004772, 8000091, 7995410, 7990729, 7986048, 7981367, 
  7976687, 7972006, 7967325, 7962644, 7957963, 7953282, 7948601, 7943920, 
  7939239, 7934558, 7929877, 7925196, 7920515, 7915835, 7911154, 7906473, 
  7901792, 7897111, 7892430, 7887749, 7883068, 7878387, 7873706, 7869025, 
  7864344, 7859663, 7854982, 7850302, 7845621, 7840940, 7836259, 7831578, 
  7826897, 7822216, 7817535, 7812854, 7808173, 7803492, 7798811, 7794130, 
  7789450, 7784769, 7780088, 7775407, 7770726, 7766045, 7761364, 7756683, 
  7752002, 7747321, 7742640, 7737959, 7733278, 7728598, 7723917, 7719236, 
  7714555, 7709874, 7705193, 7700512, 7695831, 7691150, 7686469, 7681788, 
  7677107, 7672426, 7667745, 7663065, 7658384, 7653703, 7649022, 7644341, 
  7639660, 7634979, 7630298, 7625617, 7620936, 7616255, 7611574, 7606893, 
  7602213, 7597532, 7592851, 7588170, 7583489, 7578808, 7574127, 7569446, 
  7564765, 7560084, 7555403, 7550722, 7546041, 7541360, 7536680, 7531999, 
  7527318, 7522637, 7517956, 7513275, 7508594, 7503913, 7499232, 7494551, 
  7489870, 7485189, 7480508, 7475828, 7471147, 7466466, 7461785, 7457104, 
  7452423, 7447742, 7443061, 7438380, 7433699, 7429018, 7424337, 7419656, 
  7414975, 7410295, 7405614, 7400933, 7396252, 7391571, 7386890, 7382209, 
  7377528, 7372847, 7368166, 7363485, 7358804, 7354123, 7349443, 7344762, 
  7340081, 7335400, 7330719, 7326038, 7321357, 7316676, 7311995, 7307314, 
  7302633, 7297952, 7293271, 7288591, 7283910, 7279229, 7274548, 7269867, 
  7265186, 7260505, 7255824, 7251143, 7246462, 7241781, 7237100, 7232419, 
  7227738, 7223058, 7218377, 7213696, 7209015, 7204334, 7199653, 7194972, 
};

/* RGB -> YUVJ conversions */
const int gavl_r_to_yj[256] = 
{
  0, 19595, 39191, 58786, 78381, 97976, 117572, 137167, 
  156762, 176357, 195953, 215548, 235143, 254738, 274334, 293929, 
  313524, 333119, 352715, 372310, 391905, 411501, 431096, 450691, 
  470286, 489882, 509477, 529072, 548667, 568263, 587858, 607453, 
  627048, 646644, 666239, 685834, 705430, 725025, 744620, 764215, 
  783811, 803406, 823001, 842596, 862192, 881787, 901382, 920977, 
  940573, 960168, 979763, 999358, 1018954, 1038549, 1058144, 1077740, 
  1097335, 1116930, 1136525, 1156121, 1175716, 1195311, 1214906, 1234502, 
  1254097, 1273692, 1293287, 1312883, 1332478, 1352073, 1371668, 1391264, 
  1410859, 1430454, 1450050, 1469645, 1489240, 1508835, 1528431, 1548026, 
  1567621, 1587216, 1606812, 1626407, 1646002, 1665597, 1685193, 1704788, 
  1724383, 1743978, 1763574, 1783169, 1802764, 1822360, 1841955, 1861550, 
  1881145, 1900741, 1920336, 1939931, 1959526, 1979122, 1998717, 2018312, 
  2037907, 2057503, 2077098, 2096693, 2116289, 2135884, 2155479, 2175074, 
  2194670, 2214265, 2233860, 2253455, 2273051, 2292646, 2312241, 2331836, 
  2351432, 2371027, 2390622, 2410217, 2429813, 2449408, 2469003, 2488599, 
  2508194, 2527789, 2547384, 2566980, 2586575, 2606170, 2625765, 2645361, 
  2664956, 2684551, 2704146, 2723742, 2743337, 2762932, 2782527, 2802123, 
  2821718, 2841313, 2860909, 2880504, 2900099, 2919694, 2939290, 2958885, 
  2978480, 2998075, 3017671, 3037266, 3056861, 3076456, 3096052, 3115647, 
  3135242, 3154838, 3174433, 3194028, 3213623, 3233219, 3252814, 3272409, 
  3292004, 3311600, 3331195, 3350790, 3370385, 3389981, 3409576, 3429171, 
  3448766, 3468362, 3487957, 3507552, 3527148, 3546743, 3566338, 3585933, 
  3605529, 3625124, 3644719, 3664314, 3683910, 3703505, 3723100, 3742695, 
  3762291, 3781886, 3801481, 3821076, 3840672, 3860267, 3879862, 3899458, 
  3919053, 3938648, 3958243, 3977839, 3997434, 4017029, 4036624, 4056220, 
  4075815, 4095410, 4115005, 4134601, 4154196, 4173791, 4193386, 4212982, 
  4232577, 4252172, 4271768, 4291363, 4310958, 4330553, 4350149, 4369744, 
  4389339, 4408934, 4428530, 4448125, 4467720, 4487315, 4506911, 4526506, 
  4546101, 4565697, 4585292, 4604887, 4624482, 4644078, 4663673, 4683268, 
  4702863, 4722459, 4742054, 4761649, 4781244, 4800840, 4820435, 4840030, 
  4859625, 4879221, 4898816, 4918411, 4938007, 4957602, 4977197, 4996792, 
};

const int gavl_g_to_yj[256] = 
{
  0, 38470, 76939, 115409, 153879, 192348, 230818, 269287, 
  307757, 346227, 384696, 423166, 461636, 500105, 538575, 577044, 
  615514, 653984, 692453, 730923, 769393, 807862, 846332, 884802, 
  923271, 961741, 1000210, 1038680, 1077150, 1115619, 1154089, 1192559, 
  1231028, 1269498, 1307967, 1346437, 1384907, 1423376, 1461846, 1500316, 
  1538785, 1577255, 1615725, 1654194, 1692664, 1731133, 1769603, 1808073, 
  1846542, 1885012, 1923482, 1961951, 2000421, 2038890, 2077360, 2115830, 
  2154299, 2192769, 2231239, 2269708, 2308178, 2346648, 2385117, 2423587, 
  2462056, 2500526, 2538996, 2577465, 2615935, 2654405, 2692874, 2731344, 
  2769814, 2808283, 2846753, 2885222, 2923692, 2962162, 3000631, 3039101, 
  3077571, 3116040, 3154510, 3192979, 3231449, 3269919, 3308388, 3346858, 
  3385328, 3423797, 3462267, 3500737, 3539206, 3577676, 3616145, 3654615, 
  3693085, 3731554, 3770024, 3808494, 3846963, 3885433, 3923902, 3962372, 
  4000842, 4039311, 4077781, 4116251, 4154720, 4193190, 4231660, 4270129, 
  4308599, 4347068, 4385538, 4424008, 4462477, 4500947, 4539417, 4577886, 
  4616356, 4654825, 4693295, 4731765, 4770234, 4808704, 4847174, 4885643, 
  4924113, 4962583, 5001052, 5039522, 5077991, 5116461, 5154931, 5193400, 
  5231870, 5270340, 5308809, 5347279, 5385748, 5424218, 5462688, 5501157, 
  5539627, 5578097, 5616566, 5655036, 5693506, 5731975, 5770445, 5808914, 
  5847384, 5885854, 5924323, 5962793, 6001263, 6039732, 6078202, 6116671, 
  6155141, 6193611, 6232080, 6270550, 6309020, 6347489, 6385959, 6424429, 
  6462898, 6501368, 6539837, 6578307, 6616777, 6655246, 6693716, 6732186, 
  6770655, 6809125, 6847594, 6886064, 6924534, 6963003, 7001473, 7039943, 
  7078412, 7116882, 7155352, 7193821, 7232291, 7270760, 7309230, 7347700, 
  7386169, 7424639, 7463109, 7501578, 7540048, 7578518, 7616987, 7655457, 
  7693926, 7732396, 7770866, 7809335, 7847805, 7886275, 7924744, 7963214, 
  8001683, 8040153, 8078623, 8117092, 8155562, 8194032, 8232501, 8270971, 
  8309441, 8347910, 8386380, 8424849, 8463319, 8501789, 8540258, 8578728, 
  8617198, 8655667, 8694137, 8732606, 8771076, 8809546, 8848015, 8886485, 
  8924955, 8963424, 9001894, 9040364, 9078833, 9117303, 9155772, 9194242, 
  9232712, 9271181, 9309651, 9348121, 9386590, 9425060, 9463529, 9501999, 
  9540469, 9578938, 9617408, 9655878, 9694347, 9732817, 9771287, 9809756, 
};

const int gavl_b_to_yj[256] = 
{
  0, 7471, 14942, 22413, 29884, 37356, 44827, 52298, 
  59769, 67240, 74711, 82182, 89653, 97124, 104595, 112067, 
  119538, 127009, 134480, 141951, 149422, 156893, 164364, 171835, 
  179306, 186778, 194249, 201720, 209191, 216662, 224133, 231604, 
  239075, 246546, 254018, 261489, 268960, 276431, 283902, 291373, 
  298844, 306315, 313786, 321257, 328729, 336200, 343671, 351142, 
  358613, 366084, 373555, 381026, 388497, 395969, 403440, 410911, 
  418382, 425853, 433324, 440795, 448266, 455737, 463208, 470680, 
  478151, 485622, 493093, 500564, 508035, 515506, 522977, 530448, 
  537919, 545391, 552862, 560333, 567804, 575275, 582746, 590217, 
  597688, 605159, 612631, 620102, 627573, 635044, 642515, 649986, 
  657457, 664928, 672399, 679870, 687342, 694813, 702284, 709755, 
  717226, 724697, 732168, 739639, 747110, 754582, 762053, 769524, 
  776995, 784466, 791937, 799408, 806879, 814350, 821821, 829293, 
  836764, 844235, 851706, 859177, 866648, 874119, 881590, 889061, 
  896532, 904004, 911475, 918946, 926417, 933888, 941359, 948830, 
  956301, 963772, 971244, 978715, 986186, 993657, 1001128, 1008599, 
  1016070, 1023541, 1031012, 1038483, 1045955, 1053426, 1060897, 1068368, 
  1075839, 1083310, 1090781, 1098252, 1105723, 1113194, 1120666, 1128137, 
  1135608, 1143079, 1150550, 1158021, 1165492, 1172963, 1180434, 1187906, 
  1195377, 1202848, 1210319, 1217790, 1225261, 1232732, 1240203, 1247674, 
  1255145, 1262617, 1270088, 1277559, 1285030, 1292501, 1299972, 1307443, 
  1314914, 1322385, 1329857, 1337328, 1344799, 1352270, 1359741, 1367212, 
  1374683, 1382154, 1389625, 1397096, 1404568, 1412039, 1419510, 1426981, 
  1434452, 1441923, 1449394, 1456865, 1464336, 1471807, 1479279, 1486750, 
  1494221, 1501692, 1509163, 1516634, 1524105, 1531576, 1539047, 1546519, 
  1553990, 1561461, 1568932, 1576403, 1583874, 1591345, 1598816, 1606287, 
  1613758, 1621230, 1628701, 1636172, 1643643, 1651114, 1658585, 1666056, 
  1673527, 1680998, 1688470, 1695941, 1703412, 1710883, 1718354, 1725825, 
  1733296, 1740767, 1748238, 1755709, 1763181, 1770652, 1778123, 1785594, 
  1793065, 1800536, 1808007, 1815478, 1822949, 1830420, 1837892, 1845363, 
  1852834, 1860305, 1867776, 1875247, 1882718, 1890189, 1897660, 1905132, 
};

const int gavl_r_to_uj[256] = 
{
  0, -11058, -22116, -33175, -44233, -55292, -66350, -77409, 
  -88467, -99526, -110584, -121643, -132702, -143760, -154819, -165877, 
  -176936, -187994, -199053, -210111, -221170, -232228, -243287, -254346, 
  -265404, -276463, -287521, -298580, -309638, -320697, -331755, -342814, 
  -353872, -364931, -375990, -387048, -398107, -409165, -420224, -431282, 
  -442341, -453399, -464458, -475516, -486575, -497634, -508692, -519751, 
  -530809, -541868, -552926, -563985, -575043, -586102, -597160, -608219, 
  -619277, -630336, -641395, -652453, -663512, -674570, -685629, -696687, 
  -707746, -718804, -729863, -740921, -751980, -763039, -774097, -785156, 
  -796214, -807273, -818331, -829390, -840448, -851507, -862565, -873624, 
  -884683, -895741, -906800, -917858, -928917, -939975, -951034, -962092, 
  -973151, -984209, -995268, -1006327, -1017385, -1028444, -1039502, -1050561, 
  -1061619, -1072678, -1083736, -1094795, -1105853, -1116912, -1127971, -1139029, 
  -1150088, -1161146, -1172205, -1183263, -1194322, -1205380, -1216439, -1227497, 
  -1238556, -1249615, -1260673, -1271732, -1282790, -1293849, -1304907, -1315966, 
  -1327024, -1338083, -1349141, -1360200, -1371259, -1382317, -1393376, -1404434, 
  -1415493, -1426551, -1437610, -1448668, -1459727, -1470785, -1481844, -1492903, 
  -1503961, -1515020, -1526078, -1537137, -1548195, -1559254, -1570312, -1581371, 
  -1592429, -1603488, -1614547, -1625605, -1636664, -1647722, -1658781, -1669839, 
  -1680898, -1691956, -1703015, -1714073, -1725132, -1736191, -1747249, -1758308, 
  -1769366, -1780425, -1791483, -1802542, -1813600, -1824659, -1835717, -1846776, 
  -1857834, -1868893, -1879952, -1891010, -1902069, -1913127, -1924186, -1935244, 
  -1946303, -1957361, -1968420, -1979478, -1990537, -2001596, -2012654, -2023713, 
  -2034771, -2045830, -2056888, -2067947, -2079005, -2090064, -2101122, -2112181, 
  -2123240, -2134298, -2145357, -2156415, -2167474, -2178532, -2189591, -2200649, 
  -2211708, -2222766, -2233825, -2244884, -2255942, -2267001, -2278059, -2289118, 
  -2300176, -2311235, -2322293, -2333352, -2344410, -2355469, -2366528, -2377586, 
  -2388645, -2399703, -2410762, -2421820, -2432879, -2443937, -2454996, -2466054, 
  -2477113, -2488172, -2499230, -2510289, -2521347, -2532406, -2543464, -2554523, 
  -2565581, -2576640, -2587698, -2598757, -2609816, -2620874, -2631933, -2642991, 
  -2654050, -2665108, -2676167, -2687225, -2698284, -2709342, -2720401, -2731460, 
  -2742518, -2753577, -2764635, -2775694, -2786752, -2797811, -2808869, -2819928, 
};

const int gavl_g_to_uj[256] = 
{
  0, -21708, -43418, -65127, -86837, -108546, -130256, -151965, 
  -173675, -195384, -217094, -238803, -260512, -282222, -303931, -325641, 
  -347350, -369060, -390769, -412479, -434188, -455898, -477607, -499316, 
  -521026, -542735, -564445, -586154, -607864, -629573, -651283, -672992, 
  -694702, -716411, -738120, -759830, -781539, -803249, -824958, -846668, 
  -868377, -890087, -911796, -933506, -955215, -976924, -998634, -1020343, 
  -1042053, -1063762, -1085472, -1107181, -1128891, -1150600, -1172310, -1194019, 
  -1215729, -1237438, -1259147, -1280857, -1302566, -1324276, -1345985, -1367695, 
  -1389404, -1411114, -1432823, -1454533, -1476242, -1497951, -1519661, -1541370, 
  -1563080, -1584789, -1606499, -1628208, -1649918, -1671627, -1693337, -1715046, 
  -1736755, -1758465, -1780174, -1801884, -1823593, -1845303, -1867012, -1888722, 
  -1910431, -1932141, -1953850, -1975559, -1997269, -2018978, -2040688, -2062397, 
  -2084107, -2105816, -2127526, -2149235, -2170945, -2192654, -2214363, -2236073, 
  -2257782, -2279492, -2301201, -2322911, -2344620, -2366330, -2388039, -2409749, 
  -2431458, -2453167, -2474877, -2496586, -2518296, -2540005, -2561715, -2583424, 
  -2605134, -2626843, -2648553, -2670262, -2691971, -2713681, -2735390, -2757100, 
  -2778809, -2800519, -2822228, -2843938, -2865647, -2887357, -2909066, -2930775, 
  -2952485, -2974194, -2995904, -3017613, -3039323, -3061032, -3082742, -3104451, 
  -3126161, -3147870, -3169579, -3191289, -3212998, -3234708, -3256417, -3278127, 
  -3299836, -3321546, -3343255, -3364965, -3386674, -3408383, -3430093, -3451802, 
  -3473512, -3495221, -3516931, -3538640, -3560350, -3582059, -3603769, -3625478, 
  -3647188, -3668897, -3690606, -3712316, -3734025, -3755735, -3777444, -3799154, 
  -3820863, -3842573, -3864282, -3885992, -3907701, -3929410, -3951120, -3972829, 
  -3994539, -4016248, -4037958, -4059667, -4081377, -4103086, -4124796, -4146505, 
  -4168214, -4189924, -4211633, -4233343, -4255052, -4276762, -4298471, -4320181, 
  -4341890, -4363600, -4385309, -4407018, -4428728, -4450437, -4472147, -4493856, 
  -4515566, -4537275, -4558985, -4580694, -4602404, -4624113, -4645822, -4667532, 
  -4689241, -4710951, -4732660, -4754370, -4776079, -4797789, -4819498, -4841208, 
  -4862917, -4884626, -4906336, -4928045, -4949755, -4971464, -4993174, -5014883, 
  -5036593, -5058302, -5080012, -5101721, -5123430, -5145140, -5166849, -5188559, 
  -5210268, -5231978, -5253687, -5275397, -5297106, -5318816, -5340525, -5362234, 
  -5383944, -5405653, -5427363, -5449072, -5470782, -5492491, -5514201, -5535910, 
};

const int gavl_b_to_uj[256] = 
{
  8388608, 8421376, 8454144, 8486912, 8519680, 8552448, 8585216, 8617984, 
  8650752, 8683520, 8716288, 8749056, 8781824, 8814592, 8847360, 8880128, 
  8912896, 8945664, 8978432, 9011200, 9043968, 9076736, 9109504, 9142272, 
  9175040, 9207808, 9240576, 9273344, 9306112, 9338880, 9371648, 9404416, 
  9437184, 9469952, 9502720, 9535488, 9568256, 9601024, 9633792, 9666560, 
  9699328, 9732096, 9764864, 9797632, 9830400, 9863168, 9895936, 9928704, 
  9961472, 9994240, 10027008, 10059776, 10092544, 10125312, 10158080, 10190848, 
  10223616, 10256384, 10289152, 10321920, 10354688, 10387456, 10420224, 10452992, 
  10485760, 10518528, 10551296, 10584064, 10616832, 10649600, 10682368, 10715136, 
  10747904, 10780672, 10813440, 10846208, 10878976, 10911744, 10944512, 10977280, 
  11010048, 11042816, 11075584, 11108352, 11141120, 11173888, 11206656, 11239424, 
  11272192, 11304960, 11337728, 11370496, 11403264, 11436032, 11468800, 11501568, 
  11534336, 11567104, 11599872, 11632640, 11665408, 11698176, 11730944, 11763712, 
  11796480, 11829248, 11862016, 11894784, 11927552, 11960320, 11993088, 12025856, 
  12058624, 12091392, 12124160, 12156928, 12189696, 12222464, 12255232, 12288000, 
  12320768, 12353536, 12386304, 12419072, 12451840, 12484608, 12517376, 12550144, 
  12582912, 12615680, 12648448, 12681216, 12713984, 12746752, 12779520, 12812288, 
  12845056, 12877824, 12910592, 12943360, 12976128, 13008896, 13041664, 13074432, 
  13107200, 13139968, 13172736, 13205504, 13238272, 13271040, 13303808, 13336576, 
  13369344, 13402112, 13434880, 13467648, 13500416, 13533184, 13565952, 13598720, 
  13631488, 13664256, 13697024, 13729792, 13762560, 13795328, 13828096, 13860864, 
  13893632, 13926400, 13959168, 13991936, 14024704, 14057472, 14090240, 14123008, 
  14155776, 14188544, 14221312, 14254080, 14286848, 14319616, 14352384, 14385152, 
  14417920, 14450688, 14483456, 14516224, 14548992, 14581760, 14614528, 14647296, 
  14680064, 14712832, 14745600, 14778368, 14811136, 14843904, 14876672, 14909440, 
  14942208, 14974976, 15007744, 15040512, 15073280, 15106048, 15138816, 15171584, 
  15204352, 15237120, 15269888, 15302656, 15335424, 15368192, 15400960, 15433728, 
  15466496, 15499264, 15532032, 15564800, 15597568, 15630336, 15663104, 15695872, 
  15728640, 15761408, 15794176, 15826944, 15859712, 15892480, 15925248, 15958016, 
  15990784, 16023552, 16056320, 16089088, 16121856, 16154624, 16187392, 16220160, 
  16252928, 16285696, 16318464, 16351232, 16384000, 16416768, 16449536, 16482304, 
  16515072, 16547840, 16580608, 16613376, 16646144, 16678912, 16711680, 16744448, 
};

const int gavl_r_to_vj[256] = 
{
  0, 32768, 65536, 98304, 131072, 163840, 196608, 229376, 
  262144, 294912, 327680, 360448, 393216, 425984, 458752, 491520, 
  524288, 557056, 589824, 622592, 655360, 688128, 720896, 753664, 
  786432, 819200, 851968, 884736, 917504, 950272, 983040, 1015808, 
  1048576, 1081344, 1114112, 1146880, 1179648, 1212416, 1245184, 1277952, 
  1310720, 1343488, 1376256, 1409024, 1441792, 1474560, 1507328, 1540096, 
  1572864, 1605632, 1638400, 1671168, 1703936, 1736704, 1769472, 1802240, 
  1835008, 1867776, 1900544, 1933312, 1966080, 1998848, 2031616, 2064384, 
  2097152, 2129920, 2162688, 2195456, 2228224, 2260992, 2293760, 2326528, 
  2359296, 2392064, 2424832, 2457600, 2490368, 2523136, 2555904, 2588672, 
  2621440, 2654208, 2686976, 2719744, 2752512, 2785280, 2818048, 2850816, 
  2883584, 2916352, 2949120, 2981888, 3014656, 3047424, 3080192, 3112960, 
  3145728, 3178496, 3211264, 3244032, 3276800, 3309568, 3342336, 3375104, 
  3407872, 3440640, 3473408, 3506176, 3538944, 3571712, 3604480, 3637248, 
  3670016, 3702784, 3735552, 3768320, 3801088, 3833856, 3866624, 3899392, 
  3932160, 3964928, 3997696, 4030464, 4063232, 4096000, 4128768, 4161536, 
  4194304, 4227072, 4259840, 4292608, 4325376, 4358144, 4390912, 4423680, 
  4456448, 4489216, 4521984, 4554752, 4587520, 4620288, 4653056, 4685824, 
  4718592, 4751360, 4784128, 4816896, 4849664, 4882432, 4915200, 4947968, 
  4980736, 5013504, 5046272, 5079040, 5111808, 5144576, 5177344, 5210112, 
  5242880, 5275648, 5308416, 5341184, 5373952, 5406720, 5439488, 5472256, 
  5505024, 5537792, 5570560, 5603328, 5636096, 5668864, 5701632, 5734400, 
  5767168, 5799936, 5832704, 5865472, 5898240, 5931008, 5963776, 5996544, 
  6029312, 6062080, 6094848, 6127616, 6160384, 6193152, 6225920, 6258688, 
  6291456, 6324224, 6356992, 6389760, 6422528, 6455296, 6488064, 6520832, 
  6553600, 6586368, 6619136, 6651904, 6684672, 6717440, 6750208, 6782976, 
  6815744, 6848512, 6881280, 6914048, 6946816, 6979584, 7012352, 7045120, 
  7077888, 7110656, 7143424, 7176192, 7208960, 7241728, 7274496, 7307264, 
  7340032, 7372800, 7405568, 7438336, 7471104, 7503872, 7536640, 7569408, 
  7602176, 7634944, 7667712, 7700480, 7733248, 7766016, 7798784, 7831552, 
  7864320, 7897088, 7929856, 7962624, 7995392, 8028160, 8060928, 8093696, 
  8126464, 8159232, 8192000, 8224768, 8257536, 8290304, 8323072, 8355840, 
};

const int gavl_g_to_vj[256] = 
{
  0, -27438, -54878, -82317, -109756, -137195, -164635, -192074, 
  -219513, -246952, -274392, -301831, -329270, -356709, -384149, -411588, 
  -439027, -466467, -493906, -521345, -548784, -576224, -603663, -631102, 
  -658541, -685981, -713420, -740859, -768298, -795738, -823177, -850616, 
  -878056, -905495, -932934, -960373, -987813, -1015252, -1042691, -1070130, 
  -1097570, -1125009, -1152448, -1179888, -1207327, -1234766, -1262205, -1289645, 
  -1317084, -1344523, -1371962, -1399402, -1426841, -1454280, -1481719, -1509159, 
  -1536598, -1564037, -1591477, -1618916, -1646355, -1673794, -1701234, -1728673, 
  -1756112, -1783551, -1810991, -1838430, -1865869, -1893308, -1920748, -1948187, 
  -1975626, -2003066, -2030505, -2057944, -2085383, -2112823, -2140262, -2167701, 
  -2195140, -2222580, -2250019, -2277458, -2304897, -2332337, -2359776, -2387215, 
  -2414655, -2442094, -2469533, -2496972, -2524412, -2551851, -2579290, -2606729, 
  -2634169, -2661608, -2689047, -2716487, -2743926, -2771365, -2798804, -2826244, 
  -2853683, -2881122, -2908561, -2936001, -2963440, -2990879, -3018318, -3045758, 
  -3073197, -3100636, -3128076, -3155515, -3182954, -3210393, -3237833, -3265272, 
  -3292711, -3320150, -3347590, -3375029, -3402468, -3429907, -3457347, -3484786, 
  -3512225, -3539665, -3567104, -3594543, -3621982, -3649422, -3676861, -3704300, 
  -3731739, -3759179, -3786618, -3814057, -3841496, -3868936, -3896375, -3923814, 
  -3951254, -3978693, -4006132, -4033571, -4061011, -4088450, -4115889, -4143328, 
  -4170768, -4198207, -4225646, -4253086, -4280525, -4307964, -4335403, -4362843, 
  -4390282, -4417721, -4445160, -4472600, -4500039, -4527478, -4554917, -4582357, 
  -4609796, -4637235, -4664675, -4692114, -4719553, -4746992, -4774432, -4801871, 
  -4829310, -4856749, -4884189, -4911628, -4939067, -4966506, -4993946, -5021385, 
  -5048824, -5076264, -5103703, -5131142, -5158581, -5186021, -5213460, -5240899, 
  -5268338, -5295778, -5323217, -5350656, -5378095, -5405535, -5432974, -5460413, 
  -5487853, -5515292, -5542731, -5570170, -5597610, -5625049, -5652488, -5679927, 
  -5707367, -5734806, -5762245, -5789685, -5817124, -5844563, -5872002, -5899442, 
  -5926881, -5954320, -5981759, -6009199, -6036638, -6064077, -6091516, -6118956, 
  -6146395, -6173834, -6201274, -6228713, -6256152, -6283591, -6311031, -6338470, 
  -6365909, -6393348, -6420788, -6448227, -6475666, -6503105, -6530545, -6557984, 
  -6585423, -6612863, -6640302, -6667741, -6695180, -6722620, -6750059, -6777498, 
  -6804937, -6832377, -6859816, -6887255, -6914694, -6942134, -6969573, -6997012, 
};

const int gavl_b_to_vj[256] = 
{
  8388608, 8383279, 8377951, 8372622, 8367293, 8361964, 8356636, 8351307, 
  8345978, 8340649, 8335321, 8329992, 8324663, 8319334, 8314006, 8308677, 
  8303348, 8298020, 8292691, 8287362, 8282033, 8276705, 8271376, 8266047, 
  8260718, 8255390, 8250061, 8244732, 8239403, 8234075, 8228746, 8223417, 
  8218089, 8212760, 8207431, 8202102, 8196774, 8191445, 8186116, 8180787, 
  8175459, 8170130, 8164801, 8159473, 8154144, 8148815, 8143486, 8138158, 
  8132829, 8127500, 8122171, 8116843, 8111514, 8106185, 8100856, 8095528, 
  8090199, 8084870, 8079542, 8074213, 8068884, 8063555, 8058227, 8052898, 
  8047569, 8042240, 8036912, 8031583, 8026254, 8020925, 8015597, 8010268, 
  8004939, 7999611, 7994282, 7988953, 7983624, 7978296, 7972967, 7967638, 
  7962309, 7956981, 7951652, 7946323, 7940994, 7935666, 7930337, 7925008, 
  7919680, 7914351, 7909022, 7903693, 7898365, 7893036, 7887707, 7882378, 
  7877050, 7871721, 7866392, 7861064, 7855735, 7850406, 7845077, 7839749, 
  7834420, 7829091, 7823762, 7818434, 7813105, 7807776, 7802447, 7797119, 
  7791790, 7786461, 7781133, 7775804, 7770475, 7765146, 7759818, 7754489, 
  7749160, 7743831, 7738503, 7733174, 7727845, 7722516, 7717188, 7711859, 
  7706530, 7701202, 7695873, 7690544, 7685215, 7679887, 7674558, 7669229, 
  7663900, 7658572, 7653243, 7647914, 7642585, 7637257, 7631928, 7626599, 
  7621271, 7615942, 7610613, 7605284, 7599956, 7594627, 7589298, 7583969, 
  7578641, 7573312, 7567983, 7562655, 7557326, 7551997, 7546668, 7541340, 
  7536011, 7530682, 7525353, 7520025, 7514696, 7509367, 7504038, 7498710, 
  7493381, 7488052, 7482724, 7477395, 7472066, 7466737, 7461409, 7456080, 
  7450751, 7445422, 7440094, 7434765, 7429436, 7424107, 7418779, 7413450, 
  7408121, 7402793, 7397464, 7392135, 7386806, 7381478, 7376149, 7370820, 
  7365491, 7360163, 7354834, 7349505, 7344176, 7338848, 7333519, 7328190, 
  7322862, 7317533, 7312204, 7306875, 7301547, 7296218, 7290889, 7285560, 
  7280232, 7274903, 7269574, 7264246, 7258917, 7253588, 7248259, 7242931, 
  7237602, 7232273, 7226944, 7221616, 7216287, 7210958, 7205629, 7200301, 
  7194972, 7189643, 7184315, 7178986, 7173657, 7168328, 7163000, 7157671, 
  7152342, 7147013, 7141685, 7136356, 7131027, 7125698, 7120370, 7115041, 
  7109712, 7104384, 7099055, 7093726, 7088397, 7083069, 7077740, 7072411, 
  7067082, 7061754, 7056425, 7051096, 7045767, 7040439, 7035110, 7029781, 
};

/* RGB -> YUV float conversions */
const float gavl_r_to_y_float[256] = 
{
  0.00000000, 0.00117255, 0.00234510, 0.00351765, 0.00469020, 0.00586275, 0.00703529, 0.00820784, 
  0.00938039, 0.01055294, 0.01172549, 0.01289804, 0.01407059, 0.01524314, 0.01641569, 0.01758824, 
  0.01876078, 0.01993333, 0.02110588, 0.02227843, 0.02345098, 0.02462353, 0.02579608, 0.02696863, 
  0.02814118, 0.02931373, 0.03048627, 0.03165882, 0.03283137, 0.03400392, 0.03517647, 0.03634902, 
  0.03752157, 0.03869412, 0.03986667, 0.04103922, 0.04221176, 0.04338431, 0.04455686, 0.04572941, 
  0.04690196, 0.04807451, 0.04924706, 0.05041961, 0.05159216, 0.05276471, 0.05393725, 0.05510980, 
  0.05628235, 0.05745490, 0.05862745, 0.05980000, 0.06097255, 0.06214510, 0.06331765, 0.06449020, 
  0.06566275, 0.06683529, 0.06800784, 0.06918039, 0.07035294, 0.07152549, 0.07269804, 0.07387059, 
  0.07504314, 0.07621569, 0.07738824, 0.07856078, 0.07973333, 0.08090588, 0.08207843, 0.08325098, 
  0.08442353, 0.08559608, 0.08676863, 0.08794118, 0.08911373, 0.09028627, 0.09145882, 0.09263137, 
  0.09380392, 0.09497647, 0.09614902, 0.09732157, 0.09849412, 0.09966667, 0.10083922, 0.10201176, 
  0.10318431, 0.10435686, 0.10552941, 0.10670196, 0.10787451, 0.10904706, 0.11021961, 0.11139216, 
  0.11256471, 0.11373725, 0.11490980, 0.11608235, 0.11725490, 0.11842745, 0.11960000, 0.12077255, 
  0.12194510, 0.12311765, 0.12429020, 0.12546275, 0.12663529, 0.12780784, 0.12898039, 0.13015294, 
  0.13132549, 0.13249804, 0.13367059, 0.13484314, 0.13601569, 0.13718824, 0.13836078, 0.13953333, 
  0.14070588, 0.14187843, 0.14305098, 0.14422353, 0.14539608, 0.14656863, 0.14774118, 0.14891373, 
  0.15008627, 0.15125882, 0.15243137, 0.15360392, 0.15477647, 0.15594902, 0.15712157, 0.15829412, 
  0.15946667, 0.16063922, 0.16181176, 0.16298431, 0.16415686, 0.16532941, 0.16650196, 0.16767451, 
  0.16884706, 0.17001961, 0.17119216, 0.17236471, 0.17353725, 0.17470980, 0.17588235, 0.17705490, 
  0.17822745, 0.17940000, 0.18057255, 0.18174510, 0.18291765, 0.18409020, 0.18526275, 0.18643529, 
  0.18760784, 0.18878039, 0.18995294, 0.19112549, 0.19229804, 0.19347059, 0.19464314, 0.19581569, 
  0.19698824, 0.19816078, 0.19933333, 0.20050588, 0.20167843, 0.20285098, 0.20402353, 0.20519608, 
  0.20636863, 0.20754118, 0.20871373, 0.20988627, 0.21105882, 0.21223137, 0.21340392, 0.21457647, 
  0.21574902, 0.21692157, 0.21809412, 0.21926667, 0.22043922, 0.22161176, 0.22278431, 0.22395686, 
  0.22512941, 0.22630196, 0.22747451, 0.22864706, 0.22981961, 0.23099216, 0.23216471, 0.23333725, 
  0.23450980, 0.23568235, 0.23685490, 0.23802745, 0.23920000, 0.24037255, 0.24154510, 0.24271765, 
  0.24389020, 0.24506275, 0.24623529, 0.24740784, 0.24858039, 0.24975294, 0.25092549, 0.25209804, 
  0.25327059, 0.25444314, 0.25561569, 0.25678824, 0.25796078, 0.25913333, 0.26030588, 0.26147843, 
  0.26265098, 0.26382353, 0.26499608, 0.26616863, 0.26734118, 0.26851373, 0.26968627, 0.27085882, 
  0.27203137, 0.27320392, 0.27437647, 0.27554902, 0.27672157, 0.27789412, 0.27906667, 0.28023922, 
  0.28141176, 0.28258431, 0.28375686, 0.28492941, 0.28610196, 0.28727451, 0.28844706, 0.28961961, 
  0.29079216, 0.29196471, 0.29313725, 0.29430980, 0.29548235, 0.29665490, 0.29782745, 0.29900000, 
};

const float gavl_g_to_y_float[256] = 
{
  0.00000000, 0.00230196, 0.00460392, 0.00690588, 0.00920784, 0.01150980, 0.01381176, 0.01611373, 
  0.01841569, 0.02071765, 0.02301961, 0.02532157, 0.02762353, 0.02992549, 0.03222745, 0.03452941, 
  0.03683137, 0.03913333, 0.04143529, 0.04373725, 0.04603922, 0.04834118, 0.05064314, 0.05294510, 
  0.05524706, 0.05754902, 0.05985098, 0.06215294, 0.06445490, 0.06675686, 0.06905882, 0.07136078, 
  0.07366275, 0.07596471, 0.07826667, 0.08056863, 0.08287059, 0.08517255, 0.08747451, 0.08977647, 
  0.09207843, 0.09438039, 0.09668235, 0.09898431, 0.10128627, 0.10358824, 0.10589020, 0.10819216, 
  0.11049412, 0.11279608, 0.11509804, 0.11740000, 0.11970196, 0.12200392, 0.12430588, 0.12660784, 
  0.12890980, 0.13121176, 0.13351373, 0.13581569, 0.13811765, 0.14041961, 0.14272157, 0.14502353, 
  0.14732549, 0.14962745, 0.15192941, 0.15423137, 0.15653333, 0.15883529, 0.16113725, 0.16343922, 
  0.16574118, 0.16804314, 0.17034510, 0.17264706, 0.17494902, 0.17725098, 0.17955294, 0.18185490, 
  0.18415686, 0.18645882, 0.18876078, 0.19106275, 0.19336471, 0.19566667, 0.19796863, 0.20027059, 
  0.20257255, 0.20487451, 0.20717647, 0.20947843, 0.21178039, 0.21408235, 0.21638431, 0.21868627, 
  0.22098824, 0.22329020, 0.22559216, 0.22789412, 0.23019608, 0.23249804, 0.23480000, 0.23710196, 
  0.23940392, 0.24170588, 0.24400784, 0.24630980, 0.24861176, 0.25091373, 0.25321569, 0.25551765, 
  0.25781961, 0.26012157, 0.26242353, 0.26472549, 0.26702745, 0.26932941, 0.27163137, 0.27393333, 
  0.27623529, 0.27853725, 0.28083922, 0.28314118, 0.28544314, 0.28774510, 0.29004706, 0.29234902, 
  0.29465098, 0.29695294, 0.29925490, 0.30155686, 0.30385882, 0.30616078, 0.30846275, 0.31076471, 
  0.31306667, 0.31536863, 0.31767059, 0.31997255, 0.32227451, 0.32457647, 0.32687843, 0.32918039, 
  0.33148235, 0.33378431, 0.33608627, 0.33838824, 0.34069020, 0.34299216, 0.34529412, 0.34759608, 
  0.34989804, 0.35220000, 0.35450196, 0.35680392, 0.35910588, 0.36140784, 0.36370980, 0.36601176, 
  0.36831373, 0.37061569, 0.37291765, 0.37521961, 0.37752157, 0.37982353, 0.38212549, 0.38442745, 
  0.38672941, 0.38903137, 0.39133333, 0.39363529, 0.39593725, 0.39823922, 0.40054118, 0.40284314, 
  0.40514510, 0.40744706, 0.40974902, 0.41205098, 0.41435294, 0.41665490, 0.41895686, 0.42125882, 
  0.42356078, 0.42586275, 0.42816471, 0.43046667, 0.43276863, 0.43507059, 0.43737255, 0.43967451, 
  0.44197647, 0.44427843, 0.44658039, 0.44888235, 0.45118431, 0.45348627, 0.45578824, 0.45809020, 
  0.46039216, 0.46269412, 0.46499608, 0.46729804, 0.46960000, 0.47190196, 0.47420392, 0.47650588, 
  0.47880784, 0.48110980, 0.48341176, 0.48571373, 0.48801569, 0.49031765, 0.49261961, 0.49492157, 
  0.49722353, 0.49952549, 0.50182745, 0.50412941, 0.50643137, 0.50873333, 0.51103529, 0.51333725, 
  0.51563922, 0.51794118, 0.52024314, 0.52254510, 0.52484706, 0.52714902, 0.52945098, 0.53175294, 
  0.53405490, 0.53635686, 0.53865882, 0.54096078, 0.54326275, 0.54556471, 0.54786667, 0.55016863, 
  0.55247059, 0.55477255, 0.55707451, 0.55937647, 0.56167843, 0.56398039, 0.56628235, 0.56858431, 
  0.57088627, 0.57318824, 0.57549020, 0.57779216, 0.58009412, 0.58239608, 0.58469804, 0.58700000, 
};

const float gavl_b_to_y_float[256] = 
{
  0.00000000, 0.00044706, 0.00089412, 0.00134118, 0.00178824, 0.00223529, 0.00268235, 0.00312941, 
  0.00357647, 0.00402353, 0.00447059, 0.00491765, 0.00536471, 0.00581176, 0.00625882, 0.00670588, 
  0.00715294, 0.00760000, 0.00804706, 0.00849412, 0.00894118, 0.00938824, 0.00983529, 0.01028235, 
  0.01072941, 0.01117647, 0.01162353, 0.01207059, 0.01251765, 0.01296471, 0.01341176, 0.01385882, 
  0.01430588, 0.01475294, 0.01520000, 0.01564706, 0.01609412, 0.01654118, 0.01698824, 0.01743529, 
  0.01788235, 0.01832941, 0.01877647, 0.01922353, 0.01967059, 0.02011765, 0.02056471, 0.02101176, 
  0.02145882, 0.02190588, 0.02235294, 0.02280000, 0.02324706, 0.02369412, 0.02414118, 0.02458824, 
  0.02503529, 0.02548235, 0.02592941, 0.02637647, 0.02682353, 0.02727059, 0.02771765, 0.02816471, 
  0.02861176, 0.02905882, 0.02950588, 0.02995294, 0.03040000, 0.03084706, 0.03129412, 0.03174118, 
  0.03218824, 0.03263529, 0.03308235, 0.03352941, 0.03397647, 0.03442353, 0.03487059, 0.03531765, 
  0.03576471, 0.03621176, 0.03665882, 0.03710588, 0.03755294, 0.03800000, 0.03844706, 0.03889412, 
  0.03934118, 0.03978824, 0.04023529, 0.04068235, 0.04112941, 0.04157647, 0.04202353, 0.04247059, 
  0.04291765, 0.04336471, 0.04381176, 0.04425882, 0.04470588, 0.04515294, 0.04560000, 0.04604706, 
  0.04649412, 0.04694118, 0.04738824, 0.04783529, 0.04828235, 0.04872941, 0.04917647, 0.04962353, 
  0.05007059, 0.05051765, 0.05096471, 0.05141176, 0.05185882, 0.05230588, 0.05275294, 0.05320000, 
  0.05364706, 0.05409412, 0.05454118, 0.05498824, 0.05543529, 0.05588235, 0.05632941, 0.05677647, 
  0.05722353, 0.05767059, 0.05811765, 0.05856471, 0.05901176, 0.05945882, 0.05990588, 0.06035294, 
  0.06080000, 0.06124706, 0.06169412, 0.06214118, 0.06258824, 0.06303529, 0.06348235, 0.06392941, 
  0.06437647, 0.06482353, 0.06527059, 0.06571765, 0.06616471, 0.06661176, 0.06705882, 0.06750588, 
  0.06795294, 0.06840000, 0.06884706, 0.06929412, 0.06974118, 0.07018824, 0.07063529, 0.07108235, 
  0.07152941, 0.07197647, 0.07242353, 0.07287059, 0.07331765, 0.07376471, 0.07421176, 0.07465882, 
  0.07510588, 0.07555294, 0.07600000, 0.07644706, 0.07689412, 0.07734118, 0.07778824, 0.07823529, 
  0.07868235, 0.07912941, 0.07957647, 0.08002353, 0.08047059, 0.08091765, 0.08136471, 0.08181176, 
  0.08225882, 0.08270588, 0.08315294, 0.08360000, 0.08404706, 0.08449412, 0.08494118, 0.08538824, 
  0.08583529, 0.08628235, 0.08672941, 0.08717647, 0.08762353, 0.08807059, 0.08851765, 0.08896471, 
  0.08941176, 0.08985882, 0.09030588, 0.09075294, 0.09120000, 0.09164706, 0.09209412, 0.09254118, 
  0.09298824, 0.09343529, 0.09388235, 0.09432941, 0.09477647, 0.09522353, 0.09567059, 0.09611765, 
  0.09656471, 0.09701176, 0.09745882, 0.09790588, 0.09835294, 0.09880000, 0.09924706, 0.09969412, 
  0.10014118, 0.10058824, 0.10103529, 0.10148235, 0.10192941, 0.10237647, 0.10282353, 0.10327059, 
  0.10371765, 0.10416471, 0.10461176, 0.10505882, 0.10550588, 0.10595294, 0.10640000, 0.10684706, 
  0.10729412, 0.10774118, 0.10818824, 0.10863529, 0.10908235, 0.10952941, 0.10997647, 0.11042353, 
  0.11087059, 0.11131765, 0.11176471, 0.11221176, 0.11265882, 0.11310588, 0.11355294, 0.11400000, 
};

const float gavl_r_to_u_float[256] = 
{
  -0.00000000, -0.00066173, -0.00132345, -0.00198518, -0.00264690, -0.00330863, -0.00397035, -0.00463208, 
  -0.00529380, -0.00595553, -0.00661725, -0.00727898, -0.00794071, -0.00860243, -0.00926416, -0.00992588, 
  -0.01058761, -0.01124933, -0.01191106, -0.01257278, -0.01323451, -0.01389624, -0.01455796, -0.01521969, 
  -0.01588141, -0.01654314, -0.01720486, -0.01786659, -0.01852831, -0.01919004, -0.01985176, -0.02051349, 
  -0.02117522, -0.02183694, -0.02249867, -0.02316039, -0.02382212, -0.02448384, -0.02514557, -0.02580729, 
  -0.02646902, -0.02713075, -0.02779247, -0.02845420, -0.02911592, -0.02977765, -0.03043937, -0.03110110, 
  -0.03176282, -0.03242455, -0.03308627, -0.03374800, -0.03440973, -0.03507145, -0.03573318, -0.03639490, 
  -0.03705663, -0.03771835, -0.03838008, -0.03904180, -0.03970353, -0.04036525, -0.04102698, -0.04168871, 
  -0.04235043, -0.04301216, -0.04367388, -0.04433561, -0.04499733, -0.04565906, -0.04632078, -0.04698251, 
  -0.04764424, -0.04830596, -0.04896769, -0.04962941, -0.05029114, -0.05095286, -0.05161459, -0.05227631, 
  -0.05293804, -0.05359976, -0.05426149, -0.05492322, -0.05558494, -0.05624667, -0.05690839, -0.05757012, 
  -0.05823184, -0.05889357, -0.05955529, -0.06021702, -0.06087875, -0.06154047, -0.06220220, -0.06286392, 
  -0.06352565, -0.06418737, -0.06484910, -0.06551082, -0.06617255, -0.06683427, -0.06749600, -0.06815773, 
  -0.06881945, -0.06948118, -0.07014290, -0.07080463, -0.07146635, -0.07212808, -0.07278980, -0.07345153, 
  -0.07411325, -0.07477498, -0.07543671, -0.07609843, -0.07676016, -0.07742188, -0.07808361, -0.07874533, 
  -0.07940706, -0.08006878, -0.08073051, -0.08139224, -0.08205396, -0.08271569, -0.08337741, -0.08403914, 
  -0.08470086, -0.08536259, -0.08602431, -0.08668604, -0.08734776, -0.08800949, -0.08867122, -0.08933294, 
  -0.08999467, -0.09065639, -0.09131812, -0.09197984, -0.09264157, -0.09330329, -0.09396502, -0.09462675, 
  -0.09528847, -0.09595020, -0.09661192, -0.09727365, -0.09793537, -0.09859710, -0.09925882, -0.09992055, 
  -0.10058227, -0.10124400, -0.10190573, -0.10256745, -0.10322918, -0.10389090, -0.10455263, -0.10521435, 
  -0.10587608, -0.10653780, -0.10719953, -0.10786125, -0.10852298, -0.10918471, -0.10984643, -0.11050816, 
  -0.11116988, -0.11183161, -0.11249333, -0.11315506, -0.11381678, -0.11447851, -0.11514024, -0.11580196, 
  -0.11646369, -0.11712541, -0.11778714, -0.11844886, -0.11911059, -0.11977231, -0.12043404, -0.12109576, 
  -0.12175749, -0.12241922, -0.12308094, -0.12374267, -0.12440439, -0.12506612, -0.12572784, -0.12638957, 
  -0.12705129, -0.12771302, -0.12837475, -0.12903647, -0.12969820, -0.13035992, -0.13102165, -0.13168337, 
  -0.13234510, -0.13300682, -0.13366855, -0.13433027, -0.13499200, -0.13565373, -0.13631545, -0.13697718, 
  -0.13763890, -0.13830063, -0.13896235, -0.13962408, -0.14028580, -0.14094753, -0.14160925, -0.14227098, 
  -0.14293271, -0.14359443, -0.14425616, -0.14491788, -0.14557961, -0.14624133, -0.14690306, -0.14756478, 
  -0.14822651, -0.14888824, -0.14954996, -0.15021169, -0.15087341, -0.15153514, -0.15219686, -0.15285859, 
  -0.15352031, -0.15418204, -0.15484376, -0.15550549, -0.15616722, -0.15682894, -0.15749067, -0.15815239, 
  -0.15881412, -0.15947584, -0.16013757, -0.16079929, -0.16146102, -0.16212275, -0.16278447, -0.16344620, 
  -0.16410792, -0.16476965, -0.16543137, -0.16609310, -0.16675482, -0.16741655, -0.16807827, -0.16874000, 
};

const float gavl_g_to_u_float[256] = 
{
  -0.00000000, -0.00129906, -0.00259812, -0.00389718, -0.00519624, -0.00649529, -0.00779435, -0.00909341, 
  -0.01039247, -0.01169153, -0.01299059, -0.01428965, -0.01558871, -0.01688776, -0.01818682, -0.01948588, 
  -0.02078494, -0.02208400, -0.02338306, -0.02468212, -0.02598118, -0.02728024, -0.02857929, -0.02987835, 
  -0.03117741, -0.03247647, -0.03377553, -0.03507459, -0.03637365, -0.03767271, -0.03897176, -0.04027082, 
  -0.04156988, -0.04286894, -0.04416800, -0.04546706, -0.04676612, -0.04806518, -0.04936424, -0.05066329, 
  -0.05196235, -0.05326141, -0.05456047, -0.05585953, -0.05715859, -0.05845765, -0.05975671, -0.06105576, 
  -0.06235482, -0.06365388, -0.06495294, -0.06625200, -0.06755106, -0.06885012, -0.07014918, -0.07144824, 
  -0.07274729, -0.07404635, -0.07534541, -0.07664447, -0.07794353, -0.07924259, -0.08054165, -0.08184071, 
  -0.08313976, -0.08443882, -0.08573788, -0.08703694, -0.08833600, -0.08963506, -0.09093412, -0.09223318, 
  -0.09353224, -0.09483129, -0.09613035, -0.09742941, -0.09872847, -0.10002753, -0.10132659, -0.10262565, 
  -0.10392471, -0.10522376, -0.10652282, -0.10782188, -0.10912094, -0.11042000, -0.11171906, -0.11301812, 
  -0.11431718, -0.11561624, -0.11691529, -0.11821435, -0.11951341, -0.12081247, -0.12211153, -0.12341059, 
  -0.12470965, -0.12600871, -0.12730776, -0.12860682, -0.12990588, -0.13120494, -0.13250400, -0.13380306, 
  -0.13510212, -0.13640118, -0.13770024, -0.13899929, -0.14029835, -0.14159741, -0.14289647, -0.14419553, 
  -0.14549459, -0.14679365, -0.14809271, -0.14939176, -0.15069082, -0.15198988, -0.15328894, -0.15458800, 
  -0.15588706, -0.15718612, -0.15848518, -0.15978424, -0.16108329, -0.16238235, -0.16368141, -0.16498047, 
  -0.16627953, -0.16757859, -0.16887765, -0.17017671, -0.17147576, -0.17277482, -0.17407388, -0.17537294, 
  -0.17667200, -0.17797106, -0.17927012, -0.18056918, -0.18186824, -0.18316729, -0.18446635, -0.18576541, 
  -0.18706447, -0.18836353, -0.18966259, -0.19096165, -0.19226071, -0.19355976, -0.19485882, -0.19615788, 
  -0.19745694, -0.19875600, -0.20005506, -0.20135412, -0.20265318, -0.20395224, -0.20525129, -0.20655035, 
  -0.20784941, -0.20914847, -0.21044753, -0.21174659, -0.21304565, -0.21434471, -0.21564376, -0.21694282, 
  -0.21824188, -0.21954094, -0.22084000, -0.22213906, -0.22343812, -0.22473718, -0.22603624, -0.22733529, 
  -0.22863435, -0.22993341, -0.23123247, -0.23253153, -0.23383059, -0.23512965, -0.23642871, -0.23772776, 
  -0.23902682, -0.24032588, -0.24162494, -0.24292400, -0.24422306, -0.24552212, -0.24682118, -0.24812024, 
  -0.24941929, -0.25071835, -0.25201741, -0.25331647, -0.25461553, -0.25591459, -0.25721365, -0.25851271, 
  -0.25981176, -0.26111082, -0.26240988, -0.26370894, -0.26500800, -0.26630706, -0.26760612, -0.26890518, 
  -0.27020424, -0.27150329, -0.27280235, -0.27410141, -0.27540047, -0.27669953, -0.27799859, -0.27929765, 
  -0.28059671, -0.28189576, -0.28319482, -0.28449388, -0.28579294, -0.28709200, -0.28839106, -0.28969012, 
  -0.29098918, -0.29228824, -0.29358729, -0.29488635, -0.29618541, -0.29748447, -0.29878353, -0.30008259, 
  -0.30138165, -0.30268071, -0.30397976, -0.30527882, -0.30657788, -0.30787694, -0.30917600, -0.31047506, 
  -0.31177412, -0.31307318, -0.31437224, -0.31567129, -0.31697035, -0.31826941, -0.31956847, -0.32086753, 
  -0.32216659, -0.32346565, -0.32476471, -0.32606376, -0.32736282, -0.32866188, -0.32996094, -0.33126000, 
};

const float gavl_b_to_u_float[256] = 
{
  0.00000000, 0.00196078, 0.00392157, 0.00588235, 0.00784314, 0.00980392, 0.01176471, 0.01372549, 
  0.01568627, 0.01764706, 0.01960784, 0.02156863, 0.02352941, 0.02549020, 0.02745098, 0.02941176, 
  0.03137255, 0.03333333, 0.03529412, 0.03725490, 0.03921569, 0.04117647, 0.04313725, 0.04509804, 
  0.04705882, 0.04901961, 0.05098039, 0.05294118, 0.05490196, 0.05686275, 0.05882353, 0.06078431, 
  0.06274510, 0.06470588, 0.06666667, 0.06862745, 0.07058824, 0.07254902, 0.07450980, 0.07647059, 
  0.07843137, 0.08039216, 0.08235294, 0.08431373, 0.08627451, 0.08823529, 0.09019608, 0.09215686, 
  0.09411765, 0.09607843, 0.09803922, 0.10000000, 0.10196078, 0.10392157, 0.10588235, 0.10784314, 
  0.10980392, 0.11176471, 0.11372549, 0.11568627, 0.11764706, 0.11960784, 0.12156863, 0.12352941, 
  0.12549020, 0.12745098, 0.12941176, 0.13137255, 0.13333333, 0.13529412, 0.13725490, 0.13921569, 
  0.14117647, 0.14313725, 0.14509804, 0.14705882, 0.14901961, 0.15098039, 0.15294118, 0.15490196, 
  0.15686275, 0.15882353, 0.16078431, 0.16274510, 0.16470588, 0.16666667, 0.16862745, 0.17058824, 
  0.17254902, 0.17450980, 0.17647059, 0.17843137, 0.18039216, 0.18235294, 0.18431373, 0.18627451, 
  0.18823529, 0.19019608, 0.19215686, 0.19411765, 0.19607843, 0.19803922, 0.20000000, 0.20196078, 
  0.20392157, 0.20588235, 0.20784314, 0.20980392, 0.21176471, 0.21372549, 0.21568627, 0.21764706, 
  0.21960784, 0.22156863, 0.22352941, 0.22549020, 0.22745098, 0.22941176, 0.23137255, 0.23333333, 
  0.23529412, 0.23725490, 0.23921569, 0.24117647, 0.24313725, 0.24509804, 0.24705882, 0.24901961, 
  0.25098039, 0.25294118, 0.25490196, 0.25686275, 0.25882353, 0.26078431, 0.26274510, 0.26470588, 
  0.26666667, 0.26862745, 0.27058824, 0.27254902, 0.27450980, 0.27647059, 0.27843137, 0.28039216, 
  0.28235294, 0.28431373, 0.28627451, 0.28823529, 0.29019608, 0.29215686, 0.29411765, 0.29607843, 
  0.29803922, 0.30000000, 0.30196078, 0.30392157, 0.30588235, 0.30784314, 0.30980392, 0.31176471, 
  0.31372549, 0.31568627, 0.31764706, 0.31960784, 0.32156863, 0.32352941, 0.32549020, 0.32745098, 
  0.32941176, 0.33137255, 0.33333333, 0.33529412, 0.33725490, 0.33921569, 0.34117647, 0.34313725, 
  0.34509804, 0.34705882, 0.34901961, 0.35098039, 0.35294118, 0.35490196, 0.35686275, 0.35882353, 
  0.36078431, 0.36274510, 0.36470588, 0.36666667, 0.36862745, 0.37058824, 0.37254902, 0.37450980, 
  0.37647059, 0.37843137, 0.38039216, 0.38235294, 0.38431373, 0.38627451, 0.38823529, 0.39019608, 
  0.39215686, 0.39411765, 0.39607843, 0.39803922, 0.40000000, 0.40196078, 0.40392157, 0.40588235, 
  0.40784314, 0.40980392, 0.41176471, 0.41372549, 0.41568627, 0.41764706, 0.41960784, 0.42156863, 
  0.42352941, 0.42549020, 0.42745098, 0.42941176, 0.43137255, 0.43333333, 0.43529412, 0.43725490, 
  0.43921569, 0.44117647, 0.44313725, 0.44509804, 0.44705882, 0.44901961, 0.45098039, 0.45294118, 
  0.45490196, 0.45686275, 0.45882353, 0.46078431, 0.46274510, 0.46470588, 0.46666667, 0.46862745, 
  0.47058824, 0.47254902, 0.47450980, 0.47647059, 0.47843137, 0.48039216, 0.48235294, 0.48431373, 
  0.48627451, 0.48823529, 0.49019608, 0.49215686, 0.49411765, 0.49607843, 0.49803922, 0.50000000, 
};

const float gavl_r_to_v_float[256] = 
{
  0.00000000, 0.00196078, 0.00392157, 0.00588235, 0.00784314, 0.00980392, 0.01176471, 0.01372549, 
  0.01568627, 0.01764706, 0.01960784, 0.02156863, 0.02352941, 0.02549020, 0.02745098, 0.02941176, 
  0.03137255, 0.03333333, 0.03529412, 0.03725490, 0.03921569, 0.04117647, 0.04313725, 0.04509804, 
  0.04705882, 0.04901961, 0.05098039, 0.05294118, 0.05490196, 0.05686275, 0.05882353, 0.06078431, 
  0.06274510, 0.06470588, 0.06666667, 0.06862745, 0.07058824, 0.07254902, 0.07450980, 0.07647059, 
  0.07843137, 0.08039216, 0.08235294, 0.08431373, 0.08627451, 0.08823529, 0.09019608, 0.09215686, 
  0.09411765, 0.09607843, 0.09803922, 0.10000000, 0.10196078, 0.10392157, 0.10588235, 0.10784314, 
  0.10980392, 0.11176471, 0.11372549, 0.11568627, 0.11764706, 0.11960784, 0.12156863, 0.12352941, 
  0.12549020, 0.12745098, 0.12941176, 0.13137255, 0.13333333, 0.13529412, 0.13725490, 0.13921569, 
  0.14117647, 0.14313725, 0.14509804, 0.14705882, 0.14901961, 0.15098039, 0.15294118, 0.15490196, 
  0.15686275, 0.15882353, 0.16078431, 0.16274510, 0.16470588, 0.16666667, 0.16862745, 0.17058824, 
  0.17254902, 0.17450980, 0.17647059, 0.17843137, 0.18039216, 0.18235294, 0.18431373, 0.18627451, 
  0.18823529, 0.19019608, 0.19215686, 0.19411765, 0.19607843, 0.19803922, 0.20000000, 0.20196078, 
  0.20392157, 0.20588235, 0.20784314, 0.20980392, 0.21176471, 0.21372549, 0.21568627, 0.21764706, 
  0.21960784, 0.22156863, 0.22352941, 0.22549020, 0.22745098, 0.22941176, 0.23137255, 0.23333333, 
  0.23529412, 0.23725490, 0.23921569, 0.24117647, 0.24313725, 0.24509804, 0.24705882, 0.24901961, 
  0.25098039, 0.25294118, 0.25490196, 0.25686275, 0.25882353, 0.26078431, 0.26274510, 0.26470588, 
  0.26666667, 0.26862745, 0.27058824, 0.27254902, 0.27450980, 0.27647059, 0.27843137, 0.28039216, 
  0.28235294, 0.28431373, 0.28627451, 0.28823529, 0.29019608, 0.29215686, 0.29411765, 0.29607843, 
  0.29803922, 0.30000000, 0.30196078, 0.30392157, 0.30588235, 0.30784314, 0.30980392, 0.31176471, 
  0.31372549, 0.31568627, 0.31764706, 0.31960784, 0.32156863, 0.32352941, 0.32549020, 0.32745098, 
  0.32941176, 0.33137255, 0.33333333, 0.33529412, 0.33725490, 0.33921569, 0.34117647, 0.34313725, 
  0.34509804, 0.34705882, 0.34901961, 0.35098039, 0.35294118, 0.35490196, 0.35686275, 0.35882353, 
  0.36078431, 0.36274510, 0.36470588, 0.36666667, 0.36862745, 0.37058824, 0.37254902, 0.37450980, 
  0.37647059, 0.37843137, 0.38039216, 0.38235294, 0.38431373, 0.38627451, 0.38823529, 0.39019608, 
  0.39215686, 0.39411765, 0.39607843, 0.39803922, 0.40000000, 0.40196078, 0.40392157, 0.40588235, 
  0.40784314, 0.40980392, 0.41176471, 0.41372549, 0.41568627, 0.41764706, 0.41960784, 0.42156863, 
  0.42352941, 0.42549020, 0.42745098, 0.42941176, 0.43137255, 0.43333333, 0.43529412, 0.43725490, 
  0.43921569, 0.44117647, 0.44313725, 0.44509804, 0.44705882, 0.44901961, 0.45098039, 0.45294118, 
  0.45490196, 0.45686275, 0.45882353, 0.46078431, 0.46274510, 0.46470588, 0.46666667, 0.46862745, 
  0.47058824, 0.47254902, 0.47450980, 0.47647059, 0.47843137, 0.48039216, 0.48235294, 0.48431373, 
  0.48627451, 0.48823529, 0.49019608, 0.49215686, 0.49411765, 0.49607843, 0.49803922, 0.50000000, 
};

const float gavl_g_to_v_float[256] = 
{
  -0.00000000, -0.00164192, -0.00328384, -0.00492576, -0.00656769, -0.00820961, -0.00985153, -0.01149345, 
  -0.01313537, -0.01477729, -0.01641922, -0.01806114, -0.01970306, -0.02134498, -0.02298690, -0.02462882, 
  -0.02627075, -0.02791267, -0.02955459, -0.03119651, -0.03283843, -0.03448035, -0.03612227, -0.03776420, 
  -0.03940612, -0.04104804, -0.04268996, -0.04433188, -0.04597380, -0.04761573, -0.04925765, -0.05089957, 
  -0.05254149, -0.05418341, -0.05582533, -0.05746725, -0.05910918, -0.06075110, -0.06239302, -0.06403494, 
  -0.06567686, -0.06731878, -0.06896071, -0.07060263, -0.07224455, -0.07388647, -0.07552839, -0.07717031, 
  -0.07881224, -0.08045416, -0.08209608, -0.08373800, -0.08537992, -0.08702184, -0.08866376, -0.09030569, 
  -0.09194761, -0.09358953, -0.09523145, -0.09687337, -0.09851529, -0.10015722, -0.10179914, -0.10344106, 
  -0.10508298, -0.10672490, -0.10836682, -0.11000875, -0.11165067, -0.11329259, -0.11493451, -0.11657643, 
  -0.11821835, -0.11986027, -0.12150220, -0.12314412, -0.12478604, -0.12642796, -0.12806988, -0.12971180, 
  -0.13135373, -0.13299565, -0.13463757, -0.13627949, -0.13792141, -0.13956333, -0.14120525, -0.14284718, 
  -0.14448910, -0.14613102, -0.14777294, -0.14941486, -0.15105678, -0.15269871, -0.15434063, -0.15598255, 
  -0.15762447, -0.15926639, -0.16090831, -0.16255024, -0.16419216, -0.16583408, -0.16747600, -0.16911792, 
  -0.17075984, -0.17240176, -0.17404369, -0.17568561, -0.17732753, -0.17896945, -0.18061137, -0.18225329, 
  -0.18389522, -0.18553714, -0.18717906, -0.18882098, -0.19046290, -0.19210482, -0.19374675, -0.19538867, 
  -0.19703059, -0.19867251, -0.20031443, -0.20195635, -0.20359827, -0.20524020, -0.20688212, -0.20852404, 
  -0.21016596, -0.21180788, -0.21344980, -0.21509173, -0.21673365, -0.21837557, -0.22001749, -0.22165941, 
  -0.22330133, -0.22494325, -0.22658518, -0.22822710, -0.22986902, -0.23151094, -0.23315286, -0.23479478, 
  -0.23643671, -0.23807863, -0.23972055, -0.24136247, -0.24300439, -0.24464631, -0.24628824, -0.24793016, 
  -0.24957208, -0.25121400, -0.25285592, -0.25449784, -0.25613976, -0.25778169, -0.25942361, -0.26106553, 
  -0.26270745, -0.26434937, -0.26599129, -0.26763322, -0.26927514, -0.27091706, -0.27255898, -0.27420090, 
  -0.27584282, -0.27748475, -0.27912667, -0.28076859, -0.28241051, -0.28405243, -0.28569435, -0.28733627, 
  -0.28897820, -0.29062012, -0.29226204, -0.29390396, -0.29554588, -0.29718780, -0.29882973, -0.30047165, 
  -0.30211357, -0.30375549, -0.30539741, -0.30703933, -0.30868125, -0.31032318, -0.31196510, -0.31360702, 
  -0.31524894, -0.31689086, -0.31853278, -0.32017471, -0.32181663, -0.32345855, -0.32510047, -0.32674239, 
  -0.32838431, -0.33002624, -0.33166816, -0.33331008, -0.33495200, -0.33659392, -0.33823584, -0.33987776, 
  -0.34151969, -0.34316161, -0.34480353, -0.34644545, -0.34808737, -0.34972929, -0.35137122, -0.35301314, 
  -0.35465506, -0.35629698, -0.35793890, -0.35958082, -0.36122275, -0.36286467, -0.36450659, -0.36614851, 
  -0.36779043, -0.36943235, -0.37107427, -0.37271620, -0.37435812, -0.37600004, -0.37764196, -0.37928388, 
  -0.38092580, -0.38256773, -0.38420965, -0.38585157, -0.38749349, -0.38913541, -0.39077733, -0.39241925, 
  -0.39406118, -0.39570310, -0.39734502, -0.39898694, -0.40062886, -0.40227078, -0.40391271, -0.40555463, 
  -0.40719655, -0.40883847, -0.41048039, -0.41212231, -0.41376424, -0.41540616, -0.41704808, -0.41869000, 
};

const float gavl_b_to_v_float[256] = 
{
  -0.00000000, -0.00031886, -0.00063773, -0.00095659, -0.00127545, -0.00159431, -0.00191318, -0.00223204, 
  -0.00255090, -0.00286976, -0.00318863, -0.00350749, -0.00382635, -0.00414522, -0.00446408, -0.00478294, 
  -0.00510180, -0.00542067, -0.00573953, -0.00605839, -0.00637725, -0.00669612, -0.00701498, -0.00733384, 
  -0.00765271, -0.00797157, -0.00829043, -0.00860929, -0.00892816, -0.00924702, -0.00956588, -0.00988475, 
  -0.01020361, -0.01052247, -0.01084133, -0.01116020, -0.01147906, -0.01179792, -0.01211678, -0.01243565, 
  -0.01275451, -0.01307337, -0.01339224, -0.01371110, -0.01402996, -0.01434882, -0.01466769, -0.01498655, 
  -0.01530541, -0.01562427, -0.01594314, -0.01626200, -0.01658086, -0.01689973, -0.01721859, -0.01753745, 
  -0.01785631, -0.01817518, -0.01849404, -0.01881290, -0.01913176, -0.01945063, -0.01976949, -0.02008835, 
  -0.02040722, -0.02072608, -0.02104494, -0.02136380, -0.02168267, -0.02200153, -0.02232039, -0.02263925, 
  -0.02295812, -0.02327698, -0.02359584, -0.02391471, -0.02423357, -0.02455243, -0.02487129, -0.02519016, 
  -0.02550902, -0.02582788, -0.02614675, -0.02646561, -0.02678447, -0.02710333, -0.02742220, -0.02774106, 
  -0.02805992, -0.02837878, -0.02869765, -0.02901651, -0.02933537, -0.02965424, -0.02997310, -0.03029196, 
  -0.03061082, -0.03092969, -0.03124855, -0.03156741, -0.03188627, -0.03220514, -0.03252400, -0.03284286, 
  -0.03316173, -0.03348059, -0.03379945, -0.03411831, -0.03443718, -0.03475604, -0.03507490, -0.03539376, 
  -0.03571263, -0.03603149, -0.03635035, -0.03666922, -0.03698808, -0.03730694, -0.03762580, -0.03794467, 
  -0.03826353, -0.03858239, -0.03890125, -0.03922012, -0.03953898, -0.03985784, -0.04017671, -0.04049557, 
  -0.04081443, -0.04113329, -0.04145216, -0.04177102, -0.04208988, -0.04240875, -0.04272761, -0.04304647, 
  -0.04336533, -0.04368420, -0.04400306, -0.04432192, -0.04464078, -0.04495965, -0.04527851, -0.04559737, 
  -0.04591624, -0.04623510, -0.04655396, -0.04687282, -0.04719169, -0.04751055, -0.04782941, -0.04814827, 
  -0.04846714, -0.04878600, -0.04910486, -0.04942373, -0.04974259, -0.05006145, -0.05038031, -0.05069918, 
  -0.05101804, -0.05133690, -0.05165576, -0.05197463, -0.05229349, -0.05261235, -0.05293122, -0.05325008, 
  -0.05356894, -0.05388780, -0.05420667, -0.05452553, -0.05484439, -0.05516325, -0.05548212, -0.05580098, 
  -0.05611984, -0.05643871, -0.05675757, -0.05707643, -0.05739529, -0.05771416, -0.05803302, -0.05835188, 
  -0.05867075, -0.05898961, -0.05930847, -0.05962733, -0.05994620, -0.06026506, -0.06058392, -0.06090278, 
  -0.06122165, -0.06154051, -0.06185937, -0.06217824, -0.06249710, -0.06281596, -0.06313482, -0.06345369, 
  -0.06377255, -0.06409141, -0.06441027, -0.06472914, -0.06504800, -0.06536686, -0.06568573, -0.06600459, 
  -0.06632345, -0.06664231, -0.06696118, -0.06728004, -0.06759890, -0.06791776, -0.06823663, -0.06855549, 
  -0.06887435, -0.06919322, -0.06951208, -0.06983094, -0.07014980, -0.07046867, -0.07078753, -0.07110639, 
  -0.07142525, -0.07174412, -0.07206298, -0.07238184, -0.07270071, -0.07301957, -0.07333843, -0.07365729, 
  -0.07397616, -0.07429502, -0.07461388, -0.07493275, -0.07525161, -0.07557047, -0.07588933, -0.07620820, 
  -0.07652706, -0.07684592, -0.07716478, -0.07748365, -0.07780251, -0.07812137, -0.07844024, -0.07875910, 
  -0.07907796, -0.07939682, -0.07971569, -0.08003455, -0.08035341, -0.08067227, -0.08099114, -0.08131000, 
};

/* YUV -> RGB conversions */
const int gavl_y_to_rgb[256] = 
{
  -1220944, -1144635, -1068326, -992017, -915707, -839398, -763089, -686780, 
  -610471, -534162, -457853, -381544, -305235, -228926, -152617, -76308, 
  0, 76309, 152618, 228927, 305236, 381545, 457854, 534163, 
  610472, 686781, 763090, 839399, 915708, 992018, 1068327, 1144636, 
  1220945, 1297254, 1373563, 1449872, 1526181, 1602490, 1678799, 1755108, 
  1831417, 1907726, 1984035, 2060344, 2136653, 2212962, 2289271, 2365580, 
  2441889, 2518198, 2594507, 2670816, 2747125, 2823435, 2899744, 2976053, 
  3052362, 3128671, 3204980, 3281289, 3357598, 3433907, 3510216, 3586525, 
  3662834, 3739143, 3815452, 3891761, 3968070, 4044379, 4120688, 4196997, 
  4273306, 4349615, 4425924, 4502233, 4578542, 4654852, 4731161, 4807470, 
  4883779, 4960088, 5036397, 5112706, 5189015, 5265324, 5341633, 5417942, 
  5494251, 5570560, 5646869, 5723178, 5799487, 5875796, 5952105, 6028414, 
  6104723, 6181032, 6257341, 6333650, 6409959, 6486268, 6562578, 6638887, 
  6715196, 6791505, 6867814, 6944123, 7020432, 7096741, 7173050, 7249359, 
  7325668, 7401977, 7478286, 7554595, 7630904, 7707213, 7783522, 7859831, 
  7936140, 8012449, 8088758, 8165067, 8241376, 8317685, 8393995, 8470304, 
  8546613, 8622922, 8699231, 8775540, 8851849, 8928158, 9004467, 9080776, 
  9157085, 9233394, 9309703, 9386012, 9462321, 9538630, 9614939, 9691248, 
  9767557, 9843866, 9920175, 9996484, 10072793, 10149102, 10225412, 10301721, 
  10378030, 10454339, 10530648, 10606957, 10683266, 10759575, 10835884, 10912193, 
  10988502, 11064811, 11141120, 11217429, 11293738, 11370047, 11446356, 11522665, 
  11598974, 11675283, 11751592, 11827901, 11904210, 11980519, 12056828, 12133138, 
  12209447, 12285756, 12362065, 12438374, 12514683, 12590992, 12667301, 12743610, 
  12819919, 12896228, 12972537, 13048846, 13125155, 13201464, 13277773, 13354082, 
  13430391, 13506700, 13583009, 13659318, 13735627, 13811936, 13888245, 13964555, 
  14040864, 14117173, 14193482, 14269791, 14346100, 14422409, 14498718, 14575027, 
  14651336, 14727645, 14803954, 14880263, 14956572, 15032881, 15109190, 15185499, 
  15261808, 15338117, 15414426, 15490735, 15567044, 15643353, 15719662, 15795972, 
  15872281, 15948590, 16024899, 16101208, 16177517, 16253826, 16330135, 16406444, 
  16482753, 16559062, 16635371, 16711680, 16787989, 16864298, 16940607, 17016916, 
  17093225, 17169534, 17245843, 17322152, 17398461, 17474770, 17551079, 17627388, 
  17703698, 17780007, 17856316, 17932625, 18008934, 18085243, 18161552, 18237861, 
};

const int gavl_v_to_r[256] = 
{
  -13388442, -13283845, -13179248, -13074650, -12970053, -12865456, -12760859, -12656262, 
  -12551664, -12447067, -12342470, -12237873, -12133276, -12028678, -11924081, -11819484, 
  -11714887, -11610289, -11505692, -11401095, -11296498, -11191901, -11087303, -10982706, 
  -10878109, -10773512, -10668915, -10564317, -10459720, -10355123, -10250526, -10145929, 
  -10041331, -9936734, -9832137, -9727540, -9622942, -9518345, -9413748, -9309151, 
  -9204554, -9099956, -8995359, -8890762, -8786165, -8681568, -8576970, -8472373, 
  -8367776, -8263179, -8158581, -8053984, -7949387, -7844790, -7740193, -7635595, 
  -7530998, -7426401, -7321804, -7217207, -7112609, -7008012, -6903415, -6798818, 
  -6694221, -6589623, -6485026, -6380429, -6275832, -6171234, -6066637, -5962040, 
  -5857443, -5752846, -5648248, -5543651, -5439054, -5334457, -5229860, -5125262, 
  -5020665, -4916068, -4811471, -4706874, -4602276, -4497679, -4393082, -4288485, 
  -4183887, -4079290, -3974693, -3870096, -3765499, -3660901, -3556304, -3451707, 
  -3347110, -3242513, -3137915, -3033318, -2928721, -2824124, -2719526, -2614929, 
  -2510332, -2405735, -2301138, -2196540, -2091943, -1987346, -1882749, -1778152, 
  -1673554, -1568957, -1464360, -1359763, -1255166, -1150568, -1045971, -941374, 
  -836777, -732179, -627582, -522985, -418388, -313791, -209193, -104596, 
  0, 104597, 209194, 313792, 418389, 522986, 627583, 732180, 
  836778, 941375, 1045972, 1150569, 1255167, 1359764, 1464361, 1568958, 
  1673555, 1778153, 1882750, 1987347, 2091944, 2196541, 2301139, 2405736, 
  2510333, 2614930, 2719527, 2824125, 2928722, 3033319, 3137916, 3242514, 
  3347111, 3451708, 3556305, 3660902, 3765500, 3870097, 3974694, 4079291, 
  4183888, 4288486, 4393083, 4497680, 4602277, 4706875, 4811472, 4916069, 
  5020666, 5125263, 5229861, 5334458, 5439055, 5543652, 5648249, 5752847, 
  5857444, 5962041, 6066638, 6171235, 6275833, 6380430, 6485027, 6589624, 
  6694222, 6798819, 6903416, 7008013, 7112610, 7217208, 7321805, 7426402, 
  7530999, 7635596, 7740194, 7844791, 7949388, 8053985, 8158582, 8263180, 
  8367777, 8472374, 8576971, 8681569, 8786166, 8890763, 8995360, 9099957, 
  9204555, 9309152, 9413749, 9518346, 9622943, 9727541, 9832138, 9936735, 
  10041332, 10145930, 10250527, 10355124, 10459721, 10564318, 10668916, 10773513, 
  10878110, 10982707, 11087304, 11191902, 11296499, 11401096, 11505693, 11610290, 
  11714888, 11819485, 11924082, 12028679, 12133277, 12237874, 12342471, 12447068, 
  12551665, 12656263, 12760860, 12865457, 12970054, 13074651, 13179249, 13283846, 
};

const int gavl_u_to_g[256] = 
{
  3286376, 3260701, 3235026, 3209351, 3183677, 3158002, 3132327, 3106652, 
  3080977, 3055302, 3029628, 3003953, 2978278, 2952603, 2926928, 2901254, 
  2875579, 2849904, 2824229, 2798554, 2772880, 2747205, 2721530, 2695855, 
  2670180, 2644505, 2618831, 2593156, 2567481, 2541806, 2516131, 2490457, 
  2464782, 2439107, 2413432, 2387757, 2362083, 2336408, 2310733, 2285058, 
  2259383, 2233709, 2208034, 2182359, 2156684, 2131009, 2105334, 2079660, 
  2053985, 2028310, 2002635, 1976960, 1951286, 1925611, 1899936, 1874261, 
  1848586, 1822912, 1797237, 1771562, 1745887, 1720212, 1694537, 1668863, 
  1643188, 1617513, 1591838, 1566163, 1540489, 1514814, 1489139, 1463464, 
  1437789, 1412115, 1386440, 1360765, 1335090, 1309415, 1283741, 1258066, 
  1232391, 1206716, 1181041, 1155366, 1129692, 1104017, 1078342, 1052667, 
  1026992, 1001318, 975643, 949968, 924293, 898618, 872944, 847269, 
  821594, 795919, 770244, 744570, 718895, 693220, 667545, 641870, 
  616195, 590521, 564846, 539171, 513496, 487821, 462147, 436472, 
  410797, 385122, 359447, 333773, 308098, 282423, 256748, 231073, 
  205398, 179724, 154049, 128374, 102699, 77024, 51350, 25675, 
  0, -25674, -51349, -77023, -102698, -128373, -154048, -179723, 
  -205397, -231072, -256747, -282422, -308097, -333772, -359446, -385121, 
  -410796, -436471, -462146, -487820, -513495, -539170, -564845, -590520, 
  -616194, -641869, -667544, -693219, -718894, -744569, -770243, -795918, 
  -821593, -847268, -872943, -898617, -924292, -949967, -975642, -1001317, 
  -1026991, -1052666, -1078341, -1104016, -1129691, -1155365, -1181040, -1206715, 
  -1232390, -1258065, -1283740, -1309414, -1335089, -1360764, -1386439, -1412114, 
  -1437788, -1463463, -1489138, -1514813, -1540488, -1566162, -1591837, -1617512, 
  -1643187, -1668862, -1694536, -1720211, -1745886, -1771561, -1797236, -1822911, 
  -1848585, -1874260, -1899935, -1925610, -1951285, -1976959, -2002634, -2028309, 
  -2053984, -2079659, -2105333, -2131008, -2156683, -2182358, -2208033, -2233708, 
  -2259382, -2285057, -2310732, -2336407, -2362082, -2387756, -2413431, -2439106, 
  -2464781, -2490456, -2516130, -2541805, -2567480, -2593155, -2618830, -2644504, 
  -2670179, -2695854, -2721529, -2747204, -2772879, -2798553, -2824228, -2849903, 
  -2875578, -2901253, -2926927, -2952602, -2978277, -3003952, -3029627, -3055301, 
  -3080976, -3106651, -3132326, -3158001, -3183676, -3209350, -3235025, -3260700, 
};

const int gavl_v_to_g[256] = 
{
  6819702, 6766423, 6713145, 6659866, 6606587, 6553308, 6500029, 6446750, 
  6393471, 6340192, 6286913, 6233634, 6180355, 6127076, 6073797, 6020519, 
  5967240, 5913961, 5860682, 5807403, 5754124, 5700845, 5647566, 5594287, 
  5541008, 5487729, 5434450, 5381171, 5327892, 5274614, 5221335, 5168056, 
  5114777, 5061498, 5008219, 4954940, 4901661, 4848382, 4795103, 4741824, 
  4688545, 4635266, 4581988, 4528709, 4475430, 4422151, 4368872, 4315593, 
  4262314, 4209035, 4155756, 4102477, 4049198, 3995919, 3942640, 3889362, 
  3836083, 3782804, 3729525, 3676246, 3622967, 3569688, 3516409, 3463130, 
  3409851, 3356572, 3303293, 3250014, 3196735, 3143457, 3090178, 3036899, 
  2983620, 2930341, 2877062, 2823783, 2770504, 2717225, 2663946, 2610667, 
  2557388, 2504109, 2450831, 2397552, 2344273, 2290994, 2237715, 2184436, 
  2131157, 2077878, 2024599, 1971320, 1918041, 1864762, 1811483, 1758205, 
  1704926, 1651647, 1598368, 1545089, 1491810, 1438531, 1385252, 1331973, 
  1278694, 1225415, 1172136, 1118857, 1065578, 1012300, 959021, 905742, 
  852463, 799184, 745905, 692626, 639347, 586068, 532789, 479510, 
  426231, 372952, 319674, 266395, 213116, 159837, 106558, 53279, 
  0, -53278, -106557, -159836, -213115, -266394, -319673, -372951, 
  -426230, -479509, -532788, -586067, -639346, -692625, -745904, -799183, 
  -852462, -905741, -959020, -1012299, -1065577, -1118856, -1172135, -1225414, 
  -1278693, -1331972, -1385251, -1438530, -1491809, -1545088, -1598367, -1651646, 
  -1704925, -1758204, -1811482, -1864761, -1918040, -1971319, -2024598, -2077877, 
  -2131156, -2184435, -2237714, -2290993, -2344272, -2397551, -2450830, -2504108, 
  -2557387, -2610666, -2663945, -2717224, -2770503, -2823782, -2877061, -2930340, 
  -2983619, -3036898, -3090177, -3143456, -3196734, -3250013, -3303292, -3356571, 
  -3409850, -3463129, -3516408, -3569687, -3622966, -3676245, -3729524, -3782803, 
  -3836082, -3889361, -3942639, -3995918, -4049197, -4102476, -4155755, -4209034, 
  -4262313, -4315592, -4368871, -4422150, -4475429, -4528708, -4581987, -4635265, 
  -4688544, -4741823, -4795102, -4848381, -4901660, -4954939, -5008218, -5061497, 
  -5114776, -5168055, -5221334, -5274613, -5327891, -5381170, -5434449, -5487728, 
  -5541007, -5594286, -5647565, -5700844, -5754123, -5807402, -5860681, -5913960, 
  -5967239, -6020518, -6073796, -6127075, -6180354, -6233633, -6286912, -6340191, 
  -6393470, -6446749, -6500028, -6553307, -6606586, -6659865, -6713144, -6766422, 
};

const int gavl_u_to_b[256] = 
{
  -16921769, -16789567, -16657366, -16525165, -16392963, -16260762, -16128561, -15996359, 
  -15864158, -15731957, -15599755, -15467554, -15335353, -15203151, -15070950, -14938749, 
  -14806547, -14674346, -14542145, -14409944, -14277742, -14145541, -14013340, -13881138, 
  -13748937, -13616736, -13484534, -13352333, -13220132, -13087930, -12955729, -12823528, 
  -12691326, -12559125, -12426924, -12294722, -12162521, -12030320, -11898118, -11765917, 
  -11633716, -11501514, -11369313, -11237112, -11104910, -10972709, -10840508, -10708306, 
  -10576105, -10443904, -10311702, -10179501, -10047300, -9915098, -9782897, -9650696, 
  -9518494, -9386293, -9254092, -9121890, -8989689, -8857488, -8725286, -8593085, 
  -8460884, -8328683, -8196481, -8064280, -7932079, -7799877, -7667676, -7535475, 
  -7403273, -7271072, -7138871, -7006669, -6874468, -6742267, -6610065, -6477864, 
  -6345663, -6213461, -6081260, -5949059, -5816857, -5684656, -5552455, -5420253, 
  -5288052, -5155851, -5023649, -4891448, -4759247, -4627045, -4494844, -4362643, 
  -4230441, -4098240, -3966039, -3833837, -3701636, -3569435, -3437233, -3305032, 
  -3172831, -3040629, -2908428, -2776227, -2644026, -2511824, -2379623, -2247422, 
  -2115220, -1983019, -1850818, -1718616, -1586415, -1454214, -1322012, -1189811, 
  -1057610, -925408, -793207, -661006, -528804, -396603, -264402, -132200, 
  0, 132201, 264403, 396604, 528805, 661007, 793208, 925409, 
  1057611, 1189812, 1322013, 1454215, 1586416, 1718617, 1850819, 1983020, 
  2115221, 2247423, 2379624, 2511825, 2644027, 2776228, 2908429, 3040630, 
  3172832, 3305033, 3437234, 3569436, 3701637, 3833838, 3966040, 4098241, 
  4230442, 4362644, 4494845, 4627046, 4759248, 4891449, 5023650, 5155852, 
  5288053, 5420254, 5552456, 5684657, 5816858, 5949060, 6081261, 6213462, 
  6345664, 6477865, 6610066, 6742268, 6874469, 7006670, 7138872, 7271073, 
  7403274, 7535476, 7667677, 7799878, 7932080, 8064281, 8196482, 8328684, 
  8460885, 8593086, 8725287, 8857489, 8989690, 9121891, 9254093, 9386294, 
  9518495, 9650697, 9782898, 9915099, 10047301, 10179502, 10311703, 10443905, 
  10576106, 10708307, 10840509, 10972710, 11104911, 11237113, 11369314, 11501515, 
  11633717, 11765918, 11898119, 12030321, 12162522, 12294723, 12426925, 12559126, 
  12691327, 12823529, 12955730, 13087931, 13220133, 13352334, 13484535, 13616737, 
  13748938, 13881139, 14013341, 14145542, 14277743, 14409945, 14542146, 14674347, 
  14806548, 14938750, 15070951, 15203152, 15335354, 15467555, 15599756, 15731958, 
  15864159, 15996360, 16128562, 16260763, 16392964, 16525166, 16657367, 16789568, 
};

const int gavl_yj_to_rgb[256] = 
{
  0, 65536, 131072, 196608, 262144, 327680, 393216, 458752, 
  524288, 589824, 655360, 720896, 786432, 851968, 917504, 983040, 
  1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 
  1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 
  2097152, 2162688, 2228224, 2293760, 2359296, 2424832, 2490368, 2555904, 
  2621440, 2686976, 2752512, 2818048, 2883584, 2949120, 3014656, 3080192, 
  3145728, 3211264, 3276800, 3342336, 3407872, 3473408, 3538944, 3604480, 
  3670016, 3735552, 3801088, 3866624, 3932160, 3997696, 4063232, 4128768, 
  4194304, 4259840, 4325376, 4390912, 4456448, 4521984, 4587520, 4653056, 
  4718592, 4784128, 4849664, 4915200, 4980736, 5046272, 5111808, 5177344, 
  5242880, 5308416, 5373952, 5439488, 5505024, 5570560, 5636096, 5701632, 
  5767168, 5832704, 5898240, 5963776, 6029312, 6094848, 6160384, 6225920, 
  6291456, 6356992, 6422528, 6488064, 6553600, 6619136, 6684672, 6750208, 
  6815744, 6881280, 6946816, 7012352, 7077888, 7143424, 7208960, 7274496, 
  7340032, 7405568, 7471104, 7536640, 7602176, 7667712, 7733248, 7798784, 
  7864320, 7929856, 7995392, 8060928, 8126464, 8192000, 8257536, 8323072, 
  8388608, 8454144, 8519680, 8585216, 8650752, 8716288, 8781824, 8847360, 
  8912896, 8978432, 9043968, 9109504, 9175040, 9240576, 9306112, 9371648, 
  9437184, 9502720, 9568256, 9633792, 9699328, 9764864, 9830400, 9895936, 
  9961472, 10027008, 10092544, 10158080, 10223616, 10289152, 10354688, 10420224, 
  10485760, 10551296, 10616832, 10682368, 10747904, 10813440, 10878976, 10944512, 
  11010048, 11075584, 11141120, 11206656, 11272192, 11337728, 11403264, 11468800, 
  11534336, 11599872, 11665408, 11730944, 11796480, 11862016, 11927552, 11993088, 
  12058624, 12124160, 12189696, 12255232, 12320768, 12386304, 12451840, 12517376, 
  12582912, 12648448, 12713984, 12779520, 12845056, 12910592, 12976128, 13041664, 
  13107200, 13172736, 13238272, 13303808, 13369344, 13434880, 13500416, 13565952, 
  13631488, 13697024, 13762560, 13828096, 13893632, 13959168, 14024704, 14090240, 
  14155776, 14221312, 14286848, 14352384, 14417920, 14483456, 14548992, 14614528, 
  14680064, 14745600, 14811136, 14876672, 14942208, 15007744, 15073280, 15138816, 
  15204352, 15269888, 15335424, 15400960, 15466496, 15532032, 15597568, 15663104, 
  15728640, 15794176, 15859712, 15925248, 15990784, 16056320, 16121856, 16187392, 
  16252928, 16318464, 16384000, 16449536, 16515072, 16580608, 16646144, 16711680, 
};

const int gavl_vj_to_r[256] = 
{
  -11760827, -11668946, -11577064, -11485183, -11393302, -11301420, -11209539, -11117657, 
  -11025776, -10933894, -10842013, -10750131, -10658250, -10566368, -10474487, -10382605, 
  -10290724, -10198842, -10106961, -10015079, -9923198, -9831317, -9739435, -9647554, 
  -9555672, -9463791, -9371909, -9280028, -9188146, -9096265, -9004383, -8912502, 
  -8820620, -8728739, -8636857, -8544976, -8453094, -8361213, -8269331, -8177450, 
  -8085569, -7993687, -7901806, -7809924, -7718043, -7626161, -7534280, -7442398, 
  -7350517, -7258635, -7166754, -7074872, -6982991, -6891109, -6799228, -6707346, 
  -6615465, -6523584, -6431702, -6339821, -6247939, -6156058, -6064176, -5972295, 
  -5880413, -5788532, -5696650, -5604769, -5512887, -5421006, -5329124, -5237243, 
  -5145361, -5053480, -4961598, -4869717, -4777836, -4685954, -4594073, -4502191, 
  -4410310, -4318428, -4226547, -4134665, -4042784, -3950902, -3859021, -3767139, 
  -3675258, -3583376, -3491495, -3399613, -3307732, -3215851, -3123969, -3032088, 
  -2940206, -2848325, -2756443, -2664562, -2572680, -2480799, -2388917, -2297036, 
  -2205154, -2113273, -2021391, -1929510, -1837628, -1745747, -1653865, -1561984, 
  -1470103, -1378221, -1286340, -1194458, -1102577, -1010695, -918814, -826932, 
  -735051, -643169, -551288, -459406, -367525, -275643, -183762, -91880, 
  0, 91881, 183763, 275644, 367526, 459407, 551289, 643170, 
  735052, 826933, 918815, 1010696, 1102578, 1194459, 1286341, 1378222, 
  1470104, 1561985, 1653866, 1745748, 1837629, 1929511, 2021392, 2113274, 
  2205155, 2297037, 2388918, 2480800, 2572681, 2664563, 2756444, 2848326, 
  2940207, 3032089, 3123970, 3215852, 3307733, 3399614, 3491496, 3583377, 
  3675259, 3767140, 3859022, 3950903, 4042785, 4134666, 4226548, 4318429, 
  4410311, 4502192, 4594074, 4685955, 4777837, 4869718, 4961599, 5053481, 
  5145362, 5237244, 5329125, 5421007, 5512888, 5604770, 5696651, 5788533, 
  5880414, 5972296, 6064177, 6156059, 6247940, 6339822, 6431703, 6523585, 
  6615466, 6707347, 6799229, 6891110, 6982992, 7074873, 7166755, 7258636, 
  7350518, 7442399, 7534281, 7626162, 7718044, 7809925, 7901807, 7993688, 
  8085570, 8177451, 8269332, 8361214, 8453095, 8544977, 8636858, 8728740, 
  8820621, 8912503, 9004384, 9096266, 9188147, 9280029, 9371910, 9463792, 
  9555673, 9647555, 9739436, 9831318, 9923199, 10015080, 10106962, 10198843, 
  10290725, 10382606, 10474488, 10566369, 10658251, 10750132, 10842014, 10933895, 
  11025777, 11117658, 11209540, 11301421, 11393303, 11485184, 11577065, 11668947, 
};

const int gavl_uj_to_g[256] = 
{
  2886856, 2864302, 2841748, 2819195, 2796641, 2774088, 2751534, 2728981, 
  2706427, 2683874, 2661320, 2638766, 2616213, 2593659, 2571106, 2548552, 
  2525999, 2503445, 2480891, 2458338, 2435784, 2413231, 2390677, 2368124, 
  2345570, 2323017, 2300463, 2277909, 2255356, 2232802, 2210249, 2187695, 
  2165142, 2142588, 2120035, 2097481, 2074927, 2052374, 2029820, 2007267, 
  1984713, 1962160, 1939606, 1917053, 1894499, 1871945, 1849392, 1826838, 
  1804285, 1781731, 1759178, 1736624, 1714070, 1691517, 1668963, 1646410, 
  1623856, 1601303, 1578749, 1556196, 1533642, 1511088, 1488535, 1465981, 
  1443428, 1420874, 1398321, 1375767, 1353214, 1330660, 1308106, 1285553, 
  1262999, 1240446, 1217892, 1195339, 1172785, 1150232, 1127678, 1105124, 
  1082571, 1060017, 1037464, 1014910, 992357, 969803, 947249, 924696, 
  902142, 879589, 857035, 834482, 811928, 789375, 766821, 744267, 
  721714, 699160, 676607, 654053, 631500, 608946, 586393, 563839, 
  541285, 518732, 496178, 473625, 451071, 428518, 405964, 383411, 
  360857, 338303, 315750, 293196, 270643, 248089, 225536, 202982, 
  180428, 157875, 135321, 112768, 90214, 67661, 45107, 22554, 
  0, -22553, -45106, -67660, -90213, -112767, -135320, -157874, 
  -180427, -202981, -225535, -248088, -270642, -293195, -315749, -338302, 
  -360856, -383410, -405963, -428517, -451070, -473624, -496177, -518731, 
  -541284, -563838, -586392, -608945, -631499, -654052, -676606, -699159, 
  -721713, -744266, -766820, -789374, -811927, -834481, -857034, -879588, 
  -902141, -924695, -947248, -969802, -992356, -1014909, -1037463, -1060016, 
  -1082570, -1105123, -1127677, -1150231, -1172784, -1195338, -1217891, -1240445, 
  -1262998, -1285552, -1308105, -1330659, -1353213, -1375766, -1398320, -1420873, 
  -1443427, -1465980, -1488534, -1511087, -1533641, -1556195, -1578748, -1601302, 
  -1623855, -1646409, -1668962, -1691516, -1714069, -1736623, -1759177, -1781730, 
  -1804284, -1826837, -1849391, -1871944, -1894498, -1917052, -1939605, -1962159, 
  -1984712, -2007266, -2029819, -2052373, -2074926, -2097480, -2120034, -2142587, 
  -2165141, -2187694, -2210248, -2232801, -2255355, -2277908, -2300462, -2323016, 
  -2345569, -2368123, -2390676, -2413230, -2435783, -2458337, -2480890, -2503444, 
  -2525998, -2548551, -2571105, -2593658, -2616212, -2638765, -2661319, -2683873, 
  -2706426, -2728980, -2751533, -2774087, -2796640, -2819194, -2841747, -2864301, 
};

const int gavl_vj_to_g[256] = 
{
  5990641, 5943839, 5897037, 5850235, 5803433, 5756631, 5709829, 5663027, 
  5616225, 5569424, 5522622, 5475820, 5429018, 5382216, 5335414, 5288612, 
  5241810, 5195009, 5148207, 5101405, 5054603, 5007801, 4960999, 4914197, 
  4867395, 4820594, 4773792, 4726990, 4680188, 4633386, 4586584, 4539782, 
  4492980, 4446179, 4399377, 4352575, 4305773, 4258971, 4212169, 4165367, 
  4118565, 4071763, 4024962, 3978160, 3931358, 3884556, 3837754, 3790952, 
  3744150, 3697348, 3650547, 3603745, 3556943, 3510141, 3463339, 3416537, 
  3369735, 3322933, 3276132, 3229330, 3182528, 3135726, 3088924, 3042122, 
  2995320, 2948518, 2901717, 2854915, 2808113, 2761311, 2714509, 2667707, 
  2620905, 2574103, 2527301, 2480500, 2433698, 2386896, 2340094, 2293292, 
  2246490, 2199688, 2152886, 2106085, 2059283, 2012481, 1965679, 1918877, 
  1872075, 1825273, 1778471, 1731670, 1684868, 1638066, 1591264, 1544462, 
  1497660, 1450858, 1404056, 1357254, 1310453, 1263651, 1216849, 1170047, 
  1123245, 1076443, 1029641, 982839, 936038, 889236, 842434, 795632, 
  748830, 702028, 655226, 608424, 561623, 514821, 468019, 421217, 
  374415, 327613, 280811, 234009, 187208, 140406, 93604, 46802, 
  0, -46801, -93603, -140405, -187207, -234008, -280810, -327612, 
  -374414, -421216, -468018, -514820, -561622, -608423, -655225, -702027, 
  -748829, -795631, -842433, -889235, -936037, -982838, -1029640, -1076442, 
  -1123244, -1170046, -1216848, -1263650, -1310452, -1357253, -1404055, -1450857, 
  -1497659, -1544461, -1591263, -1638065, -1684867, -1731669, -1778470, -1825272, 
  -1872074, -1918876, -1965678, -2012480, -2059282, -2106084, -2152885, -2199687, 
  -2246489, -2293291, -2340093, -2386895, -2433697, -2480499, -2527300, -2574102, 
  -2620904, -2667706, -2714508, -2761310, -2808112, -2854914, -2901716, -2948517, 
  -2995319, -3042121, -3088923, -3135725, -3182527, -3229329, -3276131, -3322932, 
  -3369734, -3416536, -3463338, -3510140, -3556942, -3603744, -3650546, -3697347, 
  -3744149, -3790951, -3837753, -3884555, -3931357, -3978159, -4024961, -4071762, 
  -4118564, -4165366, -4212168, -4258970, -4305772, -4352574, -4399376, -4446178, 
  -4492979, -4539781, -4586583, -4633385, -4680187, -4726989, -4773791, -4820593, 
  -4867394, -4914196, -4960998, -5007800, -5054602, -5101404, -5148206, -5195008, 
  -5241809, -5288611, -5335413, -5382215, -5429017, -5475819, -5522621, -5569423, 
  -5616224, -5663026, -5709828, -5756630, -5803432, -5850234, -5897036, -5943838, 
};

const int gavl_uj_to_b[256] = 
{
  -14864612, -14748483, -14632353, -14516223, -14400093, -14283963, -14167834, -14051704, 
  -13935574, -13819444, -13703314, -13587185, -13471055, -13354925, -13238795, -13122665, 
  -13006536, -12890406, -12774276, -12658146, -12542017, -12425887, -12309757, -12193627, 
  -12077497, -11961368, -11845238, -11729108, -11612978, -11496848, -11380719, -11264589, 
  -11148459, -11032329, -10916199, -10800070, -10683940, -10567810, -10451680, -10335550, 
  -10219421, -10103291, -9987161, -9871031, -9754902, -9638772, -9522642, -9406512, 
  -9290382, -9174253, -9058123, -8941993, -8825863, -8709733, -8593604, -8477474, 
  -8361344, -8245214, -8129084, -8012955, -7896825, -7780695, -7664565, -7548435, 
  -7432306, -7316176, -7200046, -7083916, -6967787, -6851657, -6735527, -6619397, 
  -6503267, -6387138, -6271008, -6154878, -6038748, -5922618, -5806489, -5690359, 
  -5574229, -5458099, -5341969, -5225840, -5109710, -4993580, -4877450, -4761320, 
  -4645191, -4529061, -4412931, -4296801, -4180672, -4064542, -3948412, -3832282, 
  -3716152, -3600023, -3483893, -3367763, -3251633, -3135503, -3019374, -2903244, 
  -2787114, -2670984, -2554854, -2438725, -2322595, -2206465, -2090335, -1974205, 
  -1858076, -1741946, -1625816, -1509686, -1393557, -1277427, -1161297, -1045167, 
  -929037, -812908, -696778, -580648, -464518, -348388, -232259, -116129, 
  0, 116130, 232260, 348389, 464519, 580649, 696779, 812909, 
  929038, 1045168, 1161298, 1277428, 1393558, 1509687, 1625817, 1741947, 
  1858077, 1974206, 2090336, 2206466, 2322596, 2438726, 2554855, 2670985, 
  2787115, 2903245, 3019375, 3135504, 3251634, 3367764, 3483894, 3600024, 
  3716153, 3832283, 3948413, 4064543, 4180673, 4296802, 4412932, 4529062, 
  4645192, 4761321, 4877451, 4993581, 5109711, 5225841, 5341970, 5458100, 
  5574230, 5690360, 5806490, 5922619, 6038749, 6154879, 6271009, 6387139, 
  6503268, 6619398, 6735528, 6851658, 6967788, 7083917, 7200047, 7316177, 
  7432307, 7548436, 7664566, 7780696, 7896826, 8012956, 8129085, 8245215, 
  8361345, 8477475, 8593605, 8709734, 8825864, 8941994, 9058124, 9174254, 
  9290383, 9406513, 9522643, 9638773, 9754903, 9871032, 9987162, 10103292, 
  10219422, 10335551, 10451681, 10567811, 10683941, 10800071, 10916200, 11032330, 
  11148460, 11264590, 11380720, 11496849, 11612979, 11729109, 11845239, 11961369, 
  12077498, 12193628, 12309758, 12425888, 12542018, 12658147, 12774277, 12890407, 
  13006537, 13122666, 13238796, 13354926, 13471056, 13587186, 13703315, 13819445, 
  13935575, 14051705, 14167835, 14283964, 14400094, 14516224, 14632354, 14748484, 
};

const float gavl_y_to_rgb_float[256] = 
{
  -0.073059, -0.068493, -0.063927, -0.059361, -0.054795, -0.050228, -0.045662, -0.041096, 
  -0.036530, -0.031963, -0.027397, -0.022831, -0.018265, -0.013699, -0.009132, -0.004566, 
  0.000000, 0.004566, 0.009132, 0.013699, 0.018265, 0.022831, 0.027397, 0.031963, 
  0.036530, 0.041096, 0.045662, 0.050228, 0.054795, 0.059361, 0.063927, 0.068493, 
  0.073059, 0.077626, 0.082192, 0.086758, 0.091324, 0.095890, 0.100457, 0.105023, 
  0.109589, 0.114155, 0.118721, 0.123288, 0.127854, 0.132420, 0.136986, 0.141553, 
  0.146119, 0.150685, 0.155251, 0.159817, 0.164384, 0.168950, 0.173516, 0.178082, 
  0.182648, 0.187215, 0.191781, 0.196347, 0.200913, 0.205479, 0.210046, 0.214612, 
  0.219178, 0.223744, 0.228311, 0.232877, 0.237443, 0.242009, 0.246575, 0.251142, 
  0.255708, 0.260274, 0.264840, 0.269406, 0.273973, 0.278539, 0.283105, 0.287671, 
  0.292237, 0.296804, 0.301370, 0.305936, 0.310502, 0.315068, 0.319635, 0.324201, 
  0.328767, 0.333333, 0.337900, 0.342466, 0.347032, 0.351598, 0.356164, 0.360731, 
  0.365297, 0.369863, 0.374429, 0.378995, 0.383562, 0.388128, 0.392694, 0.397260, 
  0.401826, 0.406393, 0.410959, 0.415525, 0.420091, 0.424658, 0.429224, 0.433790, 
  0.438356, 0.442922, 0.447489, 0.452055, 0.456621, 0.461187, 0.465753, 0.470320, 
  0.474886, 0.479452, 0.484018, 0.488584, 0.493151, 0.497717, 0.502283, 0.506849, 
  0.511416, 0.515982, 0.520548, 0.525114, 0.529680, 0.534247, 0.538813, 0.543379, 
  0.547945, 0.552511, 0.557078, 0.561644, 0.566210, 0.570776, 0.575342, 0.579909, 
  0.584475, 0.589041, 0.593607, 0.598174, 0.602740, 0.607306, 0.611872, 0.616438, 
  0.621005, 0.625571, 0.630137, 0.634703, 0.639269, 0.643836, 0.648402, 0.652968, 
  0.657534, 0.662100, 0.666667, 0.671233, 0.675799, 0.680365, 0.684932, 0.689498, 
  0.694064, 0.698630, 0.703196, 0.707763, 0.712329, 0.716895, 0.721461, 0.726027, 
  0.730594, 0.735160, 0.739726, 0.744292, 0.748858, 0.753425, 0.757991, 0.762557, 
  0.767123, 0.771689, 0.776256, 0.780822, 0.785388, 0.789954, 0.794521, 0.799087, 
  0.803653, 0.808219, 0.812785, 0.817352, 0.821918, 0.826484, 0.831050, 0.835616, 
  0.840183, 0.844749, 0.849315, 0.853881, 0.858447, 0.863014, 0.867580, 0.872146, 
  0.876712, 0.881279, 0.885845, 0.890411, 0.894977, 0.899543, 0.904110, 0.908676, 
  0.913242, 0.917808, 0.922374, 0.926941, 0.931507, 0.936073, 0.940639, 0.945205, 
  0.949772, 0.954338, 0.958904, 0.963470, 0.968037, 0.972603, 0.977169, 0.981735, 
  0.986301, 0.990868, 0.995434, 1.000000, 1.004566, 1.009132, 1.013699, 1.018265, 
  1.022831, 1.027397, 1.031963, 1.036530, 1.041096, 1.045662, 1.050228, 1.054795, 
  1.059361, 1.063927, 1.068493, 1.073059, 1.077626, 1.082192, 1.086758, 1.091324, 
};

const float gavl_v_to_r_float[256] = 
{
  -0.801143, -0.794884, -0.788625, -0.782366, -0.776107, -0.769848, -0.763589, -0.757330, 
  -0.751071, -0.744812, -0.738554, -0.732295, -0.726036, -0.719777, -0.713518, -0.707259, 
  -0.701000, -0.694741, -0.688482, -0.682223, -0.675964, -0.669705, -0.663446, -0.657187, 
  -0.650929, -0.644670, -0.638411, -0.632152, -0.625893, -0.619634, -0.613375, -0.607116, 
  -0.600857, -0.594598, -0.588339, -0.582080, -0.575821, -0.569562, -0.563304, -0.557045, 
  -0.550786, -0.544527, -0.538268, -0.532009, -0.525750, -0.519491, -0.513232, -0.506973, 
  -0.500714, -0.494455, -0.488196, -0.481937, -0.475679, -0.469420, -0.463161, -0.456902, 
  -0.450643, -0.444384, -0.438125, -0.431866, -0.425607, -0.419348, -0.413089, -0.406830, 
  -0.400571, -0.394312, -0.388054, -0.381795, -0.375536, -0.369277, -0.363018, -0.356759, 
  -0.350500, -0.344241, -0.337982, -0.331723, -0.325464, -0.319205, -0.312946, -0.306687, 
  -0.300429, -0.294170, -0.287911, -0.281652, -0.275393, -0.269134, -0.262875, -0.256616, 
  -0.250357, -0.244098, -0.237839, -0.231580, -0.225321, -0.219062, -0.212804, -0.206545, 
  -0.200286, -0.194027, -0.187768, -0.181509, -0.175250, -0.168991, -0.162732, -0.156473, 
  -0.150214, -0.143955, -0.137696, -0.131437, -0.125179, -0.118920, -0.112661, -0.106402, 
  -0.100143, -0.093884, -0.087625, -0.081366, -0.075107, -0.068848, -0.062589, -0.056330, 
  -0.050071, -0.043812, -0.037554, -0.031295, -0.025036, -0.018777, -0.012518, -0.006259, 
  0.000000, 0.006259, 0.012518, 0.018777, 0.025036, 0.031295, 0.037554, 0.043812, 
  0.050071, 0.056330, 0.062589, 0.068848, 0.075107, 0.081366, 0.087625, 0.093884, 
  0.100143, 0.106402, 0.112661, 0.118920, 0.125179, 0.131437, 0.137696, 0.143955, 
  0.150214, 0.156473, 0.162732, 0.168991, 0.175250, 0.181509, 0.187768, 0.194027, 
  0.200286, 0.206545, 0.212804, 0.219062, 0.225321, 0.231580, 0.237839, 0.244098, 
  0.250357, 0.256616, 0.262875, 0.269134, 0.275393, 0.281652, 0.287911, 0.294170, 
  0.300429, 0.306687, 0.312946, 0.319205, 0.325464, 0.331723, 0.337982, 0.344241, 
  0.350500, 0.356759, 0.363018, 0.369277, 0.375536, 0.381795, 0.388054, 0.394312, 
  0.400571, 0.406830, 0.413089, 0.419348, 0.425607, 0.431866, 0.438125, 0.444384, 
  0.450643, 0.456902, 0.463161, 0.469420, 0.475679, 0.481937, 0.488196, 0.494455, 
  0.500714, 0.506973, 0.513232, 0.519491, 0.525750, 0.532009, 0.538268, 0.544527, 
  0.550786, 0.557045, 0.563304, 0.569562, 0.575821, 0.582080, 0.588339, 0.594598, 
  0.600857, 0.607116, 0.613375, 0.619634, 0.625893, 0.632152, 0.638411, 0.644670, 
  0.650929, 0.657187, 0.663446, 0.669705, 0.675964, 0.682223, 0.688482, 0.694741, 
  0.701000, 0.707259, 0.713518, 0.719777, 0.726036, 0.732295, 0.738554, 0.744812, 
  0.751071, 0.757330, 0.763589, 0.769848, 0.776107, 0.782366, 0.788625, 0.794884, 
};

const float gavl_u_to_g_float[256] = 
{
  0.196651, 0.195115, 0.193579, 0.192042, 0.190506, 0.188970, 0.187433, 0.185897, 
  0.184361, 0.182824, 0.181288, 0.179752, 0.178215, 0.176679, 0.175143, 0.173606, 
  0.172070, 0.170534, 0.168997, 0.167461, 0.165925, 0.164388, 0.162852, 0.161316, 
  0.159779, 0.158243, 0.156707, 0.155170, 0.153634, 0.152098, 0.150561, 0.149025, 
  0.147489, 0.145952, 0.144416, 0.142880, 0.141343, 0.139807, 0.138271, 0.136734, 
  0.135198, 0.133662, 0.132125, 0.130589, 0.129052, 0.127516, 0.125980, 0.124443, 
  0.122907, 0.121371, 0.119834, 0.118298, 0.116762, 0.115225, 0.113689, 0.112153, 
  0.110616, 0.109080, 0.107544, 0.106007, 0.104471, 0.102935, 0.101398, 0.099862, 
  0.098326, 0.096789, 0.095253, 0.093717, 0.092180, 0.090644, 0.089108, 0.087571, 
  0.086035, 0.084499, 0.082962, 0.081426, 0.079890, 0.078353, 0.076817, 0.075281, 
  0.073744, 0.072208, 0.070672, 0.069135, 0.067599, 0.066063, 0.064526, 0.062990, 
  0.061454, 0.059917, 0.058381, 0.056845, 0.055308, 0.053772, 0.052236, 0.050699, 
  0.049163, 0.047627, 0.046090, 0.044554, 0.043018, 0.041481, 0.039945, 0.038408, 
  0.036872, 0.035336, 0.033799, 0.032263, 0.030727, 0.029190, 0.027654, 0.026118, 
  0.024581, 0.023045, 0.021509, 0.019972, 0.018436, 0.016900, 0.015363, 0.013827, 
  0.012291, 0.010754, 0.009218, 0.007682, 0.006145, 0.004609, 0.003073, 0.001536, 
  -0.000000, -0.001536, -0.003073, -0.004609, -0.006145, -0.007682, -0.009218, -0.010754, 
  -0.012291, -0.013827, -0.015363, -0.016900, -0.018436, -0.019972, -0.021509, -0.023045, 
  -0.024581, -0.026118, -0.027654, -0.029190, -0.030727, -0.032263, -0.033799, -0.035336, 
  -0.036872, -0.038408, -0.039945, -0.041481, -0.043018, -0.044554, -0.046090, -0.047627, 
  -0.049163, -0.050699, -0.052236, -0.053772, -0.055308, -0.056845, -0.058381, -0.059917, 
  -0.061454, -0.062990, -0.064526, -0.066063, -0.067599, -0.069135, -0.070672, -0.072208, 
  -0.073744, -0.075281, -0.076817, -0.078353, -0.079890, -0.081426, -0.082962, -0.084499, 
  -0.086035, -0.087571, -0.089108, -0.090644, -0.092180, -0.093717, -0.095253, -0.096789, 
  -0.098326, -0.099862, -0.101398, -0.102935, -0.104471, -0.106007, -0.107544, -0.109080, 
  -0.110616, -0.112153, -0.113689, -0.115225, -0.116762, -0.118298, -0.119834, -0.121371, 
  -0.122907, -0.124443, -0.125980, -0.127516, -0.129052, -0.130589, -0.132125, -0.133662, 
  -0.135198, -0.136734, -0.138271, -0.139807, -0.141343, -0.142880, -0.144416, -0.145952, 
  -0.147489, -0.149025, -0.150561, -0.152098, -0.153634, -0.155170, -0.156707, -0.158243, 
  -0.159779, -0.161316, -0.162852, -0.164388, -0.165925, -0.167461, -0.168997, -0.170534, 
  -0.172070, -0.173606, -0.175143, -0.176679, -0.178215, -0.179752, -0.181288, -0.182824, 
  -0.184361, -0.185897, -0.187433, -0.188970, -0.190506, -0.192042, -0.193579, -0.195115, 
};

const float gavl_v_to_g_float[256] = 
{
  0.408080, 0.404892, 0.401704, 0.398516, 0.395327, 0.392139, 0.388951, 0.385763, 
  0.382575, 0.379387, 0.376199, 0.373011, 0.369822, 0.366634, 0.363446, 0.360258, 
  0.357070, 0.353882, 0.350694, 0.347506, 0.344317, 0.341129, 0.337941, 0.334753, 
  0.331565, 0.328377, 0.325189, 0.322001, 0.318812, 0.315624, 0.312436, 0.309248, 
  0.306060, 0.302872, 0.299684, 0.296496, 0.293307, 0.290119, 0.286931, 0.283743, 
  0.280555, 0.277367, 0.274179, 0.270991, 0.267802, 0.264614, 0.261426, 0.258238, 
  0.255050, 0.251862, 0.248674, 0.245486, 0.242297, 0.239109, 0.235921, 0.232733, 
  0.229545, 0.226357, 0.223169, 0.219981, 0.216792, 0.213604, 0.210416, 0.207228, 
  0.204040, 0.200852, 0.197664, 0.194476, 0.191287, 0.188099, 0.184911, 0.181723, 
  0.178535, 0.175347, 0.172159, 0.168971, 0.165782, 0.162594, 0.159406, 0.156218, 
  0.153030, 0.149842, 0.146654, 0.143466, 0.140277, 0.137089, 0.133901, 0.130713, 
  0.127525, 0.124337, 0.121149, 0.117961, 0.114772, 0.111584, 0.108396, 0.105208, 
  0.102020, 0.098832, 0.095644, 0.092456, 0.089267, 0.086079, 0.082891, 0.079703, 
  0.076515, 0.073327, 0.070139, 0.066951, 0.063762, 0.060574, 0.057386, 0.054198, 
  0.051010, 0.047822, 0.044634, 0.041446, 0.038257, 0.035069, 0.031881, 0.028693, 
  0.025505, 0.022317, 0.019129, 0.015941, 0.012752, 0.009564, 0.006376, 0.003188, 
  -0.000000, -0.003188, -0.006376, -0.009564, -0.012752, -0.015941, -0.019129, -0.022317, 
  -0.025505, -0.028693, -0.031881, -0.035069, -0.038257, -0.041446, -0.044634, -0.047822, 
  -0.051010, -0.054198, -0.057386, -0.060574, -0.063762, -0.066951, -0.070139, -0.073327, 
  -0.076515, -0.079703, -0.082891, -0.086079, -0.089267, -0.092456, -0.095644, -0.098832, 
  -0.102020, -0.105208, -0.108396, -0.111584, -0.114772, -0.117961, -0.121149, -0.124337, 
  -0.127525, -0.130713, -0.133901, -0.137089, -0.140277, -0.143466, -0.146654, -0.149842, 
  -0.153030, -0.156218, -0.159406, -0.162594, -0.165782, -0.168971, -0.172159, -0.175347, 
  -0.178535, -0.181723, -0.184911, -0.188099, -0.191287, -0.194476, -0.197664, -0.200852, 
  -0.204040, -0.207228, -0.210416, -0.213604, -0.216792, -0.219981, -0.223169, -0.226357, 
  -0.229545, -0.232733, -0.235921, -0.239109, -0.242297, -0.245486, -0.248674, -0.251862, 
  -0.255050, -0.258238, -0.261426, -0.264614, -0.267802, -0.270991, -0.274179, -0.277367, 
  -0.280555, -0.283743, -0.286931, -0.290119, -0.293307, -0.296496, -0.299684, -0.302872, 
  -0.306060, -0.309248, -0.312436, -0.315624, -0.318812, -0.322001, -0.325189, -0.328377, 
  -0.331565, -0.334753, -0.337941, -0.341129, -0.344317, -0.347506, -0.350694, -0.353882, 
  -0.357070, -0.360258, -0.363446, -0.366634, -0.369822, -0.373011, -0.376199, -0.379387, 
  -0.382575, -0.385763, -0.388951, -0.392139, -0.395327, -0.398516, -0.401704, -0.404892, 
};

const float gavl_u_to_b_float[256] = 
{
  -1.012571, -1.004661, -0.996750, -0.988839, -0.980929, -0.973018, -0.965107, -0.957196, 
  -0.949286, -0.941375, -0.933464, -0.925554, -0.917643, -0.909732, -0.901821, -0.893911, 
  -0.886000, -0.878089, -0.870179, -0.862268, -0.854357, -0.846446, -0.838536, -0.830625, 
  -0.822714, -0.814804, -0.806893, -0.798982, -0.791071, -0.783161, -0.775250, -0.767339, 
  -0.759429, -0.751518, -0.743607, -0.735696, -0.727786, -0.719875, -0.711964, -0.704054, 
  -0.696143, -0.688232, -0.680321, -0.672411, -0.664500, -0.656589, -0.648679, -0.640768, 
  -0.632857, -0.624946, -0.617036, -0.609125, -0.601214, -0.593304, -0.585393, -0.577482, 
  -0.569571, -0.561661, -0.553750, -0.545839, -0.537929, -0.530018, -0.522107, -0.514196, 
  -0.506286, -0.498375, -0.490464, -0.482554, -0.474643, -0.466732, -0.458821, -0.450911, 
  -0.443000, -0.435089, -0.427179, -0.419268, -0.411357, -0.403446, -0.395536, -0.387625, 
  -0.379714, -0.371804, -0.363893, -0.355982, -0.348071, -0.340161, -0.332250, -0.324339, 
  -0.316429, -0.308518, -0.300607, -0.292696, -0.284786, -0.276875, -0.268964, -0.261054, 
  -0.253143, -0.245232, -0.237321, -0.229411, -0.221500, -0.213589, -0.205679, -0.197768, 
  -0.189857, -0.181946, -0.174036, -0.166125, -0.158214, -0.150304, -0.142393, -0.134482, 
  -0.126571, -0.118661, -0.110750, -0.102839, -0.094929, -0.087018, -0.079107, -0.071196, 
  -0.063286, -0.055375, -0.047464, -0.039554, -0.031643, -0.023732, -0.015821, -0.007911, 
  0.000000, 0.007911, 0.015821, 0.023732, 0.031643, 0.039554, 0.047464, 0.055375, 
  0.063286, 0.071196, 0.079107, 0.087018, 0.094929, 0.102839, 0.110750, 0.118661, 
  0.126571, 0.134482, 0.142393, 0.150304, 0.158214, 0.166125, 0.174036, 0.181946, 
  0.189857, 0.197768, 0.205679, 0.213589, 0.221500, 0.229411, 0.237321, 0.245232, 
  0.253143, 0.261054, 0.268964, 0.276875, 0.284786, 0.292696, 0.300607, 0.308518, 
  0.316429, 0.324339, 0.332250, 0.340161, 0.348071, 0.355982, 0.363893, 0.371804, 
  0.379714, 0.387625, 0.395536, 0.403446, 0.411357, 0.419268, 0.427179, 0.435089, 
  0.443000, 0.450911, 0.458821, 0.466732, 0.474643, 0.482554, 0.490464, 0.498375, 
  0.506286, 0.514196, 0.522107, 0.530018, 0.537929, 0.545839, 0.553750, 0.561661, 
  0.569571, 0.577482, 0.585393, 0.593304, 0.601214, 0.609125, 0.617036, 0.624946, 
  0.632857, 0.640768, 0.648679, 0.656589, 0.664500, 0.672411, 0.680321, 0.688232, 
  0.696143, 0.704054, 0.711964, 0.719875, 0.727786, 0.735696, 0.743607, 0.751518, 
  0.759429, 0.767339, 0.775250, 0.783161, 0.791071, 0.798982, 0.806893, 0.814804, 
  0.822714, 0.830625, 0.838536, 0.846446, 0.854357, 0.862268, 0.870179, 0.878089, 
  0.886000, 0.893911, 0.901821, 0.909732, 0.917643, 0.925554, 0.933464, 0.941375, 
  0.949286, 0.957196, 0.965107, 0.973018, 0.980929, 0.988839, 0.996750, 1.004661, 
};

const float gavl_yj_to_rgb_float[256] = 
{
  0.000000, 0.003922, 0.007843, 0.011765, 0.015686, 0.019608, 0.023529, 0.027451, 
  0.031373, 0.035294, 0.039216, 0.043137, 0.047059, 0.050980, 0.054902, 0.058824, 
  0.062745, 0.066667, 0.070588, 0.074510, 0.078431, 0.082353, 0.086275, 0.090196, 
  0.094118, 0.098039, 0.101961, 0.105882, 0.109804, 0.113725, 0.117647, 0.121569, 
  0.125490, 0.129412, 0.133333, 0.137255, 0.141176, 0.145098, 0.149020, 0.152941, 
  0.156863, 0.160784, 0.164706, 0.168627, 0.172549, 0.176471, 0.180392, 0.184314, 
  0.188235, 0.192157, 0.196078, 0.200000, 0.203922, 0.207843, 0.211765, 0.215686, 
  0.219608, 0.223529, 0.227451, 0.231373, 0.235294, 0.239216, 0.243137, 0.247059, 
  0.250980, 0.254902, 0.258824, 0.262745, 0.266667, 0.270588, 0.274510, 0.278431, 
  0.282353, 0.286275, 0.290196, 0.294118, 0.298039, 0.301961, 0.305882, 0.309804, 
  0.313725, 0.317647, 0.321569, 0.325490, 0.329412, 0.333333, 0.337255, 0.341176, 
  0.345098, 0.349020, 0.352941, 0.356863, 0.360784, 0.364706, 0.368627, 0.372549, 
  0.376471, 0.380392, 0.384314, 0.388235, 0.392157, 0.396078, 0.400000, 0.403922, 
  0.407843, 0.411765, 0.415686, 0.419608, 0.423529, 0.427451, 0.431373, 0.435294, 
  0.439216, 0.443137, 0.447059, 0.450980, 0.454902, 0.458824, 0.462745, 0.466667, 
  0.470588, 0.474510, 0.478431, 0.482353, 0.486275, 0.490196, 0.494118, 0.498039, 
  0.501961, 0.505882, 0.509804, 0.513725, 0.517647, 0.521569, 0.525490, 0.529412, 
  0.533333, 0.537255, 0.541176, 0.545098, 0.549020, 0.552941, 0.556863, 0.560784, 
  0.564706, 0.568627, 0.572549, 0.576471, 0.580392, 0.584314, 0.588235, 0.592157, 
  0.596078, 0.600000, 0.603922, 0.607843, 0.611765, 0.615686, 0.619608, 0.623529, 
  0.627451, 0.631373, 0.635294, 0.639216, 0.643137, 0.647059, 0.650980, 0.654902, 
  0.658824, 0.662745, 0.666667, 0.670588, 0.674510, 0.678431, 0.682353, 0.686275, 
  0.690196, 0.694118, 0.698039, 0.701961, 0.705882, 0.709804, 0.713725, 0.717647, 
  0.721569, 0.725490, 0.729412, 0.733333, 0.737255, 0.741176, 0.745098, 0.749020, 
  0.752941, 0.756863, 0.760784, 0.764706, 0.768627, 0.772549, 0.776471, 0.780392, 
  0.784314, 0.788235, 0.792157, 0.796078, 0.800000, 0.803922, 0.807843, 0.811765, 
  0.815686, 0.819608, 0.823529, 0.827451, 0.831373, 0.835294, 0.839216, 0.843137, 
  0.847059, 0.850980, 0.854902, 0.858824, 0.862745, 0.866667, 0.870588, 0.874510, 
  0.878431, 0.882353, 0.886275, 0.890196, 0.894118, 0.898039, 0.901961, 0.905882, 
  0.909804, 0.913725, 0.917647, 0.921569, 0.925490, 0.929412, 0.933333, 0.937255, 
  0.941176, 0.945098, 0.949020, 0.952941, 0.956863, 0.960784, 0.964706, 0.968627, 
  0.972549, 0.976471, 0.980392, 0.984314, 0.988235, 0.992157, 0.996078, 1.000000, 
};

const float gavl_vj_to_r_float[256] = 
{
  -0.703749, -0.698251, -0.692753, -0.687255, -0.681757, -0.676259, -0.670761, -0.665263, 
  -0.659765, -0.654267, -0.648769, -0.643271, -0.637773, -0.632275, -0.626776, -0.621278, 
  -0.615780, -0.610282, -0.604784, -0.599286, -0.593788, -0.588290, -0.582792, -0.577294, 
  -0.571796, -0.566298, -0.560800, -0.555302, -0.549804, -0.544306, -0.538808, -0.533310, 
  -0.527812, -0.522314, -0.516816, -0.511318, -0.505820, -0.500322, -0.494824, -0.489325, 
  -0.483827, -0.478329, -0.472831, -0.467333, -0.461835, -0.456337, -0.450839, -0.445341, 
  -0.439843, -0.434345, -0.428847, -0.423349, -0.417851, -0.412353, -0.406855, -0.401357, 
  -0.395859, -0.390361, -0.384863, -0.379365, -0.373867, -0.368369, -0.362871, -0.357373, 
  -0.351875, -0.346376, -0.340878, -0.335380, -0.329882, -0.324384, -0.318886, -0.313388, 
  -0.307890, -0.302392, -0.296894, -0.291396, -0.285898, -0.280400, -0.274902, -0.269404, 
  -0.263906, -0.258408, -0.252910, -0.247412, -0.241914, -0.236416, -0.230918, -0.225420, 
  -0.219922, -0.214424, -0.208925, -0.203427, -0.197929, -0.192431, -0.186933, -0.181435, 
  -0.175937, -0.170439, -0.164941, -0.159443, -0.153945, -0.148447, -0.142949, -0.137451, 
  -0.131953, -0.126455, -0.120957, -0.115459, -0.109961, -0.104463, -0.098965, -0.093467, 
  -0.087969, -0.082471, -0.076973, -0.071475, -0.065976, -0.060478, -0.054980, -0.049482, 
  -0.043984, -0.038486, -0.032988, -0.027490, -0.021992, -0.016494, -0.010996, -0.005498, 
  0.000000, 0.005498, 0.010996, 0.016494, 0.021992, 0.027490, 0.032988, 0.038486, 
  0.043984, 0.049482, 0.054980, 0.060478, 0.065976, 0.071475, 0.076973, 0.082471, 
  0.087969, 0.093467, 0.098965, 0.104463, 0.109961, 0.115459, 0.120957, 0.126455, 
  0.131953, 0.137451, 0.142949, 0.148447, 0.153945, 0.159443, 0.164941, 0.170439, 
  0.175937, 0.181435, 0.186933, 0.192431, 0.197929, 0.203427, 0.208925, 0.214424, 
  0.219922, 0.225420, 0.230918, 0.236416, 0.241914, 0.247412, 0.252910, 0.258408, 
  0.263906, 0.269404, 0.274902, 0.280400, 0.285898, 0.291396, 0.296894, 0.302392, 
  0.307890, 0.313388, 0.318886, 0.324384, 0.329882, 0.335380, 0.340878, 0.346376, 
  0.351875, 0.357373, 0.362871, 0.368369, 0.373867, 0.379365, 0.384863, 0.390361, 
  0.395859, 0.401357, 0.406855, 0.412353, 0.417851, 0.423349, 0.428847, 0.434345, 
  0.439843, 0.445341, 0.450839, 0.456337, 0.461835, 0.467333, 0.472831, 0.478329, 
  0.483827, 0.489325, 0.494824, 0.500322, 0.505820, 0.511318, 0.516816, 0.522314, 
  0.527812, 0.533310, 0.538808, 0.544306, 0.549804, 0.555302, 0.560800, 0.566298, 
  0.571796, 0.577294, 0.582792, 0.588290, 0.593788, 0.599286, 0.604784, 0.610282, 
  0.615780, 0.621278, 0.626776, 0.632275, 0.637773, 0.643271, 0.648769, 0.654267, 
  0.659765, 0.665263, 0.670761, 0.676259, 0.681757, 0.687255, 0.692753, 0.698251, 
};

const float gavl_uj_to_g_float[256] = 
{
  0.172745, 0.171395, 0.170046, 0.168696, 0.167347, 0.165997, 0.164647, 0.163298, 
  0.161948, 0.160599, 0.159249, 0.157900, 0.156550, 0.155200, 0.153851, 0.152501, 
  0.151152, 0.149802, 0.148453, 0.147103, 0.145753, 0.144404, 0.143054, 0.141705, 
  0.140355, 0.139006, 0.137656, 0.136306, 0.134957, 0.133607, 0.132258, 0.130908, 
  0.129559, 0.128209, 0.126859, 0.125510, 0.124160, 0.122811, 0.121461, 0.120112, 
  0.118762, 0.117412, 0.116063, 0.114713, 0.113364, 0.112014, 0.110665, 0.109315, 
  0.107965, 0.106616, 0.105266, 0.103917, 0.102567, 0.101218, 0.099868, 0.098519, 
  0.097169, 0.095819, 0.094470, 0.093120, 0.091771, 0.090421, 0.089072, 0.087722, 
  0.086372, 0.085023, 0.083673, 0.082324, 0.080974, 0.079625, 0.078275, 0.076925, 
  0.075576, 0.074226, 0.072877, 0.071527, 0.070178, 0.068828, 0.067478, 0.066129, 
  0.064779, 0.063430, 0.062080, 0.060731, 0.059381, 0.058031, 0.056682, 0.055332, 
  0.053983, 0.052633, 0.051284, 0.049934, 0.048584, 0.047235, 0.045885, 0.044536, 
  0.043186, 0.041837, 0.040487, 0.039137, 0.037788, 0.036438, 0.035089, 0.033739, 
  0.032390, 0.031040, 0.029691, 0.028341, 0.026991, 0.025642, 0.024292, 0.022943, 
  0.021593, 0.020244, 0.018894, 0.017544, 0.016195, 0.014845, 0.013496, 0.012146, 
  0.010797, 0.009447, 0.008097, 0.006748, 0.005398, 0.004049, 0.002699, 0.001350, 
  -0.000000, -0.001350, -0.002699, -0.004049, -0.005398, -0.006748, -0.008097, -0.009447, 
  -0.010797, -0.012146, -0.013496, -0.014845, -0.016195, -0.017544, -0.018894, -0.020244, 
  -0.021593, -0.022943, -0.024292, -0.025642, -0.026991, -0.028341, -0.029691, -0.031040, 
  -0.032390, -0.033739, -0.035089, -0.036438, -0.037788, -0.039137, -0.040487, -0.041837, 
  -0.043186, -0.044536, -0.045885, -0.047235, -0.048584, -0.049934, -0.051284, -0.052633, 
  -0.053983, -0.055332, -0.056682, -0.058031, -0.059381, -0.060731, -0.062080, -0.063430, 
  -0.064779, -0.066129, -0.067478, -0.068828, -0.070178, -0.071527, -0.072877, -0.074226, 
  -0.075576, -0.076925, -0.078275, -0.079625, -0.080974, -0.082324, -0.083673, -0.085023, 
  -0.086372, -0.087722, -0.089072, -0.090421, -0.091771, -0.093120, -0.094470, -0.095819, 
  -0.097169, -0.098519, -0.099868, -0.101218, -0.102567, -0.103917, -0.105266, -0.106616, 
  -0.107965, -0.109315, -0.110665, -0.112014, -0.113364, -0.114713, -0.116063, -0.117412, 
  -0.118762, -0.120112, -0.121461, -0.122811, -0.124160, -0.125510, -0.126859, -0.128209, 
  -0.129559, -0.130908, -0.132258, -0.133607, -0.134957, -0.136306, -0.137656, -0.139006, 
  -0.140355, -0.141705, -0.143054, -0.144404, -0.145753, -0.147103, -0.148453, -0.149802, 
  -0.151152, -0.152501, -0.153851, -0.155200, -0.156550, -0.157900, -0.159249, -0.160599, 
  -0.161948, -0.163298, -0.164647, -0.165997, -0.167347, -0.168696, -0.170046, -0.171395, 
};

const float gavl_vj_to_g_float[256] = 
{
  0.358470, 0.355670, 0.352869, 0.350069, 0.347268, 0.344468, 0.341667, 0.338866, 
  0.336066, 0.333265, 0.330465, 0.327664, 0.324864, 0.322063, 0.319263, 0.316462, 
  0.313661, 0.310861, 0.308060, 0.305260, 0.302459, 0.299659, 0.296858, 0.294058, 
  0.291257, 0.288457, 0.285656, 0.282855, 0.280055, 0.277254, 0.274454, 0.271653, 
  0.268853, 0.266052, 0.263252, 0.260451, 0.257651, 0.254850, 0.252049, 0.249249, 
  0.246448, 0.243648, 0.240847, 0.238047, 0.235246, 0.232446, 0.229645, 0.226844, 
  0.224044, 0.221243, 0.218443, 0.215642, 0.212842, 0.210041, 0.207241, 0.204440, 
  0.201640, 0.198839, 0.196038, 0.193238, 0.190437, 0.187637, 0.184836, 0.182036, 
  0.179235, 0.176435, 0.173634, 0.170833, 0.168033, 0.165232, 0.162432, 0.159631, 
  0.156831, 0.154030, 0.151230, 0.148429, 0.145629, 0.142828, 0.140027, 0.137227, 
  0.134426, 0.131626, 0.128825, 0.126025, 0.123224, 0.120424, 0.117623, 0.114823, 
  0.112022, 0.109221, 0.106421, 0.103620, 0.100820, 0.098019, 0.095219, 0.092418, 
  0.089618, 0.086817, 0.084016, 0.081216, 0.078415, 0.075615, 0.072814, 0.070014, 
  0.067213, 0.064413, 0.061612, 0.058812, 0.056011, 0.053210, 0.050410, 0.047609, 
  0.044809, 0.042008, 0.039208, 0.036407, 0.033607, 0.030806, 0.028005, 0.025205, 
  0.022404, 0.019604, 0.016803, 0.014003, 0.011202, 0.008402, 0.005601, 0.002801, 
  -0.000000, -0.002801, -0.005601, -0.008402, -0.011202, -0.014003, -0.016803, -0.019604, 
  -0.022404, -0.025205, -0.028005, -0.030806, -0.033607, -0.036407, -0.039208, -0.042008, 
  -0.044809, -0.047609, -0.050410, -0.053210, -0.056011, -0.058812, -0.061612, -0.064413, 
  -0.067213, -0.070014, -0.072814, -0.075615, -0.078415, -0.081216, -0.084016, -0.086817, 
  -0.089618, -0.092418, -0.095219, -0.098019, -0.100820, -0.103620, -0.106421, -0.109221, 
  -0.112022, -0.114823, -0.117623, -0.120424, -0.123224, -0.126025, -0.128825, -0.131626, 
  -0.134426, -0.137227, -0.140027, -0.142828, -0.145629, -0.148429, -0.151230, -0.154030, 
  -0.156831, -0.159631, -0.162432, -0.165232, -0.168033, -0.170833, -0.173634, -0.176435, 
  -0.179235, -0.182036, -0.184836, -0.187637, -0.190437, -0.193238, -0.196038, -0.198839, 
  -0.201640, -0.204440, -0.207241, -0.210041, -0.212842, -0.215642, -0.218443, -0.221243, 
  -0.224044, -0.226844, -0.229645, -0.232446, -0.235246, -0.238047, -0.240847, -0.243648, 
  -0.246448, -0.249249, -0.252049, -0.254850, -0.257651, -0.260451, -0.263252, -0.266052, 
  -0.268853, -0.271653, -0.274454, -0.277254, -0.280055, -0.282855, -0.285656, -0.288457, 
  -0.291257, -0.294058, -0.296858, -0.299659, -0.302459, -0.305260, -0.308060, -0.310861, 
  -0.313661, -0.316462, -0.319263, -0.322063, -0.324864, -0.327664, -0.330465, -0.333265, 
  -0.336066, -0.338866, -0.341667, -0.344468, -0.347268, -0.350069, -0.352869, -0.355670, 
};

const float gavl_uj_to_b_float[256] = 
{
  -0.889475, -0.882525, -0.875576, -0.868627, -0.861678, -0.854729, -0.847780, -0.840831, 
  -0.833882, -0.826933, -0.819984, -0.813035, -0.806086, -0.799137, -0.792188, -0.785239, 
  -0.778290, -0.771341, -0.764392, -0.757443, -0.750494, -0.743545, -0.736596, -0.729647, 
  -0.722698, -0.715749, -0.708800, -0.701851, -0.694902, -0.687953, -0.681004, -0.674055, 
  -0.667106, -0.660157, -0.653208, -0.646259, -0.639310, -0.632361, -0.625412, -0.618463, 
  -0.611514, -0.604565, -0.597616, -0.590667, -0.583718, -0.576769, -0.569820, -0.562871, 
  -0.555922, -0.548973, -0.542024, -0.535075, -0.528125, -0.521176, -0.514227, -0.507278, 
  -0.500329, -0.493380, -0.486431, -0.479482, -0.472533, -0.465584, -0.458635, -0.451686, 
  -0.444737, -0.437788, -0.430839, -0.423890, -0.416941, -0.409992, -0.403043, -0.396094, 
  -0.389145, -0.382196, -0.375247, -0.368298, -0.361349, -0.354400, -0.347451, -0.340502, 
  -0.333553, -0.326604, -0.319655, -0.312706, -0.305757, -0.298808, -0.291859, -0.284910, 
  -0.277961, -0.271012, -0.264063, -0.257114, -0.250165, -0.243216, -0.236267, -0.229318, 
  -0.222369, -0.215420, -0.208471, -0.201522, -0.194573, -0.187624, -0.180675, -0.173725, 
  -0.166776, -0.159827, -0.152878, -0.145929, -0.138980, -0.132031, -0.125082, -0.118133, 
  -0.111184, -0.104235, -0.097286, -0.090337, -0.083388, -0.076439, -0.069490, -0.062541, 
  -0.055592, -0.048643, -0.041694, -0.034745, -0.027796, -0.020847, -0.013898, -0.006949, 
  0.000000, 0.006949, 0.013898, 0.020847, 0.027796, 0.034745, 0.041694, 0.048643, 
  0.055592, 0.062541, 0.069490, 0.076439, 0.083388, 0.090337, 0.097286, 0.104235, 
  0.111184, 0.118133, 0.125082, 0.132031, 0.138980, 0.145929, 0.152878, 0.159827, 
  0.166776, 0.173725, 0.180675, 0.187624, 0.194573, 0.201522, 0.208471, 0.215420, 
  0.222369, 0.229318, 0.236267, 0.243216, 0.250165, 0.257114, 0.264063, 0.271012, 
  0.277961, 0.284910, 0.291859, 0.298808, 0.305757, 0.312706, 0.319655, 0.326604, 
  0.333553, 0.340502, 0.347451, 0.354400, 0.361349, 0.368298, 0.375247, 0.382196, 
  0.389145, 0.396094, 0.403043, 0.409992, 0.416941, 0.423890, 0.430839, 0.437788, 
  0.444737, 0.451686, 0.458635, 0.465584, 0.472533, 0.479482, 0.486431, 0.493380, 
  0.500329, 0.507278, 0.514227, 0.521176, 0.528125, 0.535075, 0.542024, 0.548973, 
  0.555922, 0.562871, 0.569820, 0.576769, 0.583718, 0.590667, 0.597616, 0.604565, 
  0.611514, 0.618463, 0.625412, 0.632361, 0.639310, 0.646259, 0.653208, 0.660157, 
  0.667106, 0.674055, 0.681004, 0.687953, 0.694902, 0.701851, 0.708800, 0.715749, 
  0.722698, 0.729647, 0.736596, 0.743545, 0.750494, 0.757443, 0.764392, 0.771341, 
  0.778290, 0.785239, 0.792188, 0.799137, 0.806086, 0.813035, 0.819984, 0.826933, 
  0.833882, 0.840831, 0.847780, 0.854729, 0.861678, 0.868627, 0.875576, 0.882525, 
};

