/* GCompris - ActivityEditor.qml
 *
 * SPDX-FileCopyrightText: 2025 Timothée Giet <animtim@gmail.com>
 *
 * Authors:
 *   Timothée Giet <animtim@gmail.com>
 *
 *   SPDX-License-Identifier: GPL-3.0-or-later
 */
import "../algebra_by"
import QtQuick

AlgebraEditor {
    textActivityData: textActivityData_
    teacherInstructions: baseTeacherInstructions + ("<ul><li>") +
    qsTr('When "Random operands" is selected, the right side operand is always between minimum and maximum values. The left side operand is generated by multiplying the right side operand by another number between minimum and maximum values.') + ("</li></ul>")
    + ("<ul><li>") +
    qsTr('If "Random operands" is not selected, for each sublevel you must make sure that the "First operand" is a multiple of the "Second operand".') + ("</li></ul>")

    // same as default, but set min/max and first/second minimum value to 1
    mainPrototype: ListModel {
        property bool multiple: false
        ListElement { name: "randomOperands";  label: qsTr("Random operands");       type: "boolean";        def: "true" }
        ListElement { name: "numberSubLevels"; label: qsTr("Sublevels");             type: "boundedDecimal"; def: "5";  decimalRange: '[1, 10]'; stepSize: 1; decimals: 0 }
        ListElement { name: "min";             label: qsTr("Minimum operand value"); type: "boundedDecimal"; def: "0";  decimalRange: '[1, 1000]'; stepSize: 1; decimals: 0 }
        ListElement { name: "max";             label: qsTr("Maximum operand value"); type: "boundedDecimal"; def: "10"; decimalRange: '[1, 1000]'; stepSize: 1; decimals: 0 }
        ListElement { name: "limit";           label: qsTr("Result value limit");    type: "boundedDecimal"; def: "0";  decimalRange: '[0, 10000]'; stepSize: 1; decimals: 0 }
        ListElement { name: "shuffle";      label: qsTr("Shuffle");     type: "boolean";    def: "true" }
        ListElement { name: "operands";    label: qsTr("Sublevels");   type: "model";      def: "[]" }
    }

    subPrototype: ListModel {
        property bool multiple: true
        ListElement { name: "first";  label: qsTr("First operand");  type: "boundedDecimal"; def: "0";  decimalRange: '[1, 1000]'; stepSize: 1; decimals: 0 }
        ListElement { name: "second"; label: qsTr("Second operand"); type: "boundedDecimal"; def: "10"; decimalRange: '[1, 1000]'; stepSize: 1; decimals: 0 }
    }
}


