// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AVTVECTORMETADATA_H
#define AVTVECTORMETADATA_H
#include <dbatts_exports.h>
#include <avtVarMetaData.h>


// ****************************************************************************
// Class: avtVectorMetaData
//
// Purpose:
//    Contains vector metadata attributes
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class DBATTS_API avtVectorMetaData : public avtVarMetaData
{
public:
    // These constructors are for objects of this class
    avtVectorMetaData();
    avtVectorMetaData(const avtVectorMetaData &obj);
protected:
    // These constructors are for objects derived from this class
    avtVectorMetaData(private_tmfs_t tmfs);
    avtVectorMetaData(const avtVectorMetaData &obj, private_tmfs_t tmfs);
public:
    virtual ~avtVectorMetaData();

    virtual avtVectorMetaData& operator = (const avtVectorMetaData &obj);
    virtual bool operator == (const avtVectorMetaData &obj) const;
    virtual bool operator != (const avtVectorMetaData &obj) const;
private:
    void Init();
    void Copy(const avtVectorMetaData &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    avtVectorMetaData(std::string, std::string, avtCentering, int);
    avtVectorMetaData(std::string, std::string, avtCentering, int, const double *);
    void SetExtents(const double *);
    void UnsetExtents();
    void Print(ostream &, int = 0) const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_varDim = avtVarMetaData::ID__LAST,
        ID__LAST
    };

public:
    int varDim;

private:
    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AVTVECTORMETADATA_TMFS AVTVARMETADATA_TMFS "i"

#endif
