# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient
from azure.mgmt.core.policies import AsyncARMAutoResourceProviderRegistrationPolicy

from .. import models as _models
from .._serialization import Deserializer, Serializer
from ._configuration import MigrationAssessmentMgmtClientConfiguration
from .operations import (
    AssessedMachinesOperationsOperations,
    AssessedSqlDatabaseV2OperationsOperations,
    AssessedSqlInstanceV2OperationsOperations,
    AssessedSqlMachinesOperationsOperations,
    AssessedSqlRecommendedEntityOperationsOperations,
    AssessmentOptionsOperationsOperations,
    AssessmentProjectSummaryOperationsOperations,
    AssessmentProjectsOperationsOperations,
    AssessmentsOperationsOperations,
    AvsAssessedMachinesOperationsOperations,
    AvsAssessmentOptionsOperationsOperations,
    AvsAssessmentsOperationsOperations,
    GroupsOperationsOperations,
    HypervCollectorsOperationsOperations,
    ImportCollectorsOperationsOperations,
    MachinesOperationsOperations,
    Operations,
    PrivateEndpointConnectionOperationsOperations,
    PrivateLinkResourceOperationsOperations,
    ServerCollectorsOperationsOperations,
    SqlAssessmentOptionsOperationsOperations,
    SqlAssessmentV2OperationsOperations,
    SqlAssessmentV2SummaryOperationsOperations,
    SqlCollectorOperationsOperations,
    VmwareCollectorsOperationsOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials_async import AsyncTokenCredential


class MigrationAssessmentMgmtClient:  # pylint: disable=too-many-instance-attributes
    """Azure Migrate Resource Provider management API.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.migrationassessment.aio.operations.Operations
    :ivar assessment_projects_operations: AssessmentProjectsOperationsOperations operations
    :vartype assessment_projects_operations:
     azure.mgmt.migrationassessment.aio.operations.AssessmentProjectsOperationsOperations
    :ivar assessment_options_operations: AssessmentOptionsOperationsOperations operations
    :vartype assessment_options_operations:
     azure.mgmt.migrationassessment.aio.operations.AssessmentOptionsOperationsOperations
    :ivar avs_assessment_options_operations: AvsAssessmentOptionsOperationsOperations operations
    :vartype avs_assessment_options_operations:
     azure.mgmt.migrationassessment.aio.operations.AvsAssessmentOptionsOperationsOperations
    :ivar groups_operations: GroupsOperationsOperations operations
    :vartype groups_operations:
     azure.mgmt.migrationassessment.aio.operations.GroupsOperationsOperations
    :ivar assessments_operations: AssessmentsOperationsOperations operations
    :vartype assessments_operations:
     azure.mgmt.migrationassessment.aio.operations.AssessmentsOperationsOperations
    :ivar assessed_machines_operations: AssessedMachinesOperationsOperations operations
    :vartype assessed_machines_operations:
     azure.mgmt.migrationassessment.aio.operations.AssessedMachinesOperationsOperations
    :ivar avs_assessments_operations: AvsAssessmentsOperationsOperations operations
    :vartype avs_assessments_operations:
     azure.mgmt.migrationassessment.aio.operations.AvsAssessmentsOperationsOperations
    :ivar avs_assessed_machines_operations: AvsAssessedMachinesOperationsOperations operations
    :vartype avs_assessed_machines_operations:
     azure.mgmt.migrationassessment.aio.operations.AvsAssessedMachinesOperationsOperations
    :ivar sql_assessment_v2_operations: SqlAssessmentV2OperationsOperations operations
    :vartype sql_assessment_v2_operations:
     azure.mgmt.migrationassessment.aio.operations.SqlAssessmentV2OperationsOperations
    :ivar assessed_sql_database_v2_operations: AssessedSqlDatabaseV2OperationsOperations operations
    :vartype assessed_sql_database_v2_operations:
     azure.mgmt.migrationassessment.aio.operations.AssessedSqlDatabaseV2OperationsOperations
    :ivar assessed_sql_instance_v2_operations: AssessedSqlInstanceV2OperationsOperations operations
    :vartype assessed_sql_instance_v2_operations:
     azure.mgmt.migrationassessment.aio.operations.AssessedSqlInstanceV2OperationsOperations
    :ivar assessed_sql_machines_operations: AssessedSqlMachinesOperationsOperations operations
    :vartype assessed_sql_machines_operations:
     azure.mgmt.migrationassessment.aio.operations.AssessedSqlMachinesOperationsOperations
    :ivar assessed_sql_recommended_entity_operations:
     AssessedSqlRecommendedEntityOperationsOperations operations
    :vartype assessed_sql_recommended_entity_operations:
     azure.mgmt.migrationassessment.aio.operations.AssessedSqlRecommendedEntityOperationsOperations
    :ivar sql_assessment_v2_summary_operations: SqlAssessmentV2SummaryOperationsOperations
     operations
    :vartype sql_assessment_v2_summary_operations:
     azure.mgmt.migrationassessment.aio.operations.SqlAssessmentV2SummaryOperationsOperations
    :ivar hyperv_collectors_operations: HypervCollectorsOperationsOperations operations
    :vartype hyperv_collectors_operations:
     azure.mgmt.migrationassessment.aio.operations.HypervCollectorsOperationsOperations
    :ivar import_collectors_operations: ImportCollectorsOperationsOperations operations
    :vartype import_collectors_operations:
     azure.mgmt.migrationassessment.aio.operations.ImportCollectorsOperationsOperations
    :ivar machines_operations: MachinesOperationsOperations operations
    :vartype machines_operations:
     azure.mgmt.migrationassessment.aio.operations.MachinesOperationsOperations
    :ivar private_endpoint_connection_operations: PrivateEndpointConnectionOperationsOperations
     operations
    :vartype private_endpoint_connection_operations:
     azure.mgmt.migrationassessment.aio.operations.PrivateEndpointConnectionOperationsOperations
    :ivar private_link_resource_operations: PrivateLinkResourceOperationsOperations operations
    :vartype private_link_resource_operations:
     azure.mgmt.migrationassessment.aio.operations.PrivateLinkResourceOperationsOperations
    :ivar assessment_project_summary_operations: AssessmentProjectSummaryOperationsOperations
     operations
    :vartype assessment_project_summary_operations:
     azure.mgmt.migrationassessment.aio.operations.AssessmentProjectSummaryOperationsOperations
    :ivar server_collectors_operations: ServerCollectorsOperationsOperations operations
    :vartype server_collectors_operations:
     azure.mgmt.migrationassessment.aio.operations.ServerCollectorsOperationsOperations
    :ivar sql_assessment_options_operations: SqlAssessmentOptionsOperationsOperations operations
    :vartype sql_assessment_options_operations:
     azure.mgmt.migrationassessment.aio.operations.SqlAssessmentOptionsOperationsOperations
    :ivar sql_collector_operations: SqlCollectorOperationsOperations operations
    :vartype sql_collector_operations:
     azure.mgmt.migrationassessment.aio.operations.SqlCollectorOperationsOperations
    :ivar vmware_collectors_operations: VmwareCollectorsOperationsOperations operations
    :vartype vmware_collectors_operations:
     azure.mgmt.migrationassessment.aio.operations.VmwareCollectorsOperationsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2023-03-15". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = MigrationAssessmentMgmtClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                AsyncARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(base_url=base_url, policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.assessment_projects_operations = AssessmentProjectsOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.assessment_options_operations = AssessmentOptionsOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.avs_assessment_options_operations = AvsAssessmentOptionsOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.groups_operations = GroupsOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.assessments_operations = AssessmentsOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.assessed_machines_operations = AssessedMachinesOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.avs_assessments_operations = AvsAssessmentsOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.avs_assessed_machines_operations = AvsAssessedMachinesOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sql_assessment_v2_operations = SqlAssessmentV2OperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.assessed_sql_database_v2_operations = AssessedSqlDatabaseV2OperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.assessed_sql_instance_v2_operations = AssessedSqlInstanceV2OperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.assessed_sql_machines_operations = AssessedSqlMachinesOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.assessed_sql_recommended_entity_operations = AssessedSqlRecommendedEntityOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sql_assessment_v2_summary_operations = SqlAssessmentV2SummaryOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.hyperv_collectors_operations = HypervCollectorsOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.import_collectors_operations = ImportCollectorsOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.machines_operations = MachinesOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_endpoint_connection_operations = PrivateEndpointConnectionOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_link_resource_operations = PrivateLinkResourceOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.assessment_project_summary_operations = AssessmentProjectSummaryOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.server_collectors_operations = ServerCollectorsOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sql_assessment_options_operations = SqlAssessmentOptionsOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sql_collector_operations = SqlCollectorOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.vmware_collectors_operations = VmwareCollectorsOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> Self:
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
