% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_calibration_split.R
\name{internal_calibration_split}
\alias{internal_calibration_split}
\alias{internal_calibration_split.default}
\alias{internal_calibration_split.mc_split}
\alias{internal_calibration_split.group_mc_split}
\alias{internal_calibration_split.vfold_split}
\alias{internal_calibration_split.group_vfold_split}
\alias{internal_calibration_split.boot_split}
\alias{internal_calibration_split.group_boot_split}
\alias{internal_calibration_split.val_split}
\alias{internal_calibration_split.group_val_split}
\alias{internal_calibration_split.time_val_split}
\alias{internal_calibration_split.clustering_split}
\alias{internal_calibration_split.apparent_split}
\alias{internal_calibration_split.sliding_window_split}
\alias{internal_calibration_split.sliding_index_split}
\alias{internal_calibration_split.sliding_period_split}
\alias{internal_calibration_split.initial_time_split}
\alias{internal_calibration_split.initial_validation_split}
\alias{internal_calibration_split.group_initial_validation_split}
\alias{internal_calibration_split.initial_validation_time_split}
\alias{calibration}
\alias{calibration.default}
\alias{calibration.internal_calibration_split}
\alias{assessment.internal_calibration_split}
\alias{print.internal_calibration_split}
\title{Internal calibration split of the analysis set for fitting a post-processor}
\usage{
internal_calibration_split(x, ...)

\method{internal_calibration_split}{default}(x, ...)

\method{internal_calibration_split}{mc_split}(x, split_args, ...)

\method{internal_calibration_split}{group_mc_split}(x, split_args, ...)

\method{internal_calibration_split}{vfold_split}(x, split_args, ...)

\method{internal_calibration_split}{group_vfold_split}(x, split_args, ...)

\method{internal_calibration_split}{boot_split}(x, split_args, ...)

\method{internal_calibration_split}{group_boot_split}(x, split_args, ...)

\method{internal_calibration_split}{val_split}(x, split_args, ...)

\method{internal_calibration_split}{group_val_split}(x, split_args, ...)

\method{internal_calibration_split}{time_val_split}(x, split_args, ...)

\method{internal_calibration_split}{clustering_split}(x, split_args, ...)

\method{internal_calibration_split}{apparent_split}(x, ...)

\method{internal_calibration_split}{sliding_window_split}(x, split_args, ...)

\method{internal_calibration_split}{sliding_index_split}(x, split_args, ...)

\method{internal_calibration_split}{sliding_period_split}(x, split_args, ...)

\method{internal_calibration_split}{initial_time_split}(x, split_args, ...)

\method{internal_calibration_split}{initial_validation_split}(x, split_args, ...)

\method{internal_calibration_split}{group_initial_validation_split}(x, split_args, ...)

\method{internal_calibration_split}{initial_validation_time_split}(x, split_args, ...)

calibration(x, ...)

\method{calibration}{default}(x, ...)

\method{calibration}{internal_calibration_split}(x, ...)

\method{assessment}{internal_calibration_split}(x, ...)

\method{print}{internal_calibration_split}(x, ...)
}
\arguments{
\item{x}{An \code{rsplit} object.}

\item{...}{Not currently used.}

\item{split_args}{A list of arguments to be used for the internal calibration
split.}
}
\value{
An \code{rsplit} object.
}
\description{
Internal calibration split of the analysis set for fitting a post-processor
}
\details{
\code{rsplit} objects live most commonly inside of an \code{rset} object. The
\code{split_args} argument can be the output of \code{\link[=.get_split_args]{.get_split_args()}} on that
corresponding \code{rset} object, even if some of the arguments used to create the
\code{rset} object are not needed for the internal calibration split.
\itemize{
\item For \code{mc_split} and \code{group_mc_split} objects, \code{internal_calibration_split()}
will ignore \code{split_args$times}.
\item For \code{vfold_split} and \code{group_vfold_split} objects, it will ignore
\code{split_args$times} and \code{split_args$repeats}. \code{split_args$v} will be used to
set \code{split_args$prop} to \code{1 - 1/v} if \code{prop} is not already set and otherwise
ignored. The method for \code{group_vfold_split} will always use
\code{split_args$balance = NULL}.
\item For \code{boot_split} and \code{group_boot_split} objects, it will ignore
\code{split_args$times}.
\item For \code{val_split}, \code{group_val_split}, and \code{time_val_split} objects, it will
interpret a length-2 \code{split_args$prop} as a ratio between the training and
validation sets and split into inner analysis and calibration set in
the same ratio. If \code{split_args$prop} is a single value, it will be used as
the proportion of the inner analysis set.
\item For \code{clustering_split} objects, it will ignore \code{split_args$repeats}.
}
}
\keyword{internal}
