% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-subset-summarise.R
\name{summarise.dtplyr_step}
\alias{summarise.dtplyr_step}
\title{Summarise each group to one row}
\usage{
\method{summarise}{dtplyr_step}(.data, ..., .by = NULL, .groups = NULL)
}
\arguments{
\item{.data}{A \code{\link[=lazy_dt]{lazy_dt()}}.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Name-value pairs of
summary functions. The name will be the name of the variable in the result.

The value can be:
\itemize{
\item A vector of length 1, e.g. \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.
\item A data frame with 1 row, to add multiple columns from a single expression.
}}

\item{.by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{.groups}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Grouping structure of the
result.
\itemize{
\item \code{"drop_last"}: drops the last level of grouping. This was the
only supported option before version 1.0.0.
\item \code{"drop"}: All levels of grouping are dropped.
\item \code{"keep"}: Same grouping structure as \code{.data}.
\item \code{"rowwise"}: Each row is its own group.
}

When \code{.groups} is not specified, it is set to \code{"drop_last"} for a grouped
data frame, and \code{"keep"} for a rowwise data frame. In addition, a message
informs you of how the result will be grouped unless the result is
ungrouped, the option \code{"dplyr.summarise.inform"} is set to \code{FALSE}, or when
\code{summarise()} is called from a function in a package.}
}
\description{
This is a method for the dplyr \code{\link[dplyr:summarise]{dplyr::summarise()}} generic. It is translated to
the \code{j} argument of \verb{[.data.table}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

dt <- lazy_dt(mtcars)

dt \%>\%
  group_by(cyl) \%>\%
  summarise(vs = mean(vs))

dt \%>\%
  group_by(cyl) \%>\%
  summarise(across(disp:wt, mean))
}
