% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgr.R
\name{has_ctl}
\alias{has_ctl}
\title{Check for Presence of Control Sequences}
\usage{
has_ctl(x, ctl = "all", warn = getOption("fansi.warn", TRUE), which)
}
\arguments{
\item{x}{a character vector or object that can be coerced to such.}

\item{ctl}{character, which \emph{Control Sequences} should be treated
specially.  Special treatment is context dependent, and may include
detecting them and/or computing their display/character width as zero.  For
the SGR subset of the ANSI CSI sequences, and OSC hyperlinks, \code{fansi}
will also parse, interpret, and reapply the sequences as needed.  You can
modify whether a \emph{Control Sequence} is treated specially with the \code{ctl}
parameter.
\itemize{
\item "nl": newlines.
\item "c0": all other "C0" control characters (i.e. 0x01-0x1f, 0x7F), except
for newlines and the actual ESC (0x1B) character.
\item "sgr": ANSI CSI SGR sequences.
\item "csi": all non-SGR ANSI CSI sequences.
\item "url": OSC hyperlinks
\item "osc": all non-OSC-hyperlink OSC sequences.
\item "esc": all other escape sequences.
\item "all": all of the above, except when used in combination with any of the
above, in which case it means "all but".
}}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \code{\link[=fansi]{?fansi}}).
At most one warning will be issued per element in each input vector.  Will
also warn about some badly encoded UTF-8 strings, but a lack of UTF-8
warnings is not a guarantee of correct encoding (use \code{\link{validUTF8}} for
that).}

\item{which}{character, deprecated in favor of \code{ctl}.}
}
\value{
logical of same length as \code{x}; NA values in \code{x} result in NA values
in return
}
\description{
\code{has_ctl} checks for any \emph{Control Sequence}.  You can check for different
types of sequences with the \code{ctl} parameter.  Warnings are only emitted for
malformed CSI or OSC sequences.
}
\examples{
has_ctl("hello world")
has_ctl("hello\nworld")
has_ctl("hello\nworld", "sgr")
has_ctl("hello\033[31mworld\033[m", "sgr")
}
\seealso{
\code{\link[=fansi]{?fansi}} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results,
\code{\link{unhandled_ctl}} for detecting bad control sequences.
}
