% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta.R
\name{theta_model}
\alias{theta_model}
\title{Theta model}
\usage{
theta_model(y, lambda = NULL, biasadj = FALSE)
}
\arguments{
\item{y}{a numeric vector or univariate time series of class \code{ts}}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted
values, a regular back transformation will result in median forecasts. If
biasadj is \code{TRUE}, an adjustment will be made to produce mean forecasts
and fitted values.}
}
\value{
An object of class \code{theta_model}.
}
\description{
The theta method of Assimakopoulos and Nikolopoulos (2000) is equivalent to
simple exponential smoothing with drift (Hyndman and Billah, 2003).
This function fits the theta model to a time series.
The series is tested for seasonality using the test outlined in A&N. If
deemed seasonal, the series is seasonally adjusted using a classical
multiplicative decomposition before fitting the theta model.
}
\details{
More general theta methods are available in the \CRANpkg{forecTheta}
package.
}
\examples{
nile_fit <- theta_model(Nile)
forecast(nile_fit) |> autoplot()
}
\references{
Assimakopoulos, V. and Nikolopoulos, K. (2000). The theta model:
a decomposition approach to forecasting. \emph{International Journal of
Forecasting} \bold{16}, 521-530.

Hyndman, R.J., and Billah, B. (2003) Unmasking the Theta method.
\emph{International J. Forecasting}, \bold{19}, 287-290.
}
\seealso{
\code{\link[=thetaf]{thetaf()}}
}
\author{
Rob J Hyndman
}
\keyword{ts}
